.Z88_ApplMonitor  BIT  0,(IY+76)
                  JP   Z,monitor_loop       ; ignore Intuition register dump if no CLI
                  DEC  SP
                  DEC  SP
                  DEC  SP
                  DEC  SP
                  DEC  SP
                  DEC  SP
                  DEC  SP
                  DEC  SP                   ; move SP 3 words downwards
                  PUSH AF
                  PUSH HL                   ;
                  PUSH DE                   ;
                  PUSH BC                   ; tmp save original values
                  LD   HL,0
                  ADD  HL,SP
                  LD   B,H
                  LD   C,L                  ; remember ptr to orig BC
                  LD   DE, 24               ; now make 24 bytes room
                  CP   A
                  SBC  HL,DE                ; calculate new SP address
                  LD   SP,HL                ; Set Application Stack Pointer below area...
                  LD   D,H                  ;
                  LD   E,L                  ;
                  PUSH IY                   ; preserve orig. value of IY
                  PUSH DE                   ;
                  POP  IY                   ; IY = Base of Intuition Register Dump
                  LD   (IY+22),monitor_loop % 256
                  LD   (IY+23),monitor_loop / 256
                  POP  HL
                  LD   (IY+18),L
                  LD   (IY+19),H            ; IY copied
                  PUSH IX
                  POP  HL
                  LD   (IY+16),L
                  LD   (IY+17),H            ; IX copied

                  EX   AF,AF'
                  PUSH AF
                  EX   AF,AF'
                  POP  HL
                  LD   (IY+14),L
                  LD   (IY+15),H            ; virtual AF stored
                  EXX                       ; get alternate registers
                  LD   (IY+12),L
                  LD   (IY+13),H            ; orig value of HL' stored in Runtime Area
                  LD   (IY+10),E
                  LD   (IY+11),D
                  LD   (IY+8),C
                  LD   (IY+9),B
                  EXX                       ; restore main registers

                  PUSH BC
                  POP  HL                   ; ptr to orig BC (on stack above area)
                  LD   SP,HL
                  POP  BC
                  LD   (IY+0),C
                  LD   (IY+1),B
                  POP  DE
                  LD   (IY+2),E
                  LD   (IY+3),D
                  POP  HL
                  LD   (IY+4),L
                  LD   (IY+5),H
                  POP  HL                   ; get AF
                  LD   (IY+6),L
                  LD   (IY+7),H
                  LD   HL,0
                  ADD  HL,SP
                  LD   BC,8
                  ADD  HL,BC
                  LD   (IY+20),L
                  LD   (IY+21),H            ; Intuition Stack Pointer
                  LD   SP,IY                ; stack pointer below area

                  CALL Write_CRLF
                  CALL DisplayRegisters     ; dump Intuition work registers to window

                  PUSH IY
                  POP  HL
                  DEC  HL
                  DEC  HL                   ; pointer to top of stack
                  PUSH HL
                  LD   E,(IY+20)
                  LD   D,(IY+21)            ; current stack pointer
                  PUSH DE                   ; and BOTTOM pointer
                  EXX
                  POP  DE
                  POP  HL                   ; pointers installed.
                  EXX
                  LD   H,D
                  LD   L,E
                  LD   BC,4
                  ADD  HL,BC                ; (4 words higher than BOTTOM pointer)
                  CALL DispStack_8lines     ; display 8 stack elements, 4 words before SP, 4 after

                  POP  BC                   ; BC restored
                  POP  DE                   ; DE restored
                  POP  AF                   ; skip HL...
                  POP  AF                   ; AF restored
                  EXX                       ;
                  POP  BC                   ; BC' restored
                  POP  DE                   ; DE' restored
                  POP  HL                   ; HL' restored
                  EXX                       ;
                  EX   AF,AF'               ;
                  POP  AF                   ; AF' restored
                  EX   AF,AF'               ;
                  POP  IX                   ; IX restored
                  INC  SP                   ;
                  INC  SP                   ; skip IY
                  POP  HL                   ; get SP
                  LD   SP,HL                ; install SP
                  LD   L,(IY+22)            ;
                  LD   H,(IY+23)            ;
                  PUSH HL                   ; PC on stack
                  LD   L,(IY+4)             ;
                  LD   H,(IY+5)             ;
                  PUSH HL                   ; HL on stack
                  LD   L,(IY+18)            ;
                  LD   H,(IY+19)            ;
                  PUSH HL                   ;
                  POP  IY                   ; IY restored
                  POP  HL                   ; HL restored
                  RET                       ; release Z80 to Intuition
