; The Floating Point Package (V3.21, resided at D800h, bank 02).
;
; The routines are interfaced through the RST 18H instruction, using a 1 byte
; parameter after the instruction which identifies an index to the lookup table
; placed at D821h - D8A2h.


; this routine is executed after an FPP operation to restore the
; stack pointer and setting of the necessary error flags:
D800 BF          CP   A
D801 FD 2B       DEC  IY
D803 FD 2B       DEC  IY
D805 FD F9       LD   SP,IY
D807 DD E1       POP  IX                          ; restore original IX
D809 FD E1       POP  IY                          ; restore original IY
D80B 08          EX   AF,AF'
D80C C3 1D 00    JP   001Dh

D80F FE 00       CP   00h
D811 37          SCF                              ; signal error
D812 18 ED       JR   D801h
D814 00          NOP
D815 00          NOP
D816 00          NOP
D817 00          NOP
D818 00          NOP
D819 00          NOP
D81A 00          NOP
D81B 00          NOP
D81C 00          NOP
D81D 00          NOP
D81E 00          NOP
D81F 00          NOP
D820 00          NOP
D821 C3 B0 D8    JP   D8B0h                       ; FP_AND *
D824 C3 2F D9    JP   D92Fh                       ; FP_IDV *
D827 C3 C9 D8    JP   D8C9h                       ; FP_EOR *
D82A C3 FB D8    JP   D8FBh                       ; FP_MOD *
D82D C3 E2 D8    JP   D8E2h                       ; FP_OR  *
D830 C3 90 DB    JP   DB90h                       ; FP_LEQ *
D833 C3 A4 DB    JP   DBA4h                       ; FP_NEQ *
D836 C3 7E DB    JP   DB7Eh                       ; FP_GEQ *
D839 C3 59 DB    JP   DB59h                       ; FP_LT  *
D83C C3 B6 DB    JP   DBB6h                       ; FP_EQ  *
D83F C3 59 DA    JP   DA59h                       ; FP_MUL *
D842 C3 60 D9    JP   D960h                       ; FP_ADD *
D845 C3 6B DB    JP   DB6Bh                       ; FP_GT  *
D848 C3 46 D9    JP   D946h                       ; FP_SUB *
D84B C3 B1 DA    JP   DAB1h                       ; FP_PWR *
D84E C3 C3 D9    JP   D9C3h                       ; FP_DIV *
D851 C3 DB DB    JP   DBDBh                       ; FP_ABS *
D854 C3 42 DF    JP   DF42h                       ; FP_ACS *
D857 C3 9E DE    JP   DE9Eh                       ; FP_ASN *
D85A C3 C3 DE    JP   DEC3h                       ; FP_ATN *
D85D C3 DC DC    JP   DCDCh                       ; FP_COS *
D860 C3 05 DC    JP   DC05h                       ; FP_DEG *
D863 C3 81 DD    JP   DD81h                       ; FP_EXP *
D866 C3 56 DC    JP   DC56h                       ; FP_INT *
D869 C3 0C DE    JP   DE0Ch                       ; FP_LN  *
D86C C3 8C DE    JP   DE8Ch                       ; FP_LOG *
D86F C3 E6 DB    JP   DBE6h                       ; FP_NOT *
D872 C3 0D DC    JP   DC0Dh                       ; FP_RAD *
D875 C3 23 DC    JP   DC23h                       ; FP_SGN *
D878 C3 E7 DC    JP   DCE7h                       ; FP_SIN *
D87B C3 6C DC    JP   DC6Ch                       ; FP_SQR *
D87E C3 BF DC    JP   DCBFh                       ; FP_TAN *
D881 C3 D1 E2    JP   E2D1h                       ; FP_ZER *
D884 C3 60 DD    JP   DD60h                       ; FP_ONE *
D887 C3 C6 DB    JP   DBC6h                       ; FP_TRU *
D88A C3 F9 DB    JP   DBF9h                       ; FP_PI  *
D88D C3 33 DC    JP   DC33h                       ; FP_VAL *
D890 C3 4A DF    JP   DF4Ah                       ; FP_STR *
D893 C3 A9 E1    JP   E1A9h                       ; FP_FIX *
D896 C3 61 E2    JP   E261h                       ; FP_FLT *
D899 C3 A6 E2    JP   E2A6h                       ; FP_TST *
D89C C3 B8 E2    JP   E2B8h                       ; FP_CMP *
D89F C3 D1 DB    JP   DBD1h                       ; FP_NEG *
D8A2 C3 A5 D8    JP   D8A5h                       ; FP_BAS *


; FP_BAS - call FPP function:
D8A5 E5          PUSH HL                          ; preserve FPP parameter
D8A6 6F          LD   L,A
D8A7 87          ADD  A,A
D8A8 85          ADD  A,L
D8A9 C6 21       ADD  A,21h
D8AB 6F          LD   L,A
D8AC 26 D8       LD   H,D8h                       ; FPP function address in HL
D8AE E3          EX   (SP),HL                     ; restore parameter
D8AF C9          RET                              ; execute FPP function....


; FP_AND:
D8B0 78          LD   A,B
D8B1 B1          OR   C
D8B2 28 06       JR   Z,D8BAh
D8B4 CD 58 E2    CALL E258h *
D8B7 CD A0 E1    CALL E1A0h *
D8BA 7C          LD   A,H
D8BB A2          AND  D
D8BC 67          LD   H,A
D8BD 7D          LD   A,L
D8BE A3          AND  E
D8BF 6F          LD   L,A
D8C0 D9          EXX
D8C1 7C          LD   A,H
D8C2 A2          AND  D
D8C3 67          LD   H,A
D8C4 7D          LD   A,L
D8C5 A3          AND  E
D8C6 6F          LD   L,A
D8C7 D9          EXX
D8C8 C9          RET


; FP_EOR:
D8C9 78          LD   A,B
D8CA B1          OR   C
D8CB 28 06       JR   Z,D8D3h
D8CD CD 58 E2    CALL E258h *
D8D0 CD A0 E1    CALL E1A0h *
D8D3 7C          LD   A,H
D8D4 AA          XOR  D
D8D5 67          LD   H,A
D8D6 7D          LD   A,L
D8D7 AB          XOR  E
D8D8 6F          LD   L,A
D8D9 D9          EXX
D8DA 7C          LD   A,H
D8DB AA          XOR  D
D8DC 67          LD   H,A
D8DD 7D          LD   A,L
D8DE AB          XOR  E
D8DF 6F          LD   L,A
D8E0 D9          EXX
D8E1 C9          RET


; FP_OR:
D8E2 78          LD   A,B
D8E3 B1          OR   C
D8E4 28 06       JR   Z,D8ECh
D8E6 CD 58 E2    CALL E258h *
D8E9 CD A0 E1    CALL E1A0h *
D8EC 7C          LD   A,H
D8ED B2          OR   D
D8EE 67          LD   H,A
D8EF 7D          LD   A,L
D8F0 B3          OR   E
D8F1 6F          LD   L,A
D8F2 D9          EXX
D8F3 7C          LD   A,H
D8F4 B2          OR   D
D8F5 67          LD   H,A
D8F6 7D          LD   A,L
D8F7 B3          OR   E
D8F8 6F          LD   L,A
D8F9 D9          EXX
D8FA C9          RET


; FP_MOD:
D8FB 78          LD   A,B
D8FC B1          OR   C
D8FD 28 06       JR   Z,D905h *
D8FF CD 58 E2    CALL E258h *
D902 CD A0 E1    CALL E1A0h *

D905 7C          LD   A,H
D906 AA          XOR  D
D907 CB 7C       BIT  7,H
D909 08          EX   AF,AF'
D90A CB 7C       BIT  7,H
D90C C4 B8 E1    CALL NZ,E1B8h *
D90F CD 8B E2    CALL E28Bh *
D912 CB 7C       BIT  7,H
D914 C4 B8 E1    CALL NZ,E1B8h *
D917 44          LD   B,H
D918 4D          LD   C,L
D919 21 00 00    LD   HL,0000h
D91C D9          EXX
D91D 44          LD   B,H
D91E 4D          LD   C,L
D91F 21 00 00    LD   HL,0000h
D922 3E DF       LD   A,DFh
D924 CD E0 E3    CALL E3E0h *
D927 D9          EXX
D928 0E 00       LD   C,00h
D92A 08          EX   AF,AF'
D92B C8          RET  Z
D92C C3 B8 E1    JP   E1B8h *


; FP_IDV:
D92F 78          LD   A,B
D930 B1          OR   C
D931 28 06       JR   Z,D939h
D933 CD 58 E2    CALL E258h *
D936 CD A0 E1    CALL E1A0h *
D939 CD 05 D9    CALL D905h *
D93C B7          OR   A
D93D CD 8B E2    CALL E28Bh *
D940 0E 00       LD   C,00h
D942 F0          RET  P
D943 C3 B8 E1    JP   E1B8h *


; FP_SUB:
D946 78          LD   A,B
D947 B1          OR   C
D948 20 07       JR   NZ,D951h
D94A CD 13 E3    CALL E313h *
D94D E0          RET  PO
D94E CD 0D E3    CALL E30Dh *
D951 CD 58 E2    CALL E258h *
D954 7A          LD   A,D
D955 EE 80       XOR  80h
D957 57          LD   D,A
D958 18 14       JR   D96Eh

D95A 7C          LD   A,H
D95B EE 80       XOR  80h
D95D 67          LD   H,A
D95E 18 0E       JR   D96Eh


; FP_ADD
D960 78          LD   A,B
D961 B1          OR   C
D962 20 07       JR   NZ,D96Bh
D964 CD 0D E3    CALL E30Dh *
D967 E0          RET  PO
D968 CD 13 E3    CALL E313h *
D96B CD 58 E2    CALL E258h *

D96E 05          DEC  B
D96F 04          INC  B
D970 C8          RET  Z
D971 0D          DEC  C
D972 0C          INC  C
D973 CA 8B E2    JP   Z,E28Bh *
D976 D9          EXX
D977 01 00 00    LD   BC,0000h
D97A D9          EXX
D97B 7C          LD   A,H
D97C AA          XOR  D
D97D F5          PUSH AF
D97E 78          LD   A,B
D97F B9          CP   C
D980 DC 8B E2    CALL C,E28Bh *
D983 78          LD   A,B
D984 CB FC       SET  7,H
D986 C4 90 E1    CALL NZ,E190h *
D989 F1          POP  AF
D98A 7A          LD   A,D
D98B CB FA       SET  7,D
D98D FA 9A D9    JP   M,D99Ah
D990 CD 0D E3    CALL E30Dh *
D993 DC 93 E2    CALL C,E293h *
D996 CB FC       SET  7,H
D998 18 0A       JR   D9A4h
D99A CD 13 E3    CALL E313h *
D99D DC CC E1    CALL C,E1CCh *
D9A0 CD 39 E2    CALL E239h *
D9A3 2F          CPL

D9A4 D9          EXX
D9A5 EB          EX   DE,HL
D9A6 21 00 80    LD   HL,8000h
D9A9 B7          OR   A
D9AA ED 42       SBC  HL,BC
D9AC EB          EX   DE,HL
D9AD D9          EXX
D9AE CC 85 E2    CALL Z,E285h *
D9B1 DC 77 E2    CALL C,E277h *
D9B4 DC 9F E2    CALL C,E29Fh *
D9B7 CB BC       RES  7,H
D9B9 0D          DEC  C
D9BA 0C          INC  C
D9BB CA D1 E2    JP   Z,E2D1h *
D9BE B7          OR   A
D9BF F0          RET  P
D9C0 CB FC       SET  7,H
D9C2 C9          RET


; FP_DIV:
D9C3 CD 58 E2    CALL E258h *
D9C6 05          DEC  B
D9C7 04          INC  B
D9C8 3E 46       LD   A,46h
D9CA CA 0F D8    JP   Z,D80Fh *
D9CD 0D          DEC  C
D9CE 0C          INC  C
D9CF C8          RET  Z
D9D0 7C          LD   A,H
D9D1 AA          XOR  D
D9D2 08          EX   AF,AF'
D9D3 CB FA       SET  7,D
D9D5 CB FC       SET  7,H
D9D7 C5          PUSH BC
D9D8 42          LD   B,D
D9D9 4B          LD   C,E
D9DA 11 00 00    LD   DE,0000h
D9DD D9          EXX
D9DE 42          LD   B,D
D9DF 4B          LD   C,E
D9E0 11 00 00    LD   DE,0000h
D9E3 3E E0       LD   A,E0h
D9E5 CD E0 E3    CALL E3E0h *
D9E8 D9          EXX
D9E9 CB 7A       BIT  7,D
D9EB D9          EXX
D9EC CC FB E3    CALL Z,E3FBh *
D9EF EB          EX   DE,HL
D9F0 D9          EXX
D9F1 CB 38       SRL  B
D9F3 CB 19       RR   C
D9F5 B7          OR   A
D9F6 ED 42       SBC  HL,BC
D9F8 3F          CCF
D9F9 EB          EX   DE,HL
D9FA CC 85 E2    CALL Z,E285h *
D9FD DC 77 E2    CALL C,E277h *
DA00 C1          POP  BC
DA01 DC 9F E2    CALL C,E29Fh *
DA04 1F          RRA
DA05 79          LD   A,C
DA06 98          SBC  A,B
DA07 3F          CCF
DA08 C3 9A DA    JP   DA9Ah *

DA0B 7C          LD   A,H
DA0C AA          XOR  D
DA0D 08          EX   AF,AF'
DA0E CB 7C       BIT  7,H
DA10 C4 B8 E1    CALL NZ,E1B8h *
DA13 CD 8B E2    CALL E28Bh *
DA16 CB 7C       BIT  7,H
DA18 C4 B8 E1    CALL NZ,E1B8h *
DA1B 44          LD   B,H
DA1C 4D          LD   C,L
DA1D 21 00 00    LD   HL,0000h
DA20 D9          EXX
DA21 44          LD   B,H
DA22 4D          LD   C,L
DA23 21 00 00    LD   HL,0000h
DA26 3E DF       LD   A,DFh
DA28 CD 0E E4    CALL E40Eh *
DA2B D9          EXX
DA2C 0E BF       LD   C,BFh
DA2E CD B1 E2    CALL E2B1h *
DA31 20 0D       JR   NZ,DA40h
DA33 CB 7A       BIT  7,D
DA35 20 09       JR   NZ,DA40h
DA37 CD 8B E2    CALL E28Bh *
DA3A 4A          LD   C,D
DA3B 08          EX   AF,AF'
DA3C F0          RET  P
DA3D C3 B8 E1    JP   E1B8h *
DA40 0D          DEC  C
DA41 D9          EXX
DA42 CB 23       SLA  E
DA44 CB 12       RL   D
DA46 D9          EXX
DA47 CB 13       RL   E
DA49 CB 12       RL   D
DA4B D9          EXX
DA4C ED 6A       ADC  HL,HL
DA4E D9          EXX
DA4F ED 6A       ADC  HL,HL
DA51 F2 40 DA    JP   P,DA40h
DA54 08          EX   AF,AF'
DA55 F8          RET  M
DA56 CB BC       RES  7,H
DA58 C9          RET


; FP_MUL:
DA59 78          LD   A,B
DA5A B1          OR   C
DA5B CA 0B DA    JP   Z,DA0Bh *
DA5E CD 58 E2    CALL E258h *

DA61 05          DEC  B
DA62 04          INC  B
DA63 CA D1 E2    JP   Z,E2D1h *
DA66 0D          DEC  C
DA67 0C          INC  C
DA68 C8          RET  Z
DA69 7C          LD   A,H
DA6A AA          XOR  D
DA6B 08          EX   AF,AF'
DA6C CB FA       SET  7,D
DA6E CB FC       SET  7,H
DA70 C5          PUSH BC
DA71 44          LD   B,H
DA72 4D          LD   C,L
DA73 21 00 00    LD   HL,0000h
DA76 D9          EXX
DA77 44          LD   B,H
DA78 4D          LD   C,L
DA79 21 00 00    LD   HL,0000h
DA7C 3E E0       LD   A,E0h
DA7E CD 0E E4    CALL E40Eh *
DA81 DC 22 E4    CALL C,E422h *
DA84 D9          EXX
DA85 E5          PUSH HL
DA86 21 00 80    LD   HL,8000h
DA89 B7          OR   A
DA8A ED 52       SBC  HL,DE
DA8C E1          POP  HL
DA8D CC 85 E2    CALL Z,E285h *
DA90 DC 77 E2    CALL C,E277h *
DA93 C1          POP  BC
DA94 DC 9F E2    CALL C,E29Fh *
DA97 1F          RRA
DA98 79          LD   A,C
DA99 88          ADC  A,B

DA9A 38 05       JR   C,DAA1h *
DA9C F2 D1 E2    JP   P,E2D1h *
DA9F 18 03       JR   DAA4h

DAA1 FA A1 E2    JP   M,E2A1h *
DAA4 C6 80       ADD  A,80h
DAA6 4F          LD   C,A
DAA7 CA D1 E2    JP   Z,E2D1h *
DAAA 08          EX   AF,AF'
DAAB CB BC       RES  7,H
DAAD F0          RET  P
DAAE CB FC       SET  7,H
DAB0 C9          RET



; FP_PWR:
DAB1 78          LD   A,B
DAB2 B1          OR   C
DAB3 28 06       JR   Z,DABBh
DAB5 CD 58 E2    CALL E258h *
DAB8 C3 2F DB    JP   DB2Fh *
DABB CD 8B E2    CALL E28Bh *
DABE CB 7C       BIT  7,H
DAC0 F5          PUSH AF
DAC1 C4 B8 E1    CALL NZ,E1B8h *
DAC4 48          LD   C,B
DAC5 06 20       LD   B,20h
DAC7 CD 2A E3    CALL E32Ah *
DACA 38 08       JR   C,DAD4h
DACC 10 F9       DJNZ DAC7h
DACE F1          POP  AF
DACF D9          EXX
DAD0 2C          INC  L
DAD1 D9          EXX
DAD2 4C          LD   C,H
DAD3 C9          RET

DAD4 F1          POP  AF
DAD5 C5          PUSH BC
DAD6 EB          EX   DE,HL
DAD7 E5          PUSH HL
DAD8 D9          EXX
DAD9 EB          EX   DE,HL
DADA E5          PUSH HL
DADB D9          EXX
DADC DD 21 00 00 LD   IX,0000h
DAE0 DD 39       ADD  IX,SP
DAE2 28 40       JR   Z,DB24h
DAE4 C5          PUSH BC
DAE5 D9          EXX
DAE6 D5          PUSH DE
DAE7 D9          EXX
DAE8 D5          PUSH DE
DAE9 CD 61 E2    CALL E261h
DAEC CD F8 DD    CALL DDF8h
DAEF DD 71 04    LD   (IX+04h),C
DAF2 D9          EXX
DAF3 DD 75 00    LD   (IX+00h),L
DAF6 DD 74 01    LD   (IX+01h),H
DAF9 D9          EXX
DAFA DD 75 02    LD   (IX+02h),L
DAFD DD 74 03    LD   (IX+03h),H
DB00 18 1B       JR   DB1Dh
DB02 C5          PUSH BC
DB03 D9          EXX
DB04 CB 23       SLA  E
DB06 CB 12       RL   D
DB08 D5          PUSH DE
DB09 D9          EXX
DB0A CB 13       RL   E
DB0C CB 12       RL   D
DB0E D5          PUSH DE
DB0F F5          PUSH AF
DB10 CD 3C E3    CALL E33Ch
DB13 CD 59 DA    CALL DA59h
DB16 F1          POP  AF
DB17 CD C7 E0    CALL E0C7h
DB1A DC 59 DA    CALL C,DA59h
DB1D D1          POP  DE
DB1E D9          EXX
DB1F D1          POP  DE
DB20 D9          EXX
DB21 79          LD   A,C
DB22 C1          POP  BC
DB23 4F          LD   C,A
DB24 10 DC       DJNZ DB02h
DB26 F1          POP  AF
DB27 F1          POP  AF
DB28 F1          POP  AF
DB29 C9          RET

DB2A F1          POP  AF
DB2B F1          POP  AF
DB2C F1          POP  AF
DB2D 18 95       JR   DAC4h

DB2F CB 7A       BIT  7,D
DB31 F5          PUSH AF
DB32 CD 8B E2    CALL E28Bh *
DB35 CD 4A E3    CALL E34Ah *
DB38 0D          DEC  C
DB39 0C          INC  C
DB3A 28 EE       JR   Z,DB2Ah
DB3C 3E 9E       LD   A,9Eh
DB3E B9          CP   C
DB3F 38 08       JR   C,DB49h
DB41 3C          INC  A
DB42 CD 90 E1    CALL E190h *
DB45 08          EX   AF,AF'
DB46 F2 2A DB    JP   P,DB2Ah *
DB49 CD 8B E2    CALL E28Bh *
DB4C CD 0F DE    CALL DE0Fh *
DB4F CD 53 E3    CALL E353h *
DB52 F1          POP  AF
DB53 CD 61 DA    CALL DA61h *
DB56 C3 84 DD    JP   DD84h *


; FP_LT:
DB59 78          LD   A,B
DB5A B1          OR   C
DB5B 28 08       JR   Z,DB65h
DB5D CD 58 E2    CALL E258h *
DB60 CD DB E2    CALL E2DBh *
DB63 18 03       JR   DB68h
DB65 CD CE E2    CALL E2CEh *
DB68 D0          RET  NC
DB69 18 5B       JR   DBC6h


; FP_GT:
DB6B 78          LD   A,B
DB6C B1          OR   C
DB6D 28 08       JR   Z,DB77h
DB6F CD 58 E2    CALL E258h *
DB72 CD DB E2    CALL E2DBh *
DB75 18 03       JR   DB7Ah
DB77 CD CE E2    CALL E2CEh *
DB7A C8          RET  Z
DB7B D8          RET  C
DB7C 18 48       JR   DBC6h


; FP_GEQ:
DB7E 78          LD   A,B
DB7F B1          OR   C
DB80 28 08       JR   Z,DB8Ah
DB82 CD 58 E2    CALL E258h *
DB85 CD DB E2    CALL E2DBh *
DB88 18 03       JR   DB8Dh

DB8A CD CE E2    CALL E2CEh *
DB8D D8          RET  C
DB8E 18 36       JR   DBC6h


; FP_LEQ:
DB90 78          LD   A,B
DB91 B1          OR   C
DB92 28 08       JR   Z,DB9Ch
DB94 CD 58 E2    CALL E258h *
DB97 CD DB E2    CALL E2DBh *
DB9A 18 03       JR   DB9Fh
DB9C CD CE E2    CALL E2CEh *
DB9F 28 25       JR   Z,DBC6h
DBA1 D0          RET  NC
DBA2 18 22       JR   DBC6h


; FP_NEQ:
DBA4 78          LD   A,B
DBA5 B1          OR   C
DBA6 28 08       JR   Z,DBB0h
DBA8 CD 58 E2    CALL E258h *
DBAB CD DB E2    CALL E2DBh *
DBAE 18 03       JR   DBB3h
DBB0 CD CE E2    CALL E2CEh *
DBB3 C8          RET  Z
DBB4 18 10       JR   DBC6h


; FP_EQ:
DBB6 78          LD   A,B
DBB7 B1          OR   C
DBB8 28 08       JR   Z,DBC2h
DBBA CD 58 E2    CALL E258h *
DBBD CD DB E2    CALL E2DBh *
DBC0 18 03       JR   DBC5h
DBC2 CD CE E2    CALL E2CEh *
DBC5 C0          RET  NZ


; FP_TRU:
DBC6 21 FF FF    LD   HL,FFFFh
DBC9 D9          EXX
DBCA 21 FF FF    LD   HL,FFFFh
DBCD D9          EXX
DBCE AF          XOR  A
DBCF 4F          LD   C,A
DBD0 C9          RET


; FP_NEG:
DBD1 0D          DEC  C
DBD2 0C          INC  C
DBD3 CA B8 E1    JP   Z,E1B8h *
DBD6 7C          LD   A,H
DBD7 EE 80       XOR  80h
DBD9 67          LD   H,A
DBDA C9          RET


; FP_ABS:
DBDB CB 7C       BIT  7,H
DBDD C8          RET  Z                 ; value is positive, return unchanged
DBDE 0D          DEC  C                 ; negative value...
DBDF 0C          INC  C
DBE0 CA B8 E1    JP   Z,E1B8h *         ; convert integer to positive...
DBE3 CB BC       RES  7,H               ; convert float to positive...
DBE5 C9          RET


; FP_NOT:
DBE6 CD A9 E1    CALL E1A9h *
DBE9 7C          LD   A,H
DBEA 2F          CPL
DBEB 67          LD   H,A
DBEC 7D          LD   A,L
DBED 2F          CPL
DBEE 6F          LD   L,A
DBEF D9          EXX
DBF0 7C          LD   A,H
DBF1 2F          CPL
DBF2 67          LD   H,A
DBF3 7D          LD   A,L
DBF4 2F          CPL
DBF5 6F          LD   L,A
DBF6 D9          EXX
DBF7 AF          XOR  A
DBF8 C9          RET



; FP_PI:
DBF9 21 0F 49    LD   HL,490Fh
DBFC D9          EXX
DBFD 21 A2 DA    LD   HL,DAA2h
DC00 D9          EXX
DC01 0E 81       LD   C,81h
DC03 AF          XOR  A
DC04 C9          RET


; FP_DEG:
DC05 CD 15 DC    CALL DC15h *
DC08 CD 61 DA    CALL DA61h *
DC0B AF          XOR  A
DC0C C9          RET


; FP_RAD:
DC0D CD 15 DC    CALL DC15h *
DC10 CD C6 D9    CALL D9C6h *
DC13 AF          XOR  A
DC14 C9          RET

DC15 CD 61 E2    CALL E261h *
DC18 11 2E 65    LD   DE,652Eh
DC1B D9          EXX
DC1C 11 D3 E0    LD   DE,E0D3h
DC1F D9          EXX
DC20 06 85       LD   B,85h
DC22 C9          RET


; FP_SGN:
DC23 CD B1 E2    CALL E2B1h *           ; is HLhl = 0 ?
DC26 B1          OR   C
DC27 C8          RET  Z                 ; Yes, return 0
DC28 CB 7C       BIT  7,H
DC2A C2 C6 DB    JP   NZ,DBC6h *        ; number is negative, return -1
DC2D CD D1 E2    CALL E2D1h *           ; FP_ZER
DC30 C3 77 E2    JP   E277h *           ; number is positive, return 1


; FP_VAL:
DC33 E5          PUSH HL
DC34 DD E1       POP  IX
DC36 CD 9B E4    CALL E49Bh *
DC39 F5          PUSH AF
DC3A CD DE E0    CALL E0DEh *
DC3D F1          POP  AF
DC3E FE 2D       CP   2Dh
DC40 3E 00       LD   A,00h
DC42 20 0E       JR   NZ,DC52h
DC44 0D          DEC  C
DC45 0C          INC  C
DC46 28 07       JR   Z,DC4Fh
DC48 7C          LD   A,H
DC49 EE 80       XOR  80h
DC4B 67          LD   H,A
DC4C AF          XOR  A
DC4D 18 03       JR   DC52h
DC4F CD B8 E1    CALL E1B8h *
DC52 DD E5       PUSH IX
DC54 D1          POP  DE
DC55 C9          RET


; FP_INT:
DC56 0D          DEC  C
DC57 0C          INC  C
DC58 C8          RET  Z
DC59 3E 9F       LD   A,9Fh
DC5B 44          LD   B,H
DC5C CD 90 E1    CALL E190h *
DC5F 08          EX   AF,AF'
DC60 A0          AND  B
DC61 FC 77 E2    CALL M,E277h *
DC64 78          LD   A,B
DC65 B7          OR   A
DC66 FC B8 E1    CALL M,E1B8h *
DC69 AF          XOR  A
DC6A 4F          LD   C,A
DC6B C9          RET


; FP_SQR:
DC6C CD 61 E2    CALL E261h *
DC6F CB 7C       BIT  7,H
DC71 3E 48       LD   A,48h
DC73 C2 0F D8    JP   NZ,D80Fh *
DC76 0D          DEC  C
DC77 0C          INC  C
DC78 C8          RET  Z
DC79 CB FC       SET  7,H
DC7B CB 41       BIT  0,C
DC7D CC 93 E2    CALL Z,E293h *
DC80 79          LD   A,C
DC81 D6 80       SUB  80h
DC83 CB 2F       SRA  A
DC85 C6 80       ADD  A,80h
DC87 4F          LD   C,A
DC88 C5          PUSH BC
DC89 EB          EX   DE,HL
DC8A 21 00 00    LD   HL,0000h
DC8D 44          LD   B,H
DC8E 4D          LD   C,L
DC8F D9          EXX
DC90 EB          EX   DE,HL
DC91 21 00 00    LD   HL,0000h
DC94 44          LD   B,H
DC95 4D          LD   C,L
DC96 3E E1       LD   A,E1h
DC98 CD 41 E4    CALL E441h *
DC9B D9          EXX
DC9C CB 78       BIT  7,B
DC9E D9          EXX
DC9F CC 41 E4    CALL Z,E441h *
DCA2 CD 7A E4    CALL E47Ah *
DCA5 B7          OR   A
DCA6 CD FB E3    CALL E3FBh *
DCA9 CB 1B       RR   E
DCAB 60          LD   H,B
DCAC 69          LD   L,C
DCAD D9          EXX
DCAE 60          LD   H,B
DCAF 69          LD   L,C
DCB0 DC 77 E2    CALL C,E277h *
DCB3 C1          POP  BC
DCB4 DC 9F E2    CALL C,E29Fh *
DCB7 1F          RRA
DCB8 9F          SBC  A,A
DCB9 81          ADD  A,C
DCBA 4F          LD   C,A
DCBB CB BC       RES  7,H
DCBD AF          XOR  A
DCBE C9          RET


; FP_TAN:
DCBF CD 61 E2    CALL E261h *
DCC2 CD 4A E3    CALL E34Ah *
DCC5 CD DF DC    CALL DCDFh *
DCC8 CD 53 E3    CALL E353h *
DCCB CD 4A E3    CALL E34Ah *
DCCE CD 8B E2    CALL E28Bh *
DCD1 CD EA DC    CALL DCEAh *
DCD4 CD 53 E3    CALL E353h *
DCD7 CD C6 D9    CALL D9C6h *
DCDA AF          XOR  A
DCDB C9          RET


; FP_COS:
DCDC CD 61 E2    CALL E261h *
DCDF CD DA E1    CALL E1DAh *
DCE2 1C          INC  E
DCE3 1C          INC  E
DCE4 7B          LD   A,E
DCE5 18 0E       JR   DCF5h


; FP_SIN
DCE7 CD 61 E2    CALL E261h *
DCEA E5          PUSH HL
DCEB CD DA E1    CALL E1DAh *
DCEE F1          POP  AF
DCEF 07          RLCA
DCF0 07          RLCA
DCF1 07          RLCA
DCF2 E6 04       AND  04h
DCF4 AB          XOR  E
DCF5 F5          PUSH AF
DCF6 CB BC       RES  7,H
DCF8 1F          RRA
DCF9 CD 76 DD    CALL DD76h *
DCFC DC 5A D9    CALL C,D95Ah *
DCFF F1          POP  AF
DD00 F5          PUSH AF
DD01 E6 03       AND  03h
DD03 E2 34 DD    JP   PO,DD34h *
DD06 CD 4A E3    CALL E34Ah *
DD09 CD 44 E3    CALL E344h *
DD0C CD 7D E3    CALL E37Dh *

DD0F B7 A8 11 36 6D 26 DE 05 D0 73 C0 80 ...6m&...s..
DD1B 88 08 79 9D AA AA AA 7D 00 00 00 00 ..y....}....
DD27 80


DD28 CD 53 E3    CALL E353h *
DD2B CD 53 E3    CALL E353h *
DD2E CD 61 DA    CALL DA61h
DD31 C3 56 DD    JP   DD56h

DD34 CD 44 E3    CALL E344h *
DD37 CD 7D E3    CALL E37Dh *

DD3A 71 D5 78 4C 70 AF 94 03 B6 76 C8 9C q.xLp....v..
DD46 AA 2A 7B DD FF FF FF 7E 00 00 00 00 .*{....~....
DD52 80


DD53 CD 53 E3    CALL E353h *
DD56 F1          POP  AF
DD57 E6 04       AND  04h
DD59 C8          RET  Z
DD5A 0D          DEC  C
DD5B 0C          INC  C
DD5C C8          RET  Z
DD5D CB FC       SET  7,H
DD5F C9          RET

; FP_ONE:
DD60 21 00 00    LD   HL,0000h
DD63 D9          EXX
DD64 21 00 00    LD   HL,0000h
DD67 D9          EXX
DD68 0E 80       LD   C,80h
DD6A C9          RET

DD6B 11 00 00    LD   DE,0000h
DD6E D9          EXX
DD6F 11 00 00    LD   DE,0000h
DD72 D9          EXX
DD73 06 80       LD   B,80h
DD75 C9          RET

DD76 11 0F 49    LD   DE,490Fh
DD79 D9          EXX
DD7A 11 A2 DA    LD   DE,DAA2h
DD7D D9          EXX
DD7E 06 7F       LD   B,7Fh
DD80 C9          RET


; FP_EXP:
DD81 CD 61 E2    CALL E261h *
DD84 CD 01 DE    CALL DE01h *
DD87 D9          EXX
DD88 1D          DEC  E
DD89 01 CF D1    LD   BC,D1CFh
DD8C D9          EXX
DD8D E5          PUSH HL
DD8E CD EA E1    CALL E1EAh *
DD91 F1          POP  AF
DD92 CB 7B       BIT  7,E
DD94 28 09       JR   Z,DD9Fh
DD96 17          RLA
DD97 DA D1 E2    JP   C,E2D1h *
DD9A 3E 4B       LD   A,4Bh
DD9C C3 0F D8    JP   D80Fh *
DD9F E6 80       AND  80h
DDA1 B3          OR   E
DDA2 F5          PUSH AF
DDA3 CB BC       RES  7,H
DDA5 CD 4A E3    CALL E34Ah *
DDA8 CD 7D E3    CALL E37Dh *

DDAB 72 40 2E 94 73 65 6F 4F 2E 76 37 6D r@..seoO.v7m
DDB7 02 88 79 12 E5 A0 2A 7B 14 4F AA AA ..y...*{.O..
DDC3 7D 56 FD FF 7F 7E FE FF FF FF 7F 00 }V...~......
DDCF 00 00 00 80


DDD3 CD 53 E3    CALL E353h *
DDD6 F1          POP  AF
DDD7 F5          PUSH AF
DDD8 F4 F8 DD    CALL P,DDF8h *
DDDB F1          POP  AF
DDDC F2 E3 DD    JP   P,DDE3h
DDDF E6 7F       AND  7Fh
DDE1 ED 44       NEG
DDE3 C6 80       ADD  A,80h
DDE5 81          ADD  A,C
DDE6 38 05       JR   C,DDEDh
DDE8 F2 D1 E2    JP   P,E2D1h
DDEB 18 03       JR   DDF0h
DDED FA A1 E2    JP   M,E2A1h
DDF0 C6 80       ADD  A,80h
DDF2 CA D1 E2    JP   Z,E2D1h
DDF5 4F          LD   C,A
DDF6 AF          XOR  A
DDF7 C9          RET

DDF8 CD 6B DD    CALL DD6Bh
DDFB CD 8B E2    CALL E28Bh *
DDFE C3 C6 D9    JP   D9C6h

DE01 11 72 31    LD   DE,3172h
DE04 D9          EXX
DE05 11 F8 17    LD   DE,17F8h
DE08 D9          EXX
DE09 06 7F       LD   B,7Fh
DE0B C9          RET


; FP_LN:
DE0C CD 61 E2    CALL E261h *
DE0F 3E 49       LD   A,49h
DE11 CB 7C       BIT  7,H
DE13 C2 0F D8    JP   NZ,D80Fh *
DE16 0C          INC  C
DE17 0D          DEC  C
DE18 CA 0F D8    JP   Z,D80Fh *
DE1B 11 04 35    LD   DE,3504h
DE1E D9          EXX
DE1F 11 33 F3    LD   DE,F333h
DE22 D9          EXX
DE23 CD E3 E2    CALL E2E3h *
DE26 79          LD   A,C
DE27 0E 80       LD   C,80h
DE29 38 02       JR   C,DE2Dh
DE2B 0D          DEC  C
DE2C 3C          INC  A
DE2D F5          PUSH AF
DE2E CD 5F E3    CALL E35Fh *
DE31 CD 4A E3    CALL E34Ah *
DE34 CD 44 E3    CALL E344h *
DE37 CD 7D E3    CALL E37Dh *

DE3A 48 CC FB 74 7D AF AE FF 11 7E 8C D9 H..t}....~..
DE46 CD 4C 7E E3 A9 AA 2A 7F 00 00 00 00 .L~...*.....
DE52 81


DE53 CD 53 E3    CALL E353h
DE56 CD 53 E3    CALL E353h
DE59 CD 61 DA    CALL DA61h
DE5C F1          POP  AF
DE5D CD 4A E3    CALL E34Ah
DE60 08          EX   AF,AF'
DE61 CD D1 E2    CALL E2D1h
DE64 08          EX   AF,AF'
DE65 D6 80       SUB  80h
DE67 28 1B       JR   Z,DE84h
DE69 30 02       JR   NC,DE6Dh
DE6B 2F          CPL
DE6C 3C          INC  A
DE6D 67          LD   H,A
DE6E 0E 87       LD   C,87h
DE70 F5          PUSH AF
DE71 CD 4B E2    CALL E24Bh
DE74 CB BC       RES  7,H
DE76 CD 01 DE    CALL DE01h
DE79 CD 61 DA    CALL DA61h
DE7C F1          POP  AF
DE7D 30 05       JR   NC,DE84h
DE7F FA 84 DE    JP   M,DE84h
DE82 CB FC       SET  7,H
DE84 CD 53 E3    CALL E353h
DE87 CD 6E D9    CALL D96Eh
DE8A AF          XOR  A
DE8B C9          RET


; FP_LOG:
DE8C CD 0C DE    CALL DE0Ch *
DE8F 11 5B 5E    LD   DE,5E5Bh
DE92 D9          EXX
DE93 11 A9 D8    LD   DE,D8A9h
DE96 D9          EXX
DE97 06 7E       LD   B,7Eh
DE99 CD 61 DA    CALL DA61h *
DE9C AF          XOR  A
DE9D C9          RET


; FP_ASN:
DE9E CD 61 E2    CALL E261h *
DEA1 CD 4A E3    CALL E34Ah *
DEA4 CD 3C E3    CALL E33Ch *
DEA7 CD 61 DA    CALL DA61h *
DEAA CD 6B DD    CALL DD6Bh *
DEAD CD 5A D9    CALL D95Ah *
DEB0 CD 6F DC    CALL DC6Fh *
DEB3 CD 53 E3    CALL E353h *
DEB6 0C          INC  C
DEB7 0D          DEC  C
DEB8 3E 02       LD   A,02h
DEBA D5          PUSH DE
DEBB 28 70       JR   Z,DF2Dh
DEBD D1          POP  DE
DEBE CD FB DD    CALL DDFBh *
DEC1 18 03       JR   DEC6h


; FP_ATN:
DEC3 CD 61 E2    CALL E261h *
DEC6 E5          PUSH HL
DEC7 CB BC       RES  7,H
DEC9 11 13 54    LD   DE,5413h
DECC D9          EXX
DECD 11 D0 CC    LD   DE,CCD0h
DED0 D9          EXX
DED1 06 7E       LD   B,7Eh
DED3 CD E0 E2    CALL E2E0h *
DED6 06 00       LD   B,00h
DED8 38 1C       JR   C,DEF6h
DEDA 11 82 1A    LD   DE,1A82h
DEDD D9          EXX
DEDE 11 9A 79    LD   DE,799Ah
DEE1 D9          EXX
DEE2 06 81       LD   B,81h
DEE4 CD E0 E2    CALL E2E0h *
DEE7 38 08       JR   C,DEF1h
DEE9 CD F8 DD    CALL DDF8h *
DEEC 06 02       LD   B,02h
DEEE C3 F6 DE    JP   DEF6h *

DEF1 CD 5F E3    CALL E35Fh *
DEF4 06 01       LD   B,01h
DEF6 C5          PUSH BC
DEF7 CD 4A E3    CALL E34Ah *
DEFA CD 44 E3    CALL E344h *
DEFD CD 7D E3    CALL E37Dh *

DF00 35 F3 D8 37 7B 91 6B B9 AA 7C DE 41 5..7{.k..|.A
DF0C 97 61 7C 7B 9D 37 92 7D 5A 2A CC 4C .a|{.7.}Z*.L
DF18 7D 5C A9 AA AA 7E 00 00 00 00 80


DF23 CD 53 E3    CALL E353h
DF26 CD 53 E3    CALL E353h
DF29 CD 61 DA    CALL DA61h
DF2C F1          POP  AF
DF2D CD 76 DD    CALL DD76h *
DF30 1F          RRA
DF31 F5          PUSH AF
DF32 DC 6E D9    CALL C,D96Eh *
DF35 F1          POP  AF
DF36 04          INC  B
DF37 1F          RRA
DF38 DC 5A D9    CALL C,D95Ah *
DF3B F1          POP  AF
DF3C B7          OR   A
DF3D F0          RET  P
DF3E CB FC       SET  7,H
DF40 AF          XOR  A
DF41 C9          RET


; FP_ACS:
DF42 CD 9E DE    CALL DE9Eh *
DF45 3E 02       LD   A,02h
DF47 F5          PUSH AF
DF48 18 E3       JR   DF2Dh


; FP_STR:
DF4A D9          EXX
DF4B D5          PUSH DE
DF4C D9          EXX
DF4D DD 21 00 00 LD   IX,0000h
DF51 DD 39       ADD  IX,SP
DF53 CD 61 E2    CALL E261h *
DF56 06 00       LD   B,00h
DF58 CB 7C       BIT  7,H
DF5A 28 0A       JR   Z,DF66h
DF5C CB BC       RES  7,H
DF5E 3E 2D       LD   A,2Dh
DF60 EB          EX   DE,HL
DF61 CD D6 E4    CALL E4D6h *
DF64 EB          EX   DE,HL
DF65 13          INC  DE
DF66 AF          XOR  A
DF67 B9          CP   C
DF68 28 47       JR   Z,DFB1h
DF6A D5          PUSH DE
DF6B 78          LD   A,B
DF6C F5          PUSH AF
DF6D 79          LD   A,C
DF6E FE A1       CP   A1h
DF70 30 1A       JR   NC,DF8Ch
DF72 FE 9B       CP   9Bh
DF74 30 25       JR   NC,DF9Bh
DF76 2F          CPL
DF77 FE E1       CP   E1h
DF79 38 02       JR   C,DF7Dh
DF7B 3E F8       LD   A,F8h
DF7D C6 1C       ADD  A,1Ch
DF7F CD A4 E3    CALL E3A4h *
DF82 F5          PUSH AF
DF83 CD 61 DA    CALL DA61h *
DF86 F1          POP  AF
DF87 47          LD   B,A
DF88 F1          POP  AF
DF89 90          SUB  B
DF8A 18 E0       JR   DF6Ch
DF8C D6 20       SUB  20h
DF8E CD A4 E3    CALL E3A4h *
DF91 F5          PUSH AF
DF92 CD C6 D9    CALL D9C6h *
DF95 F1          POP  AF
DF96 47          LD   B,A
DF97 F1          POP  AF
DF98 80          ADD  A,B
DF99 18 D1       JR   DF6Ch
DF9B 3E 09       LD   A,09h
DF9D CD A4 E3    CALL E3A4h *
DFA0 CD E0 E2    CALL E2E0h *
DFA3 79          LD   A,C
DFA4 C1          POP  BC
DFA5 4F          LD   C,A
DFA6 CB FC       SET  7,H
DFA8 DC 01 E3    CALL C,E301h
DFAB D1          POP  DE
DFAC CB B9       RES  7,C
DFAE 3E 00       LD   A,00h
DFB0 17          RLA
DFB1 0C          INC  C
DFB2 08          EX   AF,AF'
DFB3 78          LD   A,B
DFB4 DD CB 01 4E BIT  1,(IX+01h)
DFB8 20 08       JR   NZ,DFC2h
DFBA AF          XOR  A
DFBB DD BE 00    CP   (IX+00h)
DFBE 28 0A       JR   Z,DFCAh
DFC0 3E F6       LD   A,F6h
DFC2 DD 86 00    ADD  A,(IX+00h)
DFC5 B7          OR   A
DFC6 FA CA DF    JP   M,DFCAh
DFC9 AF          XOR  A
DFCA F5          PUSH AF
DFCB 08          EX   AF,AF'
DFCC CD 2A E3    CALL E32Ah *
DFCF 8F          ADC  A,A
DFD0 FE 0A       CP   0Ah
DFD2 38 05       JR   C,DFD9h
DFD4 D6 0A       SUB  0Ah
DFD6 D9          EXX
DFD7 2C          INC  L
DFD8 D9          EXX
DFD9 0D          DEC  C
DFDA 20 F0       JR   NZ,DFCCh
DFDC 4F          LD   C,A
DFDD 7C          LD   A,H
DFDE E6 3F       AND  3Fh
DFE0 67          LD   H,A
DFE1 F1          POP  AF
DFE2 F2 EF DF    JP   P,DFEFh
DFE5 3C          INC  A
DFE6 20 1C       JR   NZ,E004h
DFE8 3E 04       LD   A,04h
DFEA B9          CP   C
DFEB 3E 00       LD   A,00h
DFED 18 15       JR   E004h
DFEF F5          PUSH AF
DFF0 79          LD   A,C
DFF1 CE 30       ADC  A,30h
DFF3 FE 30       CP   30h
DFF5 28 05       JR   Z,DFFCh
DFF7 FE 3A       CP   3Ah
DFF9 3F          CCF
DFFA 30 08       JR   NC,E004h
DFFC E3          EX   (SP),HL
DFFD CB 75       BIT  6,L
DFFF E3          EX   (SP),HL
E000 20 05       JR   NZ,E007h
E002 3E 30       LD   A,30h
E004 3C          INC  A
E005 3D          DEC  A
E006 F5          PUSH AF
E007 04          INC  B
E008 CD B1 E2    CALL E2B1h *
E00B 0E 20       LD   C,20h
E00D 3E 00       LD   A,00h
E00F 20 BB       JR   NZ,DFCCh
E011 F1          POP  AF
E012 F5          PUSH AF
E013 3E 00       LD   A,00h
E015 38 B5       JR   C,DFCCh
E017 EB          EX   DE,HL
E018 0E FF       LD   C,FFh
E01A 16 01       LD   D,01h
E01C DD 5E 00    LD   E,(IX+00h)
E01F DD CB 01 46 BIT  0,(IX+01h)
E023 20 32       JR   NZ,E057h
E025 DD CB 01 4E BIT  1,(IX+01h)
E029 28 11       JR   Z,E03Ch
E02B 78          LD   A,B
E02C B7          OR   A
E02D 28 04       JR   Z,E033h
E02F FA 33 E0    JP   M,E033h
E032 50          LD   D,B
E033 7A          LD   A,D
E034 DD 86 00    ADD  A,(IX+00h)
E037 5F          LD   E,A
E038 FE 0B       CP   0Bh
E03A 38 17       JR   C,E053h
E03C 78          LD   A,B
E03D 11 01 01    LD   DE,0101h
E040 B7          OR   A
E041 FA 57 E0    JP   M,E057h
E044 28 0D       JR   Z,E053h
E046 DD 7E 00    LD   A,(IX+00h)
E049 B7          OR   A
E04A 20 02       JR   NZ,E04Eh
E04C 3E 0A       LD   A,0Ah
E04E B8          CP   B
E04F 38 06       JR   C,E057h
E051 50          LD   D,B
E052 58          LD   E,B
E053 78          LD   A,B
E054 C6 81       ADD  A,81h
E056 4F          LD   C,A
E057 CB FA       SET  7,D
E059 1D          DEC  E
E05A 7A          LD   A,D
E05B B9          CP   C
E05C 30 0C       JR   NC,E06Ah
E05E F1          POP  AF
E05F 28 03       JR   Z,E064h
E061 F2 6C E0    JP   P,E06Ch
E064 F5          PUSH AF
E065 1C          INC  E
E066 1D          DEC  E
E067 FA 82 E0    JP   M,E082h
E06A 3E 30       LD   A,30h
E06C 15          DEC  D
E06D E2 78 E0    JP   PO,E078h
E070 F5          PUSH AF
E071 3E 2E       LD   A,2Eh
E073 CD D6 E4    CALL E4D6h *
E076 F1          POP  AF
E077 23          INC  HL
E078 CD D6 E4    CALL E4D6h *
E07B 23          INC  HL
E07C 1D          DEC  E
E07D F2 5A E0    JP   P,E05Ah
E080 18 DC       JR   E05Eh
E082 F1          POP  AF
E083 0C          INC  C
E084 4D          LD   C,L
E085 20 39       JR   NZ,E0C0h
E087 3E 45       LD   A,45h
E089 CD D6 E4    CALL E4D6h *
E08C 23          INC  HL
E08D 78          LD   A,B
E08E 3D          DEC  A
E08F F2 9C E0    JP   P,E09Ch
E092 F5          PUSH AF
E093 3E 2D       LD   A,2Dh
E095 CD D6 E4    CALL E4D6h *
E098 F1          POP  AF
E099 23          INC  HL
E09A ED 44       NEG
E09C 16 00       LD   D,00h
E09E 1E 30       LD   E,30h
E0A0 28 11       JR   Z,E0B3h
E0A2 FE 0A       CP   0Ah
E0A4 47          LD   B,A
E0A5 3E 3A       LD   A,3Ah
E0A7 38 01       JR   C,E0AAh
E0A9 53          LD   D,E
E0AA 1C          INC  E
E0AB BB          CP   E
E0AC 20 03       JR   NZ,E0B1h
E0AE 1E 30       LD   E,30h
E0B0 14          INC  D
E0B1 10 F7       DJNZ E0AAh
E0B3 7A          LD   A,D
E0B4 B7          OR   A
E0B5 28 04       JR   Z,E0BBh
E0B7 CD D6 E4    CALL E4D6h *
E0BA 23          INC  HL
E0BB 7B          LD   A,E
E0BC CD D6 E4    CALL E4D6h *
E0BF 23          INC  HL
E0C0 AF          XOR  A
E0C1 CD D6 E4    CALL E4D6h *
E0C4 EB          EX   DE,HL
E0C5 E1          POP  HL
E0C6 C9          RET

E0C7 DD 46 04    LD   B,(IX+04h)
E0CA D9          EXX
E0CB DD 5E 00    LD   E,(IX+00h)
E0CE DD 56 01    LD   D,(IX+01h)
E0D1 D9          EXX
E0D2 DD 5E 02    LD   E,(IX+02h)
E0D5 DD 56 03    LD   D,(IX+03h)
E0D8 C9          RET

E0D9 3E 4C       LD   A,4Ch
E0DB C3 0F D8    JP   D80Fh *

E0DE CD D1 E2    CALL E2D1h *
E0E1 0E 00       LD   C,00h
E0E3 CD 6B E1    CALL E16Bh *
E0E6 FE 2E       CP   2Eh
E0E8 06 00       LD   B,00h
E0EA CC 69 E1    CALL Z,E169h *
E0ED FE 2E       CP   2Eh
E0EF 28 E8       JR   Z,E0D9h
E0F1 FE 45       CP   45h
E0F3 28 02       JR   Z,E0F7h
E0F5 FE 65       CP   65h
E0F7 3E 00       LD   A,00h
E0F9 CC 3A E1    CALL Z,E13Ah *
E0FC CB 7C       BIT  7,H
E0FE 20 08       JR   NZ,E108h
E100 B7          OR   A
E101 20 05       JR   NZ,E108h
E103 B8          CP   B
E104 20 02       JR   NZ,E108h
E106 B9          CP   C
E107 C8          RET  Z
E108 90          SUB  B
E109 81          ADD  A,C
E10A 0E 9F       LD   C,9Fh
E10C CD 4B E2    CALL E24Bh *
E10F CB BC       RES  7,H
E111 B7          OR   A
E112 C8          RET  Z
E113 FA 1E E1    JP   M,E11Eh
E116 CD A4 E3    CALL E3A4h *
E119 CD 61 DA    CALL DA61h *
E11C AF          XOR  A
E11D C9          RET

E11E FE DA       CP   DAh
E120 38 0A       JR   C,E12Ch
E122 ED 44       NEG
E124 CD A4 E3    CALL E3A4h *
E127 CD C6 D9    CALL D9C6h *
E12A AF          XOR  A
E12B C9          RET

E12C F5          PUSH AF
E12D 3E 26       LD   A,26h
E12F CD A4 E3    CALL E3A4h *
E132 CD C6 D9    CALL D9C6h *
E135 F1          POP  AF
E136 C6 26       ADD  A,26h
E138 18 E4       JR   E11Eh

E13A C5          PUSH BC
E13B 47          LD   B,A
E13C 0E 02       LD   C,02h
E13E DD 23       INC  IX
E140 CD 9B E4    CALL E49Bh *
E143 08          EX   AF,AF'
E144 CD 91 E4    CALL E491h *
E147 38 17       JR   C,E160h
E149 78          LD   A,B
E14A 87          ADD  A,A
E14B 87          ADD  A,A
E14C 80          ADD  A,B
E14D 87          ADD  A,A
E14E 47          LD   B,A
E14F CD AD E4    CALL E4ADh *
E152 DD 23       INC  IX
E154 E6 0F       AND  0Fh
E156 80          ADD  A,B
E157 47          LD   B,A
E158 0D          DEC  C
E159 F2 44 E1    JP   P,E144h *
E15C 06 64       LD   B,64h
E15E 18 E4       JR   E144h
E160 08          EX   AF,AF'
E161 FE 2D       CP   2Dh
E163 78          LD   A,B
E164 C1          POP  BC
E165 C0          RET  NZ
E166 ED 44       NEG
E168 C9          RET

E169 DD 23       INC  IX
E16B CD 91 E4    CALL E491h *
E16E D8          RET  C
E16F 04          INC  B
E170 DD 23       INC  IX
E172 CD 1B E3    CALL E31Bh *
E175 38 13       JR   C,E18Ah
E177 0D          DEC  C
E178 0C          INC  C
E179 20 0F       JR   NZ,E18Ah
E17B E6 0F       AND  0Fh
E17D D9          EXX
E17E 06 00       LD   B,00h
E180 4F          LD   C,A
E181 09          ADD  HL,BC
E182 D9          EXX
E183 30 E6       JR   NC,E16Bh
E185 23          INC  HL
E186 7C          LD   A,H
E187 B5          OR   L
E188 20 E1       JR   NZ,E16Bh
E18A 0C          INC  C
E18B CD 8E E2    CALL E28Eh *
E18E 18 DB       JR   E16Bh

E190 08          EX   AF,AF'
E191 AF          XOR  A
E192 08          EX   AF,AF'
E193 CB FC       SET  7,H
E195 CD 93 E2    CALL E293h *
E198 B9          CP   C
E199 C8          RET  Z
E19A D2 95 E1    JP   NC,E195h
E19D C3 A1 E2    JP   E2A1h *

E1A0 CD 8B E2    CALL E28Bh *
E1A3 CD A9 E1    CALL E1A9h *
E1A6 CD 8B E2    CALL E28Bh *


; FP_FIX
E1A9 0D          DEC  C
E1AA 0C          INC  C
E1AB C8          RET  Z
E1AC CB 7C       BIT  7,H
E1AE F5          PUSH AF
E1AF 3E 9F       LD   A,9Fh
E1B1 CD 90 E1    CALL E190h *
E1B4 F1          POP  AF
E1B5 0E 00       LD   C,00h
E1B7 C8          RET  Z

E1B8 B7          OR   A                 ; Fc = 0 (Carry may not be considered)
E1B9 D9          EXX
E1BA D5          PUSH DE
E1BB EB          EX   DE,HL             ; low word of integer...
E1BC 21 00 00    LD   HL,0000h
E1BF ED 52       SBC  HL,DE             ; integer = 0 - (-integer), convert to positive
E1C1 D1          POP  DE
E1C2 D9          EXX
E1C3 D5          PUSH DE
E1C4 EB          EX   DE,HL             ; high word of integer...
E1C5 21 00 00    LD   HL,0000h
E1C8 ED 52       SBC  HL,DE
E1CA D1          POP  DE
E1CB C9          RET

E1CC D9          EXX
E1CD 2F          CPL
E1CE E5          PUSH HL
E1CF B7          OR   A
E1D0 21 00 00    LD   HL,0000h
E1D3 ED 42       SBC  HL,BC
E1D5 44          LD   B,H
E1D6 4D          LD   C,L
E1D7 E1          POP  HL
E1D8 18 E0       JR   E1BAh

E1DA 3E 96       LD   A,96h
E1DC B9          CP   C
E1DD 3E 4A       LD   A,4Ah
E1DF DA 0F D8    JP   C,D80Fh
E1E2 CD 76 DD    CALL DD76h *
E1E5 D9          EXX
E1E6 01 69 21    LD   BC,2169h
E1E9 D9          EXX

E1EA CB FA       SET  7,D
E1EC CB FC       SET  7,H
E1EE 79          LD   A,C
E1EF 0E 00       LD   C,00h
E1F1 DD 21 00 00 LD   IX,0000h
E1F5 DD E5       PUSH IX
E1F7 B8          CP   B
E1F8 38 3A       JR   C,E234h

E1FA D9          EXX
E1FB E3          EX   (SP),HL
E1FC ED 42       SBC  HL,BC
E1FE E3          EX   (SP),HL
E1FF ED 52       SBC  HL,DE
E201 D9          EXX
E202 ED 52       SBC  HL,DE
E204 30 09       JR   NC,E20Fh
E206 D9          EXX
E207 E3          EX   (SP),HL
E208 09          ADD  HL,BC
E209 E3          EX   (SP),HL
E20A ED 5A       ADC  HL,DE
E20C D9          EXX
E20D ED 5A       ADC  HL,DE
E20F 3F          CCF
E210 CB 11       RL   C
E212 30 02       JR   NC,E216h
E214 CB F9       SET  7,C
E216 3D          DEC  A
E217 B8          CP   B
E218 38 19       JR   C,E233h
E21A E3          EX   (SP),HL
E21B 29          ADD  HL,HL
E21C E3          EX   (SP),HL
E21D D9          EXX
E21E ED 6A       ADC  HL,HL
E220 D9          EXX
E221 ED 6A       ADC  HL,HL
E223 30 D5       JR   NC,E1FAh
E225 B7          OR   A
E226 D9          EXX
E227 E3          EX   (SP),HL
E228 ED 42       SBC  HL,BC
E22A E3          EX   (SP),HL
E22B ED 52       SBC  HL,DE
E22D D9          EXX
E22E ED 52       SBC  HL,DE
E230 B7          OR   A
E231 18 DC       JR   E20Fh

E233 3C          INC  A
E234 59          LD   E,C
E235 4F          LD   C,A
E236 D9          EXX
E237 C1          POP  BC
E238 D9          EXX

E239 CB 7C       BIT  7,H
E23B C0          RET  NZ
E23C D9          EXX
E23D CB 21       SLA  C
E23F CB 10       RL   B
E241 ED 6A       ADC  HL,HL
E243 D9          EXX
E244 ED 6A       ADC  HL,HL
E246 0D          DEC  C
E247 C2 39 E2    JP   NZ,E239h
E24A C9          RET

E24B CB 7C       BIT  7,H
E24D C0          RET  NZ
E24E D9          EXX
E24F 29          ADD  HL,HL
E250 D9          EXX
E251 ED 6A       ADC  HL,HL
E253 0D          DEC  C
E254 C2 4B E2    JP   NZ,E24Bh
E257 C9          RET

E258 CD 8B E2    CALL E28Bh *
E25B CD 61 E2    CALL E261h *
E25E CD 8B E2    CALL E28Bh *


; FP_FLT:
E261 0D          DEC  C
E262 0C          INC  C
E263 C0          RET  NZ
E264 CD B1 E2    CALL E2B1h *
E267 C8          RET  Z
E268 7C          LD   A,H
E269 B7          OR   A
E26A FC B8 E1    CALL M,E1B8h *
E26D 0E 9F       LD   C,9Fh
E26F CD 4B E2    CALL E24Bh *
E272 B7          OR   A
E273 F8          RET  M
E274 CB BC       RES  7,H
E276 C9          RET

E277 D9          EXX
E278 01 01 00    LD   BC,0001h
E27B 09          ADD  HL,BC
E27C D9          EXX
E27D D0          RET  NC
E27E C5          PUSH BC
E27F 01 01 00    LD   BC,0001h
E282 09          ADD  HL,BC
E283 C1          POP  BC
E284 C9          RET

E285 B7          OR   A
E286 D9          EXX
E287 CB C5       SET  0,L
E289 D9          EXX
E28A C9          RET

E28B 79          LD   A,C
E28C 48          LD   C,B
E28D 47          LD   B,A
E28E EB          EX   DE,HL
E28F D9          EXX
E290 EB          EX   DE,HL
E291 D9          EXX
E292 C9          RET

E293 CD 31 E3    CALL E331h *
E296 D9          EXX
E297 CB 18       RR   B
E299 CB 19       RR   C
E29B 08          EX   AF,AF'
E29C B0          OR   B
E29D 08          EX   AF,AF'
E29E D9          EXX

E29F 0C          INC  C
E2A0 C0          RET  NZ

E2A1 3E 47       LD   A,47h
E2A3 C3 0F D8    JP   D80Fh *


; FP_TST:
E2A6 CD B1 E2    CALL E2B1h *
E2A9 B1          OR   C
E2AA C8          RET  Z
E2AB 7C          LD   A,H
E2AC E6 80       AND  80h
E2AE F6 40       OR   40h
E2B0 C9          RET

; Zero_test: Fz = 1, number is zero...
E2B1 7C          LD   A,H
E2B2 B5          OR   L
E2B3 D9          EXX
E2B4 B4          OR   H
E2B5 B5          OR   L
E2B6 D9          EXX
E2B7 C9          RET


; FP_CMP:
E2B8 78          LD   A,B
E2B9 B1          OR   C
E2BA 20 0A       JR   NZ,E2C6h
E2BC CD F9 E2    CALL E2F9h *
E2BF 3E 00       LD   A,00h
E2C1 C8          RET  Z
E2C2 3E 80       LD   A,80h
E2C4 1F          RRA
E2C5 C9          RET
E2C6 CD 58 E2    CALL E258h *
E2C9 CD ED E2    CALL E2EDh *
E2CC 18 F1       JR   E2BFh

E2CE CD F9 E2    CALL E2F9h *


; FP_ZER - Zero:
E2D1 3E 00       LD   A,00h
E2D3 D9          EXX
E2D4 67          LD   H,A
E2D5 6F          LD   L,A
E2D6 D9          EXX
E2D7 67          LD   H,A
E2D8 6F          LD   L,A
E2D9 4F          LD   C,A
E2DA C9          RET

E2DB CD ED E2    CALL E2EDh *
E2DE 18 F1       JR   E2D1h

E2E0 79          LD   A,C
E2E1 B8          CP   B
E2E2 C0          RET  NZ

E2E3 ED 52       SBC  HL,DE
E2E5 19          ADD  HL,DE
E2E6 C0          RET  NZ
E2E7 D9          EXX
E2E8 ED 52       SBC  HL,DE
E2EA 19          ADD  HL,DE
E2EB D9          EXX
E2EC C9          RET

E2ED 7C          LD   A,H
E2EE AA          XOR  D
E2EF 7C          LD   A,H
E2F0 17          RLA
E2F1 F8          RET  M
E2F2 30 EC       JR   NC,E2E0h
E2F4 CD E0 E2    CALL E2E0h *
E2F7 3F          CCF
E2F8 C9          RET

E2F9 7C          LD   A,H
E2FA AA          XOR  D
E2FB F2 E3 E2    JP   P,E2E3h *
E2FE 7C          LD   A,H
E2FF 17          RLA
E300 C9          RET

E301 05          DEC  B
E302 0C          INC  C
E303 CD 3D E3    CALL E33Dh *
E306 CD 30 E3    CALL E330h *
E309 CD 30 E3    CALL E330h *
E30C 08          EX   AF,AF'

E30D D9          EXX
E30E 19          ADD  HL,DE
E30F D9          EXX
E310 ED 5A       ADC  HL,DE
E312 C9          RET

E313 D9          EXX
E314 B7          OR   A
E315 ED 52       SBC  HL,DE
E317 D9          EXX
E318 ED 52       SBC  HL,DE
E31A C9          RET

E31B CD 3D E3    CALL E33Dh *
E31E CD 2A E3    CALL E32Ah *
E321 D8          RET  C
E322 CD 2A E3    CALL E32Ah *
E325 D8          RET  C
E326 CD 0D E3    CALL E30Dh *
E329 D8          RET  C
E32A D9          EXX
E32B 29          ADD  HL,HL
E32C D9          EXX
E32D ED 6A       ADC  HL,HL
E32F C9          RET

E330 0C          INC  C
E331 CB 3C       SRL  H
E333 CB 1D       RR   L
E335 D9          EXX
E336 CB 1C       RR   H
E338 CB 1D       RR   L
E33A D9          EXX
E33B C9          RET

E33C 41          LD   B,C
E33D 54          LD   D,H
E33E 5D          LD   E,L
E33F D9          EXX
E340 54          LD   D,H
E341 5D          LD   E,L
E342 D9          EXX
E343 C9          RET

E344 CD 3C E3    CALL E33Ch *
E347 CD 61 DA    CALL DA61h *
E34A DD E1       POP  IX
E34C C5          PUSH BC
E34D E5          PUSH HL
E34E D9          EXX
E34F E5          PUSH HL
E350 D9          EXX
E351 DD E9       JP   (IX)

E353 DD E1       POP  IX
E355 D9          EXX
E356 D1          POP  DE
E357 D9          EXX
E358 D1          POP  DE
E359 79          LD   A,C
E35A C1          POP  BC
E35B 41          LD   B,C
E35C 4F          LD   C,A
E35D DD E9       JP   (IX)

E35F CD 4A E3    CALL E34Ah *
E362 CD 6B DD    CALL DD6Bh *
E365 CD 6E D9    CALL D96Eh *
E368 CD 53 E3    CALL E353h *
E36B CD 4A E3    CALL E34Ah *
E36E CD 8B E2    CALL E28Bh *
E371 CD 6B DD    CALL DD6Bh *
E374 CD 54 D9    CALL D954h *
E377 CD 53 E3    CALL E353h *
E37A C3 C6 D9    JP   D9C6h *

E37D DD 21 02 00 LD   IX,0002h
E381 DD 39       ADD  IX,SP
E383 DD E3       EX   (SP),IX
E385 CD C7 E0    CALL E0C7h *
E388 CD 61 DA    CALL DA61h *
E38B 11 05 00    LD   DE,0005h
E38E DD 19       ADD  IX,DE
E390 CD C7 E0    CALL E0C7h *
E393 DD E3       EX   (SP),IX
E395 04          INC  B
E396 05          DEC  B
E397 FA 6E D9    JP   M,D96Eh *
E39A CD 6E D9    CALL D96Eh *
E39D CD C7 E0    CALL E0C7h *
E3A0 DD E3       EX   (SP),IX
E3A2 18 E4       JR   E388h

E3A4 3C          INC  A
E3A5 08          EX   AF,AF'
E3A6 E5          PUSH HL
E3A7 D9          EXX
E3A8 E5          PUSH HL
E3A9 D9          EXX
E3AA CD 6B DD    CALL DD6Bh *
E3AD CD 8B E2    CALL E28Bh *
E3B0 AF          XOR  A
E3B1 08          EX   AF,AF'
E3B2 3D          DEC  A
E3B3 28 20       JR   Z,E3D5h
E3B5 F2 BC E3    JP   P,E3BCh
E3B8 B9          CP   C
E3B9 38 1A       JR   C,E3D5h
E3BB 3C          INC  A
E3BC 08          EX   AF,AF'
E3BD 3C          INC  A
E3BE CB FC       SET  7,H
E3C0 CD 03 E3    CALL E303h *
E3C3 30 05       JR   NC,E3CAh
E3C5 08          EX   AF,AF'
E3C6 CD 30 E3    CALL E330h *
E3C9 08          EX   AF,AF'
E3CA 08          EX   AF,AF'
E3CB DC 77 E2    CALL C,E277h *
E3CE 0C          INC  C
E3CF FA B1 E3    JP   M,E3B1h *
E3D2 C3 A1 E2    JP   E2A1h *
E3D5 CD 8B E2    CALL E28Bh *
E3D8 CB BA       RES  7,D
E3DA D9          EXX
E3DB E1          POP  HL
E3DC D9          EXX
E3DD E1          POP  HL
E3DE 08          EX   AF,AF'
E3DF C9          RET

E3E0 B7          OR   A
E3E1 ED 42       SBC  HL,BC
E3E3 D9          EXX
E3E4 ED 42       SBC  HL,BC
E3E6 D9          EXX
E3E7 30 05       JR   NC,E3EEh
E3E9 09          ADD  HL,BC
E3EA D9          EXX
E3EB ED 4A       ADC  HL,BC
E3ED D9          EXX
E3EE 3F          CCF

E3EF CB 13       RL   E
E3F1 CB 12       RL   D
E3F3 D9          EXX
E3F4 CB 13       RL   E
E3F6 CB 12       RL   D
E3F8 D9          EXX
E3F9 3C          INC  A
E3FA F0          RET  P

E3FB ED 6A       ADC  HL,HL
E3FD D9          EXX
E3FE ED 6A       ADC  HL,HL
E400 D9          EXX
E401 30 DE       JR   NC,E3E1h
E403 B7          OR   A
E404 ED 42       SBC  HL,BC
E406 D9          EXX
E407 ED 42       SBC  HL,BC
E409 D9          EXX
E40A 37          SCF
E40B C3 EF E3    JP   E3EFh *

E40E B7          OR   A
E40F D9          EXX
E410 CB 1A       RR   D
E412 CB 1B       RR   E
E414 D9          EXX
E415 CB 1A       RR   D
E417 CB 1B       RR   E
E419 30 05       JR   NC,E420h
E41B 09          ADD  HL,BC
E41C D9          EXX
E41D ED 4A       ADC  HL,BC
E41F D9          EXX
E420 3C          INC  A
E421 F0          RET  P

E422 D9          EXX
E423 CB 1C       RR   H
E425 CB 1D       RR   L
E427 D9          EXX
E428 CB 1C       RR   H
E42A CB 1D       RR   L
E42C C3 0F E4    JP   E40Fh *

E42F ED 42       SBC  HL,BC
E431 D9          EXX
E432 ED 42       SBC  HL,BC
E434 D9          EXX
E435 0C          INC  C
E436 30 07       JR   NC,E43Fh
E438 0D          DEC  C
E439 09          ADD  HL,BC
E43A D9          EXX
E43B ED 4A       ADC  HL,BC
E43D D9          EXX
E43E 0D          DEC  C
E43F 3C          INC  A
E440 F0          RET  P

E441 CB 21       SLA  C
E443 CB 10       RL   B
E445 D9          EXX
E446 CB 11       RL   C
E448 CB 10       RL   B
E44A D9          EXX
E44B 0C          INC  C
E44C CB 23       SLA  E
E44E CB 12       RL   D
E450 D9          EXX
E451 CB 13       RL   E
E453 CB 12       RL   D
E455 D9          EXX
E456 ED 6A       ADC  HL,HL
E458 D9          EXX
E459 ED 6A       ADC  HL,HL
E45B D9          EXX
E45C CB 23       SLA  E
E45E CB 12       RL   D
E460 D9          EXX
E461 CB 13       RL   E
E463 CB 12       RL   D
E465 D9          EXX
E466 ED 6A       ADC  HL,HL
E468 D9          EXX
E469 ED 6A       ADC  HL,HL
E46B D9          EXX
E46C D2 2F E4    JP   NC,E42Fh *
E46F B7          OR   A
E470 ED 42       SBC  HL,BC
E472 D9          EXX
E473 ED 42       SBC  HL,BC
E475 D9          EXX
E476 0C          INC  C
E477 C3 3F E4    JP   E43Fh *

E47A 29          ADD  HL,HL
E47B D9          EXX
E47C ED 6A       ADC  HL,HL
E47E D9          EXX
E47F 38 EE       JR   C,E46Fh
E481 3C          INC  A
E482 0C          INC  C
E483 ED 42       SBC  HL,BC
E485 D9          EXX
E486 ED 42       SBC  HL,BC
E488 D9          EXX
E489 D0          RET  NC
E48A 09          ADD  HL,BC
E48B D9          EXX
E48C ED 4A       ADC  HL,BC
E48E D9          EXX
E48F 0D          DEC  C
E490 C9          RET

E491 CD AD E4    CALL E4ADh *
E494 FE 3A       CP   3Ah
E496 3F          CCF
E497 D8          RET  C
E498 FE 30       CP   30h
E49A C9          RET

E49B CD AD E4    CALL E4ADh *
E49E DD 23       INC  IX
E4A0 FE 20       CP   20h
E4A2 28 F7       JR   Z,E49Bh
E4A4 FE 2B       CP   2Bh
E4A6 C8          RET  Z
E4A7 FE 2D       CP   2Dh
E4A9 C8          RET  Z
E4AA DD 2B       DEC  IX
E4AC C9          RET

E4AD DD E5       PUSH IX
E4AF D1          POP  DE
E4B0 CB 7A       BIT  7,D
E4B2 28 20       JR   Z,E4D4h
E4B4 CB 72       BIT  6,D
E4B6 28 1C       JR   Z,E4D4h
E4B8 08          EX   AF,AF'
E4B9 3A D1 04    LD   A,(04D1h)
E4BC F5          PUSH AF
E4BD FD 7E 03    LD   A,(IY+03h)
E4C0 32 D1 04    LD   (04D1h),A
E4C3 D3 D1       OUT  (D1h),A
E4C5 CB BA       RES  7,D
E4C7 08          EX   AF,AF'
E4C8 1A          LD   A,(DE)
E4C9 08          EX   AF,AF'
E4CA CB FA       SET  7,D
E4CC F1          POP  AF
E4CD 32 D1 04    LD   (04D1h),A
E4D0 D3 D1       OUT  (D1h),A
E4D2 08          EX   AF,AF'
E4D3 C9          RET
E4D4 1A          LD   A,(DE)
E4D5 C9          RET

E4D6 CB 7C       BIT  7,H
E4D8 28 20       JR   Z,E4FAh
E4DA CB 74       BIT  6,H
E4DC 28 1C       JR   Z,E4FAh
E4DE 08          EX   AF,AF'
E4DF 3A D1 04    LD   A,(04D1h)
E4E2 F5          PUSH AF
E4E3 FD 7E 03    LD   A,(IY+03h)
E4E6 32 D1 04    LD   (04D1h),A
E4E9 D3 D1       OUT  (D1h),A
E4EB CB BC       RES  7,H
E4ED 08          EX   AF,AF'
E4EE 77          LD   (HL),A
E4EF 08          EX   AF,AF'
E4F0 CB FC       SET  7,H
E4F2 F1          POP  AF
E4F3 32 D1 04    LD   (04D1h),A
E4F6 D3 D1       OUT  (D1h),A
E4F8 08          EX   AF,AF'
E4F9 C9          RET
E4FA 77          LD   (HL),A
E4FB C9          RET
