
; ********************************************************************************************************************
; - TOPIC information -
; definitions of topic names to Commands and Information Topics:


    MODULE Appl_Topics

    XREF Z80asm_help, Zprom_help, Z80dbg_help
    XREF zp_topic_info_help, topic_cursor_help, topic_memory_help, topic_eprom_help
    XREF dbg_topic_info_help

    XDEF Z80asm_topics, Zprom_Topics, Z80dbg_topics
    XDEF topic_cursor, topic_memory, topic_eprom

    INCLUDE "win1_z80_src_defs_asm"


; ********************************************************************************************************************
;
; topic entries for Z80asm application...
;
.Z80asm_Topics      DEFB 0                                                      ; start marker of topics

; 'INFO' topic
.z80asm_files_topic DEFB z80asm_files_topic_end - z80asm_files_topic            ; length of topic definition
                    DEFM "INFO"
                    DEFW 0
                    DEFB @00000010
                    DEFB z80asm_files_topic_end - z80asm_files_topic            ; length of topic definition
.z80asm_files_topic_end

                    DEFB 0


; ********************************************************************************************************************
;
; topic entries for Zprom application...
;
.Zprom_Topics       DEFB 0                                                      ; start marker of topics

; 'INFO' topic
.zp_topic_info      DEFB zp_topic_info_end - zp_topic_info                      ; length of topic definition
                    DEFM "INFO"                                                 ; name terminated by high byte
                    DEFB (zp_topic_info_help - zprom_help) / 256                ; high byte of rel. pointer
                    DEFB (zp_topic_info_help - zprom_help) % 256                ; low byte of rel. pointer
                    DEFB @00010010                                              ; this information topic has help
                    DEFB zp_topic_info_end - zp_topic_info
.zp_topic_info_end

; 'CURSOR' topic
.topic_cursor       DEFB topic_cursor_end - topic_cursor                        ; length of topic definition
                    DEFM $A3
                    DEFB (topic_cursor_help - Zprom_help) / 256                 ; high byte of rel. pointer
                    DEFB (topic_cursor_help - Zprom_help) % 256                 ; low byte of rel. pointer
                    DEFB @00010000                                              ; topic has help page...
                    DEFB topic_cursor_end - topic_cursor
.topic_cursor_end

; 'MEMORY' topic
.topic_memory       DEFB topic_memory_end - topic_memory                        ; length of topic definition
                    DEFM $A9
                    DEFB (topic_memory_help - Zprom_help) / 256                 ; high byte of rel. pointer
                    DEFB (topic_memory_help - Zprom_help) % 256                 ; low byte of rel. pointer
                    DEFB @00010000                                              ; topic has help page...
                    DEFB topic_memory_end - topic_memory
.topic_memory_end

; 'EPROM' topic
.topic_eprom        DEFB topic_eprom_end - topic_eprom                          ; length of topic definition
                    DEFM $8F                                                    ; name terminated by high byte
                    DEFB (topic_eprom_help - Zprom_help) / 256                  ; high byte of rel. pointer
                    DEFB (topic_eprom_help - Zprom_help) % 256                  ; low byte of rel. pointer
                    DEFB @00010000                                              ; topic has help page...
                    DEFB topic_eprom_end - topic_eprom
.topic_eprom_end
                    DEFB 0


; ---------------------------------------------------------------------------
;
; topic entries for Z80dbg applications...
;
.Z80dbg_Topics      DEFB 0                                                      ; start marker of topics

; 'INFO' topic
.dbg_topic_info     DEFB dbg_topic_info_end - dbg_topic_info                    ; length of topic definition
                    DEFM "INFO"                                                 ; name terminated by high byte
                    DEFB (dbg_topic_info_help - Z80dbg_help) / 256              ; high byte of rel. pointer
                    DEFB (dbg_topic_info_help - Z80dbg_help) % 256              ; low byte of rel. pointer
                    DEFB @00010010                                              ; this information topic has help
                    DEFB dbg_topic_info_end - dbg_topic_info
.dbg_topic_info_end
                    DEFB 0
