
    MODULE Dumpfile_commands


if QDOS
	INCLUDE "defs_h"
	INCLUDE "#error_def"
	INCLUDE "#fileIO_def"
	INCLUDE "#memory_def"
	INCLUDE "#integer_def"
else
	if UNIX | MSDOS
		INCLUDE "defs.h"
		INCLUDE "#error.def"
		INCLUDE "#fileIO.def"
		INCLUDE "#memory.def"
		INCLUDE "#integer.def"
	endif
	if Z88
		INCLUDE "defs.h"
		INCLUDE ":*//error.def"
		INCLUDE ":*//fileIO.def"
		INCLUDE ":*//memory.def"
		INCLUDE ":*//integer.def"
	endif
endif


    XREF Write_msg
    XREF SkipSpaces
    XREF Get_Constant
    XREF Write_Err_Msg, Syntax_error

    XDEF Bank_Dump,	Segment_Dump


; ***************************************************************************************************
;
.Bank_Dump	   CALL Get_dump_param
			   RET  C				    ; return if problems	during parameter fetch
			   LD   B,E			    ; bank number
    if SEGMENT3
			   LD   C, MS_S3
    endif
    if SEGMENT2
			   LD   C, MS_S2
    endif
			   CALL_OZ(Os_Mpb)
			   PUSH BC			    ; preserve	prev. binding state
			   LD   A,E			    ; bank number in A
			   LD   BC,6			    ; length of standard	filename
			   LD   IX, bankfile
			   CALL Create_dumpfile	    ; create ":RAM.x/Bank.<bank number>"
			   JR   C,end_bank_dump	    ; Ups	- file create error

			   XOR  A
			   LD   B,A
			   LD   H,A
			   LD   L,A
			   CALL_OZ(Os_Erh)		    ; system error handler
			   PUSH AF
			   PUSH HL			    : preserve	ptr.	to prev. err.handler

    if SEGMENT3
			   LD   HL,$C000
    endif
    if SEGMENT2
			   LD   HL,$8000
    endif
			   CALL Dump_memory		    ; now	dump	bank	located at segment
			   CALL_OZ(Gn_Cl)		    ;
			   POP  HL
			   POP  AF
			   PUSH BC
			   LD   B,0
			   CALL_OZ(Os_Erh)		    ; restore prev.	error handler
			   POP  BC
			   LD   A,B
			   OR   C
			   JR   NZ,end_bank_dump
			   LD   HL, dump_msg	    ; 'dumped...'
			   CALL Write_Msg		    ; return to command line

.end_bank_dump	   POP  BC			    ; restore prev.	binding state
			   CALL_OZ(Os_Mpb)
			   RET


; ***************************************************************************************************
;
.Segment_Dump	   CALL Get_dump_param
			   RET  C
			   LD   A,E
			   AND  @00000011		    ; segment 0 - 3
			   LD   H,A
			   RRC  H
			   RRC  H				    ; get	segment specifier into bits 15,14
			   LD   L,0			    ; of HL = start	address of segment
			   PUSH HL
			   LD   IX, segmfile
			   LD   BC,9
			   CALL Create_dumpfile	    ; create ":RAM.x/Segment.<segment>"
			   POP  HL
			   RET  C
			   CALL Dump_memory		    ; dump segment into file...
			   CALL_OZ(Gn_Cl)		    ; close file...
			   LD   A,B
			   OR   C
			   RET  NZ			    ; Ups	- file IO	error
			   LD   HL, dump_msg	    ; 'dumped...'
			   JP   Write_Msg		    ; return to command line

.Get_dump_param   CALL SkipSpaces
			   JP   C, Syntax_error	    ; parameter must be specified
			   LD   C,8			    ; get	8bit	hex value...
			   CALL Get_Constant	    ;
			   RET


; *******************************************************************************************
; Dump 16K memory beginning at HL
;
; NB: HL must not be 0 in OS_MV, since DE and HL must not be equal in	system CALL.
;
.Dump_memory	   LD   BC,$4000		    ; length of block
			   LD   DE,0			    ; move from memory to file...
			   LD   A,H
			   CP   0
			   JR   NZ, dump_block	    ; all	OK...
			   DEC  BC			    ;
			   LD   A,(HL)			    ; get	byte	at address $0000
			   CALL_OZ(Os_Pb)		    ; write it	to file
			   JP   C, Write_Err_msg
			   INC  HL			    ; then dump rest of block
.dump_block	   CALL_OZ(Os_Mv)		    ; at (HL) to file...
			   CALL C,Write_Err_Msg	    ; Ups	- no	room	for dump file
			   RET


; *******************************************************************************************
;
; Create file with filename pointed to by IX. File extension will be number in A,
; e.g. '/bank.255'
;
;
.Create_dumpfile  LD   HL,0
			   ADD  HL,SP
			   LD   D,H
			   LD   E,L			    ; DE = current SP
			   EX   AF,AF'
			   LD   A,C
			   ADD  A,4			    ;
			   LD   C,A
			   CP   A				    ; Fc = 0
			   SBC  HL,BC			    ; make room for	filename & number &	null-terminator
			   LD   SP,HL			    ; set	SP below logfilename buffer
			   PUSH DE			    ; remember	current SP
			   PUSH HL			    ; remember	start of filename buffer
			   PUSH IX			    ; pointer to std. filename
			   POP  DE
			   EX   DE,HL			    ; HL = source, DE = dest.
			   SUB  4				    ; length of standard	filename
			   LD   C,A			    ; B =	0...
			   EX   AF,AF'               ; get number parameter
			   LDIR				    ; copy standard	filename into tmp buffer
								    ; DE = ptr. to null... (end of	name	+1)
			   LD   HL,2			    ; indicate	BC =	integer to be converted
			   LD   C,A			    ; number as integer in BC...
			   LD   A, @00000001	    ; to ASCII
			   CALL_OZ(Gn_Pdn)		    ; convert log number	into	ASCII representation
			   XOR  A
			   LD   (DE),A			    ; null-terminate filename
			   POP  HL
			   LD   D,H
			   LD   E,L			    ; scratch buffer
			   LD   BC,1			    ; B =	0, local string pointer...
			   LD   A, OP_OUT
			   CALL_OZ(Gn_Opf)		    ; create file for bank
			   CALL C, Write_Err_Msg	    ; write error message...
.exit_createfile  POP  HL			    ; get	old SP
			   LD   SP,HL			    ; install old SP
			   RET

.bankfile		   DEFM "/Bank."		    ; standard	filename 6 bytes long
.segmfile		   DEFM "/Segment."		    ; standard	filename 9 bytes long
.dump_msg		   DEFM "dumped..."	& 0
