
	MODULE Input_buffer

	XREF	Calc_HL_Ptr

	XREF	Display_string, Write_CRLF

	; Defined	in 'Windows_asm':
	XREF	SV_INT_window,	REL_INT_window, ToggleWindow

	XREF	Toggle_CLI
	XREF	Use_IntErrhandler, RST_ApplErrhandler

	XDEF	InputCommand, Input_buffer, Prompt


if QDOS
	INCLUDE "defs_h"
	INCLUDE "#stdio_def"
endif
if MSDOS | UNIX
	INCLUDE "defs.h"
	INCLUDE "#stdio.def"
endif
if Z88
	INCLUDE "defs.h"
	INCLUDE ":*//stdio.def"
endif


; **************************************************************************
;
; Command	line	input, 17	bytes max. input.
;
; Register status after return:
;
;	   ......../IXIY	 same
;	   AFBCDEHL/....afb	 different
;
; Stack usage:	 2 bytes
;
.InputCommand	   LD   C, 48
			   CALL Calc_HL_Ptr		    ; HL = IY + 48 , input buffer...
			   LD   D,H
			   LD   E,L			    ; get	a copy of	start of buffer...
			   LD   A,16			    ; max. buffer size
			   CALL Input_Buffer	    ;								   ** V0.19c
			   RET



; *****************************************************************************************
;
; Command	line	input.					** V0.31
;
; Entry:
;
; DE	= start of true buffer
;
; On	return, HL will point to	start of buffer & A	= length of buffer
;
; register usage:
;		DE	  = absolute ptr. to first char of	buffer.
;		(DE-1) = max. size of input buffer
;
; Register status after return:
;
;	   ......../IXIY	 same
;	   AFBCDEHL/....	 different
;
.Input_Buffer	   DEC  A				    ; use	1 byte as	max.	length id.
			   LD   C,A			    ; place cursor at end of command...
			   LD   (DE),A			    ; max	length of	buffer
			   INC  DE

.input_loop	   LD   HL, cursorpos
			   CALL_OZ (Gn_Sop)		    ; place cursor at beginning of	line
			   CALL DisplayPrompt	    ; display Intuition prompt
			   DEC  DE
			   LD   A,(DE)
			   LD   B,A			    ; max. length of buffer...
			   INC  DE			    ; point at	first char
			   LD   A,@00001001		    ; return unexp.	characters, info in	buffer
			   CALL Use_IntErrhandler    ; Use	Intuition	error handler
			   CALL SV_INT_window	    ; save Intuition screen before	keyboard input
			   CALL_OZ (Gn_Sip)
			   CALL REL_INT_window	    ; release Intuition window
			   CALL RST_ApplErrhandler   ; restore application error handler
			   CP   $1F			    ; <DIAMOND>- ?
			   JR   Z, CLI_facility
			   CP   IN_ENT			    ; <ENTER>?
			   JR   Z, enter_key
			   CP   IN_TAB			    ; <TAB>?
			   JP   Z, inp_togglewindow
			   CP   IN_ESC			    ; <ESC>?
			   JR   Z, escape_key
			   JR   input_loop		    ; then command line...
.cursorpos	   DEFM 1	& "2X" & 32 & 0    ;

.CLI_facility	   PUSH DE			    ; preserve	pointer to input line
			   PUSH BC			    ; preserve	cursor position
			   CALL Toggle_CLI		    ; activate/de-activate CLI...
			   POP  BC
			   POP  DE
			   JR   input_loop

.enter_key	   CALL_OZ(Gn_Nln)		    ; execute a 'new line'
			   LD   H,D
			   LD   L,E			    ; DE points at first	char
			   LD   A,B			    ; length of input line
			   RET

.escape_key	   CALL_OZ(Gn_Nln)		    ; execute a new	line...
			   CALL  DisplayPrompt	    ;								   ** V0.19c
			   XOR   A
			   LD    (DE),A		    ; null-terminate input line
			   LD    C,A			    ; cursor position at	beginning	of line
			   JR    input_loop



; *****************************************************************************************
;
; Select Z88-Monitor window 1	or 2.  (toggle)		 V0.18 / V0.22b
;
.inp_togglewindow CALL ToggleWindow	    ; display Intuition window...			   ** V0.22/V0.28

.disp_prompt	   CALL DisplayPrompt
			   JP   input_loop


; ***********************************************************************************
;
; Display	Intuition	input prompt											   ** V0.19c
;
.DisplayPrompt	   PUSH HL
			   LD   HL, Prompt
			   CALL_OZ(Gn_Sop)
			   POP  HL
			   RET
.Prompt		   DEFM 1	& "B?>" &	1 & "B" &	0
