; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=sse2    | FileCheck %s --check-prefixes=SSE,SSE2
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=sse4.2  | FileCheck %s --check-prefixes=SSE,SSE42
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=avx     | FileCheck %s --check-prefixes=AVX,AVX1OR2,AVX1
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=avx2    | FileCheck %s --check-prefixes=AVX,AVX1OR2,AVX2
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=avx512f | FileCheck %s --check-prefixes=AVX,AVX512,AVX512F
; RUN: llc < %s -mtriple=x86_64-apple-darwin -mattr=avx512f,avx512bw,avx512vl | FileCheck %s --check-prefixes=AVX,AVX512,AVX512VLBW

define <1 x double> @load_v1f64_v1i64(<1 x i64> %trigger, <1 x double>* %addr, <1 x double> %dst) {
; SSE-LABEL: load_v1f64_v1i64:
; SSE:       ## %bb.0:
; SSE-NEXT:    testq %rdi, %rdi
; SSE-NEXT:    jne LBB0_2
; SSE-NEXT:  ## %bb.1: ## %cond.load
; SSE-NEXT:    movsd {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:  LBB0_2: ## %else
; SSE-NEXT:    retq
;
; AVX-LABEL: load_v1f64_v1i64:
; AVX:       ## %bb.0:
; AVX-NEXT:    testq %rdi, %rdi
; AVX-NEXT:    jne LBB0_2
; AVX-NEXT:  ## %bb.1: ## %cond.load
; AVX-NEXT:    vmovsd {{.*#+}} xmm0 = mem[0],zero
; AVX-NEXT:  LBB0_2: ## %else
; AVX-NEXT:    retq
  %mask = icmp eq <1 x i64> %trigger, zeroinitializer
  %res = call <1 x double> @llvm.masked.load.v1f64.p0v1f64(<1 x double>* %addr, i32 4, <1 x i1>%mask, <1 x double>%dst)
  ret <1 x double> %res
}

define <2 x double> @load_v2f64_v2i64(<2 x i64> %trigger, <2 x double>* %addr, <2 x double> %dst) {
; SSE2-LABEL: load_v2f64_v2i64:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,0,3,2]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB1_2
; SSE2-NEXT:  ## %bb.1: ## %cond.load
; SSE2-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1]
; SSE2-NEXT:  LBB1_2: ## %else
; SSE2-NEXT:    pextrw $4, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB1_4
; SSE2-NEXT:  ## %bb.3: ## %cond.load1
; SSE2-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0]
; SSE2-NEXT:  LBB1_4: ## %else2
; SSE2-NEXT:    movapd %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: load_v2f64_v2i64:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqq %xmm0, %xmm2
; SSE42-NEXT:    pextrb $0, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB1_2
; SSE42-NEXT:  ## %bb.1: ## %cond.load
; SSE42-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1]
; SSE42-NEXT:  LBB1_2: ## %else
; SSE42-NEXT:    pextrb $8, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB1_4
; SSE42-NEXT:  ## %bb.3: ## %cond.load1
; SSE42-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0]
; SSE42-NEXT:  LBB1_4: ## %else2
; SSE42-NEXT:    movapd %xmm1, %xmm0
; SSE42-NEXT:    retq
;
; AVX1OR2-LABEL: load_v2f64_v2i64:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX1OR2-NEXT:    vmaskmovpd (%rdi), %xmm0, %xmm2
; AVX1OR2-NEXT:    vblendvpd %xmm0, %xmm2, %xmm1, %xmm0
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: load_v2f64_v2i64:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vptestnmq %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kshiftlw $14, %k0, %k0
; AVX512F-NEXT:    kshiftrw $14, %k0, %k1
; AVX512F-NEXT:    vblendmpd (%rdi), %zmm1, %zmm0 {%k1}
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLBW-LABEL: load_v2f64_v2i64:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vptestnmq %xmm0, %xmm0, %k1
; AVX512VLBW-NEXT:    vblendmpd (%rdi), %xmm1, %xmm0 {%k1}
; AVX512VLBW-NEXT:    retq
  %mask = icmp eq <2 x i64> %trigger, zeroinitializer
  %res = call <2 x double> @llvm.masked.load.v2f64.p0v2f64(<2 x double>* %addr, i32 4, <2 x i1>%mask, <2 x double>%dst)
  ret <2 x double> %res
}

define <4 x float> @load_v4f32_v4i32(<4 x i32> %trigger, <4 x float>* %addr, <4 x float> %dst) {
; SSE2-LABEL: load_v4f32_v4i32:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE2-NEXT:    movd %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB2_2
; SSE2-NEXT:  ## %bb.1: ## %cond.load
; SSE2-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm1 = xmm3[0],xmm1[1,2,3]
; SSE2-NEXT:  LBB2_2: ## %else
; SSE2-NEXT:    pextrw $2, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB2_4
; SSE2-NEXT:  ## %bb.3: ## %cond.load1
; SSE2-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,0],xmm1[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,0],xmm1[2,3]
; SSE2-NEXT:    movaps %xmm2, %xmm1
; SSE2-NEXT:  LBB2_4: ## %else2
; SSE2-NEXT:    xorps %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE2-NEXT:    pextrw $4, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB2_6
; SSE2-NEXT:  ## %bb.5: ## %cond.load4
; SSE2-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,0],xmm1[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm2[0,2]
; SSE2-NEXT:  LBB2_6: ## %else5
; SSE2-NEXT:    pextrw $6, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB2_8
; SSE2-NEXT:  ## %bb.7: ## %cond.load7
; SSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE2-NEXT:  LBB2_8: ## %else8
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: load_v4f32_v4i32:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE42-NEXT:    pextrb $0, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB2_2
; SSE42-NEXT:  ## %bb.1: ## %cond.load
; SSE42-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE42-NEXT:    blendps {{.*#+}} xmm1 = xmm3[0],xmm1[1,2,3]
; SSE42-NEXT:  LBB2_2: ## %else
; SSE42-NEXT:    pextrb $4, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB2_4
; SSE42-NEXT:  ## %bb.3: ## %cond.load1
; SSE42-NEXT:    insertps {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[2,3]
; SSE42-NEXT:  LBB2_4: ## %else2
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE42-NEXT:    pextrb $8, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB2_6
; SSE42-NEXT:  ## %bb.5: ## %cond.load4
; SSE42-NEXT:    insertps {{.*#+}} xmm1 = xmm1[0,1],mem[0],xmm1[3]
; SSE42-NEXT:  LBB2_6: ## %else5
; SSE42-NEXT:    pextrb $12, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB2_8
; SSE42-NEXT:  ## %bb.7: ## %cond.load7
; SSE42-NEXT:    insertps {{.*#+}} xmm1 = xmm1[0,1,2],mem[0]
; SSE42-NEXT:  LBB2_8: ## %else8
; SSE42-NEXT:    movaps %xmm1, %xmm0
; SSE42-NEXT:    retq
;
; AVX1OR2-LABEL: load_v4f32_v4i32:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1OR2-NEXT:    vpcmpeqd %xmm2, %xmm0, %xmm0
; AVX1OR2-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm2
; AVX1OR2-NEXT:    vblendvps %xmm0, %xmm2, %xmm1, %xmm0
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: load_v4f32_v4i32:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vptestnmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kshiftlw $12, %k0, %k0
; AVX512F-NEXT:    kshiftrw $12, %k0, %k1
; AVX512F-NEXT:    vblendmps (%rdi), %zmm1, %zmm0 {%k1}
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLBW-LABEL: load_v4f32_v4i32:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vptestnmd %xmm0, %xmm0, %k1
; AVX512VLBW-NEXT:    vblendmps (%rdi), %xmm1, %xmm0 {%k1}
; AVX512VLBW-NEXT:    retq
  %mask = icmp eq <4 x i32> %trigger, zeroinitializer
  %res = call <4 x float> @llvm.masked.load.v4f32.p0v4f32(<4 x float>* %addr, i32 4, <4 x i1>%mask, <4 x float>%dst)
  ret <4 x float> %res
}

define <4 x i32> @load_v4i32_v4i32(<4 x i32> %trigger, <4 x i32>* %addr, <4 x i32> %dst) {
; SSE2-LABEL: load_v4i32_v4i32:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE2-NEXT:    movd %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB3_2
; SSE2-NEXT:  ## %bb.1: ## %cond.load
; SSE2-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm1 = xmm3[0],xmm1[1,2,3]
; SSE2-NEXT:  LBB3_2: ## %else
; SSE2-NEXT:    pextrw $2, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB3_4
; SSE2-NEXT:  ## %bb.3: ## %cond.load1
; SSE2-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,0],xmm1[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,0],xmm1[2,3]
; SSE2-NEXT:    movaps %xmm2, %xmm1
; SSE2-NEXT:  LBB3_4: ## %else2
; SSE2-NEXT:    xorps %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE2-NEXT:    pextrw $4, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB3_6
; SSE2-NEXT:  ## %bb.5: ## %cond.load4
; SSE2-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,0],xmm1[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm2[0,2]
; SSE2-NEXT:  LBB3_6: ## %else5
; SSE2-NEXT:    pextrw $6, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB3_8
; SSE2-NEXT:  ## %bb.7: ## %cond.load7
; SSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE2-NEXT:  LBB3_8: ## %else8
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: load_v4i32_v4i32:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE42-NEXT:    pextrb $0, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB3_2
; SSE42-NEXT:  ## %bb.1: ## %cond.load
; SSE42-NEXT:    pinsrd $0, (%rdi), %xmm1
; SSE42-NEXT:  LBB3_2: ## %else
; SSE42-NEXT:    pextrb $4, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB3_4
; SSE42-NEXT:  ## %bb.3: ## %cond.load1
; SSE42-NEXT:    pinsrd $1, 4(%rdi), %xmm1
; SSE42-NEXT:  LBB3_4: ## %else2
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pcmpeqd %xmm2, %xmm0
; SSE42-NEXT:    pextrb $8, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB3_6
; SSE42-NEXT:  ## %bb.5: ## %cond.load4
; SSE42-NEXT:    pinsrd $2, 8(%rdi), %xmm1
; SSE42-NEXT:  LBB3_6: ## %else5
; SSE42-NEXT:    pextrb $12, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB3_8
; SSE42-NEXT:  ## %bb.7: ## %cond.load7
; SSE42-NEXT:    pinsrd $3, 12(%rdi), %xmm1
; SSE42-NEXT:  LBB3_8: ## %else8
; SSE42-NEXT:    movdqa %xmm1, %xmm0
; SSE42-NEXT:    retq
;
; AVX1-LABEL: load_v4i32_v4i32:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm2
; AVX1-NEXT:    vblendvps %xmm0, %xmm2, %xmm1, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_v4i32_v4i32:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpmaskmovd (%rdi), %xmm0, %xmm2
; AVX2-NEXT:    vblendvps %xmm0, %xmm2, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_v4i32_v4i32:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vptestnmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kshiftlw $12, %k0, %k0
; AVX512F-NEXT:    kshiftrw $12, %k0, %k1
; AVX512F-NEXT:    vpblendmd (%rdi), %zmm1, %zmm0 {%k1}
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLBW-LABEL: load_v4i32_v4i32:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vptestnmd %xmm0, %xmm0, %k1
; AVX512VLBW-NEXT:    vpblendmd (%rdi), %xmm1, %xmm0 {%k1}
; AVX512VLBW-NEXT:    retq
  %mask = icmp eq <4 x i32> %trigger, zeroinitializer
  %res = call <4 x i32> @llvm.masked.load.v4i32.p0v4i32(<4 x i32>* %addr, i32 4, <4 x i1>%mask, <4 x i32>%dst)
  ret <4 x i32> %res
}

define <4 x double> @load_v4f64_v4i32(<4 x i32> %trigger, <4 x double>* %addr, <4 x double> %dst) {
; SSE2-LABEL: load_v4f64_v4i32:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm3
; SSE2-NEXT:    movd %xmm3, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB4_2
; SSE2-NEXT:  ## %bb.1: ## %cond.load
; SSE2-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1]
; SSE2-NEXT:  LBB4_2: ## %else
; SSE2-NEXT:    pextrw $2, %xmm3, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB4_4
; SSE2-NEXT:  ## %bb.3: ## %cond.load1
; SSE2-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0]
; SSE2-NEXT:  LBB4_4: ## %else2
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm0
; SSE2-NEXT:    pextrw $4, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB4_6
; SSE2-NEXT:  ## %bb.5: ## %cond.load4
; SSE2-NEXT:    movlpd {{.*#+}} xmm2 = mem[0],xmm2[1]
; SSE2-NEXT:  LBB4_6: ## %else5
; SSE2-NEXT:    pextrw $6, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB4_8
; SSE2-NEXT:  ## %bb.7: ## %cond.load7
; SSE2-NEXT:    movhpd {{.*#+}} xmm2 = xmm2[0],mem[0]
; SSE2-NEXT:  LBB4_8: ## %else8
; SSE2-NEXT:    movapd %xmm1, %xmm0
; SSE2-NEXT:    movapd %xmm2, %xmm1
; SSE2-NEXT:    retq
;
; SSE42-LABEL: load_v4f64_v4i32:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pxor %xmm3, %xmm3
; SSE42-NEXT:    pcmpeqd %xmm0, %xmm3
; SSE42-NEXT:    pextrb $0, %xmm3, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB4_2
; SSE42-NEXT:  ## %bb.1: ## %cond.load
; SSE42-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1]
; SSE42-NEXT:  LBB4_2: ## %else
; SSE42-NEXT:    pextrb $4, %xmm3, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB4_4
; SSE42-NEXT:  ## %bb.3: ## %cond.load1
; SSE42-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0]
; SSE42-NEXT:  LBB4_4: ## %else2
; SSE42-NEXT:    pxor %xmm3, %xmm3
; SSE42-NEXT:    pcmpeqd %xmm3, %xmm0
; SSE42-NEXT:    pextrb $8, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB4_6
; SSE42-NEXT:  ## %bb.5: ## %cond.load4
; SSE42-NEXT:    movlpd {{.*#+}} xmm2 = mem[0],xmm2[1]
; SSE42-NEXT:  LBB4_6: ## %else5
; SSE42-NEXT:    pextrb $12, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB4_8
; SSE42-NEXT:  ## %bb.7: ## %cond.load7
; SSE42-NEXT:    movhpd {{.*#+}} xmm2 = xmm2[0],mem[0]
; SSE42-NEXT:  LBB4_8: ## %else8
; SSE42-NEXT:    movapd %xmm1, %xmm0
; SSE42-NEXT:    movapd %xmm2, %xmm1
; SSE42-NEXT:    retq
;
; AVX1-LABEL: load_v4f64_v4i32:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm2
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX1-NEXT:    vmaskmovpd (%rdi), %ymm0, %ymm2
; AVX1-NEXT:    vblendvpd %ymm0, %ymm2, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_v4f64_v4i32:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpmovsxdq %xmm0, %ymm0
; AVX2-NEXT:    vmaskmovpd (%rdi), %ymm0, %ymm2
; AVX2-NEXT:    vblendvpd %ymm0, %ymm2, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_v4f64_v4i32:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vptestnmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kshiftlw $12, %k0, %k0
; AVX512F-NEXT:    kshiftrw $12, %k0, %k1
; AVX512F-NEXT:    vblendmpd (%rdi), %zmm1, %zmm0 {%k1}
; AVX512F-NEXT:    ## kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-NEXT:    retq
;
; AVX512VLBW-LABEL: load_v4f64_v4i32:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vptestnmd %xmm0, %xmm0, %k1
; AVX512VLBW-NEXT:    vblendmpd (%rdi), %ymm1, %ymm0 {%k1}
; AVX512VLBW-NEXT:    retq
  %mask = icmp eq <4 x i32> %trigger, zeroinitializer
  %res = call <4 x double> @llvm.masked.load.v4f64.p0v4f64(<4 x double>* %addr, i32 32, <4 x i1>%mask, <4 x double>%dst)
  ret <4 x double> %res
}

define <4 x double> @load_zero_v4f64_v4i32(<4 x i32> %trigger, <4 x double>* %addr, <4 x double> %dst) {
; SSE2-LABEL: load_zero_v4f64_v4i32:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    movdqa %xmm2, %xmm3
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm3
; SSE2-NEXT:    movd %xmm3, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    xorpd %xmm1, %xmm1
; SSE2-NEXT:    je LBB5_2
; SSE2-NEXT:  ## %bb.1: ## %cond.load
; SSE2-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE2-NEXT:    xorpd %xmm1, %xmm1
; SSE2-NEXT:  LBB5_2: ## %else
; SSE2-NEXT:    pextrw $2, %xmm3, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB5_4
; SSE2-NEXT:  ## %bb.3: ## %cond.load1
; SSE2-NEXT:    movhpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; SSE2-NEXT:  LBB5_4: ## %else2
; SSE2-NEXT:    pxor %xmm3, %xmm3
; SSE2-NEXT:    pcmpeqd %xmm3, %xmm2
; SSE2-NEXT:    pextrw $4, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB5_6
; SSE2-NEXT:  ## %bb.5: ## %cond.load4
; SSE2-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1]
; SSE2-NEXT:  LBB5_6: ## %else5
; SSE2-NEXT:    pextrw $6, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB5_8
; SSE2-NEXT:  ## %bb.7: ## %cond.load7
; SSE2-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0]
; SSE2-NEXT:  LBB5_8: ## %else8
; SSE2-NEXT:    retq
;
; SSE42-LABEL: load_zero_v4f64_v4i32:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    movdqa %xmm0, %xmm2
; SSE42-NEXT:    pxor %xmm0, %xmm0
; SSE42-NEXT:    movdqa %xmm2, %xmm3
; SSE42-NEXT:    pcmpeqd %xmm0, %xmm3
; SSE42-NEXT:    pextrb $0, %xmm3, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    xorpd %xmm1, %xmm1
; SSE42-NEXT:    je LBB5_2
; SSE42-NEXT:  ## %bb.1: ## %cond.load
; SSE42-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE42-NEXT:    xorpd %xmm1, %xmm1
; SSE42-NEXT:  LBB5_2: ## %else
; SSE42-NEXT:    pextrb $4, %xmm3, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB5_4
; SSE42-NEXT:  ## %bb.3: ## %cond.load1
; SSE42-NEXT:    movhpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; SSE42-NEXT:  LBB5_4: ## %else2
; SSE42-NEXT:    pxor %xmm3, %xmm3
; SSE42-NEXT:    pcmpeqd %xmm3, %xmm2
; SSE42-NEXT:    pextrb $8, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB5_6
; SSE42-NEXT:  ## %bb.5: ## %cond.load4
; SSE42-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1]
; SSE42-NEXT:  LBB5_6: ## %else5
; SSE42-NEXT:    pextrb $12, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB5_8
; SSE42-NEXT:  ## %bb.7: ## %cond.load7
; SSE42-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0]
; SSE42-NEXT:  LBB5_8: ## %else8
; SSE42-NEXT:    retq
;
; AVX1-LABEL: load_zero_v4f64_v4i32:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm1
; AVX1-NEXT:    vpshufd {{.*#+}} xmm0 = xmm0[2,3,0,1]
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vmaskmovpd (%rdi), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_zero_v4f64_v4i32:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpmovsxdq %xmm0, %ymm0
; AVX2-NEXT:    vmaskmovpd (%rdi), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_zero_v4f64_v4i32:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    vptestnmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kshiftlw $12, %k0, %k0
; AVX512F-NEXT:    kshiftrw $12, %k0, %k1
; AVX512F-NEXT:    vmovupd (%rdi), %zmm0 {%k1} {z}
; AVX512F-NEXT:    ## kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-NEXT:    retq
;
; AVX512VLBW-LABEL: load_zero_v4f64_v4i32:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vptestnmd %xmm0, %xmm0, %k1
; AVX512VLBW-NEXT:    vmovapd (%rdi), %ymm0 {%k1} {z}
; AVX512VLBW-NEXT:    retq
  %mask = icmp eq <4 x i32> %trigger, zeroinitializer
  %res = call <4 x double> @llvm.masked.load.v4f64.p0v4f64(<4 x double>* %addr, i32 32, <4 x i1>%mask, <4 x double>zeroinitializer)
  ret <4 x double> %res
}

define <8 x float> @load_v8f32_v8i32(<8 x i32> %trigger, <8 x float>* %addr, <8 x float> %dst) {
; SSE2-LABEL: load_v8f32_v8i32:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pxor %xmm4, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm4
; SSE2-NEXT:    movdqa %xmm4, %xmm5
; SSE2-NEXT:    packssdw %xmm0, %xmm5
; SSE2-NEXT:    movd %xmm5, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_2
; SSE2-NEXT:  ## %bb.1: ## %cond.load
; SSE2-NEXT:    movss {{.*#+}} xmm5 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm2 = xmm5[0],xmm2[1,2,3]
; SSE2-NEXT:  LBB6_2: ## %else
; SSE2-NEXT:    psrlq $16, %xmm4
; SSE2-NEXT:    movd %xmm4, %eax
; SSE2-NEXT:    shrl $16, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_4
; SSE2-NEXT:  ## %bb.3: ## %cond.load1
; SSE2-NEXT:    movss {{.*#+}} xmm4 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,0],xmm2[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm4 = xmm4[2,0],xmm2[2,3]
; SSE2-NEXT:    movaps %xmm4, %xmm2
; SSE2-NEXT:  LBB6_4: ## %else2
; SSE2-NEXT:    xorps %xmm4, %xmm4
; SSE2-NEXT:    pcmpeqd %xmm4, %xmm0
; SSE2-NEXT:    pextrw $4, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_6
; SSE2-NEXT:  ## %bb.5: ## %cond.load4
; SSE2-NEXT:    movss {{.*#+}} xmm4 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm4 = xmm4[0,0],xmm2[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm4[0,2]
; SSE2-NEXT:  LBB6_6: ## %else5
; SSE2-NEXT:    pextrw $6, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_8
; SSE2-NEXT:  ## %bb.7: ## %cond.load7
; SSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm2[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[2,0]
; SSE2-NEXT:  LBB6_8: ## %else8
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-NEXT:    pextrw $0, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_10
; SSE2-NEXT:  ## %bb.9: ## %cond.load10
; SSE2-NEXT:    movss {{.*#+}} xmm4 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm3 = xmm4[0],xmm3[1,2,3]
; SSE2-NEXT:  LBB6_10: ## %else11
; SSE2-NEXT:    pextrw $2, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_12
; SSE2-NEXT:  ## %bb.11: ## %cond.load13
; SSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm3[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm3[2,3]
; SSE2-NEXT:    movaps %xmm0, %xmm3
; SSE2-NEXT:  LBB6_12: ## %else14
; SSE2-NEXT:    xorps %xmm0, %xmm0
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    pextrw $4, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_14
; SSE2-NEXT:  ## %bb.13: ## %cond.load16
; SSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm3[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[0,2]
; SSE2-NEXT:  LBB6_14: ## %else17
; SSE2-NEXT:    pextrw $6, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB6_16
; SSE2-NEXT:  ## %bb.15: ## %cond.load19
; SSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm3[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,1],xmm0[2,0]
; SSE2-NEXT:  LBB6_16: ## %else20
; SSE2-NEXT:    movaps %xmm2, %xmm0
; SSE2-NEXT:    movaps %xmm3, %xmm1
; SSE2-NEXT:    retq
;
; SSE42-LABEL: load_v8f32_v8i32:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pxor %xmm4, %xmm4
; SSE42-NEXT:    pcmpeqd %xmm0, %xmm4
; SSE42-NEXT:    pextrb $0, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_2
; SSE42-NEXT:  ## %bb.1: ## %cond.load
; SSE42-NEXT:    movss {{.*#+}} xmm5 = mem[0],zero,zero,zero
; SSE42-NEXT:    blendps {{.*#+}} xmm2 = xmm5[0],xmm2[1,2,3]
; SSE42-NEXT:  LBB6_2: ## %else
; SSE42-NEXT:    pextrb $4, %xmm4, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_4
; SSE42-NEXT:  ## %bb.3: ## %cond.load1
; SSE42-NEXT:    insertps {{.*#+}} xmm2 = xmm2[0],mem[0],xmm2[2,3]
; SSE42-NEXT:  LBB6_4: ## %else2
; SSE42-NEXT:    pxor %xmm4, %xmm4
; SSE42-NEXT:    pcmpeqd %xmm4, %xmm0
; SSE42-NEXT:    pextrb $8, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_6
; SSE42-NEXT:  ## %bb.5: ## %cond.load4
; SSE42-NEXT:    insertps {{.*#+}} xmm2 = xmm2[0,1],mem[0],xmm2[3]
; SSE42-NEXT:  LBB6_6: ## %else5
; SSE42-NEXT:    pextrb $12, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_8
; SSE42-NEXT:  ## %bb.7: ## %cond.load7
; SSE42-NEXT:    insertps {{.*#+}} xmm2 = xmm2[0,1,2],mem[0]
; SSE42-NEXT:  LBB6_8: ## %else8
; SSE42-NEXT:    pxor %xmm0, %xmm0
; SSE42-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE42-NEXT:    pextrb $0, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_10
; SSE42-NEXT:  ## %bb.9: ## %cond.load10
; SSE42-NEXT:    movd {{.*#+}} xmm4 = mem[0],zero,zero,zero
; SSE42-NEXT:    pblendw {{.*#+}} xmm3 = xmm4[0,1],xmm3[2,3,4,5,6,7]
; SSE42-NEXT:  LBB6_10: ## %else11
; SSE42-NEXT:    pextrb $4, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_12
; SSE42-NEXT:  ## %bb.11: ## %cond.load13
; SSE42-NEXT:    insertps {{.*#+}} xmm3 = xmm3[0],mem[0],xmm3[2,3]
; SSE42-NEXT:  LBB6_12: ## %else14
; SSE42-NEXT:    pxor %xmm0, %xmm0
; SSE42-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE42-NEXT:    pextrb $8, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_14
; SSE42-NEXT:  ## %bb.13: ## %cond.load16
; SSE42-NEXT:    insertps {{.*#+}} xmm3 = xmm3[0,1],mem[0],xmm3[3]
; SSE42-NEXT:  LBB6_14: ## %else17
; SSE42-NEXT:    pextrb $12, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB6_16
; SSE42-NEXT:  ## %bb.15: ## %cond.load19
; SSE42-NEXT:    insertps {{.*#+}} xmm3 = xmm3[0,1,2],mem[0]
; SSE42-NEXT:  LBB6_16: ## %else20
; SSE42-NEXT:    movaps %xmm2, %xmm0
; SSE42-NEXT:    movaps %xmm3, %xmm1
; SSE42-NEXT:    retq
;
; AVX1-LABEL: load_v8f32_v8i32:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm2
; AVX1-NEXT:    vpxor %xmm3, %xmm3, %xmm3
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm2, %xmm2
; AVX1-NEXT:    vpcmpeqd %xmm3, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm2, %ymm0, %ymm0
; AVX1-NEXT:    vmaskmovps (%rdi), %ymm0, %ymm2
; AVX1-NEXT:    vblendvps %ymm0, %ymm2, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_v8f32_v8i32:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqd %ymm2, %ymm0, %ymm0
; AVX2-NEXT:    vmaskmovps (%rdi), %ymm0, %ymm2
; AVX2-NEXT:    vblendvps %ymm0, %ymm2, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_v8f32_v8i32:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    ## kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    vptestnmd %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kshiftlw $8, %k0, %k0
; AVX512F-NEXT:    kshiftrw $8, %k0, %k1
; AVX512F-NEXT:    vblendmps (%rdi), %zmm1, %zmm0 {%k1}
; AVX512F-NEXT:    ## kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-NEXT:    retq
;
; AVX512VLBW-LABEL: load_v8f32_v8i32:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vptestnmd %ymm0, %ymm0, %k1
; AVX512VLBW-NEXT:    vblendmps (%rdi), %ymm1, %ymm0 {%k1}
; AVX512VLBW-NEXT:    retq
  %mask = icmp eq <8 x i32> %trigger, zeroinitializer
  %res = call <8 x float> @llvm.masked.load.v8f32.p0v8f32(<8 x float>* %addr, i32 32, <8 x i1>%mask, <8 x float>%dst)
  ret <8 x float> %res
}

define <8 x i32> @load_v8i32_v8i1(<8 x i1> %mask, <8 x i32>* %addr, <8 x i32> %dst) {
; SSE2-LABEL: load_v8i32_v8i1:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB7_2
; SSE2-NEXT:  ## %bb.1: ## %cond.load
; SSE2-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm1 = xmm3[0],xmm1[1,2,3]
; SSE2-NEXT:  LBB7_2: ## %else
; SSE2-NEXT:    shrl $16, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB7_4
; SSE2-NEXT:  ## %bb.3: ## %cond.load1
; SSE2-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,0],xmm1[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[2,0],xmm1[2,3]
; SSE2-NEXT:    movaps %xmm3, %xmm1
; SSE2-NEXT:  LBB7_4: ## %else2
; SSE2-NEXT:    pextrw $2, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB7_6
; SSE2-NEXT:  ## %bb.5: ## %cond.load4
; SSE2-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,0],xmm1[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm3[0,2]
; SSE2-NEXT:  LBB7_6: ## %else5
; SSE2-NEXT:    pextrw $3, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB7_8
; SSE2-NEXT:  ## %bb.7: ## %cond.load7
; SSE2-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,0],xmm1[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm3[2,0]
; SSE2-NEXT:  LBB7_8: ## %else8
; SSE2-NEXT:    pextrw $4, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB7_10
; SSE2-NEXT:  ## %bb.9: ## %cond.load10
; SSE2-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm2 = xmm3[0],xmm2[1,2,3]
; SSE2-NEXT:  LBB7_10: ## %else11
; SSE2-NEXT:    pextrw $5, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB7_12
; SSE2-NEXT:  ## %bb.11: ## %cond.load13
; SSE2-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,0],xmm2[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[2,0],xmm2[2,3]
; SSE2-NEXT:    movaps %xmm3, %xmm2
; SSE2-NEXT:  LBB7_12: ## %else14
; SSE2-NEXT:    pextrw $6, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB7_14
; SSE2-NEXT:  ## %bb.13: ## %cond.load16
; SSE2-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,0],xmm2[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm3[0,2]
; SSE2-NEXT:  LBB7_14: ## %else17
; SSE2-NEXT:    pextrw $7, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB7_16
; SSE2-NEXT:  ## %bb.15: ## %cond.load19
; SSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm2[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,1],xmm0[2,0]
; SSE2-NEXT:  LBB7_16: ## %else20
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    movaps %xmm2, %xmm1
; SSE2-NEXT:    retq
;
; SSE42-LABEL: load_v8i32_v8i1:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pextrb $0, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB7_2
; SSE42-NEXT:  ## %bb.1: ## %cond.load
; SSE42-NEXT:    pinsrd $0, (%rdi), %xmm1
; SSE42-NEXT:  LBB7_2: ## %else
; SSE42-NEXT:    pextrb $2, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB7_4
; SSE42-NEXT:  ## %bb.3: ## %cond.load1
; SSE42-NEXT:    pinsrd $1, 4(%rdi), %xmm1
; SSE42-NEXT:  LBB7_4: ## %else2
; SSE42-NEXT:    pextrb $4, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB7_6
; SSE42-NEXT:  ## %bb.5: ## %cond.load4
; SSE42-NEXT:    pinsrd $2, 8(%rdi), %xmm1
; SSE42-NEXT:  LBB7_6: ## %else5
; SSE42-NEXT:    pextrb $6, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB7_8
; SSE42-NEXT:  ## %bb.7: ## %cond.load7
; SSE42-NEXT:    pinsrd $3, 12(%rdi), %xmm1
; SSE42-NEXT:  LBB7_8: ## %else8
; SSE42-NEXT:    pextrb $8, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB7_10
; SSE42-NEXT:  ## %bb.9: ## %cond.load10
; SSE42-NEXT:    pinsrd $0, 16(%rdi), %xmm2
; SSE42-NEXT:  LBB7_10: ## %else11
; SSE42-NEXT:    pextrb $10, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB7_12
; SSE42-NEXT:  ## %bb.11: ## %cond.load13
; SSE42-NEXT:    pinsrd $1, 20(%rdi), %xmm2
; SSE42-NEXT:  LBB7_12: ## %else14
; SSE42-NEXT:    pextrb $12, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB7_14
; SSE42-NEXT:  ## %bb.13: ## %cond.load16
; SSE42-NEXT:    pinsrd $2, 24(%rdi), %xmm2
; SSE42-NEXT:  LBB7_14: ## %else17
; SSE42-NEXT:    pextrb $14, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB7_16
; SSE42-NEXT:  ## %bb.15: ## %cond.load19
; SSE42-NEXT:    pinsrd $3, 28(%rdi), %xmm2
; SSE42-NEXT:  LBB7_16: ## %else20
; SSE42-NEXT:    movdqa %xmm1, %xmm0
; SSE42-NEXT:    movdqa %xmm2, %xmm1
; SSE42-NEXT:    retq
;
; AVX1-LABEL: load_v8i32_v8i1:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vpmovzxwd {{.*#+}} xmm2 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX1-NEXT:    vpslld $31, %xmm2, %xmm2
; AVX1-NEXT:    vpsrad $31, %xmm2, %xmm2
; AVX1-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm0[4,4,5,5,6,6,7,7]
; AVX1-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm2, %ymm0
; AVX1-NEXT:    vmaskmovps (%rdi), %ymm0, %ymm2
; AVX1-NEXT:    vblendvps %ymm0, %ymm2, %ymm1, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_v8i32_v8i1:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpmaskmovd (%rdi), %ymm0, %ymm2
; AVX2-NEXT:    vblendvps %ymm0, %ymm2, %ymm1, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_v8i32_v8i1:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $ymm1 killed $ymm1 def $zmm1
; AVX512F-NEXT:    vpmovzxwq {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vpblendmd (%rdi), %zmm1, %zmm0 {%k1}
; AVX512F-NEXT:    ## kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-NEXT:    retq
;
; AVX512VLBW-LABEL: load_v8i32_v8i1:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vpsllw $15, %xmm0, %xmm0
; AVX512VLBW-NEXT:    vpmovw2m %xmm0, %k1
; AVX512VLBW-NEXT:    vpblendmd (%rdi), %ymm1, %ymm0 {%k1}
; AVX512VLBW-NEXT:    retq
  %res = call <8 x i32> @llvm.masked.load.v8i32.p0v8i32(<8 x i32>* %addr, i32 4, <8 x i1>%mask, <8 x i32>%dst)
  ret <8 x i32> %res
}

define <8 x float> @load_zero_v8f32_v8i1(<8 x i1> %mask, <8 x float>* %addr) {
; SSE2-LABEL: load_zero_v8f32_v8i1:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    je LBB8_2
; SSE2-NEXT:  ## %bb.1: ## %cond.load
; SSE2-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:  LBB8_2: ## %else
; SSE2-NEXT:    shrl $16, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB8_4
; SSE2-NEXT:  ## %bb.3: ## %cond.load1
; SSE2-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,0],xmm0[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[2,0],xmm0[2,3]
; SSE2-NEXT:    movaps %xmm3, %xmm0
; SSE2-NEXT:  LBB8_4: ## %else2
; SSE2-NEXT:    pextrw $2, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB8_6
; SSE2-NEXT:  ## %bb.5: ## %cond.load4
; SSE2-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,0],xmm0[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm3[0,2]
; SSE2-NEXT:  LBB8_6: ## %else5
; SSE2-NEXT:    pextrw $3, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB8_8
; SSE2-NEXT:  ## %bb.7: ## %cond.load7
; SSE2-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,0],xmm0[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm3[2,0]
; SSE2-NEXT:  LBB8_8: ## %else8
; SSE2-NEXT:    pextrw $4, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB8_10
; SSE2-NEXT:  ## %bb.9: ## %cond.load10
; SSE2-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm1 = xmm3[0],xmm1[1,2,3]
; SSE2-NEXT:  LBB8_10: ## %else11
; SSE2-NEXT:    pextrw $5, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB8_12
; SSE2-NEXT:  ## %bb.11: ## %cond.load13
; SSE2-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,0],xmm1[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[2,0],xmm1[2,3]
; SSE2-NEXT:    movaps %xmm3, %xmm1
; SSE2-NEXT:  LBB8_12: ## %else14
; SSE2-NEXT:    pextrw $6, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB8_14
; SSE2-NEXT:  ## %bb.13: ## %cond.load16
; SSE2-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,0],xmm1[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm3[0,2]
; SSE2-NEXT:  LBB8_14: ## %else17
; SSE2-NEXT:    pextrw $7, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB8_16
; SSE2-NEXT:  ## %bb.15: ## %cond.load19
; SSE2-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,0],xmm1[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm2[2,0]
; SSE2-NEXT:  LBB8_16: ## %else20
; SSE2-NEXT:    retq
;
; SSE42-LABEL: load_zero_v8f32_v8i1:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    movdqa %xmm0, %xmm2
; SSE42-NEXT:    pextrb $0, %xmm0, %eax
; SSE42-NEXT:    pxor %xmm0, %xmm0
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    xorps %xmm1, %xmm1
; SSE42-NEXT:    je LBB8_2
; SSE42-NEXT:  ## %bb.1: ## %cond.load
; SSE42-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE42-NEXT:    xorps %xmm1, %xmm1
; SSE42-NEXT:  LBB8_2: ## %else
; SSE42-NEXT:    pextrb $2, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB8_4
; SSE42-NEXT:  ## %bb.3: ## %cond.load1
; SSE42-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[2,3]
; SSE42-NEXT:  LBB8_4: ## %else2
; SSE42-NEXT:    pextrb $4, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB8_6
; SSE42-NEXT:  ## %bb.5: ## %cond.load4
; SSE42-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1],mem[0],xmm0[3]
; SSE42-NEXT:  LBB8_6: ## %else5
; SSE42-NEXT:    pextrb $6, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB8_8
; SSE42-NEXT:  ## %bb.7: ## %cond.load7
; SSE42-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1,2],mem[0]
; SSE42-NEXT:  LBB8_8: ## %else8
; SSE42-NEXT:    pextrb $8, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB8_10
; SSE42-NEXT:  ## %bb.9: ## %cond.load10
; SSE42-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE42-NEXT:    blendps {{.*#+}} xmm1 = xmm3[0],xmm1[1,2,3]
; SSE42-NEXT:  LBB8_10: ## %else11
; SSE42-NEXT:    pextrb $10, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB8_12
; SSE42-NEXT:  ## %bb.11: ## %cond.load13
; SSE42-NEXT:    insertps {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[2,3]
; SSE42-NEXT:  LBB8_12: ## %else14
; SSE42-NEXT:    pextrb $12, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB8_14
; SSE42-NEXT:  ## %bb.13: ## %cond.load16
; SSE42-NEXT:    insertps {{.*#+}} xmm1 = xmm1[0,1],mem[0],xmm1[3]
; SSE42-NEXT:  LBB8_14: ## %else17
; SSE42-NEXT:    pextrb $14, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB8_16
; SSE42-NEXT:  ## %bb.15: ## %cond.load19
; SSE42-NEXT:    insertps {{.*#+}} xmm1 = xmm1[0,1,2],mem[0]
; SSE42-NEXT:  LBB8_16: ## %else20
; SSE42-NEXT:    retq
;
; AVX1-LABEL: load_zero_v8f32_v8i1:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vpmovzxwd {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX1-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm1
; AVX1-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm0[4,4,5,5,6,6,7,7]
; AVX1-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vmaskmovps (%rdi), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_zero_v8f32_v8i1:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vmaskmovps (%rdi), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_zero_v8f32_v8i1:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    vpmovzxwq {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovups (%rdi), %zmm0 {%k1} {z}
; AVX512F-NEXT:    ## kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-NEXT:    retq
;
; AVX512VLBW-LABEL: load_zero_v8f32_v8i1:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vpsllw $15, %xmm0, %xmm0
; AVX512VLBW-NEXT:    vpmovw2m %xmm0, %k1
; AVX512VLBW-NEXT:    vmovaps (%rdi), %ymm0 {%k1} {z}
; AVX512VLBW-NEXT:    retq
  %res = call <8 x float> @llvm.masked.load.v8f32.p0v8f32(<8 x float>* %addr, i32 32, <8 x i1> %mask, <8 x float> zeroinitializer)
  ret <8 x float> %res
}

define <8 x i32> @load_zero_v8i32_v8i1(<8 x i1> %mask, <8 x i32>* %addr) {
; SSE2-LABEL: load_zero_v8i32_v8i1:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movdqa %xmm0, %xmm2
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    pxor %xmm0, %xmm0
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:    je LBB9_2
; SSE2-NEXT:  ## %bb.1: ## %cond.load
; SSE2-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    xorps %xmm1, %xmm1
; SSE2-NEXT:  LBB9_2: ## %else
; SSE2-NEXT:    shrl $16, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB9_4
; SSE2-NEXT:  ## %bb.3: ## %cond.load1
; SSE2-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,0],xmm0[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[2,0],xmm0[2,3]
; SSE2-NEXT:    movaps %xmm3, %xmm0
; SSE2-NEXT:  LBB9_4: ## %else2
; SSE2-NEXT:    pextrw $2, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB9_6
; SSE2-NEXT:  ## %bb.5: ## %cond.load4
; SSE2-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,0],xmm0[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm3[0,2]
; SSE2-NEXT:  LBB9_6: ## %else5
; SSE2-NEXT:    pextrw $3, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB9_8
; SSE2-NEXT:  ## %bb.7: ## %cond.load7
; SSE2-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,0],xmm0[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm3[2,0]
; SSE2-NEXT:  LBB9_8: ## %else8
; SSE2-NEXT:    pextrw $4, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB9_10
; SSE2-NEXT:  ## %bb.9: ## %cond.load10
; SSE2-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm1 = xmm3[0],xmm1[1,2,3]
; SSE2-NEXT:  LBB9_10: ## %else11
; SSE2-NEXT:    pextrw $5, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB9_12
; SSE2-NEXT:  ## %bb.11: ## %cond.load13
; SSE2-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,0],xmm1[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[2,0],xmm1[2,3]
; SSE2-NEXT:    movaps %xmm3, %xmm1
; SSE2-NEXT:  LBB9_12: ## %else14
; SSE2-NEXT:    pextrw $6, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB9_14
; SSE2-NEXT:  ## %bb.13: ## %cond.load16
; SSE2-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,0],xmm1[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm3[0,2]
; SSE2-NEXT:  LBB9_14: ## %else17
; SSE2-NEXT:    pextrw $7, %xmm2, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB9_16
; SSE2-NEXT:  ## %bb.15: ## %cond.load19
; SSE2-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,0],xmm1[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm2[2,0]
; SSE2-NEXT:  LBB9_16: ## %else20
; SSE2-NEXT:    retq
;
; SSE42-LABEL: load_zero_v8i32_v8i1:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    movdqa %xmm0, %xmm2
; SSE42-NEXT:    pextrb $0, %xmm0, %eax
; SSE42-NEXT:    pxor %xmm0, %xmm0
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    pxor %xmm1, %xmm1
; SSE42-NEXT:    je LBB9_2
; SSE42-NEXT:  ## %bb.1: ## %cond.load
; SSE42-NEXT:    movd {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE42-NEXT:    pxor %xmm1, %xmm1
; SSE42-NEXT:  LBB9_2: ## %else
; SSE42-NEXT:    pextrb $2, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB9_4
; SSE42-NEXT:  ## %bb.3: ## %cond.load1
; SSE42-NEXT:    pinsrd $1, 4(%rdi), %xmm0
; SSE42-NEXT:  LBB9_4: ## %else2
; SSE42-NEXT:    pextrb $4, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB9_6
; SSE42-NEXT:  ## %bb.5: ## %cond.load4
; SSE42-NEXT:    pinsrd $2, 8(%rdi), %xmm0
; SSE42-NEXT:  LBB9_6: ## %else5
; SSE42-NEXT:    pextrb $6, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB9_8
; SSE42-NEXT:  ## %bb.7: ## %cond.load7
; SSE42-NEXT:    pinsrd $3, 12(%rdi), %xmm0
; SSE42-NEXT:  LBB9_8: ## %else8
; SSE42-NEXT:    pextrb $8, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB9_10
; SSE42-NEXT:  ## %bb.9: ## %cond.load10
; SSE42-NEXT:    pinsrd $0, 16(%rdi), %xmm1
; SSE42-NEXT:  LBB9_10: ## %else11
; SSE42-NEXT:    pextrb $10, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB9_12
; SSE42-NEXT:  ## %bb.11: ## %cond.load13
; SSE42-NEXT:    pinsrd $1, 20(%rdi), %xmm1
; SSE42-NEXT:  LBB9_12: ## %else14
; SSE42-NEXT:    pextrb $12, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB9_14
; SSE42-NEXT:  ## %bb.13: ## %cond.load16
; SSE42-NEXT:    pinsrd $2, 24(%rdi), %xmm1
; SSE42-NEXT:  LBB9_14: ## %else17
; SSE42-NEXT:    pextrb $14, %xmm2, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB9_16
; SSE42-NEXT:  ## %bb.15: ## %cond.load19
; SSE42-NEXT:    pinsrd $3, 28(%rdi), %xmm1
; SSE42-NEXT:  LBB9_16: ## %else20
; SSE42-NEXT:    retq
;
; AVX1-LABEL: load_zero_v8i32_v8i1:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vpmovzxwd {{.*#+}} xmm1 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero
; AVX1-NEXT:    vpslld $31, %xmm1, %xmm1
; AVX1-NEXT:    vpsrad $31, %xmm1, %xmm1
; AVX1-NEXT:    vpunpckhwd {{.*#+}} xmm0 = xmm0[4,4,5,5,6,6,7,7]
; AVX1-NEXT:    vpslld $31, %xmm0, %xmm0
; AVX1-NEXT:    vpsrad $31, %xmm0, %xmm0
; AVX1-NEXT:    vinsertf128 $1, %xmm0, %ymm1, %ymm0
; AVX1-NEXT:    vmaskmovps (%rdi), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_zero_v8i32_v8i1:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpmovzxwd {{.*#+}} ymm0 = xmm0[0],zero,xmm0[1],zero,xmm0[2],zero,xmm0[3],zero,xmm0[4],zero,xmm0[5],zero,xmm0[6],zero,xmm0[7],zero
; AVX2-NEXT:    vpslld $31, %ymm0, %ymm0
; AVX2-NEXT:    vpsrad $31, %ymm0, %ymm0
; AVX2-NEXT:    vpmaskmovd (%rdi), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_zero_v8i32_v8i1:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    vpmovzxwq {{.*#+}} zmm0 = xmm0[0],zero,zero,zero,xmm0[1],zero,zero,zero,xmm0[2],zero,zero,zero,xmm0[3],zero,zero,zero,xmm0[4],zero,zero,zero,xmm0[5],zero,zero,zero,xmm0[6],zero,zero,zero,xmm0[7],zero,zero,zero
; AVX512F-NEXT:    vpsllq $63, %zmm0, %zmm0
; AVX512F-NEXT:    vptestmq %zmm0, %zmm0, %k1
; AVX512F-NEXT:    vmovdqu32 (%rdi), %zmm0 {%k1} {z}
; AVX512F-NEXT:    ## kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-NEXT:    retq
;
; AVX512VLBW-LABEL: load_zero_v8i32_v8i1:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vpsllw $15, %xmm0, %xmm0
; AVX512VLBW-NEXT:    vpmovw2m %xmm0, %k1
; AVX512VLBW-NEXT:    vmovdqu32 (%rdi), %ymm0 {%k1} {z}
; AVX512VLBW-NEXT:    retq
  %res = call <8 x i32> @llvm.masked.load.v8i32.p0v8i32(<8 x i32>* %addr, i32 4, <8 x i1> %mask, <8 x i32> zeroinitializer)
  ret <8 x i32> %res
}

define <2 x float> @load_v2f32_v2i32(<2 x i32> %trigger, <2 x float>* %addr, <2 x float> %dst) {
; SSE2-LABEL: load_v2f32_v2i32:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,0,3,2]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB10_2
; SSE2-NEXT:  ## %bb.1: ## %cond.load
; SSE2-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm1 = xmm2[0],xmm1[1,2,3]
; SSE2-NEXT:  LBB10_2: ## %else
; SSE2-NEXT:    pextrw $4, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB10_4
; SSE2-NEXT:  ## %bb.3: ## %cond.load1
; SSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[2,0],xmm1[2,3]
; SSE2-NEXT:    movaps %xmm0, %xmm1
; SSE2-NEXT:  LBB10_4: ## %else2
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: load_v2f32_v2i32:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    movdqa %xmm0, %xmm3
; SSE42-NEXT:    pblendw {{.*#+}} xmm3 = xmm3[0,1],xmm2[2,3],xmm3[4,5],xmm2[6,7]
; SSE42-NEXT:    pcmpeqq %xmm2, %xmm3
; SSE42-NEXT:    pextrb $0, %xmm3, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB10_2
; SSE42-NEXT:  ## %bb.1: ## %cond.load
; SSE42-NEXT:    movd {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm3[0,1],xmm1[2,3,4,5,6,7]
; SSE42-NEXT:  LBB10_2: ## %else
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,3],xmm0[4,5],xmm2[6,7]
; SSE42-NEXT:    pcmpeqq %xmm2, %xmm0
; SSE42-NEXT:    pextrb $8, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB10_4
; SSE42-NEXT:  ## %bb.3: ## %cond.load1
; SSE42-NEXT:    insertps {{.*#+}} xmm1 = xmm1[0],mem[0],xmm1[2,3]
; SSE42-NEXT:  LBB10_4: ## %else2
; SSE42-NEXT:    movaps %xmm1, %xmm0
; SSE42-NEXT:    retq
;
; AVX1-LABEL: load_v2f32_v2i32:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,3],xmm0[4,5],xmm2[6,7]
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,2],zero,zero
; AVX1-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm2
; AVX1-NEXT:    vblendvps %xmm0, %xmm2, %xmm1, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_v2f32_v2i32:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; AVX2-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,2],zero,zero
; AVX2-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm2
; AVX2-NEXT:    vblendvps %xmm0, %xmm2, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_v2f32_v2i32:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $xmm1 killed $xmm1 def $zmm1
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; AVX512F-NEXT:    vptestnmq %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kshiftlw $14, %k0, %k0
; AVX512F-NEXT:    kshiftrw $14, %k0, %k1
; AVX512F-NEXT:    vblendmps (%rdi), %zmm1, %zmm0 {%k1}
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLBW-LABEL: load_v2f32_v2i32:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; AVX512VLBW-NEXT:    vptestnmq %xmm0, %xmm0, %k1
; AVX512VLBW-NEXT:    vblendmps (%rdi), %xmm1, %xmm0 {%k1}
; AVX512VLBW-NEXT:    retq
  %mask = icmp eq <2 x i32> %trigger, zeroinitializer
  %res = call <2 x float> @llvm.masked.load.v2f32.p0v2f32(<2 x float>* %addr, i32 4, <2 x i1>%mask, <2 x float>%dst)
  ret <2 x float> %res
}

define <2 x i32> @load_v2i32_v2i32(<2 x i32> %trigger, <2 x i32>* %addr, <2 x i32> %dst) {
; SSE2-LABEL: load_v2i32_v2i32:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm0 = xmm2[1,0,3,2]
; SSE2-NEXT:    pand %xmm2, %xmm0
; SSE2-NEXT:    movd %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB11_2
; SSE2-NEXT:  ## %bb.1: ## %cond.load
; SSE2-NEXT:    movl (%rdi), %eax
; SSE2-NEXT:    movq %rax, %xmm2
; SSE2-NEXT:    movsd {{.*#+}} xmm1 = xmm2[0],xmm1[1]
; SSE2-NEXT:  LBB11_2: ## %else
; SSE2-NEXT:    pextrw $4, %xmm0, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB11_4
; SSE2-NEXT:  ## %bb.3: ## %cond.load1
; SSE2-NEXT:    movl 4(%rdi), %eax
; SSE2-NEXT:    movq %rax, %xmm0
; SSE2-NEXT:    unpcklpd {{.*#+}} xmm1 = xmm1[0],xmm0[0]
; SSE2-NEXT:  LBB11_4: ## %else2
; SSE2-NEXT:    movapd %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: load_v2i32_v2i32:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    movdqa %xmm0, %xmm3
; SSE42-NEXT:    pblendw {{.*#+}} xmm3 = xmm3[0,1],xmm2[2,3],xmm3[4,5],xmm2[6,7]
; SSE42-NEXT:    pcmpeqq %xmm2, %xmm3
; SSE42-NEXT:    pextrb $0, %xmm3, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB11_2
; SSE42-NEXT:  ## %bb.1: ## %cond.load
; SSE42-NEXT:    movl (%rdi), %eax
; SSE42-NEXT:    pinsrq $0, %rax, %xmm1
; SSE42-NEXT:  LBB11_2: ## %else
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,3],xmm0[4,5],xmm2[6,7]
; SSE42-NEXT:    pcmpeqq %xmm2, %xmm0
; SSE42-NEXT:    pextrb $8, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB11_4
; SSE42-NEXT:  ## %bb.3: ## %cond.load1
; SSE42-NEXT:    movl 4(%rdi), %eax
; SSE42-NEXT:    pinsrq $1, %rax, %xmm1
; SSE42-NEXT:  LBB11_4: ## %else2
; SSE42-NEXT:    movdqa %xmm1, %xmm0
; SSE42-NEXT:    retq
;
; AVX1-LABEL: load_v2i32_v2i32:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,3],xmm0[4,5],xmm2[6,7]
; AVX1-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX1-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,2],zero,zero
; AVX1-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm2
; AVX1-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[0,2,2,3]
; AVX1-NEXT:    vblendvps %xmm0, %xmm2, %xmm1, %xmm0
; AVX1-NEXT:    vpmovsxdq %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_v2i32_v2i32:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; AVX2-NEXT:    vpcmpeqq %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,2],zero,zero
; AVX2-NEXT:    vpmaskmovd (%rdi), %xmm0, %xmm2
; AVX2-NEXT:    vpermilps {{.*#+}} xmm1 = xmm1[0,2,2,3]
; AVX2-NEXT:    vblendvps %xmm0, %xmm2, %xmm1, %xmm0
; AVX2-NEXT:    vpmovsxdq %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_v2i32_v2i32:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; AVX512F-NEXT:    vptestnmq %zmm0, %zmm0, %k0
; AVX512F-NEXT:    vpshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; AVX512F-NEXT:    kshiftlw $14, %k0, %k0
; AVX512F-NEXT:    kshiftrw $14, %k0, %k1
; AVX512F-NEXT:    vmovdqu32 (%rdi), %zmm0 {%k1}
; AVX512F-NEXT:    vpmovsxdq %xmm0, %xmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLBW-LABEL: load_v2i32_v2i32:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX512VLBW-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm2[1],xmm0[2],xmm2[3]
; AVX512VLBW-NEXT:    vptestnmq %xmm0, %xmm0, %k1
; AVX512VLBW-NEXT:    vpshufd {{.*#+}} xmm0 = xmm1[0,2,2,3]
; AVX512VLBW-NEXT:    vmovdqu32 (%rdi), %xmm0 {%k1}
; AVX512VLBW-NEXT:    vpmovsxdq %xmm0, %xmm0
; AVX512VLBW-NEXT:    retq
  %mask = icmp eq <2 x i32> %trigger, zeroinitializer
  %res = call <2 x i32> @llvm.masked.load.v2i32.p0v2i32(<2 x i32>* %addr, i32 4, <2 x i1>%mask, <2 x i32>%dst)
  ret <2 x i32> %res
}

define <2 x float> @load_undef_v2f32_v2i32(<2 x i32> %trigger, <2 x float>* %addr) {
; SSE2-LABEL: load_undef_v2f32_v2i32:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    pand {{.*}}(%rip), %xmm0
; SSE2-NEXT:    pxor %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm2
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm2[1,0,3,2]
; SSE2-NEXT:    pand %xmm2, %xmm1
; SSE2-NEXT:    movd %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    ## implicit-def: $xmm0
; SSE2-NEXT:    je LBB12_2
; SSE2-NEXT:  ## %bb.1: ## %cond.load
; SSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:  LBB12_2: ## %else
; SSE2-NEXT:    pextrw $4, %xmm1, %eax
; SSE2-NEXT:    testb $1, %al
; SSE2-NEXT:    je LBB12_4
; SSE2-NEXT:  ## %bb.3: ## %cond.load1
; SSE2-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,0],xmm0[0,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm0[2,3]
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:  LBB12_4: ## %else2
; SSE2-NEXT:    retq
;
; SSE42-LABEL: load_undef_v2f32_v2i32:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    movdqa %xmm0, %xmm1
; SSE42-NEXT:    pxor %xmm2, %xmm2
; SSE42-NEXT:    pblendw {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,3],xmm0[4,5],xmm2[6,7]
; SSE42-NEXT:    pcmpeqq %xmm2, %xmm0
; SSE42-NEXT:    pextrb $0, %xmm0, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    ## implicit-def: $xmm0
; SSE42-NEXT:    je LBB12_2
; SSE42-NEXT:  ## %bb.1: ## %cond.load
; SSE42-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE42-NEXT:  LBB12_2: ## %else
; SSE42-NEXT:    pblendw {{.*#+}} xmm1 = xmm1[0,1],xmm2[2,3],xmm1[4,5],xmm2[6,7]
; SSE42-NEXT:    pcmpeqq %xmm2, %xmm1
; SSE42-NEXT:    pextrb $8, %xmm1, %eax
; SSE42-NEXT:    testb $1, %al
; SSE42-NEXT:    je LBB12_4
; SSE42-NEXT:  ## %bb.3: ## %cond.load1
; SSE42-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[2,3]
; SSE42-NEXT:  LBB12_4: ## %else2
; SSE42-NEXT:    retq
;
; AVX1-LABEL: load_undef_v2f32_v2i32:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX1-NEXT:    vpblendw {{.*#+}} xmm0 = xmm0[0,1],xmm1[2,3],xmm0[4,5],xmm1[6,7]
; AVX1-NEXT:    vpcmpeqq %xmm1, %xmm0, %xmm0
; AVX1-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,2],zero,zero
; AVX1-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_undef_v2f32_v2i32:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3]
; AVX2-NEXT:    vpcmpeqq %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,2],zero,zero
; AVX2-NEXT:    vmaskmovps (%rdi), %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: load_undef_v2f32_v2i32:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512F-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3]
; AVX512F-NEXT:    vptestnmq %zmm0, %zmm0, %k0
; AVX512F-NEXT:    kshiftlw $14, %k0, %k0
; AVX512F-NEXT:    kshiftrw $14, %k0, %k1
; AVX512F-NEXT:    vmovups (%rdi), %zmm0 {%k1} {z}
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLBW-LABEL: load_undef_v2f32_v2i32:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512VLBW-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm1[1],xmm0[2],xmm1[3]
; AVX512VLBW-NEXT:    vptestnmq %xmm0, %xmm0, %k1
; AVX512VLBW-NEXT:    vmovups (%rdi), %xmm0 {%k1} {z}
; AVX512VLBW-NEXT:    retq
  %mask = icmp eq <2 x i32> %trigger, zeroinitializer
  %res = call <2 x float> @llvm.masked.load.v2f32.p0v2f32(<2 x float>* %addr, i32 4, <2 x i1>%mask, <2 x float>undef)
  ret <2 x float> %res
}

define <4 x float> @load_all_v4f32_v4i32(<4 x i32> %trigger, <4 x float>* %addr) {
; SSE-LABEL: load_all_v4f32_v4i32:
; SSE:       ## %bb.0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX1OR2-LABEL: load_all_v4f32_v4i32:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vmovups (%rdi), %xmm0
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: load_all_v4f32_v4i32:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    movw $15, %ax
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vmovups (%rdi), %zmm0 {%k1} {z}
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLBW-LABEL: load_all_v4f32_v4i32:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    kxnorw %k0, %k0, %k1
; AVX512VLBW-NEXT:    vmovups (%rdi), %xmm0 {%k1} {z}
; AVX512VLBW-NEXT:    retq
  %mask = icmp eq <4 x i32> %trigger, zeroinitializer
  %res = call <4 x float> @llvm.masked.load.v4f32.p0v4f32(<4 x float>* %addr, i32 4, <4 x i1><i1 true, i1 true, i1 true, i1 true>, <4 x float>undef)
  ret <4 x float> %res
}

;;; Loads with Constant Masks - these should be optimized to use something other than a variable blend.

; 128-bit FP vectors are supported with AVX.

define <4 x float> @mload_constmask_v4f32(<4 x float>* %addr, <4 x float> %dst) {
; SSE2-LABEL: mload_constmask_v4f32:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3]
; SSE2-NEXT:    movaps %xmm0, %xmm1
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm2[0,2]
; SSE2-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,0],xmm1[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm2[2,0]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: mload_constmask_v4f32:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE42-NEXT:    blendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3]
; SSE42-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1],mem[0],xmm0[3]
; SSE42-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1,2],mem[0]
; SSE42-NEXT:    retq
;
; AVX1OR2-LABEL: mload_constmask_v4f32:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vblendps {{.*#+}} xmm0 = mem[0],xmm0[1],mem[2,3]
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: mload_constmask_v4f32:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    movw $13, %ax
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vmovups (%rdi), %zmm0 {%k1}
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLBW-LABEL: mload_constmask_v4f32:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    movb $13, %al
; AVX512VLBW-NEXT:    kmovd %eax, %k1
; AVX512VLBW-NEXT:    vmovups (%rdi), %xmm0 {%k1}
; AVX512VLBW-NEXT:    retq
  %res = call <4 x float> @llvm.masked.load.v4f32.p0v4f32(<4 x float>* %addr, i32 4, <4 x i1> <i1 1, i1 0, i1 1, i1 1>, <4 x float> %dst)
  ret <4 x float> %res
}

define <2 x double> @mload_constmask_v2f64(<2 x double>* %addr, <2 x double> %dst) {
; SSE-LABEL: mload_constmask_v2f64:
; SSE:       ## %bb.0:
; SSE-NEXT:    movhpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; SSE-NEXT:    retq
;
; AVX-LABEL: mload_constmask_v2f64:
; AVX:       ## %bb.0:
; AVX-NEXT:    vmovhpd {{.*#+}} xmm0 = xmm0[0],mem[0]
; AVX-NEXT:    retq
  %res = call <2 x double> @llvm.masked.load.v2f64.p0v2f64(<2 x double>* %addr, i32 4, <2 x i1> <i1 0, i1 1>, <2 x double> %dst)
  ret <2 x double> %res
}

; 128-bit integer vectors are supported with AVX2.

define <4 x i32> @mload_constmask_v4i32(<4 x i32>* %addr, <4 x i32> %dst) {
; SSE2-LABEL: mload_constmask_v4i32:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,0],xmm0[0,0]
; SSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    movaps %xmm1, %xmm2
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,0],xmm0[0,2]
; SSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm2[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[2,0],xmm0[2,0]
; SSE2-NEXT:    movaps %xmm1, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: mload_constmask_v4i32:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pinsrd $1, 4(%rdi), %xmm0
; SSE42-NEXT:    pinsrd $2, 8(%rdi), %xmm0
; SSE42-NEXT:    pinsrd $3, 12(%rdi), %xmm0
; SSE42-NEXT:    retq
;
; AVX1-LABEL: mload_constmask_v4i32:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vmovaps {{.*#+}} xmm1 = [0,4294967295,4294967295,4294967295]
; AVX1-NEXT:    vmaskmovps (%rdi), %xmm1, %xmm1
; AVX1-NEXT:    vblendps {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; AVX1-NEXT:    retq
;
; AVX2-LABEL: mload_constmask_v4i32:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vmovdqa {{.*#+}} xmm1 = [0,4294967295,4294967295,4294967295]
; AVX2-NEXT:    vpmaskmovd (%rdi), %xmm1, %xmm1
; AVX2-NEXT:    vpblendd {{.*#+}} xmm0 = xmm0[0],xmm1[1,2,3]
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: mload_constmask_v4i32:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 def $zmm0
; AVX512F-NEXT:    movw $14, %ax
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vmovdqu32 (%rdi), %zmm0 {%k1}
; AVX512F-NEXT:    ## kill: def $xmm0 killed $xmm0 killed $zmm0
; AVX512F-NEXT:    vzeroupper
; AVX512F-NEXT:    retq
;
; AVX512VLBW-LABEL: mload_constmask_v4i32:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    movb $14, %al
; AVX512VLBW-NEXT:    kmovd %eax, %k1
; AVX512VLBW-NEXT:    vmovdqu32 (%rdi), %xmm0 {%k1}
; AVX512VLBW-NEXT:    retq
  %res = call <4 x i32> @llvm.masked.load.v4i32.p0v4i32(<4 x i32>* %addr, i32 4, <4 x i1> <i1 0, i1 1, i1 1, i1 1>, <4 x i32> %dst)
  ret <4 x i32> %res
}

define <2 x i64> @mload_constmask_v2i64(<2 x i64>* %addr, <2 x i64> %dst) {
; SSE2-LABEL: mload_constmask_v2i64:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; SSE2-NEXT:    movlhps {{.*#+}} xmm0 = xmm0[0],xmm1[0]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: mload_constmask_v2i64:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pinsrq $1, 8(%rdi), %xmm0
; SSE42-NEXT:    retq
;
; AVX-LABEL: mload_constmask_v2i64:
; AVX:       ## %bb.0:
; AVX-NEXT:    vpinsrq $1, 8(%rdi), %xmm0, %xmm0
; AVX-NEXT:    retq
  %res = call <2 x i64> @llvm.masked.load.v2i64.p0v2i64(<2 x i64>* %addr, i32 4, <2 x i1> <i1 0, i1 1>, <2 x i64> %dst)
  ret <2 x i64> %res
}

; 256-bit FP vectors are supported with AVX.

define <8 x float> @mload_constmask_v8f32(<8 x float>* %addr, <8 x float> %dst) {
; SSE2-LABEL: mload_constmask_v8f32:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,0],xmm3[0,0]
; SSE2-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,0],xmm0[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,0],xmm3[0,2]
; SSE2-NEXT:    movaps %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: mload_constmask_v8f32:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE42-NEXT:    blendps {{.*#+}} xmm0 = xmm2[0],xmm0[1,2,3]
; SSE42-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0],mem[0],xmm0[2,3]
; SSE42-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1],mem[0],xmm0[3]
; SSE42-NEXT:    retq
;
; AVX1OR2-LABEL: mload_constmask_v8f32:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vmovaps {{.*#+}} ymm1 = [4294967295,4294967295,4294967295,0,0,0,0,0]
; AVX1OR2-NEXT:    vmaskmovps (%rdi), %ymm1, %ymm1
; AVX1OR2-NEXT:    vblendps {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3,4,5,6,7]
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: mload_constmask_v8f32:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    movw $7, %ax
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vmovups (%rdi), %zmm0 {%k1}
; AVX512F-NEXT:    ## kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-NEXT:    retq
;
; AVX512VLBW-LABEL: mload_constmask_v8f32:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    movb $7, %al
; AVX512VLBW-NEXT:    kmovd %eax, %k1
; AVX512VLBW-NEXT:    vmovups (%rdi), %ymm0 {%k1}
; AVX512VLBW-NEXT:    retq
  %res = call <8 x float> @llvm.masked.load.v8f32.p0v8f32(<8 x float>* %addr, i32 4, <8 x i1> <i1 1, i1 1, i1 1, i1 0, i1 0, i1 0, i1 0, i1 0>, <8 x float> %dst)
  ret <8 x float> %res
}

define <4 x double> @mload_constmask_v4f64(<4 x double>* %addr, <4 x double> %dst) {
; SSE-LABEL: mload_constmask_v4f64:
; SSE:       ## %bb.0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1]
; SSE-NEXT:    retq
;
; AVX1OR2-LABEL: mload_constmask_v4f64:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vmovapd {{.*#+}} ymm1 = [18446744073709551615,18446744073709551615,18446744073709551615,0]
; AVX1OR2-NEXT:    vmaskmovpd (%rdi), %ymm1, %ymm1
; AVX1OR2-NEXT:    vblendpd {{.*#+}} ymm0 = ymm1[0,1,2],ymm0[3]
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: mload_constmask_v4f64:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    movb $7, %al
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vmovupd (%rdi), %zmm0 {%k1}
; AVX512F-NEXT:    ## kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-NEXT:    retq
;
; AVX512VLBW-LABEL: mload_constmask_v4f64:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    movb $7, %al
; AVX512VLBW-NEXT:    kmovd %eax, %k1
; AVX512VLBW-NEXT:    vmovupd (%rdi), %ymm0 {%k1}
; AVX512VLBW-NEXT:    retq
  %res = call <4 x double> @llvm.masked.load.v4f64.p0v4f64(<4 x double>* %addr, i32 4, <4 x i1> <i1 1, i1 1, i1 1, i1 0>, <4 x double> %dst)
  ret <4 x double> %res
}

; 256-bit integer vectors are supported with AVX2.

define <8 x i32> @mload_constmask_v8i32(<8 x i32>* %addr, <8 x i32> %dst) {
; SSE2-LABEL: mload_constmask_v8i32:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm2 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[0,0],xmm3[0,0]
; SSE2-NEXT:    movss {{.*#+}} xmm3 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm3 = xmm3[0,0],xmm0[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm2 = xmm2[2,0],xmm3[0,2]
; SSE2-NEXT:    movss {{.*#+}} xmm0 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,0],xmm1[2,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,1],xmm0[2,0]
; SSE2-NEXT:    movaps %xmm2, %xmm0
; SSE2-NEXT:    retq
;
; SSE42-LABEL: mload_constmask_v8i32:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pinsrd $0, (%rdi), %xmm0
; SSE42-NEXT:    pinsrd $1, 4(%rdi), %xmm0
; SSE42-NEXT:    pinsrd $2, 8(%rdi), %xmm0
; SSE42-NEXT:    pinsrd $3, 28(%rdi), %xmm1
; SSE42-NEXT:    retq
;
; AVX1OR2-LABEL: mload_constmask_v8i32:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vblendps {{.*#+}} ymm0 = mem[0,1,2],ymm0[3,4,5,6],mem[7]
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: mload_constmask_v8i32:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    movw $135, %ax
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vmovdqu32 (%rdi), %zmm0 {%k1}
; AVX512F-NEXT:    ## kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-NEXT:    retq
;
; AVX512VLBW-LABEL: mload_constmask_v8i32:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    movb $-121, %al
; AVX512VLBW-NEXT:    kmovd %eax, %k1
; AVX512VLBW-NEXT:    vmovdqu32 (%rdi), %ymm0 {%k1}
; AVX512VLBW-NEXT:    retq
  %res = call <8 x i32> @llvm.masked.load.v8i32.p0v8i32(<8 x i32>* %addr, i32 4, <8 x i1> <i1 1, i1 1, i1 1, i1 0, i1 0, i1 0, i1 0, i1 1>, <8 x i32> %dst)
  ret <8 x i32> %res
}

define <4 x i64> @mload_constmask_v4i64(<4 x i64>* %addr, <4 x i64> %dst) {
; SSE2-LABEL: mload_constmask_v4i64:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movlpd {{.*#+}} xmm0 = mem[0],xmm0[1]
; SSE2-NEXT:    movsd {{.*#+}} xmm2 = mem[0],zero
; SSE2-NEXT:    movlhps {{.*#+}} xmm1 = xmm1[0],xmm2[0]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: mload_constmask_v4i64:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pinsrq $0, (%rdi), %xmm0
; SSE42-NEXT:    pinsrq $1, 24(%rdi), %xmm1
; SSE42-NEXT:    retq
;
; AVX1OR2-LABEL: mload_constmask_v4i64:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vblendps {{.*#+}} ymm0 = mem[0,1],ymm0[2,3,4,5],mem[6,7]
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: mload_constmask_v4i64:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    ## kill: def $ymm0 killed $ymm0 def $zmm0
; AVX512F-NEXT:    movb $9, %al
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vmovdqu64 (%rdi), %zmm0 {%k1}
; AVX512F-NEXT:    ## kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-NEXT:    retq
;
; AVX512VLBW-LABEL: mload_constmask_v4i64:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    movb $9, %al
; AVX512VLBW-NEXT:    kmovd %eax, %k1
; AVX512VLBW-NEXT:    vmovdqu64 (%rdi), %ymm0 {%k1}
; AVX512VLBW-NEXT:    retq
  %res = call <4 x i64> @llvm.masked.load.v4i64.p0v4i64(<4 x i64>* %addr, i32 4, <4 x i1> <i1 1, i1 0, i1 0, i1 1>, <4 x i64> %dst)
  ret <4 x i64> %res
}

; 512-bit FP vectors are supported with AVX512.

define <8 x double> @mload_constmask_v8f64(<8 x double>* %addr, <8 x double> %dst) {
; SSE-LABEL: mload_constmask_v8f64:
; SSE:       ## %bb.0:
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1]
; SSE-NEXT:    movhpd {{.*#+}} xmm3 = xmm3[0],mem[0]
; SSE-NEXT:    retq
;
; AVX1OR2-LABEL: mload_constmask_v8f64:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vblendps {{.*#+}} ymm0 = mem[0,1,2,3,4,5],ymm0[6,7]
; AVX1OR2-NEXT:    vblendps {{.*#+}} ymm1 = ymm1[0,1,2,3,4,5],mem[6,7]
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: mload_constmask_v8f64:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    movb $-121, %al
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vmovupd (%rdi), %zmm0 {%k1}
; AVX512F-NEXT:    retq
;
; AVX512VLBW-LABEL: mload_constmask_v8f64:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    movb $-121, %al
; AVX512VLBW-NEXT:    kmovd %eax, %k1
; AVX512VLBW-NEXT:    vmovupd (%rdi), %zmm0 {%k1}
; AVX512VLBW-NEXT:    retq
  %res = call <8 x double> @llvm.masked.load.v8f64.p0v8f64(<8 x double>* %addr, i32 4, <8 x i1> <i1 1, i1 1, i1 1, i1 0, i1 0, i1 0, i1 0, i1 1>, <8 x double> %dst)
  ret <8 x double> %res
}

; If the pass-through operand is undef, no blend is needed.

define <4 x double> @mload_constmask_v4f64_undef_passthrough(<4 x double>* %addr) {
; SSE-LABEL: mload_constmask_v4f64_undef_passthrough:
; SSE:       ## %bb.0:
; SSE-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    movups (%rdi), %xmm0
; SSE-NEXT:    retq
;
; AVX1OR2-LABEL: mload_constmask_v4f64_undef_passthrough:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vmovapd {{.*#+}} ymm0 = [18446744073709551615,18446744073709551615,18446744073709551615,0]
; AVX1OR2-NEXT:    vmaskmovpd (%rdi), %ymm0, %ymm0
; AVX1OR2-NEXT:    retq
;
; AVX512F-LABEL: mload_constmask_v4f64_undef_passthrough:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    movb $7, %al
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vmovupd (%rdi), %zmm0 {%k1} {z}
; AVX512F-NEXT:    ## kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-NEXT:    retq
;
; AVX512VLBW-LABEL: mload_constmask_v4f64_undef_passthrough:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    movb $7, %al
; AVX512VLBW-NEXT:    kmovd %eax, %k1
; AVX512VLBW-NEXT:    vmovupd (%rdi), %ymm0 {%k1} {z}
; AVX512VLBW-NEXT:    retq
  %res = call <4 x double> @llvm.masked.load.v4f64.p0v4f64(<4 x double>* %addr, i32 4, <4 x i1> <i1 1, i1 1, i1 1, i1 0>, <4 x double> undef)
  ret <4 x double> %res
}

define <4 x i64> @mload_constmask_v4i64_undef_passthrough(<4 x i64>* %addr) {
; SSE-LABEL: mload_constmask_v4i64_undef_passthrough:
; SSE:       ## %bb.0:
; SSE-NEXT:    movsd {{.*#+}} xmm1 = mem[0],zero
; SSE-NEXT:    movq {{.*#+}} xmm0 = mem[0],zero
; SSE-NEXT:    pshufd {{.*#+}} xmm0 = xmm0[0,1,0,1]
; SSE-NEXT:    retq
;
; AVX1-LABEL: mload_constmask_v4i64_undef_passthrough:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vmovapd {{.*#+}} ymm0 = [0,18446744073709551615,18446744073709551615,0]
; AVX1-NEXT:    vmaskmovpd (%rdi), %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: mload_constmask_v4i64_undef_passthrough:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vmovdqa {{.*#+}} ymm0 = [0,18446744073709551615,18446744073709551615,0]
; AVX2-NEXT:    vpmaskmovq (%rdi), %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512F-LABEL: mload_constmask_v4i64_undef_passthrough:
; AVX512F:       ## %bb.0:
; AVX512F-NEXT:    movb $6, %al
; AVX512F-NEXT:    kmovw %eax, %k1
; AVX512F-NEXT:    vmovdqu64 (%rdi), %zmm0 {%k1} {z}
; AVX512F-NEXT:    ## kill: def $ymm0 killed $ymm0 killed $zmm0
; AVX512F-NEXT:    retq
;
; AVX512VLBW-LABEL: mload_constmask_v4i64_undef_passthrough:
; AVX512VLBW:       ## %bb.0:
; AVX512VLBW-NEXT:    movb $6, %al
; AVX512VLBW-NEXT:    kmovd %eax, %k1
; AVX512VLBW-NEXT:    vmovdqu64 (%rdi), %ymm0 {%k1} {z}
; AVX512VLBW-NEXT:    retq
  %res = call <4 x i64> @llvm.masked.load.v4i64.p0v4i64(<4 x i64>* %addr, i32 4, <4 x i1> <i1 0, i1 1, i1 1, i1 0>, <4 x i64> undef)
  ret <4 x i64> %res
}

;  When only one element of the mask is set, reduce to a scalar load.

define <4 x i32> @load_one_mask_bit_set1(<4 x i32>* %addr, <4 x i32> %val) {
; SSE2-LABEL: load_one_mask_bit_set1:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE2-NEXT:    movss {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: load_one_mask_bit_set1:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pinsrd $0, (%rdi), %xmm0
; SSE42-NEXT:    retq
;
; AVX-LABEL: load_one_mask_bit_set1:
; AVX:       ## %bb.0:
; AVX-NEXT:    vpinsrd $0, (%rdi), %xmm0, %xmm0
; AVX-NEXT:    retq
  %res = call <4 x i32> @llvm.masked.load.v4i32.p0v4i32(<4 x i32>* %addr, i32 4, <4 x i1><i1 true, i1 false, i1 false, i1 false>, <4 x i32> %val)
  ret <4 x i32> %res
}

; Choose a different element to show that the correct address offset is produced.

define <4 x float> @load_one_mask_bit_set2(<4 x float>* %addr, <4 x float> %val) {
; SSE2-LABEL: load_one_mask_bit_set2:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movss {{.*#+}} xmm1 = mem[0],zero,zero,zero
; SSE2-NEXT:    shufps {{.*#+}} xmm1 = xmm1[0,0],xmm0[3,0]
; SSE2-NEXT:    shufps {{.*#+}} xmm0 = xmm0[0,1],xmm1[0,2]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: load_one_mask_bit_set2:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    insertps {{.*#+}} xmm0 = xmm0[0,1],mem[0],xmm0[3]
; SSE42-NEXT:    retq
;
; AVX-LABEL: load_one_mask_bit_set2:
; AVX:       ## %bb.0:
; AVX-NEXT:    vinsertps {{.*#+}} xmm0 = xmm0[0,1],mem[0],xmm0[3]
; AVX-NEXT:    retq
  %res = call <4 x float> @llvm.masked.load.v4f32.p0v4f32(<4 x float>* %addr, i32 4, <4 x i1><i1 false, i1 false, i1 true, i1 false>, <4 x float> %val)
  ret <4 x float> %res
}

; Choose a different scalar type and a high element of a 256-bit vector because AVX doesn't support those evenly.

define <4 x i64> @load_one_mask_bit_set3(<4 x i64>* %addr, <4 x i64> %val) {
; SSE2-LABEL: load_one_mask_bit_set3:
; SSE2:       ## %bb.0:
; SSE2-NEXT:    movlpd {{.*#+}} xmm1 = mem[0],xmm1[1]
; SSE2-NEXT:    retq
;
; SSE42-LABEL: load_one_mask_bit_set3:
; SSE42:       ## %bb.0:
; SSE42-NEXT:    pinsrq $0, 16(%rdi), %xmm1
; SSE42-NEXT:    retq
;
; AVX1-LABEL: load_one_mask_bit_set3:
; AVX1:       ## %bb.0:
; AVX1-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX1-NEXT:    vpinsrq $0, 16(%rdi), %xmm1, %xmm1
; AVX1-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX1-NEXT:    retq
;
; AVX2-LABEL: load_one_mask_bit_set3:
; AVX2:       ## %bb.0:
; AVX2-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX2-NEXT:    vpinsrq $0, 16(%rdi), %xmm1, %xmm1
; AVX2-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX2-NEXT:    retq
;
; AVX512-LABEL: load_one_mask_bit_set3:
; AVX512:       ## %bb.0:
; AVX512-NEXT:    vextracti128 $1, %ymm0, %xmm1
; AVX512-NEXT:    vpinsrq $0, 16(%rdi), %xmm1, %xmm1
; AVX512-NEXT:    vinserti128 $1, %xmm1, %ymm0, %ymm0
; AVX512-NEXT:    retq
  %res = call <4 x i64> @llvm.masked.load.v4i64.p0v4i64(<4 x i64>* %addr, i32 4, <4 x i1><i1 false, i1 false, i1 true, i1 false>, <4 x i64> %val)
  ret <4 x i64> %res
}

; Choose a different scalar type and a high element of a 256-bit vector because AVX doesn't support those evenly.

define <4 x double> @load_one_mask_bit_set4(<4 x double>* %addr, <4 x double> %val) {
; SSE-LABEL: load_one_mask_bit_set4:
; SSE:       ## %bb.0:
; SSE-NEXT:    movhpd {{.*#+}} xmm1 = xmm1[0],mem[0]
; SSE-NEXT:    retq
;
; AVX-LABEL: load_one_mask_bit_set4:
; AVX:       ## %bb.0:
; AVX-NEXT:    vextractf128 $1, %ymm0, %xmm1
; AVX-NEXT:    vmovhpd {{.*#+}} xmm1 = xmm1[0],mem[0]
; AVX-NEXT:    vinsertf128 $1, %xmm1, %ymm0, %ymm0
; AVX-NEXT:    retq
  %res = call <4 x double> @llvm.masked.load.v4f64.p0v4f64(<4 x double>* %addr, i32 4, <4 x i1><i1 false, i1 false, i1 false, i1 true>, <4 x double> %val)
  ret <4 x double> %res
}

; Try a 512-bit vector to make sure AVX doesn't die and AVX512 works as expected.

define <8 x double> @load_one_mask_bit_set5(<8 x double>* %addr, <8 x double> %val) {
; SSE-LABEL: load_one_mask_bit_set5:
; SSE:       ## %bb.0:
; SSE-NEXT:    movhpd {{.*#+}} xmm3 = xmm3[0],mem[0]
; SSE-NEXT:    retq
;
; AVX1OR2-LABEL: load_one_mask_bit_set5:
; AVX1OR2:       ## %bb.0:
; AVX1OR2-NEXT:    vextractf128 $1, %ymm1, %xmm2
; AVX1OR2-NEXT:    vmovhpd {{.*#+}} xmm2 = xmm2[0],mem[0]
; AVX1OR2-NEXT:    vinsertf128 $1, %xmm2, %ymm1, %ymm1
; AVX1OR2-NEXT:    retq
;
; AVX512-LABEL: load_one_mask_bit_set5:
; AVX512:       ## %bb.0:
; AVX512-NEXT:    vextractf32x4 $3, %zmm0, %xmm1
; AVX512-NEXT:    vmovhpd {{.*#+}} xmm1 = xmm1[0],mem[0]
; AVX512-NEXT:    vinsertf32x4 $3, %xmm1, %zmm0, %zmm0
; AVX512-NEXT:    retq
  %res = call <8 x double> @llvm.masked.load.v8f64.p0v8f64(<8 x double>* %addr, i32 4, <8 x i1><i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 false, i1 true>, <8 x double> %val)
  ret <8 x double> %res
}

define i32 @pr38986(i1 %c, i32* %p) {
; SSE-LABEL: pr38986:
; SSE:       ## %bb.0:
; SSE-NEXT:    testb $1, %dil
; SSE-NEXT:    ## implicit-def: $eax
; SSE-NEXT:    je LBB30_2
; SSE-NEXT:  ## %bb.1: ## %cond.load
; SSE-NEXT:    movl (%rsi), %eax
; SSE-NEXT:  LBB30_2: ## %else
; SSE-NEXT:    retq
;
; AVX-LABEL: pr38986:
; AVX:       ## %bb.0:
; AVX-NEXT:    testb $1, %dil
; AVX-NEXT:    ## implicit-def: $eax
; AVX-NEXT:    je LBB30_2
; AVX-NEXT:  ## %bb.1: ## %cond.load
; AVX-NEXT:    movl (%rsi), %eax
; AVX-NEXT:  LBB30_2: ## %else
; AVX-NEXT:    retq
 %vc = insertelement <1 x i1> undef, i1 %c, i32 0
 %vp = bitcast i32* %p to <1 x i32>*
 %L = call <1 x i32> @llvm.masked.load.v1i32.p0v1i32 (<1 x i32>* %vp, i32 4, <1 x i1> %vc, <1 x i32> undef)
 %ret = bitcast <1 x i32> %L to i32
 ret i32 %ret
}
declare <1 x i32>  @llvm.masked.load.v1i32.p0v1i32 (<1 x i32>*, i32, <1 x i1>, <1 x i32>)


declare <4 x i32> @llvm.masked.load.v4i32.p0v4i32(<4 x i32>*, i32, <4 x i1>, <4 x i32>)
declare <2 x i32> @llvm.masked.load.v2i32.p0v2i32(<2 x i32>*, i32, <2 x i1>, <2 x i32>)
declare <4 x i64> @llvm.masked.load.v4i64.p0v4i64(<4 x i64>*, i32, <4 x i1>, <4 x i64>)
declare <2 x i64> @llvm.masked.load.v2i64.p0v2i64(<2 x i64>*, i32, <2 x i1>, <2 x i64>)
declare <8 x float> @llvm.masked.load.v8f32.p0v8f32(<8 x float>*, i32, <8 x i1>, <8 x float>)
declare <8 x i32> @llvm.masked.load.v8i32.p0v8i32(<8 x i32>*, i32, <8 x i1>, <8 x i32>)
declare <4 x float> @llvm.masked.load.v4f32.p0v4f32(<4 x float>*, i32, <4 x i1>, <4 x float>)
declare <2 x float> @llvm.masked.load.v2f32.p0v2f32(<2 x float>*, i32, <2 x i1>, <2 x float>)
declare <8 x double> @llvm.masked.load.v8f64.p0v8f64(<8 x double>*, i32, <8 x i1>, <8 x double>)
declare <4 x double> @llvm.masked.load.v4f64.p0v4f64(<4 x double>*, i32, <4 x i1>, <4 x double>)
declare <2 x double> @llvm.masked.load.v2f64.p0v2f64(<2 x double>*, i32, <2 x i1>, <2 x double>)
declare <1 x double> @llvm.masked.load.v1f64.p0v1f64(<1 x double>*, i32, <1 x i1>, <1 x double>)
