;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;
; Definitions for 8259A interrupt controller
;

;	REGISTER DISPLACEMENTS

ICW1	=	0		;ICW1
ICW2	=	1		;ICW2
ICW3	=	1		;ICW3
ICW4	=	1		;ICW4
OCW1	=	1		;OCW1
OCW2	=	0		;OCW2
OCW3	=	0		;OCW3

;	ICW1 REGISTER FLAGS

ICW1A	=	11100000B	;A7-A5
ICW1OP	=	00010000B	;1=ICW1 , 0=OCW'S
ICW1LT	=	00001000B	;TRIGGER MODE (0=EDGE , 1=LEVEL)
ICW1ADI	=	00000100B	;CALL INTERVAL (0=8 , 1=4)
ICW1SNG	=	00000010B	;0=CASCADE , 1=SINGLE
ICW1IL4	=	00000001B	;ICW4 (0=NOT USED , 1=USED)

;	ICW3 REGISTER FLAGS (MASTER DEVICE)

ICW3S0	=	00000001B	;IR INPUT 0 HAS SLAVE
ICW3S1	=	00000010B	;IR INPUT 1 HAS SLAVE
ICW3S2	=	00000100B	;IR INPUT 2 HAS SLAVE
ICW3S3	=	00001000B	;IR INPUT 3 HAS SLAVE
ICW3S4	=	00010000B	;IR INPUT 4 HAS SLAVE
ICW3S5	=	00100000B	;IR INPUT 5 HAS SLAVE
ICW3S6	=	01000000B	;IR INPUT 6 HAS SLAVE
ICW3S7	=	10000000B	;IR INPUT 7 HAS SLAVE

;	ICW3 REGISTER FLAGS (SLAVE DEVICE)

ICW3SID	=	00000111B	;SLAVE ID MASK

;	ICW4 REGISTER FLAGS

ICW4SFN	=	00010000B	;1=SPECIAL FULLY NESTED MODE
ICW4BMS	=	00001000B	;BUFFERED MODE SLAVE
ICW4BMM	=	00001100B	;BUFFERED MODE MASTER
ICW4AE	=	00000010B	;AUTO EOI
ICW4UPM	=	00000001B	;MICRO-PROCESSOR MODE
				; (0=8080/85 , 1=8086/88)

;	OCW1 REGISTER (INTERRUPT MASK REGISTER)

OCW1IM0	=	00000001B	;IR0
OCW1IM1	=	00000010B	;IR1
OCW1IM2	=	00000100B	;IR2
OCW1IM3	=	00001000B	;IR3
OCW1IM4	=	00010000B	;IR4
OCW1IM5	=	00100000B	;IR5
OCW1IM6	=	01000000B	;IR6
OCW1IM7	=	10000000B	;IR7

;	OCW2 REGISTER

OCW2OP	=	00000000B	;OCW2
OCW2R	=	10000000B	;PRIORITY ROTATION
OCW2SL	=	01000000B	;SELECT A SPECIFIC LEVEL
OCW2EOI	=	00100000B	;END OF INTERRUPT COMMAND
OCW2L	=	00000111B	;IR LEVEL TO BE ACTED UPON

;	OCW3 REGISTER

OCW3OP	=	00001000B	;OCW3
OCW3RSM	=	01000000B	;RESET SPECIAL MASK MODE
OCW3SSM	=	01100000B	;SET SPECIAL MASK MODE
OCW3P	=	00000100B	;POLL COMMAND
OCW3RIR	=	00000010B	;READ IR REG
OCW3RIS	=	00000011B	;READ IS REG
