	PAGE	,132
;	Copyright(C) 1984, Zenith Data Systems Corporation
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;

	PAGE	,132
	TITLE	BIOS initialization data and code


;**************************************************************************
;*	Initialization code and data. This section is overwritten by a disk
;	buffer after initialization
;
;	IMPORTANT!!!
;	This must be the last module to be loaded (before SYSINIT).
;
;**************************************************************************

.XLIST
	INCLUDE ASCII.DEF
	INCLUDE DRIVERS.DEF
	INCLUDE FIXED.DEF
	INCLUDE IOCONFIG.DEF
	INCLUDE LOADER.DEF
	INCLUDE MSDOS.DEF
	INCLUDE MACRO.ASM
	INCLUDE Z150BIOS.DEF
	INCLUDE Z150ROM.DEF
	INCLUDE DEFMTR.ASM
	INCLUDE U8250.DEF
	INCLUDE DEFCONFG.ASM
	INCLUDE DEFCHR.ASM
	INCLUDE DEFIPAGE.ASM
	INCLUDE DEF8253.ASM
.LIST

;	Define the externals in SYSINIT used for initialization

	EXTRN	CURRENT_DOS_LOCATION:WORD, FINAL_DOS_LOCATION:WORD
	EXTRN	DEVICE_LIST:DWORD, MEMORY_SIZE:WORD, DEFAULT_DRIVE:BYTE
	EXTRN	BUFFERS:BYTE, FILES:BYTE
	EXTRN	SYSINIT:FAR, SYSSIZE:BYTE
	EXTRN	ISR_UKB:NEAR,ISR_UCRT:NEAR,DUMMY_IRET:NEAR

LOOPCOUNT	=  	0FFFFH			; Loop constant
B9600		=  	0CH			; 9600 baud divisor for 8250

BIOS	SEGMENT BYTE PUBLIC 'BIOS'
	ASSUME	CS:BIOS,DS:BIOS,SS:BIOS

	PUBLIC	BIOS_INIT, CON_INIT, DISK_BUF, DISK_INIT
	PUBLIC	RE_INIT, MDS


	EXTRN	BPB_9X2:BYTE
	EXTRN	FIXED_BPBS:BYTE
	EXTRN	INIT_BPB:BYTE
	EXTRN	SPECIAL:NEAR
	EXTRN	SUCESS:NEAR
	EXTRN	NUM_DISK:BYTE
	EXTRN	STACK_TOP:WORD
	EXTRN	DATE:WORD
	EXTRN	KB_BREAK:NEAR
	EXTRN	CONFIG_PTR:WORD
	EXTRN	CONFIG_DATA:BYTE
	EXTRN	IO_TABLES:BYTE
	EXTRN	PRINTER_MAX:ABS
	EXTRN	SERIAL_MAX:ABS
	EXTRN	SCT1:BYTE
	EXTRN	CON:BYTE
	EXTRN	ONE_DRIVE:BYTE
	EXTRN	NUM_FLOPPY:BYTE
	EXTRN	FIXED_FLAGS:BYTE
	EXTRN	TIM_FLG:BYTE
	EXTRN	DOP_TYPE:BYTE
	EXTRN	DECODE:NEAR
	EXTRN	DOP17:NEAR
	EXTRN	DOP18:NEAR
	EXTRN	PMSG:NEAR
	EXTRN	BIOS_START:NEAR
	EXTRN	SERA_ISR:NEAR
	EXTRN	SERB_ISR:NEAR
	EXTRN	ISR_USAI:NEAR
	EXTRN	ISR_USAO:NEAR
	EXTRN	ISR_USBI:NEAR
	EXTRN	ISR_USBO:NEAR
	EXTRN	CQ_ZSERA:NEAR
	EXTRN	CQ_ZSERB:NEAR
	EXTRN	ROM_TIMER_VECTOR:WORD
	EXTRN	ISR_TIM:NEAR
	EXTRN	ISR_UTM:NEAR
	EXTRN	ISR_EVN:NEAR
	EXTRN	BIOS_DATE:WORD
	EXTRN	BIOS_AUXFUNC:FAR
	EXTRN	BIOS_PRNFUNC:FAR
	EXTRN	CID_AUX:BYTE
	EXTRN	CID_PRN:BYTE
	EXTRN	BIOS_EXTRA:NEAR
	EXTRN	FNT_ROM:DWORD
	EXTRN	FNT_RAM:DWORD
	EXTRN	FNT_SIZE:WORD
	EXTRN	FNT_MSIZE:WORD
	EXTRN	FONTLD:NEAR
	EXTRN	FNT_TAB:WORD
	EXTRN	DEF_DRV:BYTE
	EXTRN	ISR_ULP:NEAR
	EXTRN	ISR_VSYN:NEAR
	EXTRN	ISR_UVSYN:NEAR
	EXTRN	VSYNC_PTR:DWORD

	EXTRN	KB_MTR:DWORD
	EXTRN	KB_INT:NEAR
	EXTRN	CQ_ZCON:BYTE
	EXTRN	Q_ZCON:BYTE
	EXTRN	SER_EXIST:BYTE

 
DISK_BUF LABEL	BYTE		; Disk buffer after initialization complete
INIT_START LABEL BYTE
	ERRNZ	DISK_BUF,INIT_START

;	Data needed to load MSDOS.SYS
;
DATA_SECTOR	DW	?		; Data start sector
BOOT_BPB	BPB_STRUC	<>	; BPB from boot disk
FAT_SEG		DW	?		; Segment FAT is loaded at
IO_MSG		DB	'I/O erro', 'r'+80H

MDS		DW	?		; Destination of monitor data segment

;	Init table used by the DOS. This table describes
;	the maximum format a unit will take on during operation.
;	The table is initially set up for 4 floppys and 4 fixed
;	disk partitions. At boot time the table is readjusted to
;	show the actual configuration of floppys and fixed disk
;	partitions.

BPB_TABLE LABEL	WORD
	DW	OFFSET BPB_9X2
	DW	OFFSET BPB_9X2
	DW	OFFSET BPB_9X2
	DW	OFFSET BPB_9X2

	ERRNZ	<(OFFSET $ - OFFSET BPB_TABLE)/2>,MAX_FLOPPY

	DW	OFFSET INIT_BPB
	DW	OFFSET INIT_BPB
	DW	OFFSET INIT_BPB
	DW	OFFSET INIT_BPB

	ERRNZ	<(OFFSET $ - OFFSET BPB_TABLE)/2>,<(MAX_FLOPPY+MAX_FIXED)>


;	Floppy disk parameter table used by ROM (moved to location
;	 0:570H during boot)
DISK_PARMS LABEL BYTE

	DB	0DFH
	DB	002H
	DB	025H
	DB	002H
	DB	009H
	DB	02AH
	DB	0FFH
	DB	050H
	DB	0F6H
	DB	0DH
	DB	04H
LDPT	=  	OFFSET $ - OFFSET DISK_PARMS

;***************************************************************************
;
;	The following two tables are used to calculate parameters to
;	assign the first partition on the first winchester disk.
;
;***************************************************************************

;	"Break" points where disk parameters change on winchester partitions
;	Compatible values used here. 0 <= Part size < MIN_PART is invalid
BREAK	DW	0200H		; <= 256K 
	DW	0800H		; <= 1M
	DW	2000H		; <= 4M
	DW	7FA8H		; <= ~16M
NUM_BREAK	=  	(OFFSET $ - OFFSET BREAK) / 2

;	Number of directory entries, one to one correspondence to BREAK vector
DIRS	DW	0040H
	DW	0070H
	DW	0100H
	DW	0200H
	DW	0400H		; For partitions > ~16M

;*
;	CON driver initialization - install INT 29H handler

CON_INIT PROC NEAR
	MOV	DI,29H SHL 2		; Get location of interrupt
	SUB	AX,AX
	MOV	ES,AX
	MOV	AX,OFFSET SPECIAL	; Put offset of special routine
	CLD
	STOSW				;  in interrupt location
	MOV	AX,BIOS2_SEG		; Put segment of interrupt routine
	STOSW				;  in interrupt location
	JMP	SUCESS
CON_INIT ENDP

;*
;	Disk driver initialization - Return the address of a BPB table
;		and the number of units
DISK_INIT PROC	NEAR

	MOV	AL,8       		; Return the number of units
	MOV	ES:[BX+CIN_UNITS],AL
	MOV	WORD PTR ES:[BX+CIN_BADDR],OFFSET BPB_TABLE	; Return the address of the BPB table
	MOV	WORD PTR ES:[BX+CIN_BADDR+2],CS	; Segment
	JMP	SUCESS

DISK_INIT ENDP


;*	Initialization code. The initialization code is split into two
;	parts; The following part along with the previous data is
;	overwritten by a disk buffer after initialization and should be
;	as large as the largest sector size supported. The part at the
;	end is overwritten when MS-DOS is relocated.
;
BIOS_INIT LABEL FAR

;	Set up a local stack

	MOV	AX,CS
	CLI
	MOV	SS,AX
	MOV	SP,OFFSET STACK_TOP
	STI

	IF	DT_STAMP
;	Initialize date/time from 'stamp' on disk loader image
	
	SUB	AX,AX				; Set data segment to 0
	MOV	DS,AX
	MOV	AX,BIOS2_SEG
	MOV	ES,AX
	MOV	SI,(LOAD_ADDR+DISK_BPB_OFFSET+TYPE BPB_STRUC)  ; Point to time
	MOV	DI,OFFSET BIOS_DATE
	MOV	CX,7				; 7 bytes to move
INIT0A:
	MOV	AL,[SI]				; Get byte
	MOV	CS:[DI],AL			; Store it
	INC	SI
	INC	DI
	LOOP	INIT0A				; Do for all 7 bytes

	ENDIF


;	Move the boot BPB from the loader to a local location

	SUB	AX,AX			; Set up source pointer
	MOV	DS,AX
	MOV	SI,LOAD_ADDR+DISK_BPB_OFFSET

	PUSH	CS			; Set up destination pointer
	POP	ES
	MOV	DI,OFFSET BOOT_BPB

	MOV	CX,TYPE BPB_STRUC
	CLD
	REP	MOVSB

;	Move the floppy disk parameter block to an internal area 
;	and install a pointer to this block
	
	MOV	AX,BIOS2_SEG		; Get current segment
	MOV	ES,AX
	MOV	DI,OFFSET BIOS_EXTRA + BIOS_DPT

	PUSH	CS			; Get source pointer
	POP	DS

	ASSUME	DS:BIOS

	MOV	SI,OFFSET DISK_PARMS
	MOV	AX,DI			; Save address

	MOV	CX,LDPT 		; Get length of table
	REP	MOVSB			; Move table

	SUB	DI,DI
	MOV	ES,DI			; Address paragraph 0

	MOV	DI,DISK_PARMS_INTR SHL 2	; Address of disk parms.
	STOSW				; Update disk parameter pointer
	MOV	AX,BIOS2_SEG
	STOSW
	
;	Ensure print screen inactive, set last accessed drive

	MOV	BYTE PTR BIOS_EXTRA[PRT_SCRN_FLAG],0

	MOV	BYTE PTR BIOS_EXTRA[LAST_DRIVE],0

;	Set up for cntl-C on keyboard break

	MOV	DI,BREAK_INTR SHL 2	; Get offset of break
	MOV	AX,OFFSET KB_BREAK
	CLI
	STOSW
	MOV	AX,CS
	STOSW
	STI

;	Set up the configuration table pointer at start of the BIOS

	MOV	CONFIG_PTR,OFFSET CONFIG_DATA

;	Set up the I/O tables for the ROM

	MOV	DI,IO_PARMS_INTR SHL 2		; Offset of pointer
	MOV	AX,OFFSET IO_TABLES		;  Offset of data
	STOSW
	MOV	AX,CS				; Segment
	STOSW

;	Initialize the system timer

	MOV	DI,(ZINTTIM+ZM8259AI) SHL 2	; Point to vector location
	SUB	AX,AX
	MOV	ES,AX				; Set ES to IPAGE segment
	MOV	AX,ES:WORD PTR [DI]		; Save old vector
	MOV	ROM_TIMER_VECTOR,AX
	MOV	AX,ES:WORD PTR [DI+2]
	MOV	ROM_TIMER_VECTOR[2],AX
	MOV	AX,OFFSET ISR_TIM		; Get offset of timer service routine
	CLD
	CLI
	STOSW					; Move offset into vector area
	MOV	AX,BIOS2_SEG			; Get segment of service routine
	STOSW					; Move it in

;	Install user timer vector

	MOV	DI,INT_UTMA SHL 2
	MOV	AX,OFFSET ISR_UTM		; Install offset
	STOSW
	MOV	AX,BIOS2_SEG			; Install segment
	STOSW
	
	MOV	AL,36H				; Sel timer0,LSB,MSB,MODE3
	OUT	ZTIMER+PITCW,AL
	MOV	AX,ZTIMEVAL			; Set 100 Hz divisor
	OUT	ZTIMER,AL
	MOV	AL,AH
	OUT	ZTIMER,AL
	STI

;	Install Event interrupt

	MOV	DI,INT_EVNA SHL 2
	MOV	AX,OFFSET ISR_EVN		; Get offset of service routine
	STOSW
	MOV	AX,CS				; Get segment of routine
	STOSW

;	Initialize user keyboard and crt interrupt

	MOV	DI,INT_UKBA SHL 2
	MOV	AX,OFFSET ISR_UKB
	STOSW
	MOV	AX,CS
	STOSW
	MOV	DI,INT_UCRTA SHL 2
	MOV	AX,OFFSET ISR_UCRT
	STOSW
	MOV	AX,CS
	STOSW

;	Initialize user light pen interrupt

	MOV	DI,INT_ULPA SHL 2
	MOV	AX,OFFSET ISR_ULP
	STOSW
	MOV	AX,CS
	STOSW

;	Prepare the BIOS for receiving ROM keyboard interrupts

	MOV	DI,INT_MTRKB SHL 2	; Save old interrupt vector
	MOV	AX,ES:[DI]
	MOV	WORD PTR KB_MTR,AX
	MOV	AX,ES:[DI+2]
	MOV	WORD PTR KB_MTR+2,AX
	MOV	AX,OFFSET KB_INT
	CLI
	STOSW
	MOV	AX,CS
	STOSW
	STI

;	Point print screen interrupt to dummy IRET

	MOV	DI,INT_PRSCA SHL 2
	MOV	AX,OFFSET DUMMY_IRET
	STOSW
	MOV	AX,CS
	STOSW

;	Set up VSYNC interrupt vector

	MOV	DI,INT_UVSYNA SHL 2
	MOV	AX,OFFSET ISR_UVSYN
	STOSW
	MOV	AX,CS
	STOSW

	MOV	AX,ES:WORD PTR INT_VSYN		; Get seg of vsync service routine
	MOV	CS:WORD PTR VSYNC_PTR,AX	; Store it 
	MOV	AX,ES:WORD PTR INT_VSYN[2]	; Get offset
	MOV	CS:WORD PTR VSYNC_PTR[2],AX	; Store it
	MOV	DI,INT_VSYNA SHL 2		; Get pointer to VSYNC vector
	MOV	AX,OFFSET ISR_VSYN		; Get offset of ISR
	CLI
	STOSW
	MOV	AX,CS
	STOSW
	STI

;	Check for serial ports

	INT	EQUIPMENT_INTR			; Check for ports
	AND	AX,0E00H			; Isolate serial bits
	JZ	SER_CHK2			; No ports, skip on down
	MOV	CL,9
	SHR	AX,CL				; Make them the LSB's

;	AL = # serial ports

	CMP	AL,0				; Are there any?
	JZ	SER_CHK2			; No, skip
	CMP	AL,2				; Are there at least two?
	JAE	SER_CHK1A			; Yes skip

;	There is one port, see which one

	MOV	AX,ROM_SEG			; Get rom seg
	MOV	ES,AX
	MOV	ES,ES:ROM_DATA_SEG		; ES = ROM data segment
	MOV	BX,0				; Look at first entry of port table
	CMP	WORD PTR ES:[BX],ZSERA		; Port A?
	JNZ	SER_CHK0A			; No, skip
	MOV	SER_EXIST,0FFH			; Flag A as real
	JMP SHORT	SER_CHK2		; Done
SER_CHK0A:
	CMP	WORD PTR ES:[BX],ZSERB		; Port B?
	JNZ	SER_CHK2			; No, bail out
	MOV	SER_EXIST[1],0FFH		; Flag B as real
	JMP SHORT	SER_CHK2		; Done

SER_CHK1A:
	MOV	SER_EXIST,0FFH			; Flag serial A as real
	MOV	SER_EXIST[1],0FFH		; Flag serial B as real
	
SER_CHK2:
	
;	Initialize the printer devices

	MOV	CX,ROM_SEG			; Address ROM data for time outs
	MOV	ES,CX
	MOV	ES,ES:ROM_DATA_SEG
	MOV	DI,OFFSET PRINTER_TIME_OUT

	MOV	SI,OFFSET IO_TABLES

	MOV	CX,PRINTER_MAX		; For the max number of devices
INIT2:
	MOV	DX,PRINTER_MAX		; Get device number
	SUB	DX,CX
	MOV	AH,PIO_INIT		; and initialization code
	INT	PRINTER_IO_INTR  	; Init parallel port

	MOV	AL,PCT_TIME_OUT[SI]
	STOSB
	ADD	SI,PCT_SIZE
	LOOP	INIT2			; Next device

;	Initialize PRN device

	MOV	AH,CHR_CONTROL
	MOV	AL,CHR_CFSU		; New setup subfunction of control
	MOV	BX,BIOS2_SEG
	MOV	ES,BX
	MOV	BX,OFFSET CID_PRN	; Get 'new' CID
	PUSH	CS			; Fake far call
	CALL	NEAR PTR BIOS_PRNFUNC
	JNC	INIT2A			; If no error, skip
	JMP	IO_ERROR		;  else abort boot

INIT2A:
;	Initialize the RS232 devices

	MOV	DI,INT_USAIA SHL 2	; Install user serial int vectors
	SUB	AX,AX			; Set AX to interrupt page segment
	MOV	ES,AX
	MOV	AX,OFFSET ISR_USAI	; Get offset of service routine
	CLD
	STOSW				; Move in offset
	MOV	AX,BIOS2_SEG		; Get segment
	STOSW				; Move it in

	MOV	DI,INT_USAOA SHL 2	; Serial A output int
	MOV	AX,OFFSET ISR_USAO	; Offset of service routine
	CLD
	STOSW				; Move it in
	MOV	AX,BIOS2_SEG		; Segment address
	STOSW

	MOV	DI,INT_USBIA SHL 2	; Serial B input int
	MOV	AX,OFFSET ISR_USBI	; Get offset of service routine
	CLD
	STOSW
	MOV	AX,BIOS2_SEG
	STOSW

	MOV	DI,INT_USBOA SHL 2	; Serial B output int
	MOV	AX,OFFSET ISR_USBO
	CLD
	STOSW
	MOV	AX,BIOS2_SEG
	STOSW

;	Install actual serial ISR's

	MOV	DI,0CH SHL 2		; Get location of interrupt
	MOV	AX,OFFSET SERA_ISR	; Put offset of service routine
	CLD
	STOSW				;  in interrupt location
	MOV	AX,BIOS2_SEG		; Put segment of interrupt routine
	STOSW				;  in interrupt location

	MOV	DI,0BH SHL 2		; Also install for INT 0BH
	MOV	AX,OFFSET SERB_ISR
	CLD
	STOSW
	MOV	AX,BIOS2_SEG
	STOSW

;	Zero the int vector for the mouse

	MOV	DI,33H SHL 2
	MOV	AX,0
	STOSW
	STOSW

	MOV	DI,OFFSET CQ_ZSERA	; Get address of A's queue descriptor
	MOV	CS:WORD PTR CQ_SEGM[DI],CS	; Store queue segment
	MOV	DI,OFFSET CQ_ZSERB	; Get address of B's queue descriptor
	MOV	CS:WORD PTR CQ_SEGM[DI],CS	; Store queue segment

;	Initialize AUX device

	MOV	AH,CHR_CONTROL
	MOV	AL,CHR_CFSU		; New setup subfunction of control
	MOV	BX,BIOS2_SEG
	MOV	ES,BX
	MOV	BX,OFFSET CID_AUX	; Pointer to 'new' CID
	PUSH	CS			; Fake far call
	CALL	NEAR PTR BIOS_AUXFUNC
	JNC	INIT2B			; If no error, skip
	JMP	IO_ERROR		;  else abort boot
INIT2B:

;	Enable serial interrupts on 8259A

	IN	AL,ZM8259A+1		; Get current interrupt mask
	AND	AL,NOT ZSERA_INT_MASK	; Enable serial A ints
	AND	AL,NOT ZSERB_INT_MASK	; Enable serial B ints
	OUT	ZM8259A+1,AL		; Write it to the 8259A

;	Initialize console queue

	MOV	DI,OFFSET CQ_ZCON	; Get addr of queue descriptor
	MOV	AX,ROM_SEG
	MOV	ES,AX			; Point ES to ROM data seg
	CLI				; Don't allow interrupts
	MOV	AX,CS:CQ_SEGM[DI]	; Get segment of queue
	MOV	ES:KBD_BUFF_SEG,AX	; Store if for ROM
	MOV	AX,CS:CQ_SADDR[DI]	; Get start of queue
	MOV	ES:KBD_BUFF_START,AX	; Store it for ROM
	MOV	AX,CS:CQ_EADDR[DI]	; Get address of end of queue

	MOV	ES:KBD_BUFF_END,AX	; Store it for ROM

	MOV	ES,ES:ROM_DATA_SEG	; Point to IBM data seg

	MOV	AX,OFFSET Q_ZCON  	; Get head pointer
	MOV	ES:BUFFER_HEAD,AX	; Store for ROM
	MOV	ES:BUFFER_TAIL,AX	; Make tail = head
	STI				; Allow interrupts now


;	Initialize CURRENT_DOS_LOCATION

	CALL	LOAD_DOS		; Load DOS and return address in AX
	MOV	CX,SEG SYSINIT
	MOV	DS,CX
	MOV	CURRENT_DOS_LOCATION,AX

;	Initialize FINAL_DOS_LOCATION

	MOV	AX,OFFSET BIOS_TRANSIENT ; Find first free para. after resident BIOS
	ADD	AX,15			; Adjust to next paragraph
	MOV	CL,4
	SHR	AX,CL
	ADD	AX,BIOS2_SEG
	MOV	CS:MDS,AX		; Save MDS segment

	PUSH	DS			; Save data segment and para.
	PUSH	AX

	SUB	AX,AX			; Locate current MDS
	MOV	DS,AX

	ASSUME	DS:IPAGE_SEG

	MOV	AX,MTR_DS
	MOV	DS,AX			; Get segment of MDS

	ASSUME	DS:MTR_D_SEG

	MOV	AX,MTR_DS_SIZE		; Find size in paragraphs
	ADD	AX,15
	MOV	CL,4
	SHR	AX,CL
	POP	BX
	ADD	AX,BX			; Get location of MDS
	PUSH	AX
	PUSH	CX
	MOV	CX,4			; Convert paragraph to address
	SUB	AX,BIOS2_SEG		; Adjust for bios segment
	SHL	AX,CL			; Get offset of FONT table
	MOV	FNT_TAB,AX		; Save addr of FONT table
	POP	CX
	POP	AX
	ADD	AX,(MTR_FNT_SIZE + 15) SHR 4	; Allow space for FONT 
	POP	DS

	ASSUME	DS:NOTHING

	MOV	FINAL_DOS_LOCATION,AX


;	Initialize MEMORY_SIZE

	INT	MEMORY_SIZE_INTR	; Find memory size
	MOV	CL,6			; Convert from 1k blocks to paragraphs
	SHL	AX,CL
	MOV	MEMORY_SIZE,AX		; Set memory size

;	Initialize DEVICE_LIST pointer to boot devices

	MOV	WORD PTR DEVICE_LIST,OFFSET CON		; CON driver is head of the list
	MOV	WORD PTR DEVICE_LIST+2,CS

	PUSH	CS			; Restore BIOS data
	POP	DS
	PUSH	CS
	POP	ES

	ASSUME	DS:BIOS

;	Reset disk system

	SUB	AH,AH
	INT	DISK_IO_INTR

;	Determine number of floppy drives and set up disk tables

	INT	EQUIPMENT_INTR
	AND	AL,0C0H			; Isolate drive bits
	ROL	AL,1
	ROL	AL,1			; Put drive bits in low bits
	JNZ	INIT4
	MOV	BYTE PTR ONE_DRIVE,1	; Flag one drive system
	INC	AL			; Make one drive look like two
INIT4:
	INC	AL
	MOV	NUM_DISK,AL		; Set driver number of devices
	MOV	NUM_FLOPPY,AL

;	Check for fixed disks

	MOV	AH,DIO_GETPARMS		; Return drive parameters
	MOV	DL,80H			; Fixed disk 0
	INT	DISK_IO_INTR
	JC	INIT5			; No fixed disk controller
	OR	DL,DL			; Test for any drives attached
	JZ	INIT5			; No fixed disks attached.

;	Fixed disks exist, set up for MAX_FIXED partitions

	ADD	NUM_DISK,MAX_FIXED	; Show more drives available
	MOV	AL,NUM_FLOPPY		; Prepare for updating DOS init. tables
	CMP	AL,MAX_FLOPPY
	JZ	INIT5			; No modification of DOS init. tables needed

;	Set up the DOS init. tables for the fixed disks

	MOV	SI,OFFSET BPB_TABLE+MAX_FLOPPY*2	; Set up source
	SHL	AL,1			; Word index
	CBW
	ADD	AX,OFFSET BPB_TABLE	; Add in base address
	MOV	DI,AX			; Set up destination
	MOV	CX,MAX_FIXED		; MAX_FIXED partitions
	REP	MOVSW			; Update init. table

;	Select the boot drive

INIT5:
	MOV	DL,BYTE PTR BOOT_BPB+BPB_UNIT	; Boot unit boot BPB
	TEST	DL,80H			; Check for fixed disk
	JNZ	INIT5A			; Booting from a fixed disk
	PUSH	DX			; Save boot drive
	CALL	ASSIGN_PART		; Log in a partition
	POP	DX			; Restore boot drive
	JMP	SHORT INIT6		; Finished, transfer to SYSINIT
INIT5A:
	MOV	DL,MAX_FLOPPY		; Set to correct fixed disk unit number
	
;	Do an assign on the fixed disk (copy the boot BPB
;	into the first slot in the FIXED BPB block)

	MOV	SI,OFFSET BOOT_BPB	; Get source offset
	MOV	DI,OFFSET FIXED_BPBS	; Get destination offset
	MOV	CX,TYPE BPB_STRUC	; Get count
	REP	MOVSB			; Set up table
	OR	ES:FIXED_FLAGS,7	; Set assigned flag,formatted flag and
					; changed flag for first fixed disk
INIT6:
	MOV	AX,SEG SYSINIT
	MOV	DS,AX
	MOV	CS:DEF_DRV,DL		; Store default drive for FONTLD
	INC	DL			; DOS needs to 1 greater drive number
	MOV	DEFAULT_DRIVE,DL	; Select disk

	JMP	SYSINIT			; Initialize MS-DOS


;	Re-locate the monitor data segment and read in ALTCHAR.SYS
;
RE_INIT	PROC	FAR

	PUSH	DS			; Save registers
	PUSH	ES
	PUSH	AX
	PUSH	BX
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI

	ASSUME	SS:NOTHING

	MOV	ES,CS:MDS		; Get the destination of the MDS
	SUB	AX,AX			; Get the current loc. of the MDS
	MOV	DS,AX

	ASSUME	DS:IPAGE_SEG

	MOV	AX,MTR_DS
	MOV	DS,AX

	ASSUME	DS:MTR_D_SEG

	SUB	SI,SI			; Prepare to move MDS
	MOV	DI,SI
	MOV	CX,MTR_DS_SIZE		; Get the size
	CLD
	CLI
	REP	MOVSB			; Move the data segment
	SUB	AX,AX
	MOV	DS,AX

	ASSUME	DS:IPAGE_SEG

	MOV	MTR_DS,ES
	STI

	PUSH	CS
	POP	DS			; Restore DS to BIOS

	ASSUME	DS:BIOS

;	Move in FONT information

	MOV	AX,FNT_TAB		; Get FONT address
	MOV	WORD PTR FNT_RAM,AX	; Store it
	MOV	WORD PTR FNT_RAM+2,CS	; Save RAM paragraph for FONT
	MOV	WORD PTR FNT_MSIZE,MTR_FNT_SIZE	; Store MAX size
	MOV	DS,CS:MDS		; Address ROM data segment
	
	ASSUME	DS:MTR_D_SEG

	MOV	AX,WORD PTR MTR_FNTSIZ	; Get font size
	MOV	CS:FNT_SIZE,AX		; Store it
	MOV	BX,WORD PTR MTR_FONT	; Get address of FONT table
	MOV	DX,WORD PTR MTR_FONT+2	;  and segment
	MOV	AX,CS:FNT_TAB		; Get address of our FONT
	MOV	WORD PTR MTR_FONT,AX	; Let the ROM know
	MOV	WORD PTR MTR_FONT+2,CS
	MOV	CS:WORD PTR FNT_ROM,BX	; Save the ROM addr
	MOV	CS:WORD PTR FNT_ROM+2,DX

;	Move in the FONT table

	ASSUME	DS:NOTHING

	MOV	DS,DX			; Get address of ROM's FONT table
	MOV	SI,BX
	MOV	DI,CS:FNT_TAB		; Set up destination
	PUSH	CS
	POP	ES
	MOV	CX,WORD PTR CS:FNT_SIZE	; Get size of table
	REP	MOVSB			; Move it in
	PUSH	CS
	POP	DS			; Restore DS

	CALL	FONTLD			; Read in ALTCHAR.SYS


	IF	DT_STAMP
	MOV	CS:TIM_FLG,0		; Allow date/time stamping now
	ENDIF

	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	POP	AX
	POP	ES
	POP	DS

	RET

RE_INIT	ENDP


	SUBTTL	BIOS Initialization code
	PAGE

;***************************************************************
;   INITIALIZATION CODE
;	This code will be overwritten by
;	the DOS when SYSINIT relocates it.
;***************************************************************

BIOS_TRANSIENT	LABEL	NEAR

	ASSUME	DS:BIOS

;	LOAD_DOS - This routine will load the DOS from the MS-DOS
;		file system.
;
;	ENTRY:	None
;
;	EXIT:	AX - Paragraph the DOS is currently at
;
;	USES:	All
;
LOAD_DOS	PROC	NEAR

;	Locate the first free paragraph after the BIOS and SYSINIT

;	MOV	AX,OFFSET SYSSIZE	; Get size of SYSINIT
;	ADD	AX,15			; Bias for paragraph
;	MOV	CL,4			; Turn into paragraph size
;	SHR	AX,CL
;	ADD	AX,SEG SYSINIT		; Add in base segment
	MOV	AX,1000H		; Start loading at 2nd 64K bank

	MOV	FAT_SEG,AX		; Save FAT segment

;	Locate the first FAT and read it in

	MOV	SI,OFFSET BOOT_BPB	; Point to the boot BPB
	MOV	AX,BPB_RES[SI]		; Get the number of reserved sectors
	ADD	AX,BPB_HIDDEN[SI]	; Add in number of hidden sectors
	MOV	DATA_SECTOR,AX		; Save FAT sector for now
	MOV	DOP_TYPE,DIO_READ	; Set read operation for entire procedure
	CALL	LOAD_FAT
	JC	IO_ERROR

;	Locate the first directory sector

	MOV	AL,BPB_NFATS[SI]	; Get the number of FAT's
	CBW
	MUL	BPB_FATSECS[SI]		; Times number of sectors in a FAT
	ADD	DATA_SECTOR,AX		; Add to current preceding count

;	Locate the paragraph past the FAT to load the DOS at

	MOV	AX,SEC_SIZE		; Find the number of bytes in a FAT
	MUL	BPB_FATSECS[SI]
	MOV	CL,4			; Turn into paragraph (no bias needed)
	SHR	AX,CL
	ADD	AX,FAT_SEG
	
;	Load in the first directory sector and get the first allocation unit

	MOV	ES,AX
	SUB	BX,BX			; At offset 0
	MOV	DX,DATA_SECTOR		; Sector number in DX for decoding
	CALL	DECODE
	MOV	DL,BPB_UNIT[SI]		; Pass unit and
	CALL	DOP17			; Read one directory sector
	JC	IO_ERROR

;	Update DATA_SECTOR to actually contain the first data sector number

	MOV	AX,DE_SIZE		; Size of a directory entry times
	MUL	BPB_DIRENTS[SI]		; Number of directories
	ADD	AX,SEC_SIZE-1		; Fudge it to ensure full sector allocation
	ADC	DX,0			; Just in case it is over 16 bits
	MOV	BX,SEC_SIZE		; Divide by sector size in bytes
	DIV	BX			; AX = Number of directory sectors
	ADD	DATA_SECTOR,AX		; DATA_SECTOR correct now

;	Prepare to load the DOS

	MOV	AX,ES:[DE_SIZE+DE_START]	; Get the first group number from the MSDOS.SYS entry
	SUB	BX,BX			; Load at offset 0


;	Load the DOS

LD1:
	PUSH	AX			; Save group number
	CALL	GROUP_TO_SECTOR		; Translate to sector number
	MOV	DX,AX			; In DX for decoding
	CALL	DECODE
	MOV	DL,BPB_UNIT[SI]		; Pass unit for disk I/O
	MOV	AL,BPB_SPAU[SI]		; Read in a groups worth
	CBW
	CALL	DOP18			; Do the actual read
	JC	IO_ERROR
	POP	AX			; Restore group number
	PUSH	DS			; Save DS
	MOV	DS,FAT_SEG		; Point to FAT
	CALL	NEXT_GROUP		; Get the next group
	POP	DS			; Restore DS
	CMP	AX,0FFFH		; Last link in FAT?
	JNZ	LD1			; No, read in this group

;	Done, return paragraph of the DOS

	MOV	AX,ES			; Return DOS paragraph in AX
	RET				; Yes, DOS loaded

LOAD_DOS	ENDP

;	IO_ERROR - This routine will display a message when
;		a disk error has occured.
IO_ERROR	PROC	NEAR

	MOV	DX,OFFSET IO_MSG
	CALL	PMSG
STALL:
	JMP	STALL

IO_ERROR	ENDP
	
;	LOAD_FAT - This routine will load a FAT into memory.
;
;	ENTRY:	AX - Sector number of FAT
;		DS:SI - Pointer to BPB
;		FAT_SEG - Segment to load the FAT at
;
;	EXIT:	'C' set, can not read FAT
;		'C' clear, FAT read and in memory
;
;	USES:	AX, BX, CX, DX, ES, DI 
;
LOAD_FAT	PROC	NEAR

	MOV	ES,FAT_SEG
	MOV	CL,BPB_NFATS[SI]	; Prepare for multiple FAT's
	SUB	CH,CH
	MOV	DX,AX			; Sector number in DX
LF1:
	PUSH	CX			; Save number of FAT'S left
	PUSH	DX			; Save sector number
	SUB	BX,BX			; Load at offset 0
	CALL	DECODE			; Decode the sector number
	MOV	DL,BPB_UNIT[SI]		; Pass the unit number
	MOV	AX,BPB_FATSECS[SI]	; Read in an entire FAT
	CALL	DOP18			; Do the actual read
	JNC	LF2			; Carry clear, no error, exit
	POP	DX			; Else restore the sector number and
	ADD	DX,BPB_FATSECS[SI]	; try the next FAT
	POP	CX
	LOOP	LF1
	STC				; Can't read any FAT's, error
	RET
LF2:
	POP	DX
	POP	CX
	RET

LOAD_FAT	ENDP
		

;	NEXT_GROUP - This routine will return the next group
;		in the FAT link given the current group
;
;	ENTRY:	AX - last group number
;		DS - Segment of FAT
;
;	EXIT:	AX = next group number
;
;	USES:	None
;
NEXT_GROUP	PROC	NEAR

	PUSH	BX			; Free up a couple of registers
	PUSH	DX
	MOV	DX,3			; Group number times 3/2 to get index
	MUL	DX
	SHR	AX,1			; Note, 'C' shows odd or even
	MOV	BX,AX			; Set up index
	MOV	AX,[BX]			; load next group number
	JC	NG1			; Jump and decode group if odd
	AND	AX,0FFFH		; Else decode like this
	JMP	SHORT NG2
NG1:
	SHR	AX,1			; Decode odd group
	SHR	AX,1
	SHR	AX,1
	SHR	AX,1
NG2:
	POP	DX			; Restore registers
	POP	BX
	RET

NEXT_GROUP	ENDP


;	GROUP_TO_SECTOR - This routine will take a group number and
;		decode it to get a sector number for disk I/O
;
;	ENTRY:	AX - Group number
;		DS:SI - Pointer to BPB for this disk
;		DATA_SECTOR - Sector number of the first data sector
;
;	EXIT:	AX - Sector corresponding to given group
;
;	USES:	None
;
GROUP_TO_SECTOR	PROC	NEAR

	PUSH	DX			; Save a register
	SUB	AX,2			; Base group number at 0
	MOV	DL,BPB_SPAU[SI]		; multiply times sectors per group
	SUB	DH,DH
	MUL	DX
	ADD	AX,DATA_SECTOR		; Add base data sector
	POP	DX
	RET

GROUP_TO_SECTOR ENDP

;	ASSIGN_PART - This routine will attempt to assign a DOS partition
;		partition from the first winchester disk.
;
;	ENTRY:	DS - Same as CS
;
;	EXIT:	None
;
;	USES:	All
;
ASSIGN_PART	PROC	NEAR

;	Check for Winchester controller

	MOV	AH,DIO_GETPARMS		; Attempt to get parameters for
	MOV	DL,80H			;  first winch disk
	INT	DISK_IO_INTR
	JC	ASSIGN_EXIT		; If controller does not exist exit

;	Load the boot sector of the winchester

	MOV	CX,1			; Sector 1, cylinder 0
	MOV	DX,0080H		; First winchester disk, head 0
	SUB	BX,BX			; At (now) unused memory
	MOV	ES,FAT_SEG
	MOV	DOP_TYPE,DIO_READ	; Do a read
	MOV	SI,OFFSET FIXED_BPBS	; Disk I/O needs a BPB
	CALL	DOP17			; Read one sector
	JC	ASSIGN_EXIT		; If an error then don't do assign
	CMP	WORD PTR ES:[SEC_SIZE-2],0AA55H	; Is table valid?
	JNZ	ASSIGN_EXIT		; Nope, exit.

;	Locate a DOS partition

	MOV	SI,SEC_SIZE-(MAX_FIXED*TYPE P_ENT+2) ; Address the part table
	MOV	CX,MAX_FIXED		; Must find DOS partition in MAX_FIXED entries
AP1:
	CMP	BYTE PTR ES:OS_ID[SI],DOS_ID	; Is this a DOS partition?
	JZ	AP2			; Yes, continue
	ADD	SI,TYPE P_ENT		; No, Check next entry
	LOOP	AP1
	JMP	ASSIGN_EXIT		; No DOS partitions on the disk, exit
AP2:
	CALL	SET_BPB			; Calculate BPB parameters
	JC	ASSIGN_EXIT		; Exit on error

;	Check if the partition has been formatted by loading the boot
;	sector and comparing the BPB there to the one calculated.

	MOV	DH,BYTE PTR ES:BOOT_FLAG[SI+1]	; Head of boot sector
	MOV	DL,80H				; Drive number
	MOV	CX,WORD PTR ES:BOOT_FLAG[SI+2]	; Cylinder and sector
	SUB	BX,BX			; Load at unused FAT_SEG memory
	MOV	SI,OFFSET FIXED_BPBS	; Pass BPB
	CALL	DOP17			; Read boot sector
	JC	ASSIGN_EXIT		; If error then exit
	CMP	ES:[SEC_SIZE-2],0AA55H	; Is this a valid sector?
	JNZ	AP3			; No, exit

;	Compare BPB's and see if the disk is formatted

	MOV	SI,OFFSET FIXED_BPBS	; Yes, compare BPB's
	MOV	DI,DISK_BPB_OFFSET
	MOV	CX,OFFSET BPB_MBYTE - OFFSET BPB_SECSZ
	CLD
	REP	CMPSB
	JNZ	AP3			; BPB's different, don't flag formatted
	INC	SI			; Skip over media byte
	INC	DI
	MOV	CX,TYPE BPB_STRUC - OFFSET BPB_FATSECS
	REP	CMPSB
	JNZ	AP3			; BPB's different
	OR	FIXED_FLAGS,1 SHL 2 + 1 SHL 1	; Flag partition as formatted and changed
AP3:
	OR	FIXED_FLAGS,1 SHL 0	; Flag partition as assigned
ASSIGN_EXIT:
	RET

ASSIGN_PART	ENDP

;	SET_BPB - This routine will set up the first winchester disk BPB
;	given SI pointing to the entry in the partition table. This routine
;	assumes that the following entries in the BPB are already set:
;	BPB_SECSZ, BPB_RES, BPB_NFATS, BPB_MBYTE, BPB_SPT and BPB_UNIT
;
;	ENTRY:	ES:SI - Points to a DOS partition table entry
;
;	EXIT:	ES:SI Unchanged
;		If 'C' set, parameters could not be calculated
;		If 'C' clear, FIXED_BPB has valid parameters for given part.
;
;	USES:	All
;
SET_BPB	PROC	NEAR

;	Set the number of heads

	MOV	DL,80H			; Do first winchester disk
	MOV	AH,DIO_GETPARMS		; Get the number of heads
	INT	DISK_IO_INTR
	JC	BAD_PART		; If error then do not assign
	INC	DH			; Correct head count
	MOV	BYTE PTR FIXED_BPBS+BPB_HEADS,DH	; Save in BPB

;	Set the hidden sectors

	MOV	AX,WORD PTR ES:REL_SEC[SI]	; Get the number of hidden sectors
	MOV	WORD PTR FIXED_BPBS+BPB_HIDDEN,AX	; Set number of hidden sectors in BPB

;	Set the partition size

	MOV	AX,WORD PTR ES:PART_SIZE[SI]	; Get the size of the part.
	CMP	AX,MIN_PART		; Is it below the minimum partition?
	JB	BAD_PART		; Yes, exit with error
	MOV	WORD PTR FIXED_BPBS+BPB_SECS,AX	; No, set part. size into BPB

;	Determine the necessary cluster factor and number of directory entries

	SUB	DI,DI			; Create index
SB1:
	CMP	AX,BREAK[DI]		; Check if at a break point
	JBE	SB2			; Have correct info. now
	INC	DI			; Not there yet, try next one
	INC	DI
	CMP	DI,NUM_BREAK*2		; Have we done all breaks?
	JB	SB1			; No, try next one

;	Set the number of directory entries into the BPB

SB2:
	MOV	CX,DIRS[DI]		; Get number of directory entries
	MOV	WORD PTR FIXED_BPBS+BPB_DIRENTS,CX	; Save in BPB

;	Calculate cluster factor

	SHR	DI,1			; Get correct index
	MOV	CX,DI			; Into CL
	MOV	BL,1			; CLF = 2 ** CL
	SHL	BL,CL
	MOV	BYTE PTR FIXED_BPBS+BPB_SPAU,BL	; Save cluster factor

;	Determine number of FAT sectors required

	DEC	BL			; Use cluster factor - 1 to ensure enough
	SUB	BH,BH
	ADD	BX,AX			; Add number of sectors
	SHR	BX,CL			; Divide by cluster factor
	INC	BX
	AND	BL,NOT 1		; Do 3/2 (bytes/cluster) * clusters
	MOV	AX,BX
	SHR	AX,1
	ADD	AX,BX
	ADD	AX,SEC_SIZE-1		; Bias for entire sector
	SHR	AH,1			; Divide by sector size (512)
	MOV	BYTE PTR FIXED_BPBS+BPB_FATSECS,AH	; Save FAT sectors in BPB
	CLC
	RET

BAD_PART:
	STC			; Can not assign partition
	RET

SET_BPB	ENDP


BIOS_END LABEL NEAR

BIOS_LENGTH	EQU  	OFFSET BIOS_END - OFFSET BIOS_START

BIOS	ENDS
	END

