;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;

	PAGE
;
;  PBE_STATUS - Console status
;
;     Check if a character is ready at the console.
;
;     Returns:
;         "Z" clear - character in AL
;         "Z" set - AL = 0 (No character ready)
;
;     Uses: No registers are modified
;

PBE_STATUS PROC FAR
	PUSH	BX		; Save regs
	PUSH	DI
	PUSH	SI
	PUSH	DX
	PUSH	AX
	MOV	AH,CHR_LOOK	; Get Look function
	PUSH	CS		; Make into far call
	CALL	NEAR PTR BIOS_CONFUNC ; Get copy of first char in queue, empty?
	MOV	BL,0		; Assume queue empty, was it ?
	JC	BSTAT1		;    Yes, skip
	MOV	BL,AL		;    No, Save char
BSTAT1:
	MOV	AL,0FFH		; Get -1
	ADC	AL,0		; Set "Z" flag appropriately
	POP	AX		; Recover AX
	MOV	AL,BL		; Get char
	POP	DX		; Restore regs
	POP	SI
	POP	DI
	POP	BX
	RET			;   and return


PBE_STATUS ENDP

	PAGE
;
;  PBE_CONIN - Console input
;
;     Wait for character from the console, then return the character.
;
;     Returns:
;         AL = character 
;
;     Uses: No registers are modified
;

PBE_CONIN PROC FAR
	PUSH	BX		; Save regs
	PUSH	DI
	PUSH	SI
	PUSH	DX
BCONIN1:
	PUSH	AX
	MOV	AH,CHR_READ	; Get read function
	PUSH	CS		; Make call a far call
	CALL	NEAR PTR BIOS_CONFUNC ; Read char, any errors ?
	MOV	BL,AL		; Save char
	POP	AX
	JC	BCONIN1		; If an error, then try again

	MOV	AL,BL		; Get char
	POP	DX		; Restore regs
	POP	SI
	POP	DI
	POP	BX
	RET			;   and return
PBE_CONIN ENDP


;
;  PBE_FLUSH - Flush the keyboard type ahead queue
;
;     Uses:  No registers are changed.
;

PBE_FLUSH PROC	FAR
	PUSH	BX		; Save regs
	PUSH	DI
	PUSH	SI
	PUSH	DX
	PUSH	AX
	MOV	AH,CHR_CONTROL	; Get control function
	MOV	AL,CHR_CFCI	; Get clear input subfunction
	PUSH	CS		; Make call a far call
	CALL	NEAR PTR BIOS_CONFUNC ; Clear input, (ignore errors)
	POP	AX		; Restore regs
	POP	DX
	POP	SI
	POP	DI
	POP	BX
	RET			;   and return
PBE_FLUSH ENDP


	PAGE
;
;  PBE_CONOUT - Console output
;
;     Call with:
;         AL = character to output
;
;     Uses: No registers are changed.
;

PBE_CONOUT PROC FAR
	PUSH	BX		; Save regs
	PUSH	DI
	PUSH	SI
	PUSH	DX
BCONOUT1:
	PUSH	AX
	MOV	AH,CHR_WRITE	; Get write function
	PUSH	CS		; Make call a far call
	CALL	NEAR PTR BIOS_CONFUNC ; Write char, any errors ?
	POP	AX
	JC	BCONOUT1	; If an error, then try again

	POP	DX		; Restore regs
	POP	SI
	POP	DI
	POP	BX
	RET			;   and return
PBE_CONOUT ENDP


