	TITLE	DSKFUNC - Disk I/O Functions
	PAGE	,132
;	Copyright(C) 1984, Zenith Data Systems Corporation
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;

.XLIST
	INCLUDE ASCII.DEF
	INCLUDE DRIVERS.DEF
	INCLUDE FIXED.DEF
	INCLUDE IOCONFIG.DEF
	INCLUDE LOADER.DEF
	INCLUDE MSDOS.DEF
	INCLUDE MACLIB.ASM
	INCLUDE Z150BIOS.DEF
	INCLUDE Z150ROM.DEF
	INCLUDE DEFDSK.ASM
.LIST

BIOS	SEGMENT BYTE PUBLIC 'BIOS'
	ASSUME	CS:BIOS,DS:BIOS,SS:BIOS

	PUBLIC	BUILD_BPB, DRIVE_MAP, MEDIA_CHECK, DSK_TPTR
	PUBLIC	BIOS_DSKFUNC

	EXTRN	NUM_FLOPPY:BYTE
	EXTRN	TIM_PTR:WORD
	EXTRN	DSK_TIMOUT:WORD
	EXTRN	TIM_RESET:NEAR
	EXTRN	FIXED_FLAGS:BYTE
	EXTRN	ERROR1:NEAR
	EXTRN	FIXED_BPBS:BYTE
	EXTRN	SUCESS:NEAR
	EXTRN	FLOPPY_BPBS:BYTE
	EXTRN	RECURLV:WORD
	EXTRN	SP_SAVE:WORD
	EXTRN	SS_SAVE:WORD
	EXTRN	STACK_TOP:WORD
	EXTRN	DSK:NEAR
	EXTRN	ERROR:NEAR
	EXTRN	NUM_DISK:BYTE


	SUBTTL BIOS Disk change status
	PAGE

;*	MEDIA_CHECK - return the disk change status
;		If a floppy 
;		     Check if drive has been accessed within last
;		     2 secs, if so, return no change, else return
;		     don't know.
;		If a fixed disk
;		  1) Check if partition is assigned, if not return
;		     drive not ready else 2)
;		  2) Check formatted flag. If not formatted return drive not ready
;		     else 3)
;		  3) Check for drive changed flag. If not changed then return
;		     disk not changed. If changed flip media byte to ensure
;		     DOS sees different media and return disk changed.
;		     
;	ENTRY:	ES:BX - Pointer to DOS packet
;		DS = CS
;
;	EXIT:	Packet status = Disk change status (-1 disk has changed,
;					  0 don't know,
;					  1 disk has not changed)
;
MEDIA_CHECK PROC NEAR

	MOV	ES:CMC_STAT[BX],CMCS_DKN	; Don't know if disk changed
	MOV	AL,ES:SRH_UNIT[BX]		; Need to check for fixed disk
	CALL	DRIVE_MAP			; Map to Z150 drive number
	JNC	MC0A				; Jump if no error
	JMP	ERROR				; Exit to error handler

MC0A:
	CMP	AL,NUM_FLOPPY
	JAE	MC1				; Yes fixed disk, more processing

	IF	D_2SEC				; Assemble if 2 sec delay chosen

;	See when floppy was last accessed


	CBW
	SHL	AX,1				; Make unit into word pointer
	MOV	DI,AX
	MOV	CS:WORD PTR TIM_PTR,AX		; Store pointer for later use
	MOV	AX,DSK_TIMOUT[DI]		; Get current counter value
	CMP	AX,0				; Has it been too long?
	JNA	MC0				; Yes, return 'don't know'
	INC	ES:BYTE PTR CMC_STAT[BX]	; Flag as not changed
MC0:
	ENDIF
	JMP	TIM_RESET			; Reset timer and exit


;	Find correct fixed BPB

MC1:
	SUB	AL,NUM_FLOPPY			; Base at 0 for index
	CBW
	MOV	DI,AX
	MOV	AL,SRHS_EDNR			; Get ready for drive not ready error
	TEST	FIXED_FLAGS[DI],1 SHL 0		; Is disk assigned?
	JZ	MC2
	TEST	FIXED_FLAGS[DI],1 SHL 1		; Is disk formatted?
	JNZ	MC3
MC2:
	JMP	ERROR1

;	Address the BPB for this drive
MC3:
	MOV	AX,DI
	MOV	AH,TYPE BPB_STRUC
	MUL	AH
	ADD	AX,OFFSET FIXED_BPBS
	MOV	SI,AX

	TEST	FIXED_FLAGS[DI],1 SHL 2		; Is disk changed?
	JNZ	MC4
MC35:
	INC	BYTE PTR ES:CMC_STAT[BX]	; Flag as not changed
	JMP	SUCESS
MC4:
	XOR	BPB_MBYTE[SI],0FFH		; Flip media byte so DOS sees different one
	AND	FIXED_FLAGS[DI],NOT (1 SHL 2)	; Make into a valid BPB
MC5:
	DEC	BYTE PTR ES:CMC_STAT[BX]	; Flag as changed
	JMP	SUCESS

MEDIA_CHECK ENDP


	SUBTTL Build BPB for disk
	PAGE
;**	BUILD_BPB
;	  Return the address of a BPB that describes
;	  the requested unit. If a floppy, index off of media byte
;	  If a fixed disk, index off of unit
;
;	ENTRY:	ES:BX - packet
;		DS - BIOS segment
;
;	EXIT:	Packet has pointer to new BPB
;
BUILD_BPB PROC	NEAR

;	Check for a fixed disk

	MOV	AL,ES:SRH_UNIT[BX]
	CALL	DRIVE_MAP		; Map from Z100 number to Z150 number
	JNC	BBPB0			; Jump if no error
	JMP	ERROR			; Exit

BBPB0:	
	CMP	AL,NUM_FLOPPY
	JAE	BBPB1			; Get BPB for fixed disk

;	Get BPB for floppy disk

	LDS	SI,ES:CBPB_TADDR[BX]	; Get media byte
	LODSB
	PUSH	CS			; Restore data
	POP	DS

	AND	AL,3			; Index based on FAT bits
	MOV	SI,OFFSET FLOPPY_BPBS	; Get address of BPB
	JMP	SHORT BBPB2

;	Get BPB for fixed disk

BBPB1:
	SUB	AL,NUM_FLOPPY
	MOV	SI,OFFSET FIXED_BPBS	; Get address of fixed BPB's
BBPB2:
	MOV	AH,TYPE BPB_STRUC
	MUL	AH
	ADD	AX,SI

	MOV	WORD PTR ES:CBPB_BADDR[BX],AX	; Return offset and segment
	MOV	WORD PTR ES:CBPB_BADDR[BX+2],CS
	CALL	TABLE_UPDT		; Update disk tables
	JMP	SUCESS

BUILD_BPB ENDP

	SUBTTL	Disk I/O
	PAGE

BIOS_DSKFUNC	PROC	FAR
	CLI
	INC	WORD PTR CS:RECURLV	; Bump recursion
	JNZ	BDSK1			; If nested call
	MOV	CS:SP_SAVE,SP		; Save current stack area
	MOV	CS:SS_SAVE,SS
	PUSH	CS
	POP	SS			; Set up local stack
	MOV	SP,OFFSET STACK_TOP	;  area for first level call
BDSK1:
	STI
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	DS
	PUSH	CS
	POP	DS
	CALL	DSK			; Do call
	POP	DS
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	CLI
	DEC	WORD PTR CS:RECURLV	; Leaving last level?
	JNS	BDSK2			; Nope, leave stack
	MOV	SS,CS:SS_SAVE
	MOV	SP,CS:SP_SAVE		; Restore user stack
BDSK2:
	STI
	RET
BIOS_DSKFUNC	ENDP


;	DRIVE_MAP - Map Z100 drive number to Z150 number
;
;	Entry:	AL - Z100 drive number
;
;	Exit:	C set if error
;		   AL - MSDOS error code
;		C clear if OK
;		   AL - Z150 drive number
;

DRIVE_MAP:
	CMP	AL,NUM_FLOPPY		; Is it a floppy?
	JB	DRMP1			; Yes, unit number OK
	CMP	AL,MAX_FLOPPY		; Is it a winchester?
	JB	DRMP2			; No, error
	SUB	AL,MAX_FLOPPY		; Index on 0
	PUSH	AX			; Save unit 
	PUSH	SI
	CBW				; Make into a word
	ADD	AX,OFFSET FIXED_FLAGS	; Point to flag for this unit
	MOV	SI,AX
	MOV	AL,[SI]			; Get flag byte
	AND	AL,03H			; Check if assigned and formatted
	CMP	AL,03H			; Was it?
	POP	SI
	POP	AX
	JNZ	DRMP2			; No,error
	ADD	AL,NUM_FLOPPY		; Index on NUM_FLOPPY
	CMP	AL,NUM_DISK		; Too big?
	JAE	DRMP0			; Yes

;	Z150 unit number is now in AL
DRMP1:
	CLC				; No error
	RET

DRMP0:
;	User attempted to use a non-existant drive

	MOV	AL,SRHS_EUKU		; Get error code
	STC				; Flag error
	RET

DRMP2:
	MOV	AL,SRHS_EDNR			; Show drive not ready
	STC
	RET



;	TABLE_UPDT - Update Disk Tables
;
;	Entry:	CS:AX - Pointer to disk BPB
;		ES:BX - Pointer to DOS request packet
;

TABLE_UPDT:
	PUSH	SI			; Save SI
	PUSH	DX			; Save DX
	MOV	BP,AX			; Load BPB offset into BP
	MOV	AL,ES:SRH_UNIT[BX]	; Get unit number
	CBW				; Make into a word pointer
	SHL	AX,1
	ADD	AX,OFFSET DSK_TPTR	; Offset into Disk pointer table
	MOV	SI,AX
	MOV	SI,[SI]			; Get address of table entry
	
;	At this point, CS:SI points to the disk table entry
;	and CS:CX points to the BPB.

	PUSH	DS
	PUSH	CS
	POP	DS			; Set up DS
	ASSUME	DS:BIOS
	MOV	DL,BYTE PTR BPB_SPT[BP]	; Sectors per track
	MOV	DSK_SPT[SI],DL
	MOV	DX,BPB_SECSZ[BP]	; Bytes per sector
	MOV	DSK_BPS[SI],DX
	MOV	BYTE PTR DSK_FLAG[SI],0	; Assume single sided
	MOV	BYTE PTR DSK_MAXT[SI],40; Assume 40 tracks
	CMP	WORD PTR BPB_HEADS[BP],1; Is it single sided?
	JZ	TU1			; Yes, skip
	MOV	BYTE PTR DSK_MAXT[SI],80; 80 tracks
	INC	BYTE PTR DSK_FLAG[SI]	; Make it double sided
TU1:
	CMP	BYTE PTR ES:SRH_UNIT[BX],MAX_FLOPPY	; Is it a floppy?
	JB	TU2			; Yes, done
	MOV	DX,BPB_HIDDEN[BP]	; Base sector
	MOV	DSK_BSEC[SI],DX
	MOV	DX,BPB_SECS[BP]		; Total number of sectors
	MOV	DSKW_NPS[SI],DX
	MOV	DL,BYTE PTR BPB_FATSECS[BP]	; Size of FAT
	MOV	DSKW_FAT[SI],DL
	MOV	DL,BPB_SPAU[BP]		; Sectors per allocation unit
	MOV	DSKW_SPAU[SI],DL
	MOV	DL,BPB_UNIT[BP]		; Unit number
	MOV	DSKW_WUN[SI],DL
TU2:
	POP	DS
	POP	DX
	POP	SI
	RET



	PAGE
	SUBTTL	Disk Tables
;
;  This table contains pointers to the actual disk
;  tables used by the bios. 
;
;  LAST MODIFIED: 1/20/83 - bcb
;


	DW OFFSET SPDISK ; Special disk (before DSK_TPTR)

DSK_TPTR	LABEL	WORD

	DW	OFFSET DISK0
	DW	OFFSET DISK1

	DW	OFFSET DISK2
	DW	OFFSET DISK3

	DW	OFFSET DISK4
	DW	OFFSET DISK5
	DW	OFFSET DISK6
	DW	OFFSET DISK7
	DW	-1			; Mark end of table

SPDISK	DB	DSK_SIZE DUP(0FFH)	; Initialized to an invalid value

;
;   5.25 inch Unit 0
;

DISK0	LABEL	BYTE
	ERRNZ	DISK0,DSK_STA
	DW	0			; Status
	ERRNZ	DISK0,DSK_TYPE
	DB	DSK_TZ2075		; Z-207 type disk
	ERRNZ	DISK0,DSK_LTRK
	DB	0			; Last track
	ERRNZ	DISK0,DSK_LOPT
	DB	DSK_OUK			; Last operation is unknown
	ERRNZ	DISK0,DSK_FLAG
	DB	DSK_FDS+DSK_FDC+DSK_FSL	; Double sided disk
	ERRNZ	DISK0,DSK_SEL
	DB	0			; Select disk 0, no precomp
	ERRNZ	DISK0,DSK_RS
	DB	DIO_RESET		; Restore(home) command
	ERRNZ	DISK0,DSK_SPHI
	DB	0			; Step in command 
	ERRNZ	DISK0,DSK_FMT
	DB	DIO_FORMAT		; Format(write track) command
	ERRNZ	DISK0,DSK_RD
	DB	DIO_READ		; Read command
	ERRNZ	DISK0,DSK_WR
	DB	DIO_WRITE		; Write command
	ERRNZ	DISK0,DSK_SK
	DB	0			; Seek command
	ERRNZ	DISK0,DSK_SERR
	DW	0			; # of soft errors
	ERRNZ	DISK0,DSK_MAXT
	DB	80			; Number of tracks on disk
	ERRNZ	DISK0,DSK_NRETRY
	DB	1			; Number of retrys
	ERRNZ	DISK0,DSK_SPT
	DB	8			; Sectors per track
	ERRNZ	DISK0,DSK_BPS
	DW	512			; Bytes per sector
	ERRNZ	DISK0,DSK_BPWT
	DW	6437			; Bytes per write track
	ERRNZ	DISK0,DSK_BPRT
	DW	6437			; Bytes per read track
	ERRNZ	DISK0,DSK_DELAY
	DW	400			; 400 instr = 1.5mls
	ERRNZ	DISK0,DSK_LDELAY
	DW	4000			; 4000 instr = 15mls
	ERRNZ	DISK0,DSK_PORT
	DW	0			; Base Port number
	ERRNZ	DISK0,DSK_RDT
	DB	0			; Read track command
	ERRNZ	DISK0,DSK_IMGFLG
	DB	0			; Drive exits
	ERRNZ	DISK0,DSK_TDSEL
	DW	100			; Time to wait before deselect
	ERRNZ	DISK0,DSK_NAME
	DB	'A'			; Drive A:
	ERRNZ	DISK0,DSK_TIMEOUT
	DW	0			; Current timeout
	ERRNZ	DISK0,DSK_SIZE

;
;   5.25 inch Unit 1
;

DISK1	LABEL	BYTE
	ERRNZ	DISK1,DSK_STA
	DW	0			; Status
	ERRNZ	DISK1,DSK_TYPE
	DB	DSK_TZ2075		; Z-207 type disk
	ERRNZ	DISK1,DSK_LTRK
	DB	0			; Last track
	ERRNZ	DISK1,DSK_LOPT
	DB	DSK_OUK			; Last operation is unknown
	ERRNZ	DISK1,DSK_FLAG
	DB	DSK_FDS+DSK_FDC+DSK_FSL	; Double sided disk
	ERRNZ	DISK1,DSK_SEL
	DB	0			; Select disk 0, no precomp
	ERRNZ	DISK1,DSK_RS
	DB	DIO_RESET		; Restore(home) command
	ERRNZ	DISK1,DSK_SPHI
	DB	0			; Step in command 
	ERRNZ	DISK1,DSK_FMT
	DB	DIO_FORMAT		; Format(write track) command
	ERRNZ	DISK1,DSK_RD
	DB	DIO_READ		; Read command
	ERRNZ	DISK1,DSK_WR
	DB	DIO_WRITE		; Write command
	ERRNZ	DISK1,DSK_SK
	DB	0			; Seek command
	ERRNZ	DISK1,DSK_SERR
	DW	0			; # of soft errors
	ERRNZ	DISK1,DSK_MAXT
	DB	80			; Number of tracks on disk
	ERRNZ	DISK1,DSK_NRETRY
	DB	1			; Number of retrys
	ERRNZ	DISK1,DSK_SPT
	DB	8			; Sectors per track
	ERRNZ	DISK1,DSK_BPS
	DW	512			; Bytes per sector
	ERRNZ	DISK1,DSK_BPWT
	DW	6437			; Bytes per write track
	ERRNZ	DISK1,DSK_BPRT
	DW	6437			; Bytes per read track
	ERRNZ	DISK1,DSK_DELAY
	DW	400			; 400 instr = 1.5mls
	ERRNZ	DISK1,DSK_LDELAY
	DW	4000			; 4000 instr = 15mls
	ERRNZ	DISK1,DSK_PORT
	DW	0			; Base Port number
	ERRNZ	DISK1,DSK_RDT
	DB	0			; Read track command
	ERRNZ	DISK1,DSK_IMGFLG
	DB	0			; Drive exits
	ERRNZ	DISK1,DSK_TDSEL
	DW	100			; Time to wait before deselect
	ERRNZ	DISK1,DSK_NAME
	DB	'B'			; Drive B:
	ERRNZ	DISK1,DSK_TIMEOUT
	DW	0			; Current timeout
	ERRNZ	DISK1,DSK_SIZE


;
;   5.25 inch Unit 2
;

DISK2	LABEL	BYTE
	ERRNZ	DISK2,DSK_STA
	DW	0			; Status
	ERRNZ	DISK2,DSK_TYPE
	DB	DSK_TZ2075		; Z-207 type disk
	ERRNZ	DISK2,DSK_LTRK
	DB	0			; Last track
	ERRNZ	DISK2,DSK_LOPT
	DB	DSK_OUK			; Last operation is unknown
	ERRNZ	DISK2,DSK_FLAG
	DB	DSK_FDS+DSK_FDC+DSK_FSL	; Double sided disk
	ERRNZ	DISK2,DSK_SEL
	DB	0			; Select disk 0, no precomp
	ERRNZ	DISK2,DSK_RS
	DB	DIO_RESET		; Restore(home) command
	ERRNZ	DISK2,DSK_SPHI
	DB	0			; Step in command 
	ERRNZ	DISK2,DSK_FMT
	DB	DIO_FORMAT		; Format(write track) command
	ERRNZ	DISK2,DSK_RD
	DB	DIO_READ		; Read command
	ERRNZ	DISK2,DSK_WR
	DB	DIO_WRITE		; Write command
	ERRNZ	DISK2,DSK_SK
	DB	0			; Seek command
	ERRNZ	DISK2,DSK_SERR
	DW	0			; # of soft errors
	ERRNZ	DISK2,DSK_MAXT
	DB	80			; Number of tracks on disk
	ERRNZ	DISK2,DSK_NRETRY
	DB	1			; Number of retrys
	ERRNZ	DISK2,DSK_SPT
	DB	8			; Sectors per track
	ERRNZ	DISK2,DSK_BPS
	DW	512			; Bytes per sector
	ERRNZ	DISK2,DSK_BPWT
	DW	6437			; Bytes per write track
	ERRNZ	DISK2,DSK_BPRT
	DW	6437			; Bytes per read track
	ERRNZ	DISK2,DSK_DELAY
	DW	400			; 400 instr = 1.5mls
	ERRNZ	DISK2,DSK_LDELAY
	DW	4000			; 4000 instr = 15mls
	ERRNZ	DISK2,DSK_PORT
	DW	0			; Base Port number
	ERRNZ	DISK2,DSK_RDT
	DB	0			; Read track command
	ERRNZ	DISK2,DSK_IMGFLG
	DB	0			; Drive exits
	ERRNZ	DISK2,DSK_TDSEL
	DW	100			; Time to wait before deselect
	ERRNZ	DISK2,DSK_NAME
	DB	'C'			; Drive C:
	ERRNZ	DISK2,DSK_TIMEOUT
	DW	0			; Current timeout
	ERRNZ	DISK2,DSK_SIZE


;
;   5.25 inch Unit 3
;

DISK3	LABEL	BYTE
	ERRNZ	DISK3,DSK_STA
	DW	0			; Status
	ERRNZ	DISK3,DSK_TYPE
	DB	DSK_TZ2075		; Z-207 type disk
	ERRNZ	DISK3,DSK_LTRK
	DB	0			; Last track
	ERRNZ	DISK3,DSK_LOPT
	DB	DSK_OUK			; Last operation is unknown
	ERRNZ	DISK3,DSK_FLAG
	DB	DSK_FDS+DSK_FDC+DSK_FSL	; Double sided disk
	ERRNZ	DISK3,DSK_SEL
	DB	0			; Select side 0, no precomp
	ERRNZ	DISK3,DSK_RS
	DB	DIO_RESET		; Restore(home) command
	ERRNZ	DISK3,DSK_SPHI
	DB	0			; Step in command 
	ERRNZ	DISK3,DSK_FMT
	DB	DIO_FORMAT		; Format(write track) command
	ERRNZ	DISK3,DSK_RD
	DB	DIO_READ		; Read command
	ERRNZ	DISK3,DSK_WR
	DB	DIO_WRITE		; Write command
	ERRNZ	DISK3,DSK_SK
	DB	0			; Seek command
	ERRNZ	DISK3,DSK_SERR
	DW	0			; # of soft errors
	ERRNZ	DISK3,DSK_MAXT
	DB	80			; Number of tracks on disk
	ERRNZ	DISK3,DSK_NRETRY
	DB	1			; Number of retrys
	ERRNZ	DISK3,DSK_SPT
	DB	8			; Sectors per track
	ERRNZ	DISK3,DSK_BPS
	DW	512			; Bytes per sector
	ERRNZ	DISK3,DSK_BPWT
	DW	6437			; Bytes per write track
	ERRNZ	DISK3,DSK_BPRT
	DW	6437			; Bytes per read track
	ERRNZ	DISK3,DSK_DELAY
	DW	400			; 400 instr = 1.5mls
	ERRNZ	DISK3,DSK_LDELAY
	DW	4000			; 4000 instr = 15mls
	ERRNZ	DISK3,DSK_PORT
	DW	0			; Base Port number
	ERRNZ	DISK3,DSK_RDT
	DB	0			; Read track command
	ERRNZ	DISK3,DSK_IMGFLG
	DB	0			; Drive exits
	ERRNZ	DISK3,DSK_TDSEL
	DW	100			; Time to wait before deselect
	ERRNZ	DISK3,DSK_NAME
	DB	'D'			; Drive D:
	ERRNZ	DISK3,DSK_TIMEOUT
	DW	0			; Current timeout
	ERRNZ	DISK3,DSK_SIZE



;
;	DISK4 - Winchester unit E:
;

DISK4	LABEL	BYTE
	ERRNZ	DISK4,DSK_STA
	DW	0			; Status
	ERRNZ	DISK4,DSK_TYPE
	DB	DSK_TZ217		; Z-217 type disk
	ERRNZ	DISK4,DSK_LTRK
	DB	0			; Last track
	ERRNZ	DISK4,DSK_LOPT
	DB	DSK_OUK			; Last operation is unknown
	ERRNZ	DISK4,DSK_FLAG
	DB	0			; Flag byte
	ERRNZ	DISK4,DSK_SEL
	DB	0			; Holds flag from superblock
	ERRNZ	DISK4,DSK_RS
	DB	0			; Restore(home) command
	ERRNZ	DISK4,DSK_SPHI
	DB	0			; Step in command 
	ERRNZ	DISK4,DSK_FMT
	DB	0			; Format(write track) command
	ERRNZ	DISK4,DSK_RD
	DB	0			; Read command
	ERRNZ	DISK4,DSK_WR
	DB	0			; Write command
	ERRNZ	DISK4,DSK_SK
	DB	0			; Seek command
	ERRNZ	DISK4,DSK_SERR
	DW	0			; # of soft errors
	ERRNZ	DISK4,DSK_MAXT
	DB	0			; Number of tracks on disk
	ERRNZ	DISK4,DSK_NRETRY
	DB	0			; Number of retrys
	ERRNZ	DISK4,DSK_SPT
	DB	18			; Sectors per track
	ERRNZ	DISK4,DSK_BPS
	DW	512			; Bytes per sector
	ERRNZ	DISK4,DSK_BPWT
	DW	0			; Bytes per write track
	ERRNZ	DISK4,DSK_BPRT
	DW	0			; Bytes per read track
	ERRNZ	DISK4,DSK_DELAY
	DW	400			; 400 instr = 1.5mls
	ERRNZ	DISK4,DSK_LDELAY
	DW	4000			; 4000 instr = 15mls
	ERRNZ	DISK4,DSK_PORT
	DW	0			; Base Port number
	ERRNZ	DISK4,DSK_RDT
	DB	0			; Read track command
	ERRNZ	DISK4,DSK_IMGFLG
	DB	0			; Drive exits but can't be reused
	ERRNZ	DISK4,DSK_TDSEL
	DW	0			; Time to wait before deselect
	ERRNZ	DISK4,DSK_NAME
	DB	'E'			; Drive E:
	ERRNZ	DISK4,DSK_TIMEOUT
	DW	0			; Current timeout
	ERRNZ	DISK4,DSK_SIZE
	ERRNZ	DISK4,DSK_BSEC
	DW	0			; Base partition sector number
	ERRNZ	DISK4,DSKW_NPS
	DW	0			; Number of sectors in partition
	ERRNZ	DISK4,DSKW_FAT
	DB	0			; # sectors/FAT table
	ERRNZ	DISK4,DSKW_SPAU
	DB	4			; Sectors/allocation unit
	ERRNZ	DISK4,DSKW_WUN
	DB	0			; Drive unit number
	ERRNZ	DISK4,DSKW_BSECH
	DB	0			; MSB of sector number
	ERRNZ	DISK4,DSKW_SIZE


;
;	DISK5 - Winchester unit F:
;

DISK5	LABEL	BYTE
	ERRNZ	DISK5,DSK_STA
	DW	0			; Status
	ERRNZ	DISK5,DSK_TYPE
	DB	DSK_TZ217		; Z-217 type disk
	ERRNZ	DISK5,DSK_LTRK
	DB	0			; Last track
	ERRNZ	DISK5,DSK_LOPT
	DB	DSK_OUK			; Last operation is unknown
	ERRNZ	DISK5,DSK_FLAG
	DB	0			; Flag byte
	ERRNZ	DISK5,DSK_SEL
	DB	0			; Holds flag from superblock
	ERRNZ	DISK5,DSK_RS
	DB	0			; Restore(home) command
	ERRNZ	DISK5,DSK_SPHI
	DB	0			; Step in command 
	ERRNZ	DISK5,DSK_FMT
	DB	0			; Format(write track) command
	ERRNZ	DISK5,DSK_RD
	DB	0			; Read command
	ERRNZ	DISK5,DSK_WR
	DB	0			; Write command
	ERRNZ	DISK5,DSK_SK
	DB	0			; Seek command
	ERRNZ	DISK5,DSK_SERR
	DW	0			; # of soft errors
	ERRNZ	DISK5,DSK_MAXT
	DB	0			; Number of tracks on disk
	ERRNZ	DISK5,DSK_NRETRY
	DB	0			; Number of retrys
	ERRNZ	DISK5,DSK_SPT
	DB	18			; Sectors per track
	ERRNZ	DISK5,DSK_BPS
	DW	512			; Bytes per sector
	ERRNZ	DISK5,DSK_BPWT
	DW	0			; Bytes per write track
	ERRNZ	DISK5,DSK_BPRT
	DW	0			; Bytes per read track
	ERRNZ	DISK5,DSK_DELAY
	DW	400			; 400 instr = 1.5mls
	ERRNZ	DISK5,DSK_LDELAY
	DW	4000			; 4000 instr = 15mls
	ERRNZ	DISK5,DSK_PORT
	DW	0			; Base Port number
	ERRNZ	DISK5,DSK_RDT
	DB	0			; Read track command
	ERRNZ	DISK5,DSK_IMGFLG
	DB	0			; Drive exits but can't be reused
	ERRNZ	DISK5,DSK_TDSEL
	DW	0			; Time to wait before deselect
	ERRNZ	DISK5,DSK_NAME
	DB	'F'			; Drive F:
	ERRNZ	DISK5,DSK_TIMEOUT
	DW	0			; Current timeout
	ERRNZ	DISK5,DSK_SIZE
	ERRNZ	DISK5,DSK_BSEC
	DW	0			; Base partition sector number
	ERRNZ	DISK5,DSKW_NPS
	DW	0			; Number of sectors in partition
	ERRNZ	DISK5,DSKW_FAT
	DB	0			; # sectors/FAT table
	ERRNZ	DISK5,DSKW_SPAU
	DB	4			; Sectors/allocation unit
	ERRNZ	DISK5,DSKW_WUN
	DB	0			; Initial drive unit
	ERRNZ	DISK5,DSKW_BSECH
	DB	0			; MSB of sector number
	ERRNZ	DISK5,DSKW_SIZE

;
;	DISK6 - Winchester unit G:
;

DISK6	LABEL	BYTE
	ERRNZ	DISK6,DSK_STA
	DW	0			; Status
	ERRNZ	DISK6,DSK_TYPE
	DB	DSK_TZ217		; Z-217 type disk
	ERRNZ	DISK6,DSK_LTRK
	DB	0			; Last track
	ERRNZ	DISK6,DSK_LOPT
	DB	DSK_OUK			; Last operation is unknown
	ERRNZ	DISK6,DSK_FLAG
	DB	0			; Flag byte
	ERRNZ	DISK6,DSK_SEL
	DB	0			; Holds flag from superblock
	ERRNZ	DISK6,DSK_RS
	DB	0			; Restore(home) command
	ERRNZ	DISK6,DSK_SPHI
	DB	0			; Step in command 
	ERRNZ	DISK6,DSK_FMT
	DB	0			; Format(write track) command
	ERRNZ	DISK6,DSK_RD
	DB	0			; Read command
	ERRNZ	DISK6,DSK_WR
	DB	0			; Write command
	ERRNZ	DISK6,DSK_SK
	DB	0			; Seek command
	ERRNZ	DISK6,DSK_SERR
	DW	0			; # of soft errors
	ERRNZ	DISK6,DSK_MAXT
	DB	0			; Number of tracks on disk
	ERRNZ	DISK6,DSK_NRETRY
	DB	0			; Number of retrys
	ERRNZ	DISK6,DSK_SPT
	DB	18			; Sectors per track
	ERRNZ	DISK6,DSK_BPS
	DW	512			; Bytes per sector
	ERRNZ	DISK6,DSK_BPWT
	DW	0			; Bytes per write track
	ERRNZ	DISK6,DSK_BPRT
	DW	0			; Bytes per read track
	ERRNZ	DISK6,DSK_DELAY
	DW	400			; 400 instr = 1.5mls
	ERRNZ	DISK6,DSK_LDELAY
	DW	4000			; 4000 instr = 15mls
	ERRNZ	DISK6,DSK_PORT
	DW	0			; Base Port number
	ERRNZ	DISK6,DSK_RDT
	DB	0			; Read track command
	ERRNZ	DISK6,DSK_IMGFLG
	DB	0			; Drive exits but can't be reused
	ERRNZ	DISK6,DSK_TDSEL
	DW	0			; Time to wait before deselect
	ERRNZ	DISK6,DSK_NAME
	DB	'G'			; Drive H:
	ERRNZ	DISK6,DSK_TIMEOUT
	DW	0			; Current timeout
	ERRNZ	DISK6,DSK_SIZE
	ERRNZ	DISK6,DSK_BSEC
	DW	0			; Base partition sector number
	ERRNZ	DISK6,DSKW_NPS
	DW	0			; Number of sectors in partition
	ERRNZ	DISK6,DSKW_FAT
	DB	0			; # sectors/FAT table
	ERRNZ	DISK6,DSKW_SPAU
	DB	4			; Sectors/allocation unit
	ERRNZ	DISK6,DSKW_WUN
	DB	0			; Initial drive unit
	ERRNZ	DISK6,DSKW_BSECH
	DB	0			; MSB of sector number
	ERRNZ	DISK6,DSKW_SIZE

;
;	DISK7 - Winchester unit H:
;

DISK7	LABEL	BYTE
	ERRNZ	DISK7,DSK_STA
	DW	0			; Status
	ERRNZ	DISK7,DSK_TYPE
	DB	DSK_TZ217		; Z-217 type disk
	ERRNZ	DISK7,DSK_LTRK
	DB	0			; Last track
	ERRNZ	DISK7,DSK_LOPT
	DB	DSK_OUK			; Last operation is unknown
	ERRNZ	DISK7,DSK_FLAG
	DB	0			; Flag byte
	ERRNZ	DISK7,DSK_SEL
	DB	0			; Holds flag from superblock
	ERRNZ	DISK7,DSK_RS
	DB	0			; Restore(home) command
	ERRNZ	DISK7,DSK_SPHI
	DB	0			; Step in command 
	ERRNZ	DISK7,DSK_FMT
	DB	0			; Format(write track) command
	ERRNZ	DISK7,DSK_RD
	DB	0			; Read command
	ERRNZ	DISK7,DSK_WR
	DB	0			; Write command
	ERRNZ	DISK7,DSK_SK
	DB	0			; Seek command
	ERRNZ	DISK7,DSK_SERR
	DW	0			; # of soft errors
	ERRNZ	DISK7,DSK_MAXT
	DB	0			; Number of tracks on disk
	ERRNZ	DISK7,DSK_NRETRY
	DB	0			; Number of retrys
	ERRNZ	DISK7,DSK_SPT
	DB	18			; Sectors per track
	ERRNZ	DISK7,DSK_BPS
	DW	512			; Bytes per sector
	ERRNZ	DISK7,DSK_BPWT
	DW	0			; Bytes per write track
	ERRNZ	DISK7,DSK_BPRT
	DW	0			; Bytes per read track
	ERRNZ	DISK7,DSK_DELAY
	DW	400			; 400 instr = 1.5mls
	ERRNZ	DISK7,DSK_LDELAY
	DW	4000			; 4000 instr = 15mls
	ERRNZ	DISK7,DSK_PORT
	DW	0			; Base Port number
	ERRNZ	DISK7,DSK_RDT
	DB	0			; Read track command
	ERRNZ	DISK7,DSK_IMGFLG
	DB	0			; Drive exits but can't be reused
	ERRNZ	DISK7,DSK_TDSEL
	DW	0			; Time to wait before deselect
	ERRNZ	DISK7,DSK_NAME
	DB	'H'			; Drive H:
	ERRNZ	DISK7,DSK_TIMEOUT
	DW	0			; Current timeout
	ERRNZ	DISK7,DSK_SIZE
	ERRNZ	DISK7,DSK_BSEC
	DW	0			; Base partition sector number
	ERRNZ	DISK7,DSKW_NPS
	DW	0			; Number of sectors in partition
	ERRNZ	DISK7,DSKW_FAT
	DB	0			; # sectors/FAT table
	ERRNZ	DISK7,DSKW_SPAU
	DB	4			; Sectors/allocation unit
	ERRNZ	DISK7,DSKW_WUN
	DB	0			; Initial drive unit
	ERRNZ	DISK7,DSKW_BSECH
	DB	0			; MSB of sector number
	ERRNZ	DISK7,DSKW_SIZE



BIOS	ENDS
	END
