;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;
; Definitions for Z-207 disk controller board
;

;  PORT DISPLACEMENTS

FDCMD	=	0		;1797 COMMAND REGISTER
FDSTA	=	0		;     STATUS REGISTER
FDTRK	=	1		;     TRACK REGISTER
FDSEC	=	2		;     SECTOR REGISTER
FDDAT	=	3		;     DATA REGISTER
FDCON	=	4		;DISK CONTROL PORT
FDAS	=	5		;AUX STATUS PORT


;  SOME USEFUL DEFINITIONS

FDHOLES	=	2		;NUMBER OF INDEX HOLES FOR DISK TO COME TO SPEED
FDSTEPS	=	10		;NUMBER OF STEPS TO STEP IN
FDHULDM =	3		;HEAD UNLOAD MULTIPLIER
FD5MOM	=	20		;5.25 INCH MOTOR STARTUP MULTIPLIER
FD8NRD	=	1FFFH		;8 INCH MOTOR MAX STARTUP TRYS
FDHLDM	=	4		;HEAD LOAD MULTIPLIER
FDCOML	=	60/4		;TICS BEFORE STATUS CAN BE READ AFTER A COMMAND
FD5IT	=	23		;INSIDE TRACK NUMBER ON 48TPI, 5.25 INCH 



;  COMMANDS
FDCRST	=	000H		;RESTORE
FDCSEK	=	010H		;SEEK
FDCSTP	=	020H		;STEP
FDCSTI	=	040H		;STEP IN
FDCSTO	=	060H		;STEP OUT
FDCRDS	=	080H		;READ SECTOR
FDCWRS	=	0A0H		;WRITE SECTOR
FDCRDA	=	0C0H		;READ ADDRESS
FDCRDT	=	0E0H		;READ TRACK
FDCWRT	=	0F0H		;WRITE TRACK
FDCFI	=	0D0H		;FORCE INTERRUPT

;  TYPE 1 COMMAND FLAGS
FDFUTR	=	00010000B	;UPDATE TRACK REGISTER
FDFHLB	=	00001000B	;HEAD LOAD AT BEGINNING
FDFVRF	=	00000100B	;VERIFY FLAGS

;  TYPE 1 COMMAND STEP RATE FLAGS
FDFS6	=	00000000B	;STEP RATE  6 MS
FDFS12	=	00000001B	;          12
FDFS20	=	00000010B	;          20
FDFS30	=	00000011B	;          30

;  TYPE 2&3 COMMAND FLAGS
FDFMRF	=	00010000B	;MULTIPLE RECORD FLAG
FDFSLF	=	00001000B	;SECTOR LENGTH FLAG
FDFDLF	=	00000100B	;30 MS DELAY
FDFSS1	=	00000010B	;SELECT SIDE 1
FDFDDM	=	00000001B	;DELETED DATA MARK

;  TYPE 4 COMMAND FLAGS
FDFINI	=	00000000B	;TERMINATE WITH NO INTERRUPT
FDFII0	=	00000001B	;NOT READY TO READY TRANSITION
FDFII1	=	00000010B	;READY TO NOT READY TRANSITION
FDFII2	=	00000100B	;INDEX PULSE
FDFII3	=	00001000B	;IMMEDIATE INTERRUPT

;  STATUS FLAGS
FDSNRD	=	10000000B	;NOT READY
FDSWPV	=	01000000B	;WRITE PROTECT VIOLATION
FDSHLD	=	00100000B	;HEAD IS LOADED
FDSRTE	=	00100000B	;RECORD TYPE
FDSWTF	=	00100000B	;WRITE FAULT
FDSSEK	=	00010000B	;SEEK ERROR
FDSRNF	=	00010000B	;RECORD NOT FOUND
FDSCRC	=	00001000B	;CRC ERROR
FDSTK0	=	00000100B	;FOUND TRACK 0
FDSLDT	=	00000100B	;LOST DATA
FDSIND	=	00000010B	;INDEX HOLE
FDSBSY	=	00000001B	;BUSY

;  INFO RETURNED BY A READ ADDRESS COMMAND
FDRATRK	=	0		;TRACK
FDRASID	=	1		;SIDE
FDRASEC	=	2		;SECTOR
FDRASL	=	3		;SECTOR LENGTH
FDRACRC	=	4		;2 BYTE CRC
FDRAL	=	6		;LENGTH OF READ ADDRESS INFO

;  DISK HEADER SECTOR LENGTH VALUES
FDSL128	=	0		;SECTOR LENGTH 128
FDSL256	=	1		;SECTOR LENGTH 256
FDSL512	=	2		;SECTOR LENGTH 512
FDSL1K	=	3		;SECTOR LENGTH 1024

;  CONTROL REGISTER FLAGS
CONDS	=	00000011B	;DRIVE SELECT BITS
CONDS8	=	00000100B	;0=5 1/4" , 1=8"
CONDSEN	=	00001000B	;DRIVE SELECT ENABLE
CONPC	=	00010000B	;WRITE PRE-COMPENSATION
				; 5 1/4"  0=YES , 1=NO
				; 8"  0=ALL TRACKS , 1=TRACKS 44-76
CON5FS	=	00100000B	;5 1/4" FAST STEP
CONWE	=	01000000B	;ENABLE WAIT FOR DRQ OR IRQ
CONSD	=	10000000B	;ENABLE SINGLE DENSITY

;  AUXILARY STATUS REGISTER FLAGS
ASIRQ	=	00000001B	;1797 INTERRUPT R=EST
ASMO	=	00000010B	;5 1/4" MOTOR ON
AS96T	=	00001000B	;5 1/4" DRIVES ARE 96TPI
AS5PC	=	00010000B	;5 1/4" DRIVES NEED WRITE PRE-COMPENSATION
AS2S	=	01000000B	;SELECTED 8" DRIVE CONTAINS 2 SIDED MEDIA
ASDRQ	=	10000000B	;1797 DRQ

