;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;
; Configuration type info
;

Z207A		= 0B0H	; Z-207 disk controller base port
  ; (See DEFZ207 to program controller)
Z217A		= 0AEH	; Z-217 disk controller base port
  ; (See DEFZ217 to program controller)
ZGRNSEG		= 0E000H	; Segment of green video plane
ZREDSEG		= 0D000H	; Segment of red video plane
ZBLUSEG		= 0C000H	; Segment of blue video plane
ZVIDEO		= 0D8H	; Video 68A21 port
  ; PA0 -> enable red display 
  ; PA1 -> enable green display
  ; PA2 -> enable blue display
  ; PA3 -> not flash screen
  ; PA4 -> not write multiple red
  ; PA5 -> not write multiple green
  ; PA6 -> not write multiple blue
  ; PA7 -> disable video RAM
  ; PB7-PB0 -> LA15-LA8
  ; CA1 - not used
  ; CA2 -> clear screen
  ; CB1 - not used
  ; CB2 -> value to write (0 or 1) on clear screen
  ; (see DEF6821 to program the 6821)
ZCRTC		= 0DCH	; Video 6845 CRT-C port
  ; (see DEF6845 to program the 6845)
ZLPEN		= 0DEH	; Light pen latch
  ZLPEN_BIT	  = 00000111B	  ; Bit hit by pen
  ZLPEN_ROW	  = 11110000B	  ; Row hit by pen
ZPIA		= 0E0H	; Parallel printer plus light pen and
                                ;  video vertical retrace 68A21 port
  ; PA0 -> PDATA1
  ; PA1 -> PDATA2
  ; PA2 -> not STROBE
  ; PA3 -> not INIT
  ; PA4 <- VSYNC
  ; PA5 -> clear VSYNC flip flop
  ; PA6 <- light pen switch
  ; PA7 -> clear light pen flip flop
  ; PB0 <- BUSY
  ; PB1 <- not ERROR
  ; PB2 -> PDATA3
  ; PB3 -> PDATA4
  ; PB4 -> PDATA5
  ; PB5 -> PDATA6
  ; PB6 -> PDATA7
  ; PB7 -> PDATA8
  ; CA1 <- light pen hit (from flip flop)
  ; CA2 <- VSYNC (from flip flop)
  ; CB1 <- not ACKNLG
  ; CB2 <- BUSY
  ; (See DEF6821 to program the PIA)
ZTIMER		= 040H	; Timer 8253 port
  ZTIMEVAL	  = 11932     ; 100ms divide by N value
  ; (See DEF8253 to program the 8253)
ZTIMERS		= 0FBH	; Timer interrupt status port
  ZTIMERS0	  = 001H	  ; Timer 0 interrupt
  ZTIMERS2	  = 002H	  ; Timer 2 interrupt
ZSERA		= 03F8H	; First 8250 serial port
ZSERB		= 02F8H	; Second 8250 serial port
  ; (See DEFEP2 to program 2661-2)
ZSERA_INT_MASK	= 10H		; 8259A mask to enable serial A ints
ZSERB_INT_MASK	= 08H		; 8259A mask to enable serial B ints
ZM8259A		= 020H	; Master 8259A interrupt controller port
  ZINTTIM	  = 0		  ; Timer interrupt
  ZINTKD	  = 1		  ; Keyboard interrupt
  ZINTRES	  = 2		  ; Reserved interrupt
  ZINTSA	  = 3		  ; Serial port A interrupt
  ZINTSB	  = 4		  ; Serial port B interrupt
  ZINTDSK	  = 5		  ; Disk interrupt
  ZINTDKT	  = 6		  ; Diskette interrupt
  ZINTPP	  = 7		  ; Parallel port interrupt
  ; (See DEF8259A to program the 8259A)
  ZM8259AI	  = 8		    ; Base interrupt number for master
