;	Copyright(C) 1984, Zenith Data Systems Corporation
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;

	PAGE	,132
	TITLE	BDEVLST - BIOS Device Driver Headers

.XLIST
	INCLUDE ASCII.DEF
	INCLUDE DRIVERS.DEF
	INCLUDE FIXED.DEF
	INCLUDE IOCONFIG.DEF
	INCLUDE LOADER.DEF
	INCLUDE MSDOS.DEF
	INCLUDE MACRO.ASM
	INCLUDE Z150BIOS.DEF
	INCLUDE Z150ROM.DEF
.LIST

	PUBLIC	CON
	PUBLIC	AUX
	PUBLIC	PRN
	PUBLIC	CLOCK
	PUBLIC	DISK
	PUBLIC	LPT1
	PUBLIC	COM1
	PUBLIC	LPT2
	PUBLIC	LPT3
	PUBLIC	NUM_DISK

	EXTRN	CON_STRAT:NEAR
	EXTRN	CON_INT:NEAR
	EXTRN	AUX_STRAT:NEAR
	EXTRN	AUX_INT:NEAR
	EXTRN	PRN_STRAT:NEAR
	EXTRN	PRN_INT:NEAR
	EXTRN	COM1_STRAT:NEAR
	EXTRN	COM1_INT:NEAR
	EXTRN	COM2_STRAT:NEAR
	EXTRN	COM2_INT:NEAR
	EXTRN	LPT1_STRAT:NEAR
	EXTRN	LPT1_INT:NEAR
	EXTRN	LPT2_STRAT:NEAR
	EXTRN	LPT2_INT:NEAR
	EXTRN	LPT3_STRAT:NEAR
	EXTRN	LPT3_INT:NEAR
	EXTRN	CLOCK_STRAT:NEAR
	EXTRN	CLOCK_INT:NEAR
	EXTRN	DISK_STRAT:NEAR
	EXTRN	DISK_INT:NEAR

	PAGE

BIOS	SEGMENT BYTE PUBLIC 'BIOS'
	ASSUME	CS:BIOS,DS:BIOS,SS:BIOS

;	Linked list of device headers. The following devices are
;	defined:
;		"CON" - Console
;		"AUX" - Auxilliary I/O (Same as COM1)
;		"PRN" - Printer device (Same as LPT1)
;		"CLOCK$" - Clock device
;		DISK - Disk driver
;		"COM1" - Serial communication device 1
;		"COM2" - Serial communication device 2
;		"LPT1" - Printer device 1
;		"LPT2" - Printer device 2
;		"LPT3" - Printer device 3
;		
CON	LABEL	BYTE
	DW	OFFSET AUX		; Double word pointer to next header
	DW	BIOS2_SEG
	DW	8013H			; Special device
	DW	OFFSET CON_STRAT	; Address of strategy routine
	DW	OFFSET CON_INT		; Address of interrupt routine
	DB	"CON     "		; Character device name

	ERRNZ	$,<(CON + TYPE DVH_STRUC)>

AUX	LABEL	BYTE
	DW	OFFSET PRN
	DW	BIOS2_SEG
	DW	8000H
	DW	OFFSET AUX_STRAT
	DW	OFFSET AUX_INT
	DB	"AUX     "

	ERRNZ	$,<(AUX + TYPE DVH_STRUC)>

PRN	LABEL	BYTE
	DW	OFFSET CLOCK
	DW	BIOS2_SEG
	DW	8000H
	DW	OFFSET PRN_STRAT
	DW	OFFSET PRN_INT
	DB	"PRN     "

	ERRNZ	$,<(PRN + TYPE DVH_STRUC)>

CLOCK	LABEL	BYTE
	DW	OFFSET DISK
	DW	BIOS2_SEG
	DW	8008H
	DW	OFFSET CLOCK_STRAT
	DW	OFFSET CLOCK_INT
	DB	"CLOCK$  "

	ERRNZ	$,<(CLOCK + TYPE DVH_STRUC)>

DISK	LABEL	BYTE
	DW	OFFSET LPT1
	DW	BIOS2_SEG
	DW	0
	DW	OFFSET DISK_STRAT
	DW	OFFSET DISK_INT
	DB	8 DUP(0)		; Number of units, filled in at boot time

	ERRNZ	$,<(DISK + TYPE DVH_STRUC)>

LPT1	LABEL	BYTE
	DW	OFFSET COM1
	DW	BIOS2_SEG
	DW	8000H
	DW	OFFSET LPT1_STRAT
	DW	OFFSET LPT1_INT
	DB	"LPT1    "

	ERRNZ	$,<(LPT1 + TYPE DVH_STRUC)>


COM1	LABEL	BYTE
	DW	OFFSET LPT2
	DW	BIOS2_SEG
	DW	8000H
	DW	OFFSET COM1_STRAT
	DW	OFFSET COM1_INT
	DB	"COM1    "

	ERRNZ	$,<(COM1 + TYPE DVH_STRUC)>


LPT2	LABEL	BYTE
	DW	OFFSET LPT3
	DW	BIOS2_SEG
	DW	8000H
	DW	OFFSET LPT2_STRAT
	DW	OFFSET LPT2_INT
	DB	"LPT2    "

	ERRNZ	$,<(LPT2 + TYPE DVH_STRUC)>


LPT3	LABEL	BYTE
	DW	-1
	DW	BIOS2_SEG
	DW	8000H
	DW	OFFSET LPT3_STRAT
	DW	OFFSET LPT3_INT
	DB	"LPT3    "

	ERRNZ	$,<(LPT3 + TYPE DVH_STRUC)>



NUM_DISK	DB	0		; Number of drives in system

BIOS	ENDS
	END
