;	Copyright(C) 1984, Zenith Data Systems Corporation
;
;		RESTRICTED RIGHTS LEGEND
;		------------------------
;	
;	    "Use, duplication, or disclosure by the
;	Government is subject to restrictions as set forth
;	in paragraph (b) (3) (B) of the Rights in Technical
;	Data and Computer Software clause in DAR
;	7-104.9(a).  Contractor/manufacturer is Zenith
;	Data Systems Corporation of Hilltop Road, St.
;	Joseph, Michigan 49085.
;
;

.XLIST
	INCLUDE ASCII.DEF
	INCLUDE DRIVERS.DEF
	INCLUDE FIXED.DEF
	INCLUDE IOCONFIG.DEF
	INCLUDE LOADER.DEF
	INCLUDE MSDOS.DEF
	INCLUDE MACRO.ASM
	INCLUDE Z150BIOS.DEF
	INCLUDE Z150ROM.DEF
.LIST

BIOS	SEGMENT BYTE PUBLIC 'BIOS'
	ASSUME	CS:BIOS,DS:BIOS,SS:BIOS

	PUBLIC	CLOCK_READ, CLOCK_WRITE


	EXTRN	BIOS_DATE:WORD
	EXTRN	SUCESS:NEAR


	TITLE	Clock functions
	PAGE
;**	This routine will save the date passed by the system for later use
;
;	ENTRY:	ES:BX - Pointer to DOS packet
;
;	EXIT:	None
;

CLOCK_WRITE PROC NEAR

	LDS	SI,ES:CRW_TADDR[BX]	; Get transfer addr
	MOV	DI,OFFSET BIOS_DATE	; Address of date code
	MOV	AX,CS
	MOV	ES,AX			; DS:SI = from, ES:DI = to
	JMP	SHORT TIM_IO		; Common timer i/o routine


CLOCK_WRITE ENDP

	SUBTTL	BIOS Return date and time function
	PAGE

;**	This routine will return the current date and time.
;
;	ENTRY:	ES:BX - Pointer to DOS packet
;
;	EXIT:	Modified transfer address giving date and time info.

CLOCK_READ	PROC	NEAR

	LES	DI,ES:CRW_TADDR[BX]	; Get transfer addr
	MOV	AX,CS
	MOV	DS,AX			; Set up ES:DI as destination
	MOV	SI,OFFSET BIOS_DATE	; Date address

;	ES:DI points to transfer address, DS:SI points to source

TIM_IO:
	MOV	AX,DS:[SI]		; Get first word
	MOV	ES:[DI],AX		; transfer it

;	The final two values are transfered in reverse byte order

	MOV	AX,DS:[SI+2]		; Get next
	XCHG	AL,AH
	MOV	ES:[DI+2],AX		; Reverse and save
	MOV	AX,DS:[SI+4]
	XCHG	AL,AH
	MOV	ES:[DI+4],AX		; Save next
	JMP	SUCESS


CLOCK_READ	ENDP

BIOS	ENDS
	END
