	TITLE	SCREEN CLOCK FOR Z-100
	PAGE	,132
;	SCRNCLK -- SCREEN CLOCK FOR Z-100
;
;	THIS PROGRAM PROVIDES A SCREEN CLOCK FOR Z-DOS THAT FUNCTIONS
;	LIKE THE HDOS AND CP/M SCREEN CLOCK PRESENTED IN REMARK #22,
;	NOV., 1981.
;
;	THE CLOCK IS TIMED BY THE SYSTEM CLOCK.  THE NUMBERS ARE WRITTEN
;	TO THE SCREEN BY WRITING DIRECTLY TO THE VIDEO RAM, AND CAN BE
;	ANY COLOR (DETERMINED BY THE LABEL "COLOR" BELOW).
;
;	BY P. SWAYNE, HUG  27-FEB-84  31-MAY-85

;	DEFINITIONS
TRUE	EQU	0FFFFH			;DEFINE TRUE
FALSE	EQU	NOT TRUE		;AND FALSE
TBL1	EQU	FALSE			;NORMAL Z-100 NUMBERS
TBL2	EQU	TRUE			;PC-TYPE NUMBERS, UNSLASHED ZERO
TBL3	EQU	FALSE			;SLANTED NUMBERS

WHITE	EQU	0			;VRAM COLOR CONTROL BITS
CYAN	EQU	00010000B
MAGENTA	EQU	00100000B
BLUE	EQU	00110000B
YELLOW	EQU	01000000B
GREEN	EQU	01010000B
RED	EQU	01100000B

COLOR	EQU	WHITE			;CLOCK COLOR

TIMEINT	EQU	51H*4			;Z100 TIMER INTERRUPT VECTOR
SYSINT	EQU	21H*4			;MS-DOS SYSTEM INTERRUPT VECTOR
VRPORT	EQU	0D8H			;VIDEO RAM CONTROL PORT
BRAM	EQU	0C000H			;BLUE VIDEO PLANE SEGMENT
RRAM	EQU	0D000H			;RED VIDEO PLANE SEGMENT
GRAM	EQU	0E000H			;GREEN VIDEO PLANE SEGMENT
	IF	COLOR LE BLUE
VRAM	EQU	BRAM
	ENDIF
	IF	(COLOR GT BLUE) AND (COLOR LE GREEN)
VRAM	EQU	GRAM
	ENDIF
	IF	COLOR EQ RED
VRAM	EQU	RRAM
	ENDIF
BIOSSEG	SEGMENT AT 40H
	ORG	24H
GETDATE	LABEL	FAR			;BIOS GET DATE/TIME FUNC.
BIOSSEG	ENDS

CLK	SEGMENT
	ASSUME	CS:CLK,DS:CLK,ES:CLK,SS:CLK
	ORG	100H

START:	JMP	SETUP			;SET UP CLOCK INTERRUPT, ETC.

;	CLOCK DATA AREA

CLKFLG	DB	1			;CLOCK ON/OFF FLAG
SKFLG	DB	0			;TIMER SKIP FLAG
OLDSEC	DB	0			;OLD SECOND
SYSSTK	DW	0			;SYSTEM STACK
SYSSTKS	DW	0			;SYSTEM STACK SEGMENT
VPVAL	DB	0			;VIDEO CONTROL PORT VALUE
SCRPTR	DW	0			;SCREEN POINTER
HOUR	DW	0			;HOUR
	DB	':'-'0'
MINUTE	DW	0			;MINUTE
	DB	':'-'0'
SECOND	DW	0			;SECOND
	DB	0FFH
	IF	TBL1
NUMTBL	DB	70H,88H,98H,0A8H,0C8H,88H,70H,0	;BITS FOR ZERO
	DB	20H,60H,20H,20H,20H,20H,70H,0	;ONE
	DB	70H,88H,8,10H,20H,40H,0F8H,0	;TWO
	DB	0F8H,10H,20H,10H,8,88H,70H,0	;THREE
	DB	10H,30H,50H,90H,0F8H,10H,10H,0	;FOUR
	DB	0F8H,80H,0F8H,8,8,88H,70H,0	;FIVE
	DB	30H,40H,80H,0F0H,88H,88H,70H,0	;SIX
	DB	0F8H,8,10H,20H,40H,40H,40H,0	;SEVEN
	DB	70H,88H,88H,70H,88H,88H,70H,0	;EIGHT
	DB	70H,88H,88H,78H,8,10H,60H,0	;NINE
	DB	0,30H,30H,0,30H,30H,0,0		;COLON
	ENDIF
	IF	TBL2
NUMTBL	DB	01111000B	;ZERO
	DB	11001100B
	DB	11001100B
	DB	11001100B
	DB	11001100B
	DB	11001100B
	DB	01111000B
	DB	0
	DB	00011000B	;ONE
	DB	00111000B
	DB	00011000B
	DB	00011000B
	DB	00011000B
	DB	00011000B
	DB	00111100B
	DB	0
	DB	00111000B	;TWO
	DB	01101100B
	DB	00001100B
	DB	00011000B
	DB	00110000B
	DB	01100100B
	DB	01111100B
	DB	0
	DB	01111000B	;THREE
	DB	11001100B
	DB	00001100B
	DB	00111000B
	DB	00001100B
	DB	11001100B
	DB	01111000B
	DB	0
	DB	00011100B	;FOUR
	DB	00111100B
	DB	01101100B
	DB	11001100B
	DB	11111110B
	DB	00001100B
	DB	00011110B
	DB	0
	DB	11111100B	;FIVE
	DB	11000000B
	DB	11111000B
	DB	00001100B
	DB	00001100B
	DB	11001100B
	DB	01111000B
	DB	0
	DB	00111000B	;SIX
	DB	01100000B
	DB	11000000B
	DB	11111000B
	DB	11001100B
	DB	11001100B
	DB	01111000B
	DB	0
	DB	11111110B	;SEVEN
	DB	10000110B
	DB	00001100B
	DB	00011000B
	DB	00110000B
	DB	00110000B
	DB	00110000B
	DB	0
	DB	01111000B	;EIGHT
	DB	11001100B
	DB	11001100B
	DB	01111000B
	DB	11001100B
	DB	11001100B
	DB	01111000B
	DB	0
	DB	01111000B	;NINE 9
	DB	11001100B
	DB	11001100B
	DB	01111100B
	DB	00001100B
	DB	00011000B
	DB	01110000B
	DB	0
	DB	00000000B	;COLON
	DB	00110000B
	DB	00110000B
	DB	00000000B
	DB	00110000B
	DB	00110000B
	DB	00000000B
	DB	0
	ENDIF
	IF	TBL3
NUMTBL	DB	00000000B	;ZERO
	DB	00011111B
	DB	00110011B
	DB	01100110B
	DB	11001100B
	DB	11111000B
	DB	0
	DB	0
	DB	00000000B	;ONE
	DB	00000011B
	DB	00000110B
	DB	00001100B
	DB	00011000B
	DB	00110000B
	DB	0
	DB	0
	DB	00000000B	;TWO
	DB	00011111B
	DB	00000011B
	DB	01111110B
	DB	11000000B
	DB	11111000B
	DB	0
	DB	0
	DB	00000000B	;THREE
	DB	00011111B
	DB	00000011B
	DB	01111110B
	DB	00001100B
	DB	11111000B
	DB	0
	DB	0
	DB	00000000B	;FOUR
	DB	00110011B
	DB	01100110B
	DB	01111100B
	DB	00011000B
	DB	00110000B
	DB	0
	DB	0
	DB	00000000B	;FIVE
	DB	00011111B
	DB	00110000B
	DB	01111110B
	DB	00001100B
	DB	11111000B
	DB	0
	DB	0
	DB	00000000B	;SIX
	DB	00011111B
	DB	00110000B
	DB	01111110B
	DB	11001100B
	DB	11111000B
	DB	0
	DB	0
	DB	00000000B	;SEVEN
	DB	00011111B
	DB	00000011B
	DB	00000110B
	DB	00001100B
	DB	00011000B
	DB	0
	DB	0
	DB	00000000B	;EIGHT
	DB	00011111B
	DB	00110011B
	DB	01111110B
	DB	11001100B
	DB	11111000B
	DB	0
	DB	0
	DB	00000000B	;NINE
	DB	00011111B
	DB	00110011B
	DB	01111110B
	DB	00001100B
	DB	11111000B
	DB	0
	DB	0
	DB	00000000B	;COLON
	DB	00000110B
	DB	00001100B
	DB	00000000B
	DB	00110000B
	DB	01100000B
	DB	0
	DB	0
	ENDIF

JMPF	MACRO
	DB	0EAH			;DEFINE FAR JUMP
	ENDM

;	PROCESS CLOCK INTERRUPTS HERE

	DB	'CK'			;IDENTIFIER
MYTIME:	PUSH	AX
	CMP	CS:CLKFLG,0		;CLOCK ENABLED?
	JZ	TIMEXIT			;IF NOT, EXIT
	MOV	AL,CS:SKFLG		;GET SKIP FLAG
	INC	AL			;ADD 1
	AND	AL,7			;COUNT IS MOD 8
	MOV	CS:SKFLG,AL
	JNZ	TIMEXIT			;NOT TIME TO CHECK TIME
	MOV	CS:SYSSTK,SP		;ELSE, SAVE SYSTEM STACK
	MOV	CS:SYSSTKS,SS		;SAVE SYSTEM STACK SEGMENT
	MOV	AX,CS
	MOV	SS,AX			;PUT STACK SEGMENT HERE
	MOV	SP,OFFSET START		;SET LOCAL STACK
	PUSH	CX			;SAVE REGISTERS
	PUSH	DX
	CALL	GETDATE			;ELSE, GET TIME FROM BIOS
	CMP	DH,CS:OLDSEC		;HAS SECOND CHANGED?
	JNZ	UPDATE			;IF SO, UPDATE CLOCK
PEXIT:	POP	DX			;ELSE, RESTORE REGISTERS
	POP	CX
	MOV	SS,CS:SYSSTKS		;RESTORE SYSTEM STACK
	MOV	SP,CS:SYSSTK
TIMEXIT:POP	AX
	JMPF				;JUMP TO SYSTEM
TIMADR	DW	0,0			;SYSTEM TIMER ADDRES GOES HERE
UPDATE:	PUSH	BX			;SAVE SOME REGISTERS
	PUSH	SI
	PUSH	DI
	PUSH	DS
	PUSH	ES
	PUSH	CS
	POP	DS			;PUT DS HERE
	MOV	OLDSEC,DH		;UPDATE OLD SECOND

;	A SECOND HAS PASSED, PRINT TIME ON THE SCREEN

PTIME:	CLD				;ENSURE FORWARD DIRECTION
	MOV	AL,CH			;GET HOURS
	CALL	CONBCD			;CONVERT TO BCD
	MOV	HOUR,AX			;RESULT TO BUFFER
	MOV	AL,CL			;GET MINUTES
	CALL	CONBCD			;CONVERT TO BCD
	MOV	MINUTE,AX		;RESULT TO BUFFER
	MOV	AL,DH			;GET SECONDS
	CALL	CONBCD			;CONVERT TO BCD
	MOV	SECOND,AX		;RESULT TO BUFFER
	IN	AL,VRPORT		;READ VIDEO RAM PORT
	MOV	VPVAL,AL		;SAVE IT
	AND	AL,0FH			;STRIP VRAM CONTROL BITS
	OUT	VRPORT,AL		;ENABLE VIDEO RAM
	MOV	AX,OFFSET VRAM
	MOV	ES,AX			;POINT ES AT VIDEO RAM
	XOR	AL,AL			;GET A ZERO
	MOV	DI,47H			;SET A VRAM POINTER
	MOV	CX,9			;SET A COUNTER
	MOV	DL,CL			;AND ANOTHER ONE
CLRLP:	PUSH	CX			;SAVE COUNTER
	REP	STOSB			;CLEAR A LINE OF VIDEO RAM
	ADD	DI,80H-9		;MOVE TO NEXT LINE
	POP	CX			;RESTORE COUNTER
	DEC	DL
	JNZ	CLRLP			;LOOP UNTIL 9 LINES CLEARED
	IN	AL,VRPORT		;GET VIDEO PORT VALUE
	OR	AL,COLOR		;SET CLOCK COLOR
	OUT	VRPORT,AL		;SET UP COLOR
	MOV	SCRPTR,48H		;INITIALIZE SCREEN POINTER
	MOV	BX,OFFSET HOUR		;POINT TO TIME STRING
	MOV	DL,8			;SET A COUNTER
	XOR	AH,AH			;GET ZERO IN AH
	PUSH	BP			;SAVE BP
	MOV	BP,7FH			;GET ADDITION CONSTANT
PTMLP:	MOV	AL,[BX]			;GET A DIGIT
	INC	BX			;INCREMENT POINTER
	MOV	CL,3
	SHL	AL,CL			;MULTIPLY RAW NO. BY 8
	MOV	SI,OFFSET NUMTBL	;POINT TO NUMBER TABLE
	ADD	SI,AX			;POINT TO NUMBER DESIRED
	CALL	PDIGIT			;PRINT IT
	DEC	DL			;DONE?
	JNZ	PTMLP			;LOOP UNTIL DONE
PDONE:	MOV	AL,VPVAL		;GET VIDEO PORT VALUE
	OUT	VRPORT,AL		;RESET VIDEO CONDITION
	POP	BP
	POP	ES			;RESTORE REGISTERS
	POP	DS
	POP	DI
	POP	SI
	POP	BX
	JMP	PEXIT			;AND EXIT

;	CONVERT NUMBER IN AL TO BCD DIGITS IN AL, AH

CONBCD:	MOV	AH,0			;CLEAR AH
	MOV	BH,10			;GET RADIX
	DIV	BH			;DIVIDE BY IT
	RET

;	PLACE A DIGIT IN VIDEO RAM

PDIGIT:	MOV	CX,7			;SET A COUNTER (7 LINES/DIGIT)
	MOV	DI,SCRPTR		;GET SCREEN POINTER
PDIGLP:	MOVSB				;MOVE A BYTE TO VRAM
	ADD	DI,BP			;UPDATE VRAM POINTER
	LOOP	PDIGLP			;LOOP UNTIL DONE
	INC	SCRPTR			;UPDATE SCREEN POINTER
	RET

;	LOCAL SYSTEM INTERRUPT PROCESSOR

MYSYS:	CMP	AH,0F2H			;CLOCK PROCESS CODE?
	JZ	CLKSYS			;YES
	JMPF				;ELSE, EXIT
SYSADR	DW	0,0
CLKSYS:	OR	AL,AL			;KILL CLOCK?
	JNZ	SETCLK			;NO, SET IT
	MOV	CS:CLKFLG,0		;DISABLE CLOCK
	IRET
SETCLK:	MOV	CS:CLKFLG,1		;ENABLE CLOCK
	IRET

ENDRES:					;END OF RESIDENT CODE

;	SET UP CLOCK AND EXIT WITH PROGRAM RESIDENT

SETUP:	PUSH	DS			;SAVE DS
	XOR	AX,AX
	MOV	DS,AX			;DS AT 0
	MOV	SI,OFFSET TIMEINT	;POINT TO TIMER INTERRUPT
	LES	DI,DWORD PTR [SI]	;GET VECTOR IN ES:DI
	CMP	WORD PTR ES:-2[DI],'KC'	;CLOCK ALREADY IN?
	JZ	ITSIN			;YES
	CLI				;ELSE, TURN OFF INTERRUPTS
	MOV	WORD PTR [SI],OFFSET MYTIME	;PUT IN MY VECTOR
	MOV	2[SI],CS		;AND THIS SEGMENT
	POP	DS			;RESTORE DS
	MOV	WORD PTR TIMADR,DI	;PUT OLD VECTOR AT OUR EXIT
	MOV	WORD PTR TIMADR+2,ES
	STI
	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX			;DS AT 0
	MOV	SI,OFFSET SYSINT	;POINT TO SYSTEM INTERRUPT
	LES	DI,DWORD PTR [SI]	;GET VECTOR
	MOV	WORD PTR [SI],OFFSET MYSYS	;PUT IN MY VECTOR
	MOV	2[SI],CS
	POP	DS
	MOV	WORD PTR SYSADR,DI	;PUT OLD VECTOR HERE
	MOV	WORD PTR SYSADR+2,ES
	MOV	DX,OFFSET ENDRES	;POINT TO END OF RES. CODE
	INT	27H			;EXIT, LEAVE PROGRAM HERE
ITSIN:	INT	20H			;EXIT, NOTHING DONE
CLK	ENDS
	END	START
                                                                                                              