	TITLE	SCREEN CLOCK FOR MS-DOS
	PAGE	,132
;	SCRNCLK -- SCREEN CLOCK FOR MS-DOS (Z-150 OR IBM)
;
;	THIS PROGRAM PROVIDES A SCREEN CLOCK FOR MS-DOS THAT FUNCTIONS
;	LIKE THE HDOS AND CP/M SCREEN CLOCK PRESENTED IN REMARK #22,
;	NOV., 1981.
;
;	THE CLOCK IS TIMED INTERNALLY DUE TO THE INABILITY TO ACCESS THE
;	SYSTEM TIME FROM THE BIOS.  IT CAN BE SET TO THE SYSTEM TIME WITH
;	THE COMPANION PROGRAM "CLOCK".  THE COLOR OF THE DISPLAYED CLOCK
;	IS DETERMINED BY THE LABEL "COLOR", BELOW.  IF YOU ARE IN A B/W
;	MODE, THE COLOR IS AUTOMATICALLY SET TO WHITE.
;
;	BY P. SWAYNE, HUG  22-MAY-84  25-APR-85

;	DEFINITIONS

BLUE	EQU	001B			;COLOR CONTROL BITS
GREEN	EQU	010B
CYAN	EQU	011B
RED	EQU	100B
MAGENTA	EQU	101B
YELLOW	EQU	110B			;(IBM CALLS IT BROWN)
WHITE	EQU	111B

COLOR	EQU	GREEN			;CLOCK COLOR

ROW	EQU	0			;PUT CLOCK ON TOP ROW

CALFAC	EQU	89			;CALIBRATION FACTOR

SCRINT	EQU	10H			;SCREEN CONTROL INTERRUPT
SCP	EQU	2			;SET CURSOR POSITION
GCP	EQU	3			;GET CURSOR POSITION
WCHAR	EQU	9			;WRITE CHARACTER
GVS	EQU	15			;GET VIDEO STATE
TIMEINT	EQU	1CH*4			;Z-150 TIMER INTERRUPT VECTOR
SYSINT	EQU	21H*4			;MS-DOS SYSTEM INTERRUPT

JMPF	MACRO
	DB	0EAH			;DEFINE FAR JUMP
	ENDM

CLK	SEGMENT
	ASSUME	CS:CLK,DS:CLK,ES:CLK,SS:CLK
	ORG	100H

START:	JMP	SETUP			;SET UP CLOCK INTERRUPT, ETC.

;	CLOCK DATA AREA

CLKFLG	DB	1			;CLOCK ON/OFF FLAG
SEC	DB	0			;SECOND (BINARY)
MIN	DB	0			;MINUTE
HOU	DB	0			;HOUR
TICCNT	DB	18			;TIC COUNTER
SECCNT	DB	0			;SECOND COUNTER (FOR CALIBRATION)
SYSSTK	DW	0			;SYSTEM STACK
SYSSTKS	DW	0			;SYSTEM STACK SEGMENT
CPOS	DW	0			;CURSOR POSITION
CMODE	DB	0			;CURRENT VIDEO MODE
MODES	DB	0,1,2,3,1,0,2,2		;DECODED MODES
TIMSTR	DB	' '			;SPACE BEFORE TIME
HOUR	DW	0			;HOUR (ASCII)
	DB	':'
MINUTE	DW	0			;MINUTE
	DB	':'
SECOND	DW	0			;SECOND
	DB	0FFH

;	PROCESS CLOCK INTERRUPTS HERE

	DB	'CK'			;IDENTIFIER
MYTIME:	PUSH	AX
	DEC	CS:TICCNT		;DECREMENT TIC COUNTER
	JNZ	TIMEXIT			;NOT TIMED OUT
	MOV	CS:TICCNT,18		;ELSE, RESET TIC COUNTER
	MOV	AL,CS:SECCNT		;GET SECOND COUNTER
	INC	AL			;ADD ONE
	CMP	AL,CALFAC		;REACHED CALIBRATION FACTOR?
	MOV	CS:SECCNT,AL		;UPDATE COUNTER
	JNZ	NOTCAL			;CAL FACTOR NOT REACHED
	MOV	CS:SECCNT,0		;ELSE, ZERO COUNTER
	JMP	SHORT TIMEXIT		;AND EXIT
NOTCAL:	MOV	AL,CS:SEC		;GET SECONDS
	INC	AL			;ADD ONE
	CMP	AL,60			;60 SECONDS?
	MOV	CS:SEC,AL		;RESET SECONDS
	JNZ	CHKFLG			;NOT A MINUTE, CHECK FLAG
	MOV	CS:SEC,0		;ELSE, ZERO SECONDS
	MOV	AL,CS:MIN		;GET MINUTES
	INC	AL			;ADD ONE
	CMP	AL,60			;60 MINUTES?
	MOV	CS:MIN,AL		;RESET MINUTES
	JNZ	CHKFLG			;NOT AN HOUR
	MOV	CS:MIN,0		;ELSE, ZERO MINUTES
	MOV	AL,CS:HOU		;GET HOUR
	INC	AL
	CMP	AL,24			;24 HOURS?
	MOV	CS:HOU,AL		;RESET HOUR
	JNZ	CHKFLG			;NOT A DAY
	MOV	CS:HOU,0		;ELSE, ZERO HOUR
CHKFLG:	CMP	CS:CLKFLG,0		;CLOCK ENABLED?
	JNZ	UPDATE			;IF SO, UPDATE SCREEN CLOCK
TIMEXIT:POP	AX
TIMEX:	JMPF				;FAR JUMP INSTRUCTION
TIMADR	DW	0,0			;SYSTEM TIMER ADDRES GOES HERE

;	A SECOND HAS PASSED, PRINT TIME ON THE SCREEN

UPDATE:	MOV	CS:CLKFLG,0		;DISABLE OTHER CLOCK INTERRUPTS
	MOV	CS:SYSSTK,SP		;ELSE, SAVE SYSTEM STACK
	MOV	CS:SYSSTKS,SS		;SAVE SYSTEM STACK SEGMENT
	CLI				;KILL INTERRUPTS (ON AT ENTRY)
	MOV	AX,CS
	MOV	SS,AX			;PUT STACK SEGMENT HERE
	MOV	SP,OFFSET START		;SET LOCAL STACK
	STI
	PUSH	BX			;SAVE REGISTERS
	PUSH	CX
	PUSH	DX
	PUSH	SI
	PUSH	DI
	PUSH	DS
	PUSH	ES
	PUSH	BP
	MOV	AX,CS
	MOV	DS,AX			;PUT DS HERE
PTIME:	CLD				;ENSURE FORWARD DIRECTION
	MOV	AL,HOU			;GET HOURS
	CALL	CONASC			;CONVERT TO ASCII
	MOV	HOUR,AX			;RESULT TO BUFFER
	MOV	AL,MIN			;GET MINUTES
	CALL	CONASC			;CONVERT TO ASCII
	MOV	MINUTE,AX		;RESULT TO BUFFER
	MOV	AL,SEC			;GET SECONDS
	CALL	CONASC			;CONVERT TO ASCII
	MOV	SECOND,AX		;RESULT TO BUFFER
	MOV	AH,GVS
	INT	SCRINT			;GET VIDEO STATE
	PUSH	BX			;SAVE PAGE
	MOV	BX,OFFSET MODES		;POINT TO VIDEO MODES
	XLAT				;GET MODE CODE
	MOV	CMODE,AL		;SAVE DECODED MODE
	POP	BX			;GET PAGE
	MOV	AH,GCP
	INT	SCRINT			;GET CURSOR POSITION
	MOV	CPOS,DX			;SAVE IT
	MOV	DH,ROW			;GET ROW FOR CLOCK
	MOV	DL,31			;ASSUME COLUMN 31
	CMP	BYTE PTR CMODE,2	;80 COLUMN MODE
	JB	PTIME0			;NO
	MOV	DL,71			;ELSE, SET COLUMN 71
PTIME0:	MOV	AH,SCP
	INT	SCRINT			;SET CURSOR TO TIME AREA
	MOV	CX,9			;SET A COUNTER
	MOV	BL,WHITE		;ASSUME WHITE COLOR
	CMP	BYTE PTR CMODE,0	;40 COL B/W?
	JZ	PTIME1			;YES
	CMP	BYTE PTR CMODE,2	;80 COL B/W?
	JZ	PTIME1
	MOV	BL,COLOR		;ELSE, USE COLOR
PTIME1:	MOV	SI,OFFSET TIMSTR	;POINT TO TIME STRING
PTMLP:	LODSB				;GET A DIGIT
	PUSH	CX			;SAVE COUNTER
	PUSH	SI			;SAVE POINTER
	CALL	PDIGIT			;PRINT DIGIT
	POP	SI
	POP	CX
	LOOP	PTMLP			;LOOP UNTIL DONE
PDONE:	MOV	AH,SCP
	MOV	DX,CPOS
	INT	SCRINT			;RESTORE CUSOR TO USER'S POSITION
	POP	BP
	POP	ES
	POP	DS			;RESTORE REGISTERS
	POP	DI
	POP	SI
	POP	DX
	POP	CX
	POP	BX
	CLI
	MOV	SS,CS:SYSSTKS		;RESTORE SYSTEM STACK
	MOV	SP,CS:SYSSTK
	STI
	MOV	CS:CLKFLG,1		;RE-ENABLE CLOCK
	JMP	TIMEXIT			;AND EXIT

;	CONVERT NUMBER IN AL TO ASCII DIGITS IN AL, AH

CONASC:	MOV	AH,0			;CLEAR AH
	MOV	BH,10			;GET RADIX
	DIV	BH			;DIVIDE BY IT
	ADD	AX,'00'			;ADD ASCII
	RET

;	PRINT A DIGIT ON THE SCREEN

PDIGIT:	MOV	AH,WCHAR
	MOV	CX,1
	INT	SCRINT			;WRITE CHARACTER
	MOV	AH,GCP
	INT	SCRINT			;GET CURSOR POSITION
	INC	DL			;MOV IT OVER
	MOV	AH,SCP
	INT	SCRINT			;SET NEW CURSOR POSITION
	RET

;	LOCAL SYSTEM INTERRUPT PROCESSOR

MYSYS:	CMP	AH,0F0H			;CLOCK PROCESS CODE?
	JZ	CLKSYS			;YES
	JMPF				;ELSE, EXIT
SYSADR	DW	0,0
CLKSYS:	OR	AL,AL			;KILL CLOCK?
	JNZ	SETCLK			;NO, SET IT
	MOV	CS:CLKFLG,0		;DISABLE CLOCK
	IRET
SETCLK:	MOV	CS:CLKFLG,1		;ENABLE CLOCK
	MOV	CS:WORD PTR MIN,CX	;SET MINUTE, HOUR
	MOV	CS:SEC,DH		;AND SECOND
	MOV	CS:TICCNT,18		;SET TIC COUNTER
	IRET

LEND:					;END OF RESIDENT CODE

;	SET UP CLOCK VECTOR AND INITIALIZE TIME
;	THEN EXIT WITH PROGRAM RESIDENT

SETUP:	MOV	AH,2CH
	INT	21H			;GET TIME
	MOV	SEC,DH			;SAVE SECOND
WFSEC:	MOV	AH,2CH
	INT	21H			;GET TIME AGAIN
	CMP	SEC,DH			;SAME SECOND?
	JZ	WFSEC			;WAIT FOR NEW SECOND
	MOV	SEC,DH			;SET SECONDS
	MOV	WORD PTR MIN,CX		;SET MINUTES, HOURS
	PUSH	DS			;SAVE DS
	XOR	AX,AX
	MOV	DS,AX			;DS AT 0
	MOV	SI,OFFSET TIMEINT	;POINT TO TIMER INTERRUPT
	LES	DI,DWORD PTR [SI]	;GET VECTOR IN ES:DI
	CMP	WORD PTR ES:-2[DI],'KC'	;CLOCK ALREADY IN?
	JZ	ITSIN			;YES
	CLI				;ELSE, TURN OFF INTERRUPTS
	MOV	WORD PTR [SI],OFFSET MYTIME	;PUT IN MY VECTOR
	MOV	2[SI],CS		;AND THIS SEGMENT
	POP	DS			;RESTORE DS
	MOV	WORD PTR TIMADR,DI	;PUT OLD VECTOR AT OUR EXIT
	MOV	WORD PTR TIMADR+2,ES
	STI
	PUSH	DS
	XOR	AX,AX
	MOV	DS,AX			;DS AT 0
	MOV	SI,OFFSET SYSINT	;POINT TO SYSTEM INTERRUPT
	LES	DI,DWORD PTR [SI]	;GET VECTOR
	MOV	WORD PTR [SI],OFFSET MYSYS	;PUT IN MY VECTOR
	MOV	2[SI],CS
	POP	DS
	MOV	WORD PTR SYSADR,DI	;PUT OLD VECTOR HERE
	MOV	WORD PTR SYSADR+2,ES
	MOV	DX,OFFSET LEND		;POINT TO END OF RES. CODE
	INT	27H			;EXIT, LEAVE PROGRAM HERE
ITSIN:	INT	20H			;EXIT, NOTHING DONE
CLK	ENDS
	END	START
                                                                                                                   