	PAGE	,132
	TITLE	BASICA PRINT PATCHER
;	BASPATCH -- BASICA PRINT PATCHER
;
;	THIS PROGRAM PATCHES BASICA SO THAT THE LLIST AND LPRINT
;	COMMANDS WILL OUTPUT THROUGH THE DOS, INSTEAD OF GOING
;	DIRECTLY TO THE BIOS.  PRINTING VIA "PRN" AS A DEVICE
;	WILL STILL BYPASS THE DOS.
;
;	BY P. SWAYNE, HUG  20-MAY-85

;	DEFINITIONS

BASADR	EQU	38FDH-800H		;BASIC PATCH AREA
PCHSIZ	EQU	67D8H			;PATCH AREA SIZE
OPENF	EQU	0FH			;OPEN FILE
CLOSEF	EQU	10H			;CLOSE FILE
SETDTA	EQU	1AH			;SET DTA ADDRESS
READF	EQU	27H			;READ FILE (RANDOM BLK.)
WRITEF	EQU	28H			;WRITE FILE (RANDOM BLOCK)

CODE	SEGMENT
	ASSUME  CS:CODE,DS:CODE,ES:CODE,SS:CODE
	ORG     5CH
FCB	LABEL   BYTE                    ;DEFAULT FCB ADDRESS
	ORG     100H

START:  MOV     DX,OFFSET SIGNON
	MOV     AH,9
	INT     21H                     ;PRINT SIGNON
	CMP     BYTE PTR FCB+1,' '      ;TEST FOR ARGUMENT
	JNZ     GOTARG                  ;GOT ONE
	MOV     DX,OFFSET EXPL
	MOV     AH,9
	INT     21H                     ;ELSE, EXPLAIN PROGRAM
	INT     20H
GOTARG: MOV     DI,OFFSET FCB+32        ;POINT TO RECORD COUNTERS
	XOR     AX,AX
	CLD
	MOV	CX,3
	REP	STOSW			;CLEAR RECORD COUNTERS
	MOV	DX,OFFSET FCB
	MOV	AH,OPENF
	INT	21H			;OPEN FILE
	INC	AL
	JNZ	OPENED			;OPEN OK
FILERR:	MOV	DX,OFFSET NOFILE
	MOV	AH,9
	INT	21H			;ELSE, SAY "NO FILE"
	INT	20H
OPENED:	MOV	WORD PTR FCB+14,1	;SET RECORD SIZE TO 1
	MOV	DX,OFFSET BUFFER
	MOV	AH,SETDTA
	INT	21H			;SET DTA TO BUFFER
	MOV	WORD PTR FCB+33,BASADR	;START READING FILE HERE
	MOV	CX,PCHSIZ		;COUNT OF BYTES TO READ
	MOV	DX,OFFSET FCB
	MOV	AH,READF
	INT	21H			;READ FROM FILE
	OR	AL,AL
	JNZ	FILERR			;FILE ERROR
	MOV	AL,0CDH			;GET "INT" CODE
	MOV	DI,OFFSET BUFFER
	MOV	CX,PCHSIZ		;SEARCH ENTIRE PATCH AREA
SEARCH1:REPNZ	SCASB			;SEARCH FOR "INT"
	JNZ	NOT1			;NOT FOUND
	CMP	BYTE PTR [DI],17H	;INT 17H?
	JNZ	SEARCH1			;NO, KEEP LOOKING
	CMP	BYTE PTR 1[DI],8AH	;VERIFY PATCH
	JNZ	NOT1			;NOT HERE
	MOV	SI,OFFSET PATCH1	;ELSE, POINT TO PATCH 1
	JMP	PATCH			;MAKE THE PATCH
NOT1:	MOV	AL,9AH			;GET "CALLF" CODE
	MOV	DI,OFFSET BUFFER
	MOV	CX,OFFSET PCHSIZ
	MOV	SI,OFFSET PATCH2	;ASSUME PATCH2 WILL BE FOUND
SEARCH2:REPNZ	SCASB			;SEARCH FOR "CALLF"
	JNZ	NOPCH			;NO PATCH TO DO
	CMP	BYTE PTR [DI],4BH	;CALL TO PRNFUNC?
	JNZ	SEARCH2			;NO, KEEP LOOKING
	CMP	WORD PTR 1[DI],4000H	;VERIFY PATCH
	JZ	PATCH			;THIS IS IT
NOPCH:	MOV	DX,OFFSET NPMSG
	MOV	AH,9
	INT	21H			;ELSE, SAY "NO PATCH DONE"
	INT	20H
PATCH:	DEC	DI			;POINT TO PATCH ADDRESS
	LODSB				;GET PATCH COUNT
	MOV	CL,AL
	XOR	CH,CH			;CX = PATCH COUNT
	REP	MOVSB			;MAKE THE PATCH
	MOV	WORD PTR FCB+33,BASADR	;RESET RECORD ADDRESS
	MOV	CX,PCHSIZ		;COUNT OF BYTES TO WRITE
	MOV	DX,OFFSET FCB
	MOV	AH,WRITEF
	INT	21H			;WRITE TO FILE
	OR	AL,AL
	JZ	PCHOK			;WRITE OK
WRERR:	MOV	DX,OFFSET BADWR
	MOV	AH,9
	INT	21H			;SAY "NO WRITE"
	INT	20H
PCHOK:	MOV	DX,OFFSET FCB
	MOV	AH,CLOSEF
	INT	21H			;CLOSE FILE
	INC	AL
	JZ	WRERR			;ERROR IN CLOSING
	MOV	DX,OFFSET DONE
	MOV	AH,9
	INT	21H			;ELSE, SAY "DONE"
	INT	20H			;AND EXIT

;	MESSAGES

SIGNON	DB	13,10,'BASICA LPRINT Patching Utility'
	DB	13,10,10,'$'
EXPL	DB	'To use this program, enter',13,10,10
	DB	'  BASPATCH d:BASICA.EXE',13,10,10
	DB	'where d: is a drive designation, and',13,10
	DB	'BASICA.EXE is the file to patch.$'
NOFILE	DB	'ERROR -- No file, or read error.$'
NPMSG	DB	'LPRINT code not found, no patch done.$'
BADWR	DB	'ERROR -- Disk write problem.$'
DONE	DB	'BASICA successfully patched.$'

;	PATCHES TO BE INSERTED INTO BASICA

PATCH1	DB	11,88H,0C2H,0B4H,5,0CDH,21H,0B4H,0,59H,5AH,0C3H
PATCH2	DB	7,88H,0C2H,0B4H,5,0CDH,21H,90H

BUFFER	LABEL	BYTE			;BUFFER STARTS HERE

CODE	ENDS
	END	START
                                                                                                