//\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\/\///
//       vcPlayer.cpp : Sample windows app for VideoCharger COM object
//\/\/\/\/\/\\/\\/\/\/\/\/\/\/\/\/\/\/\/\/\\/\/\/\/\/\/\\/\/\/\/\//
///////////////////////////////////////////////////////////////////
//===========================================================================
//
//             I B M    P R O P R I E T A R Y    S O U R C E    C O D E
//                             C O N F I D E N T I A L
//
//     Copyright (c) 1998 by International Buisiness Machines.  All
//     rights reserved.
// 
// vcPlayer.cpp - windows application to create the Main Frame in
// the window and initialize the IBM VideoCharger player COM object.
//===========================================================================

#include "stdafx.h"
#include "vcPlayer.h"
#include "iscplaysdk.h"

UINT RWM_NEWMOVIE = RegisterWindowMessage("IBM-ISC-SAMPLE");
/////////////////////////////////////////////////////////////////////////////
class ISCNewCmndInfo : public CCommandLineInfo
{
public:

	ISCNewCmndInfo(){ sFileParam = ""; } 
	~ISCNewCmndInfo() {}
	
	CString sFileParam;
	void ParseParam(LPCTSTR lpszParam, BOOL bFlag, BOOL bLast)
	{
		if(bFlag)
			return;

		// If this is the last parameter and not an option it must be
		// the path and name of the meta file or local file.
		if (bLast)
			sFileParam += lpszParam;	
		else
		{
			// Check for blanks in the directory name
			sFileParam += lpszParam;
			sFileParam += " ";
		}
	}
};
////////////////////////////////////////////////////////////////////////////
using namespace MPLAYERLib;

BEGIN_MESSAGE_MAP(vcPlayerApp, CWinApp)
	//{{AFX_MSG_MAP(vcPlayerApp)
	ON_COMMAND(ID_COMMAND_PLAY, OnCommandPlay)
	ON_COMMAND(ID_COMMAND_STOP, OnCommandStop)
	ON_COMMAND(ID_COMMAND_PAUSE, OnCommandPause)
	ON_UPDATE_COMMAND_UI(ID_COMMAND_STOP, OnUpdateCommandStop)
	ON_UPDATE_COMMAND_UI(ID_COMMAND_PLAY, OnUpdateCommandPlay)
	ON_UPDATE_COMMAND_UI(ID_COMMAND_PAUSE, OnUpdateCommandPause)
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// vcPlayerApp construction

vcPlayerApp::vcPlayerApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

vcPlayerApp::~vcPlayerApp()
{
	CoUninitialize();	

	if(hMutexOneInstance)
		CloseHandle(hMutexOneInstance);	
}


/////////////////////////////////////////////////////////////////////////////
// The one and only vcPlayerApp object

vcPlayerApp theApp;
IISCMPlayerPtr pISCMPlayer;
short m_playstate = 0;

// This identifier was generated to be statistically unique for your app.
// You may change it if you prefer to choose a specific identifier.

// {20F7AF60-CB80-11D0-A0B8-00A024D0C99B}
static const CLSID clsid =
{ 0x20f7af60, 0xcb80, 0x11d0, { 0xa0, 0xb8, 0x0, 0xa0, 0x24, 0xd0, 0xc9, 0x9b } };

/////////////////////////////////////////////////////////////////////////////
// vcPlayerApp initialization

BOOL vcPlayerApp::InitInstance()
{
	// Set the Registry Key
	SetRegistryKey(IDS_CORP_NAME);	
	
	// parse the meta file
	ISCNewCmndInfo isc_newcmdInfo;	
	ParseCommandLine(isc_newcmdInfo);
				
	WriteProfileString("Video_Viewer", "New_File", isc_newcmdInfo.sFileParam);

	// looking for existing player
	if(FoundPrevInstance())
	{			
		if(!isc_newcmdInfo.sFileParam.IsEmpty())
			::PostMessage(HWND_BROADCAST, RWM_NEWMOVIE, 0, 0 );
		
		return FALSE;
	}

	 // Initialize the quartz library
	CoInitialize(NULL);

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

#ifdef _AFXDLL
	Enable3dControls();			// Call this when using MFC in a shared DLL
#else
	Enable3dControlsStatic();	// Call this when linking to MFC statically
#endif
	
	// if no registered data, initilize it.
	CString szRegTrace = "Software\\IBM_Corp\\vcPlayer\\Settings\\Trace";		
	HKEY hKey;
        
    if(ERROR_SUCCESS != RegOpenKeyEx(HKEY_CURRENT_USER, szRegTrace, 0, KEY_READ, &hKey) )
	{
		pISCMPlayer = IISCMPlayerPtr(CLSID_ISCMPlayer);
		pISCMPlayer->InitRegData(TRUE);		
	}
	else
		RegCloseKey(hKey);
	
	LoadStdProfileSettings();  // Load standard INI file options (including MRU)

	AfxEnableControlContainer();
	
	if(!mFrm.LoadFrame(IDR_MAINFRAME))
		return FALSE;

	m_pMainWnd = &mFrm;
	mFrm.ShowWindow(m_nCmdShow);
	mFrm.UpdateWindow();

	return TRUE;
}

//////////////////////////////////////////////////////////////////////////////
// We want only one instance of this app to run at a time.  This function
// determines whether the app is already running.  Retuning FALSE from this
// app is the not running indication.  Returning TRUE indicates that
// another instance of the app is running.
////////////////////////////////////////////////////////////////////////////////
BOOL vcPlayerApp::FoundPrevInstance()
{
	BOOL	bFound = FALSE;
	hMutexOneInstance = NULL;
	const char	szMutex[] = _T("IBMVideoViewer");
	
	// The first instance of the app will successfully create this mutex.
	// When later instnaces try to create the mutex, they will fail
	// because it already exists, indicating to the program that a previous
	// instance is running.

	hMutexOneInstance = CreateMutex(NULL, TRUE, szMutex);
	if (GetLastError() == ERROR_ALREADY_EXISTS)
	{
		bFound = TRUE;
	}

	if (hMutexOneInstance)
	{
		ReleaseMutex(hMutexOneInstance);
	}

	return bFound;
}



/////////////////////////////////////////////////////////////////////////////
// vcPlayerApp commands
////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////
// Retrieve the string data from the System Registry
/////////////////////////////////////////////////////////////////////////////
CString vcPlayerApp::GetKeyStrData(HKEY HKey, char *regPath, char *filterName)
{
	HKEY hKey;
    DWORD nType, nSize;
    unsigned char* pBuffer;
	CString cs = "";

    if(ERROR_SUCCESS != RegOpenKeyEx(HKey, regPath, 0, KEY_READ, &hKey) )
                return cs;

    if(ERROR_SUCCESS == RegQueryValueEx(hKey, filterName,0, &nType, NULL, &nSize))
    {
                pBuffer = (unsigned char*)malloc(nSize);
                if(ERROR_SUCCESS == RegQueryValueEx(hKey, filterName, 0, &nType, pBuffer, &nSize))
                        cs = pBuffer;
                free(pBuffer);
    }

	RegCloseKey(hKey);
	return cs;
}


void vcPlayerApp::OnCommandPlay() 

{
        pISCMPlayer = IISCMPlayerPtr(CLSID_ISCMPlayer);
        pISCMPlayer->Play();
}

void vcPlayerApp::OnUpdateCommandPlay(CCmdUI* pCmdUI) 
{
	
     pISCMPlayer->GetPlayingState(&m_playstate);
	 if(( m_playstate == M_SEEKING)||(m_playstate == M_PLAYING))
              pCmdUI->Enable(FALSE);
		else if(( m_playstate == M_COMPLETE))
              pCmdUI->Enable(FALSE);
        else
              pCmdUI->Enable();
	
}

	


	


void vcPlayerApp::OnCommandStop() 

{
        pISCMPlayer = IISCMPlayerPtr(CLSID_ISCMPlayer);
        pISCMPlayer->Stop();
}

void vcPlayerApp::OnUpdateCommandStop(CCmdUI* pCmdUI) 
{
	 pISCMPlayer->GetPlayingState(&m_playstate);
	 if((m_playstate == M_STOP))
                pCmdUI->Enable(FALSE);
        else
                pCmdUI->Enable();	
	
}

	


void vcPlayerApp::OnCommandPause() 

{


	    pISCMPlayer = IISCMPlayerPtr(CLSID_ISCMPlayer);
        pISCMPlayer->Pause();
}

void vcPlayerApp::OnUpdateCommandPause(CCmdUI* pCmdUI) 
{

	pISCMPlayer->GetPlayingState(&m_playstate);
	if(( m_playstate == M_STOP)||( m_playstate == M_SEEKING)||(m_playstate == M_PAUSED))
                pCmdUI->Enable(FALSE);
    else
                pCmdUI->Enable();
	
}

