/*
    Prn2file.c

    Converts a print file created with Filer to an editable file.  Version 
    2 - this version modified to handle lines of up to 1000 characters, 
    any number of lines.
*/

#include <stdio.h>      /* Standard I/O functions header file */

    /* Line array. */
#define LINE_LEN 1000
char line[LINE_LEN];


    /* Main function. */
void main( void )
{
    int newchar;    /* character read/written from/to file */
    int column;     /* current column in the line */
    int columnsave; /* current column, to save when writing */

    /* Initialize line. */
    for ( column=0; column<LINE_LEN; column++ )
        line[column] = ' ';
    column = 0;

    /* Read until EOF. */
    while ( (newchar = getchar()) != EOF )
    {
        /* Convert formfeeds into CR/LF pairs. */
        if ( newchar == 0x0c )
        {
            newchar = 0x0d;
            ungetc( 0x0a, stdin );
        }

        /* Process the character. */
        switch ( newchar )
        {
            /* If the character is a carriage return, go back to the 
               beginning of the line. */
            case 0x0d:
                column = 0;
                break;

            /* If the character is a line feed, print out the current line. */
            case 0x0a:
                columnsave = column;
                for ( column = LINE_LEN-1;
                        column >= 0 && line[column] == ' '; column-- );
                line[++column] = '\0';
                if ( column > 0 ) puts( line );
                for ( column=0; column<LINE_LEN; column++ )
                    line[column] = ' ';
                column = columnsave;
                break;

            /* If the character is a space, go to the next column, but do 
               not overwrite the existing character (thus mimicking a 
               printer). */
            case 0x20:
                column++;
                if ( column >= LINE_LEN-1 )
                {
                    fputs( "Error - line too long!  Abort.", stderr );
                    exit( 1 );
                }
                break;

            /* If the character is printable, put it in the line. */
            default:
                line[column++] = newchar;
                if ( column >= LINE_LEN-1 )
                {
                    fputs( "Error - line too long!  Abort.", stderr );
                    exit( 1 );
                }
                break;
        }
    }

    /* Print out last line and write EOF. */
    for ( column = LINE_LEN-1;
            column >= 0 && line[column] == ' '; column-- );
    line[++column] = '\0';
    if ( column > 0 ) puts( line );
    putchar( '\x1a' );
}
