/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.StreamTokenizer;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

class Mid2Wav4 {
    static final int fq = 44100;
    static final int MAXNOTES = 128;
    static final double dt = 2.2675736961451248E-5;
    static final double DIAPASON = 440.0;
    static final double MAXDOUBLE = 1.0E300;
    static final boolean[] is_perc = new boolean[]{false, false, false, false, false, false, false, false, false, true, false, false, false, false, false, true};
    static final short MAXSHORT = Short.MAX_VALUE;
    static final String sitePA = "http://palbou.free.fr/winstrs/";
    static String instrFile;
    static FileInputStream inputFile;
    static RandomAccessFile tempFile;
    static RandomAccessFile outputFile;
    static MIDIheader mh;
    static boolean[] pedale;
    static int nnotes;
    static int[] volume;
    static float sg;
    static float sd;
    static double tempo;
    static instrument[] ins;
    static noteJouee[] note;
    static int prev_c;
    static int prev_stat;
    static /* synthetic */ Class class$Mid2Wav4;

    Mid2Wav4() {
    }

    static int getWORD() throws IOException {
        int n = inputFile.available();
        if (n < 2) {
            inputFile.skip(n);
            return 0;
        }
        return (inputFile.read() << 8) + inputFile.read();
    }

    static int getDWORD() throws IOException {
        int n = inputFile.available();
        if (n < 4) {
            inputFile.skip(n);
            return 0;
        }
        return (((inputFile.read() << 8) + inputFile.read() << 8) + inputFile.read() << 8) + inputFile.read();
    }

    static int seekChunk(char c, char c2, char c3, char c4) throws IOException {
        int n;
        char[] cArray = new char[4];
        while (true) {
            if (inputFile.available() < 8) {
                return 0;
            }
            cArray[0] = (char)inputFile.read();
            cArray[1] = (char)inputFile.read();
            cArray[2] = (char)inputFile.read();
            cArray[3] = (char)inputFile.read();
            n = Mid2Wav4.getDWORD();
            if (cArray[0] == c && cArray[1] == c2 && cArray[2] == c3 && cArray[3] == c4) break;
            inputFile.skip(n);
        }
        return n;
    }

    static MIDIheader readHeader() throws IOException {
        if (Mid2Wav4.seekChunk('M', 'T', 'h', 'd') != 6 || inputFile.available() < 6) {
            return null;
        }
        MIDIheader mIDIheader = new MIDIheader();
        mIDIheader.SMFtype = Mid2Wav4.getWORD();
        mIDIheader.tracks = Mid2Wav4.getWORD();
        mIDIheader.ticks4 = Mid2Wav4.getWORD();
        return mIDIheader;
    }

    static event evreturn(event event2) throws IOException {
        if (inputFile.available() == 0) {
            event2.type = 0;
        }
        return event2;
    }

    static int getchar() throws IOException {
        if (prev_c != -1) {
            int n = prev_c;
            prev_c = -1;
            return n;
        }
        if (inputFile.available() == 0) {
            return -1;
        }
        return inputFile.read();
    }

    static int getDeltaSize() throws IOException {
        int n = Mid2Wav4.getchar();
        if ((n & 0x80) == 0) {
            return n;
        }
        int n2 = (n & 0x7F) << 7;
        n = Mid2Wav4.getchar();
        if ((n & 0x80) == 0) {
            return n2 | n;
        }
        n2 = (n2 | n & 0x7F) << 7;
        n = Mid2Wav4.getchar();
        if ((n & 0x80) == 0) {
            return n2 | n;
        }
        n2 = (n2 | n & 0x7F) << 7;
        return n2 | Mid2Wav4.getchar() & 0x7F;
    }

    static event readEvent() throws IOException {
        event event2 = new event();
        do {
            event2.date = Mid2Wav4.getDeltaSize();
            int n = Mid2Wav4.getchar();
            block0 : switch (n) {
                case 255: {
                    prev_stat = 0;
                    switch (Mid2Wav4.getchar()) {
                        case 47: {
                            event2.type = Mid2Wav4.getchar() != 0 ? 0 : 1;
                            return event2;
                        }
                        case 81: {
                            event2.data = Mid2Wav4.getDWORD();
                            if (event2.data >> 24 == 3) {
                                event2.data = (int)((long)event2.data & 0xFFFFFFL);
                                event2.type = 2;
                            } else {
                                event2.type = 1;
                            }
                            return Mid2Wav4.evreturn(event2);
                        }
                    }
                }
                case 240: 
                case 247: {
                    prev_stat = 0;
                    int n2 = Mid2Wav4.getDeltaSize();
                    inputFile.skip(n2);
                    break;
                }
                default: {
                    if ((n & 0x80) != 0) {
                        prev_stat = n;
                    } else {
                        prev_c = n;
                    }
                    event2.channel = prev_stat & 0xF;
                    switch (prev_stat >> 4) {
                        case 14: {
                            event2.type = 3;
                            event2.data = Mid2Wav4.getchar();
                            event2.data |= Mid2Wav4.getchar() << 7;
                            return Mid2Wav4.evreturn(event2);
                        }
                        case 13: {
                            event2.type = 4;
                            event2.data = Mid2Wav4.getchar();
                            return Mid2Wav4.evreturn(event2);
                        }
                        case 12: {
                            event2.type = 5;
                            event2.data = Mid2Wav4.getchar();
                            return Mid2Wav4.evreturn(event2);
                        }
                        case 11: {
                            switch (Mid2Wav4.getchar()) {
                                case 120: 
                                case 123: {
                                    event2.type = 6;
                                    if (Mid2Wav4.getchar() != 0) {
                                        event2.type = 0;
                                    }
                                    return Mid2Wav4.evreturn(event2);
                                }
                                case 121: {
                                    event2.type = 8;
                                    if (Mid2Wav4.getchar() != 0) {
                                        event2.type = 0;
                                    }
                                    return Mid2Wav4.evreturn(event2);
                                }
                                case 64: {
                                    event2.type = 7;
                                    event2.data = Mid2Wav4.getchar();
                                    return Mid2Wav4.evreturn(event2);
                                }
                                case 7: {
                                    event2.type = 9;
                                    event2.data = Mid2Wav4.getchar();
                                    return Mid2Wav4.evreturn(event2);
                                }
                            }
                            Mid2Wav4.getchar();
                            break block0;
                        }
                        case 8: {
                            event2.type = 10;
                            event2.data = Mid2Wav4.getchar();
                            Mid2Wav4.getchar();
                            return Mid2Wav4.evreturn(event2);
                        }
                        case 9: {
                            event2.data = Mid2Wav4.getchar();
                            event2.data2 = Mid2Wav4.getchar();
                            event2.type = event2.data2 != 0 ? 11 : 10;
                            return Mid2Wav4.evreturn(event2);
                        }
                        case 10: {
                            event2.type = 12;
                            event2.data = Mid2Wav4.getchar();
                            event2.data2 = Mid2Wav4.getchar();
                            return Mid2Wav4.evreturn(event2);
                        }
                    }
                    event2.type = 0;
                    return event2;
                }
            }
        } while (inputFile.available() != 0);
        event2.type = 0;
        return event2;
    }

    static void skipLine(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.eolIsSignificant(true);
        while (streamTokenizer.nextToken() != 10) {
            if (streamTokenizer.ttype != -1) continue;
            throw new IOException();
        }
        streamTokenizer.eolIsSignificant(false);
    }

    static boolean readCfloat(StreamTokenizer streamTokenizer) throws IOException {
        if (streamTokenizer.nextToken() == -2) {
            double d = streamTokenizer.nval;
            if (streamTokenizer.nextToken() == -3 && (streamTokenizer.sval.startsWith("e") || streamTokenizer.sval.startsWith("E"))) {
                if (streamTokenizer.sval.equals("e") || streamTokenizer.sval.equals("E")) {
                    if (streamTokenizer.nextToken() == 43 && streamTokenizer.nextToken() == -2) {
                        streamTokenizer.nval = d * Math.pow(10.0, streamTokenizer.nval);
                    } else {
                        streamTokenizer.pushBack();
                        streamTokenizer.nval = d;
                    }
                } else {
                    try {
                        Integer n = new Integer(streamTokenizer.sval.substring(1));
                        streamTokenizer.nval = d * Math.pow(10.0, n.doubleValue());
                    }
                    catch (NumberFormatException numberFormatException) {
                        streamTokenizer.nval = d;
                        streamTokenizer.pushBack();
                    }
                }
            } else {
                streamTokenizer.pushBack();
                streamTokenizer.nval = d;
            }
            return true;
        }
        streamTokenizer.pushBack();
        return false;
    }

    static boolean findEntry(ZipInputStream zipInputStream, String string) throws IOException {
        ZipEntry zipEntry = zipInputStream.getNextEntry();
        while (zipEntry != null) {
            if (zipEntry.getName().equals(string)) {
                return true;
            }
            zipInputStream.closeEntry();
            zipEntry = zipInputStream.getNextEntry();
        }
        return false;
    }

    static boolean readsample(echantillon echantillon2, String string) {
        try {
            URL uRL = new URL(instrFile);
            InputStream inputStream = uRL.openStream();
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            Mid2Wav4.findEntry(zipInputStream, string);
            StreamTokenizer streamTokenizer = new StreamTokenizer(new InputStreamReader(zipInputStream));
            Mid2Wav4.skipLine(streamTokenizer);
            if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                return false;
            }
            echantillon2.fe = (int)streamTokenizer.nval;
            if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval <= 0.0) {
                return false;
            }
            echantillon2.e = new float[(int)streamTokenizer.nval];
            for (int i = 0; i < echantillon2.e.length; ++i) {
                if (!Mid2Wav4.readCfloat(streamTokenizer)) {
                    return false;
                }
                echantillon2.e[i] = (float)streamTokenizer.nval;
            }
            if (!Mid2Wav4.readCfloat(streamTokenizer) || streamTokenizer.nval < 0.0) {
                return false;
            }
            echantillon2.arms = (float)streamTokenizer.nval;
            if (!Mid2Wav4.readCfloat(streamTokenizer) || streamTokenizer.nval < 0.0) {
                return false;
            }
            echantillon2.ff = (float)streamTokenizer.nval;
            zipInputStream.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    static boolean readperc(int n, percussion percussion2) {
        percussion2.wt = new echantillon();
        if (!Mid2Wav4.readsample(percussion2.wt, n + ".hit") && !Mid2Wav4.readsample(percussion2.wt, "76.hit")) {
            return false;
        }
        try {
            URL uRL = new URL(instrFile);
            InputStream inputStream = uRL.openStream();
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            if (!Mid2Wav4.findEntry(zipInputStream, n + ".pdt")) {
                zipInputStream.close();
                inputStream = uRL.openStream();
                zipInputStream = new ZipInputStream(inputStream);
                if (!Mid2Wav4.findEntry(zipInputStream, "76.pdt")) {
                    zipInputStream.close();
                    return false;
                }
            }
            StreamTokenizer streamTokenizer = new StreamTokenizer(new InputStreamReader(zipInputStream));
            Mid2Wav4.skipLine(streamTokenizer);
            if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                return false;
            }
            percussion2.decr_time = (float)streamTokenizer.nval;
            if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                return false;
            }
            percussion2.sust_decr_time = (float)streamTokenizer.nval;
            if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                return false;
            }
            percussion2.left = (float)streamTokenizer.nval;
            if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                return false;
            }
            percussion2.right = (float)streamTokenizer.nval;
            zipInputStream.close();
            double d = percussion2.left + percussion2.right;
            percussion2.left = (float)((double)percussion2.left / d);
            percussion2.right = (float)((double)percussion2.right / d);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    static boolean readinst(int n, instrument instrument2) {
        try {
            URL uRL = new URL(instrFile);
            InputStream inputStream = uRL.openStream();
            ZipInputStream zipInputStream = new ZipInputStream(inputStream);
            if (!Mid2Wav4.findEntry(zipInputStream, n + ".idt")) {
                zipInputStream.close();
                inputStream = uRL.openStream();
                zipInputStream = new ZipInputStream(inputStream);
                if (!Mid2Wav4.findEntry(zipInputStream, "0.idt")) {
                    zipInputStream.close();
                    return false;
                }
                n = 0;
            }
            StreamTokenizer streamTokenizer = new StreamTokenizer(new InputStreamReader(zipInputStream));
            Mid2Wav4.skipLine(streamTokenizer);
            if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval <= 0.0) {
                return false;
            }
            instrument2.E = new enregistrement[(int)streamTokenizer.nval];
            instrument2.samples_pool = null;
            instrument2.a_max = 0.0f;
            for (int i = 0; i < instrument2.E.length; ++i) {
                instrument2.E[i] = new enregistrement();
                Mid2Wav4.skipLine(streamTokenizer);
                Mid2Wav4.skipLine(streamTokenizer);
                if (streamTokenizer.nextToken() != -3) {
                    return false;
                }
                echantillon echantillon2 = instrument2.samples_pool;
                while (echantillon2 != null && !echantillon2.name.equals(streamTokenizer.sval)) {
                    echantillon2 = echantillon2.next;
                }
                if (echantillon2 == null) {
                    echantillon2 = new echantillon();
                    if (!Mid2Wav4.readsample(echantillon2, n + "." + streamTokenizer.sval + ".wt")) {
                        return false;
                    }
                    echantillon2.name = streamTokenizer.sval;
                    echantillon2.next = instrument2.samples_pool;
                    instrument2.samples_pool = echantillon2;
                }
                instrument2.E[i].wt = echantillon2;
                if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                    return false;
                }
                instrument2.E[i].note1 = (short)streamTokenizer.nval;
                if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                    return false;
                }
                instrument2.E[i].note2 = (short)streamTokenizer.nval;
                if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                    return false;
                }
                instrument2.E[i].rel_amp = (float)streamTokenizer.nval;
                if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                    return false;
                }
                instrument2.E[i].decr_time = (float)streamTokenizer.nval;
                if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                    return false;
                }
                instrument2.E[i].sust_decr_time = (float)streamTokenizer.nval;
                if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                    return false;
                }
                instrument2.E[i].vbr_freq = (float)streamTokenizer.nval;
                if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                    return false;
                }
                instrument2.E[i].vbr_amp = (float)streamTokenizer.nval;
                if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                    return false;
                }
                instrument2.E[i].left = (float)streamTokenizer.nval;
                if (streamTokenizer.nextToken() != -2 || streamTokenizer.nval < 0.0) {
                    return false;
                }
                instrument2.E[i].right = (float)streamTokenizer.nval;
                double d = instrument2.E[i].left + instrument2.E[i].right;
                instrument2.E[i].left = (float)((double)instrument2.E[i].left / d);
                instrument2.E[i].right = (float)((double)instrument2.E[i].right / d);
                if (!(instrument2.a_max < instrument2.E[i].rel_amp)) continue;
                instrument2.a_max = instrument2.E[i].rel_amp;
            }
            zipInputStream.close();
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    static void doEvent(event event2) {
        switch (event2.type) {
            case 2: {
                tempo = (double)Mid2Wav4.mh.ticks4 / ((double)event2.data * 1.0E-6) * 2.2675736961451248E-5;
                break;
            }
            case 5: {
                if (is_perc[event2.channel]) break;
                Mid2Wav4.ins[event2.channel] = new instrument();
                if (Mid2Wav4.readinst(event2.data, ins[event2.channel])) break;
                System.out.println();
                System.out.print("ERROR: can't load instrument data");
                System.exit(4);
                break;
            }
            case 6: {
                for (int i = 0; i < nnotes; ++i) {
                    Mid2Wav4.note[i].t2eon = is_perc[Mid2Wav4.note[i].canal] ? (pedale[Mid2Wav4.note[i].canal] ? (double)Mid2Wav4.note[i].perc.sust_decr_time : (double)Mid2Wav4.note[i].perc.decr_time) : (pedale[Mid2Wav4.note[i].canal] ? (double)Mid2Wav4.note[i].inst_rec.sust_decr_time : (double)Mid2Wav4.note[i].inst_rec.decr_time);
                }
                break;
            }
            case 9: {
                Mid2Wav4.volume[event2.channel] = event2.data;
                break;
            }
            case 10: {
                int n;
                for (n = 0; n < nnotes && (Mid2Wav4.note[n].demi_ton != event2.data || Mid2Wav4.note[n].canal != event2.channel || Mid2Wav4.note[n].t2eon < 1.0000000000000001E298); ++n) {
                }
                if (n >= nnotes) break;
                if (is_perc[Mid2Wav4.note[n].canal]) {
                    Mid2Wav4.note[n].t2eon = pedale[Mid2Wav4.note[n].canal] ? (double)Mid2Wav4.note[n].perc.sust_decr_time : (double)Mid2Wav4.note[n].perc.decr_time;
                    break;
                }
                Mid2Wav4.note[n].t2eon = pedale[Mid2Wav4.note[n].canal] ? (double)Mid2Wav4.note[n].inst_rec.sust_decr_time : (double)Mid2Wav4.note[n].inst_rec.decr_time;
                break;
            }
            case 11: {
                int n;
                if (nnotes == 128) {
                    System.out.println();
                    System.out.print("ERROR: too many notes (>128)");
                    System.exit(5);
                }
                Mid2Wav4.note[Mid2Wav4.nnotes] = new noteJouee();
                Mid2Wav4.note[Mid2Wav4.nnotes].canal = n = event2.channel;
                Mid2Wav4.note[Mid2Wav4.nnotes].volume = event2.data2;
                Mid2Wav4.note[Mid2Wav4.nnotes].demi_ton = event2.data;
                Mid2Wav4.note[Mid2Wav4.nnotes].t = 0.0;
                Mid2Wav4.note[Mid2Wav4.nnotes].t2eon = 1.0E300;
                if (is_perc[n]) {
                    if (!Mid2Wav4.readperc(event2.data, Mid2Wav4.note[Mid2Wav4.nnotes].perc)) {
                        System.out.println();
                        System.out.print("ERROR: can't load percussion instrument data");
                        System.exit(7);
                    }
                } else {
                    int n2;
                    if (ins[n] == null && !Mid2Wav4.readinst(0, Mid2Wav4.ins[n] = new instrument())) {
                        System.out.println();
                        System.out.print("ERROR: can't load instrument data");
                        System.exit(4);
                    }
                    for (n2 = 0; n2 < Mid2Wav4.ins[n].E.length && Mid2Wav4.note[Mid2Wav4.nnotes].demi_ton > Mid2Wav4.ins[n].E[n2].note2; ++n2) {
                    }
                    if (n2 == Mid2Wav4.ins[n].E.length) {
                        --n2;
                    }
                    Mid2Wav4.note[Mid2Wav4.nnotes].inst_rec = Mid2Wav4.ins[n].E[n2];
                    Mid2Wav4.note[Mid2Wav4.nnotes].inst = ins[n];
                    Mid2Wav4.note[Mid2Wav4.nnotes].f = 440.0 * Math.pow(2.0, (double)(event2.data - 69) / 12.0);
                }
                ++nnotes;
                break;
            }
            case 7: {
                boolean bl = Mid2Wav4.pedale[event2.channel] = event2.data != 0;
                if (event2.data != 0) break;
                if (is_perc[event2.channel]) {
                    for (int i = 0; i < nnotes; ++i) {
                        if (Mid2Wav4.note[i].canal != event2.channel || !(Mid2Wav4.note[i].t2eon <= (double)Mid2Wav4.note[i].perc.sust_decr_time)) continue;
                        Mid2Wav4.note[i].t2eon = Mid2Wav4.note[i].perc.decr_time;
                    }
                } else {
                    for (int i = 0; i < nnotes; ++i) {
                        if (Mid2Wav4.note[i].canal != event2.channel || !(Mid2Wav4.note[i].t2eon <= (double)Mid2Wav4.note[i].inst_rec.sust_decr_time)) continue;
                        Mid2Wav4.note[i].t2eon = Mid2Wav4.note[i].inst_rec.decr_time;
                    }
                }
                break;
            }
            case 8: {
                Mid2Wav4.pedale[event2.channel] = false;
                break;
            }
            case 12: {
                int n;
                for (n = 0; n < nnotes && (Mid2Wav4.note[n].demi_ton != event2.data || Mid2Wav4.note[n].canal != event2.channel); ++n) {
                }
                if (n >= nnotes) break;
                Mid2Wav4.note[n].volume = event2.data2;
                break;
            }
            case 4: {
                for (int i = 0; i < nnotes; ++i) {
                    if (Mid2Wav4.note[i].canal != event2.channel) continue;
                    Mid2Wav4.note[i].volume = event2.data;
                }
                break;
            }
        }
    }

    static double interp(float[] fArray, double d) {
        int n = (int)d;
        return (double)fArray[n] * ((double)(n + 1) - d) + (double)fArray[n + 1] * (d - (double)n);
    }

    static void doNote() {
        sg = 0.0f;
        sd = 0.0f;
        for (int i = 0; i < nnotes; ++i) {
            double d;
            double d2;
            double d3;
            double d4;
            int n = Mid2Wav4.note[i].canal;
            if (is_perc[n]) {
                d4 = pedale[n] ? (double)Mid2Wav4.note[i].perc.sust_decr_time : (double)Mid2Wav4.note[i].perc.decr_time;
                d3 = Mid2Wav4.note[i].t2eon > d4 ? 1.0 : Mid2Wav4.note[i].t2eon / d4;
                d2 = (double)Mid2Wav4.note[i].perc.wt.fe * Mid2Wav4.note[i].t;
                if (d2 < (double)(Mid2Wav4.note[i].perc.wt.e.length - 1)) {
                    d = (double)((float)volume[n] / Mid2Wav4.note[i].perc.wt.arms * (float)Mid2Wav4.note[i].volume) * d3 * Mid2Wav4.interp(Mid2Wav4.note[i].perc.wt.e, d2);
                    sg = (float)((double)sg + d * (double)Mid2Wav4.note[i].perc.left);
                    sd = (float)((double)sd + d * (double)Mid2Wav4.note[i].perc.right);
                } else {
                    Mid2Wav4.note[i].t2eon = 0.0;
                }
            } else {
                d4 = pedale[n] ? (double)Mid2Wav4.note[i].inst_rec.sust_decr_time : (double)Mid2Wav4.note[i].inst_rec.decr_time;
                d3 = Mid2Wav4.note[i].t2eon > d4 ? 1.0 : Mid2Wav4.note[i].t2eon / d4;
                double d5 = Mid2Wav4.note[i].f;
                d2 = d5 / (double)Mid2Wav4.note[i].inst_rec.wt.ff * Mid2Wav4.note[i].t * (double)Mid2Wav4.note[i].inst_rec.wt.fe;
                if (d2 < (double)(Mid2Wav4.note[i].inst_rec.wt.e.length - 1)) {
                    d = (double)((float)volume[n] / Mid2Wav4.note[i].inst_rec.wt.arms * Mid2Wav4.note[i].inst_rec.rel_amp / Mid2Wav4.note[i].inst.a_max * (float)Mid2Wav4.note[i].volume) * d3 * Mid2Wav4.interp(Mid2Wav4.note[i].inst_rec.wt.e, d2);
                    sg = (float)((double)sg + d * (double)Mid2Wav4.note[i].inst_rec.left);
                    sd = (float)((double)sd + d * (double)Mid2Wav4.note[i].inst_rec.right);
                } else {
                    Mid2Wav4.note[i].t2eon = 0.0;
                }
            }
            Mid2Wav4.note[i].t += 2.2675736961451248E-5;
            Mid2Wav4.note[i].t2eon -= 2.2675736961451248E-5;
            if (!(Mid2Wav4.note[i].t2eon < 0.0)) continue;
            --nnotes;
            for (int j = i; j < nnotes; ++j) {
                Mid2Wav4.note[j] = note[j + 1];
            }
            --i;
        }
    }

    static void writeShort(int n) throws IOException {
        outputFile.write(n & 0xFF);
        outputFile.write(n >> 8);
    }

    static void writeInt(int n) throws IOException {
        Mid2Wav4.writeShort(n & 0xFFFF);
        Mid2Wav4.writeShort(n >> 16);
    }

    static void putech(double d, int n) throws IOException {
        if (n == 16) {
            Mid2Wav4.writeShort((int)(d * 32767.0));
        } else {
            outputFile.write((int)(d * 127.0 + 128.0));
        }
    }

    static void write_wave(RandomAccessFile randomAccessFile, double d, int n, int n2, int n3, boolean bl) throws IOException {
        n = (int)((long)n & 0xFFFFFFFFFFFFFFFEL);
        int n4 = (bl ? 2 : 1) * (n3 == 16 ? 2 : 1);
        int n5 = n * n4;
        int n6 = 16;
        int n7 = n5 + 36;
        outputFile.writeBytes("RIFF");
        Mid2Wav4.writeInt(n7);
        outputFile.writeBytes("WAVEfmt ");
        Mid2Wav4.writeInt(n6);
        Mid2Wav4.writeShort(1);
        Mid2Wav4.writeShort(bl ? 2 : 1);
        Mid2Wav4.writeInt(n2);
        Mid2Wav4.writeInt(n2 *= n4);
        Mid2Wav4.writeShort(n4);
        Mid2Wav4.writeShort(n3);
        outputFile.writeBytes("data");
        Mid2Wav4.writeInt(n5);
        boolean bl2 = false;
        System.out.print("\nWriting");
        for (int i = 0; i < n; ++i) {
            if (i % 44100 == 0) {
                System.out.print(".");
            }
            float f = randomAccessFile.readFloat();
            float f2 = randomAccessFile.readFloat();
            if (bl) {
                Mid2Wav4.putech((double)f / d, n3);
                Mid2Wav4.putech((double)f2 / d, n3);
                continue;
            }
            Mid2Wav4.putech((double)((f + f2) / 2.0f) / d, n3);
        }
    }

    public static void main(String[] stringArray) throws IOException {
        int n;
        Object object;
        Object object2;
        Object object3;
        if (stringArray.length == 0) {
            System.out.print("Mid2Wav4 source_file.mid dest_file.wav [l | w]\n\nCreate a 16 bits stereo WAV file (44kHz).\nl : load instrument files locally, w : load instruments data from the Web\n\nCopyright (C) Pierre Albou, May 2000 - September 2002, all rights reserved.");
            return;
        }
        if (stringArray.length < 2) {
            System.out.print("ERROR: source and/or destination file names missing");
            return;
        }
        if (stringArray.length > 3) {
            System.out.println("WARNING: unused arguments");
        }
        if (stringArray.length == 3 && stringArray[2].equals("l")) {
            int n2;
            object3 = System.getProperty("file.separator");
            if (System.getProperty("os.name").startsWith("Windows")) {
                n2 = 1;
                object2 = ":\\";
            } else {
                n2 = 0;
                object2 = object3;
            }
            object = (class$Mid2Wav4 == null ? (class$Mid2Wav4 = Mid2Wav4.class$("Mid2Wav4")) : class$Mid2Wav4).getClassLoader().getResource("Mid2Wav4.class").getPath();
            object = ((String)object).substring(((String)object).lastIndexOf(":") + 1 - 2 * n2, ((String)object).length() - 16).replace('/', File.separatorChar);
            String string = ((String)object).substring(n2).startsWith((String)object2) ? ((String)object).substring(0, ((String)object).length() - 12) : System.getProperty("user.dir") + (String)object3 + ((String)object).substring(0, ((String)object).length() - 12);
            instrFile = "file:///" + string + "instr4.zip";
        } else {
            instrFile = "http://palbou.free.fr/winstrs/instr4.zip";
        }
        try {
            inputFile = new FileInputStream(stringArray[0]);
            tempFile = new RandomAccessFile("mid2wav4.tmp", "rw");
            outputFile = new RandomAccessFile(stringArray[1], "rw");
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.print("ERROR: cannot open files");
            return;
        }
        mh = Mid2Wav4.readHeader();
        if (mh == null) {
            System.out.print("ERROR: faulty MIDI header");
            return;
        }
        if (Mid2Wav4.mh.SMFtype > 1) {
            System.out.print("ERROR: cannot process this MIDI file type (2)");
            return;
        }
        object3 = null;
        block6: for (n = 0; n < Mid2Wav4.mh.tracks; ++n) {
            if (Mid2Wav4.seekChunk('M', 'T', 'r', 'k') == 0) {
                System.out.print("ERROR: corrupted MIDI file");
                return;
            }
            object = null;
            object2 = object3;
            event event2 = Mid2Wav4.readEvent();
            while (true) {
                if (event2.type == 0) {
                    System.out.print("ERROR: corrupted MIDI file");
                    return;
                }
                if (object2 != null && ((event)object2).date <= event2.date) {
                    if (((event)object2).type == 1) {
                        object2 = null;
                        continue;
                    }
                    event2.date -= ((event)object2).date;
                    object = object2;
                    object2 = ((event)object2).suivant;
                    continue;
                }
                if (event2.type != 1 || object2 == null) {
                    if (object == null) {
                        object3 = event2;
                    } else {
                        ((event)object).suivant = event2;
                    }
                    object = event2;
                    event2.suivant = object2;
                }
                if (object2 != null) {
                    ((event)object2).date -= event2.date;
                }
                if (event2.type == 1) continue block6;
                event2 = Mid2Wav4.readEvent();
            }
        }
        inputFile.close();
        System.out.print("Synthesis");
        note = new noteJouee[128];
        n = 0;
        double d = 0.0;
        double d2 = 0.0;
        Object object4 = object3;
        while (((event)object4).type != 1 || d2 > 0.0) {
            while (d2 <= 0.0 && ((event)object4).type != 1) {
                Mid2Wav4.doEvent((event)object4);
                object4 = ((event)object4).suivant;
                d2 += (double)((event)object4).date;
            }
            d2 -= tempo;
            Mid2Wav4.doNote();
            try {
                tempFile.writeFloat(sg);
                sg = Math.abs(sg);
                if ((double)sg > d) {
                    d = sg;
                }
                tempFile.writeFloat(sd);
            }
            catch (IOException iOException) {
                System.out.println();
                System.out.print("ERROR: cannot write (disk full ?)");
                return;
            }
            sd = Math.abs(sd);
            if ((double)sd > d) {
                d = sd;
            }
            if (++n % 44100 != 0) continue;
            System.out.print('.');
        }
        tempFile.seek(0L);
        try {
            Mid2Wav4.write_wave(tempFile, d, n, 44100, 16, true);
        }
        catch (IOException iOException) {
            System.out.println();
            System.out.print("ERROR: writing (disk full ?)");
            return;
        }
        tempFile.close();
        outputFile.close();
        File file = new File("mid2wav4.tmp");
        file.delete();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        pedale = new boolean[]{false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false};
        nnotes = 0;
        volume = new int[]{127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127};
        ins = new instrument[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null};
        prev_c = -1;
    }
}

