/*
 * Decompiled with CFR 0.152.
 */
package com.develop.jawin;

import com.develop.io.LittleEndianInputStream;
import com.develop.io.LittleEndianOutputStream;
import com.develop.io.NakedByteStream;
import com.develop.jawin.Bootstrap;
import com.develop.jawin.COMError;
import com.develop.jawin.COMException;
import com.develop.jawin.COMPtr;
import com.develop.jawin.DispatchPtr;
import com.develop.jawin.GUID;
import com.develop.jawin.Identity;
import com.develop.jawin.ObjectFinalization;
import com.develop.jawin.marshal.StructConverter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;

public class IdentityManager {
    public static final boolean traceRefs = null != System.getProperty("com.develop.jawin.traceRefs");
    private static HashMap idents = new HashMap();
    private static Object lock = new int[0];
    private static HashMap guidToClass = new HashMap();

    public static synchronized COMPtr queryInterface(Class clazz, COMPtr cOMPtr) {
        COMPtr cOMPtr2 = IdentityManager.newCOMPtr(clazz);
        int n = cOMPtr.getUnknown();
        if (n != 0) {
            cOMPtr2.setUnknown(Bootstrap.queryInterface(n, cOMPtr2.getGuidToken()));
        } else {
            cOMPtr2.setUnknown(Bootstrap.unmarshalFromGIT(cOMPtr.getPeer(), cOMPtr2.getGuidToken()));
        }
        if (traceRefs) {
            System.out.println(cOMPtr + " QI --> " + cOMPtr2);
        }
        return cOMPtr2;
    }

    public static COMPtr newListener(Class clazz, Object object) throws COMException {
        DispatchPtr dispatchPtr = null;
        try {
            Field[] fieldArray = clazz.getFields();
            HashMap hashMap = (HashMap)clazz.getField("mthsMap").get(null);
            HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
            int n = 0;
            int n2 = 0;
            while (n2 < fieldArray.length) {
                if (fieldArray[n2].getName().startsWith("id")) {
                    ++n;
                    hashMap2.put(fieldArray[n2].getName().substring(2), clazz.getField(fieldArray[n2].getName()).get(null));
                }
                ++n2;
            }
            Method[] methodArray = clazz.getMethods();
            HashMap<String, Method> hashMap3 = new HashMap<String, Method>();
            int n3 = 0;
            while (n3 < n) {
                hashMap3.put(methodArray[n3].getName(), methodArray[n3]);
                ++n3;
            }
            int n4 = 0;
            while (n4 < n) {
                hashMap.put(hashMap2.get(methodArray[n4].getName()), methodArray[n4]);
                ++n4;
            }
            GUID gUID = (GUID)clazz.getField("proxyIID").get(null);
            int n5 = IdentityManager.registerProxy((GUID)clazz.getField("proxyIID").get(null), clazz);
            dispatchPtr = new DispatchPtr(object, gUID, n5);
        }
        catch (Exception exception) {
            throw new COMException(exception.getMessage());
        }
        return dispatchPtr;
    }

    private static COMPtr newCOMPtr(Class clazz) {
        try {
            return (COMPtr)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new COMError("Unable to create instance of " + clazz.getClass());
        }
    }

    public static COMPtr createGITRef(COMPtr cOMPtr) {
        COMPtr cOMPtr2 = IdentityManager.newCOMPtr(cOMPtr.getClass());
        int n = 0;
        COMPtr cOMPtr3 = cOMPtr;
        synchronized (cOMPtr3) {
            n = cOMPtr.getPeer();
            if (n == 0) {
                n = Bootstrap.marshalToGIT(cOMPtr.getUnknown(), cOMPtr.getGuidToken());
            }
        }
        cOMPtr2.setPeer(n);
        return cOMPtr2;
    }

    public static COMPtr createDirectRef(COMPtr cOMPtr) {
        COMPtr cOMPtr2 = IdentityManager.newCOMPtr(cOMPtr.getClass());
        int n = 0;
        COMPtr cOMPtr3 = cOMPtr;
        synchronized (cOMPtr3) {
            n = cOMPtr.getUnknown();
            if (n == 0) {
                n = Bootstrap.unmarshalFromGIT(cOMPtr.getPeer(), cOMPtr.getGuidToken());
            }
        }
        cOMPtr2.setUnknown(n);
        if (traceRefs && 0 == cOMPtr.getUnknown()) {
            System.out.println(cOMPtr + " unmarshal --> " + cOMPtr2);
        }
        return cOMPtr2;
    }

    static Identity IncRef(int n) {
        Integer n2 = new Integer(n);
        Object object = lock;
        synchronized (object) {
            Identity identity = (Identity)idents.get(n2);
            if (identity == null) {
                identity = new Identity(n);
                idents.put(n2, identity);
            } else {
                identity.IncRef();
            }
            Identity identity2 = identity;
            return identity2;
        }
    }

    public static void DecRef(int n) {
        int n2 = 0;
        Integer n3 = new Integer(n);
        Object object = lock;
        synchronized (object) {
            Identity identity = (Identity)idents.get(n3);
            if (identity == null) {
                throw new COMError("Peer " + n + " is not a COM identity");
            }
            n2 = identity.DecRef();
            if (n2 == 0) {
                idents.remove(n3);
            }
        }
        if (n2 == 0) {
            Bootstrap.revokeGIT(n);
        }
    }

    public static COMPtr getCOMPtr(int n, int n2, GUID gUID) {
        Class clazz = (Class)guidToClass.get(gUID);
        if (clazz == null) {
            throw new COMError("No Java class for ITF" + gUID);
        }
        COMPtr cOMPtr = null;
        try {
            cOMPtr = (COMPtr)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new COMError("Could not create COMPtr " + exception.getMessage());
        }
        cOMPtr.setUnknown(n2);
        cOMPtr.setPeer(n);
        ObjectFinalization.registerObject(cOMPtr);
        return cOMPtr;
    }

    public static COMPtr getCOMPtr(LittleEndianInputStream littleEndianInputStream, GUID gUID) throws IOException, COMException {
        COMPtr cOMPtr = null;
        int n = littleEndianInputStream.readInt();
        int n2 = littleEndianInputStream.readInt();
        if (n != 0 || n2 != 0) {
            cOMPtr = IdentityManager.getCOMPtr(n2, n, gUID);
            ObjectFinalization.registerObject(cOMPtr);
        }
        return cOMPtr;
    }

    public static COMPtr getCOMPtr(byte[] byArray, int n, GUID gUID) throws COMException {
        int n2 = StructConverter.bytesIntoInt(byArray, n);
        int n3 = StructConverter.bytesIntoInt(byArray, n + 4);
        COMPtr cOMPtr = IdentityManager.getCOMPtr(n3, n2, gUID);
        ObjectFinalization.registerObject(cOMPtr);
        return cOMPtr;
    }

    private static void registerProxyPrototype(GUID gUID, Class clazz) {
        guidToClass.put(gUID, clazz);
    }

    public static int registerProxy(GUID gUID, Class clazz) {
        IdentityManager.registerProxyPrototype(gUID, clazz);
        NakedByteStream nakedByteStream = new NakedByteStream();
        LittleEndianOutputStream littleEndianOutputStream = new LittleEndianOutputStream(nakedByteStream);
        try {
            gUID.marshal(littleEndianOutputStream, null);
            return Bootstrap.registerGUID(nakedByteStream.getInternalBuffer());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new Error("could not initialize proxy");
        }
    }

    public static int registerRecord(GUID gUID, GUID gUID2, Class clazz) {
        IdentityManager.registerProxyPrototype(gUID2, clazz);
        NakedByteStream nakedByteStream = new NakedByteStream();
        LittleEndianOutputStream littleEndianOutputStream = new LittleEndianOutputStream(nakedByteStream);
        NakedByteStream nakedByteStream2 = new NakedByteStream();
        LittleEndianOutputStream littleEndianOutputStream2 = new LittleEndianOutputStream(nakedByteStream2);
        try {
            gUID.marshal(littleEndianOutputStream, null);
            gUID2.marshal(littleEndianOutputStream2, null);
            return Bootstrap.registerRecord(nakedByteStream.getInternalBuffer(), nakedByteStream2.getInternalBuffer());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            throw new Error("could not initialize record");
        }
    }
}

