/*
 * Decompiled with CFR 0.152.
 */
package com.develop.jawin;

import com.develop.jawin.Bootstrap;
import com.develop.jawin.COMError;
import com.develop.jawin.COMException;
import com.develop.jawin.IUnknown;
import com.develop.jawin.IdentityManager;
import com.develop.jawin.marshal.GenericStub;
import java.io.IOException;

public abstract class COMPtr
implements IUnknown {
    private int peer;
    private int unknown = 0;

    void setPeer(int n) {
        if (this.peer != 0) {
            throw new COMError("peer already exists");
        }
        this.peer = n;
        if (n != 0) {
            IdentityManager.IncRef(n);
        }
    }

    void setUnknown(int n) {
        if (this.unknown != 0) {
            throw new COMError("unknown already exists");
        }
        this.unknown = n;
    }

    protected COMPtr() {
    }

    protected COMPtr(int n, int n2) {
        this.peer = n;
        this.unknown = n2;
    }

    protected void nullUnknown() {
        this.unknown = 0;
    }

    public void stealUnknown(COMPtr cOMPtr) {
        this.setUnknown(cOMPtr.unknown);
        cOMPtr.unknown = 0;
        if (IdentityManager.traceRefs) {
            System.out.println(this + " assigned reference");
        }
    }

    public byte[] comInvoke(int n, String string, int n2, int n3, byte[] byArray) throws COMException, IOException {
        return GenericStub.comInvokeString(string, n2, n3, byArray, null, n, this.getGuidToken(), this.peer, this.unknown);
    }

    protected void copyUnknown(COMPtr cOMPtr) {
        this.setUnknown(cOMPtr.unknown);
        int n = Bootstrap.directCOM(cOMPtr.unknown, 1);
        if (IdentityManager.traceRefs) {
            System.out.println(this + " AddRef = " + n);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[" + Integer.toHexString(this.peer) + "," + Integer.toHexString(this.unknown) + "]";
    }

    public synchronized int getPeer() {
        return this.peer;
    }

    public synchronized int getUnknown() {
        return this.unknown;
    }

    public synchronized IUnknown queryInterface(Class clazz) {
        return IdentityManager.queryInterface(clazz, this);
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
        if (this.unknown != 0 && IdentityManager.traceRefs) {
            System.err.println("****Failed to release reference to " + this);
        }
    }

    public synchronized void close() {
        this.releaseUnknown();
        if (this.peer != 0) {
            IdentityManager.DecRef(this.peer);
            this.peer = 0;
        }
    }

    protected void releaseUnknown() {
        if (this.unknown != 0) {
            int n = Bootstrap.directCOM(this.unknown, 2);
            if (IdentityManager.traceRefs) {
                System.out.println(this + " Release = " + n);
            }
        }
        this.unknown = 0;
    }

    public abstract int getGuidToken();
}

