/*
 * Decompiled with CFR 0.152.
 */
package com.develop.jawin.win32;

import com.develop.io.LittleEndianInputStream;
import com.develop.util.HexFormatter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Date;

public class EVENTLOGRECORD {
    public final int length;
    public final int recordNumber;
    final Date timeGenerated;
    final Date timeWritten;
    public final int eventID;
    public final short eventType;
    public final short eventCategory;
    final String[] strings;
    final byte[] bytes;
    public final String source;
    public final String computerName;

    public EVENTLOGRECORD(byte[] byArray) throws IOException {
        LittleEndianInputStream littleEndianInputStream = new LittleEndianInputStream(new ByteArrayInputStream(byArray));
        this.length = littleEndianInputStream.readInt();
        littleEndianInputStream.readInt();
        this.recordNumber = littleEndianInputStream.readInt();
        this.timeGenerated = new Date(1000L * (long)littleEndianInputStream.readInt());
        this.timeWritten = new Date(1000L * (long)littleEndianInputStream.readInt());
        this.eventID = littleEndianInputStream.readInt();
        this.eventType = littleEndianInputStream.readShort();
        int n = littleEndianInputStream.readShort();
        this.eventCategory = littleEndianInputStream.readShort();
        littleEndianInputStream.readShort();
        littleEndianInputStream.readInt();
        int n2 = littleEndianInputStream.readInt();
        int n3 = littleEndianInputStream.readInt();
        int n4 = littleEndianInputStream.readInt();
        int n5 = littleEndianInputStream.readInt();
        int n6 = littleEndianInputStream.readInt();
        this.source = littleEndianInputStream.readUnicodeSz(32);
        this.computerName = littleEndianInputStream.readUnicodeSz(32);
        this.strings = new String[n];
        if (n != 0) {
            LittleEndianInputStream littleEndianInputStream2 = new LittleEndianInputStream(new ByteArrayInputStream(byArray, n2, byArray.length - n2));
            int n7 = 0;
            while (n7 < n) {
                this.strings[n7] = littleEndianInputStream2.readUnicodeSz(32);
                ++n7;
            }
        }
        this.bytes = new byte[n5];
        if (n5 != 0) {
            System.arraycopy(byArray, n6, this.bytes, 0, n5);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("EVENTLOGRECORD source:" + this.source + " machine:" + this.computerName + "\n\tgenerated " + this.timeGenerated + "\n\twritten " + this.timeWritten);
        int n = this.strings.length;
        int n2 = 0;
        while (n2 < n) {
            stringBuffer.append("\n\t").append(this.strings[n2]);
            ++n2;
        }
        n = this.bytes.length;
        if (n > 0) {
            stringBuffer.append("\n\tRAW DATA:");
            stringBuffer.append(HexFormatter.convertBytesToString(this.bytes));
        }
        return stringBuffer.toString();
    }
}

