/*
 * Decompiled with CFR 0.152.
 */
package org.tritonus.sampled.convert;

import java.util.Collection;
import java.util.Iterator;
import javax.sound.sampled.AudioFormat;
import org.tritonus.sampled.convert.TFormatConversionProvider;
import org.tritonus.util.ArraySet;

public abstract class TSimpleFormatConversionProvider
extends TFormatConversionProvider {
    private Collection m_sourceEncodings = new ArraySet();
    private Collection m_targetEncodings = new ArraySet();
    private Collection m_sourceFormats;
    private Collection m_targetFormats;

    protected TSimpleFormatConversionProvider(Collection sourceFormats, Collection targetFormats) {
        this.m_sourceFormats = sourceFormats;
        this.m_targetFormats = targetFormats;
        TSimpleFormatConversionProvider.collectEncodings(this.m_sourceFormats, this.m_sourceEncodings);
        TSimpleFormatConversionProvider.collectEncodings(this.m_targetFormats, this.m_targetEncodings);
    }

    private static void collectEncodings(Collection formats, Collection encodings) {
        Iterator iterator = formats.iterator();
        while (iterator.hasNext()) {
            AudioFormat format = (AudioFormat)iterator.next();
            encodings.add(format.getEncoding());
        }
    }

    public AudioFormat.Encoding[] getSourceEncodings() {
        return this.m_sourceEncodings.toArray(TFormatConversionProvider.EMPTY_ENCODING_ARRAY);
    }

    public AudioFormat.Encoding[] getTargetEncodings() {
        return this.m_targetEncodings.toArray(TFormatConversionProvider.EMPTY_ENCODING_ARRAY);
    }

    public boolean isSourceEncodingSupported(AudioFormat.Encoding sourceEncoding) {
        return this.m_sourceEncodings.contains(sourceEncoding);
    }

    public boolean isTargetEncodingSupported(AudioFormat.Encoding targetEncoding) {
        return this.m_targetEncodings.contains(targetEncoding);
    }

    public AudioFormat.Encoding[] getTargetEncodings(AudioFormat sourceFormat) {
        if (this.isAllowedSourceFormat(sourceFormat)) {
            return this.getTargetEncodings();
        }
        return TFormatConversionProvider.EMPTY_ENCODING_ARRAY;
    }

    public AudioFormat[] getTargetFormats(AudioFormat.Encoding targetEncoding, AudioFormat sourceFormat) {
        if (this.isConversionSupported(targetEncoding, sourceFormat)) {
            return this.m_targetFormats.toArray(TFormatConversionProvider.EMPTY_FORMAT_ARRAY);
        }
        return TFormatConversionProvider.EMPTY_FORMAT_ARRAY;
    }

    protected boolean isAllowedSourceEncoding(AudioFormat.Encoding sourceEncoding) {
        return this.m_sourceEncodings.contains(sourceEncoding);
    }

    protected boolean isAllowedTargetEncoding(AudioFormat.Encoding targetEncoding) {
        return this.m_targetEncodings.contains(targetEncoding);
    }

    protected boolean isAllowedSourceFormat(AudioFormat sourceFormat) {
        Iterator iterator = this.m_sourceFormats.iterator();
        while (iterator.hasNext()) {
            AudioFormat format = (AudioFormat)iterator.next();
            if (!format.matches(sourceFormat)) continue;
            return true;
        }
        return false;
    }

    protected boolean isAllowedTargetFormat(AudioFormat targetFormat) {
        Iterator iterator = this.m_targetFormats.iterator();
        while (iterator.hasNext()) {
            AudioFormat format = (AudioFormat)iterator.next();
            if (!format.matches(targetFormat)) continue;
            return true;
        }
        return false;
    }

    protected Collection getCollectionSourceEncodings() {
        return this.m_sourceEncodings;
    }

    protected Collection getCollectionTargetEncodings() {
        return this.m_targetEncodings;
    }

    protected Collection getCollectionSourceFormats() {
        return this.m_sourceFormats;
    }

    protected Collection getCollectionTargetFormats() {
        return this.m_targetFormats;
    }
}

