/*
 * Decompiled with CFR 0.152.
 */
package javazoom.jlGui.tag;

import helliker.id3.ID3Exception;
import helliker.id3.ID3v2FormatException;
import helliker.id3.MP3File;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Header;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jlGui.tag.TagInfo;

public class MpegInfo
implements TagInfo {
    private String channels = null;
    private String version = null;
    private int rate = 0;
    private String layer = null;
    private String emphasis = null;
    private int nominalbitrate = 0;
    private long total = 0L;
    private String vendor = null;
    private String location = null;
    private long size = 0L;
    private boolean copyright = false;
    private boolean crc = false;
    private boolean original = false;
    private boolean priv = false;
    private boolean vbr = false;
    private int track = -1;
    private String year = null;
    private String genre = null;
    private String title = null;
    private String artist = null;
    private String album = null;
    private Vector comments = null;

    public MpegInfo(String string) throws JavaLayerException, IOException, ID3Exception {
        MP3File mP3File = null;
        File file = new File(string);
        this.size = file.length();
        this.location = string;
        FileInputStream fileInputStream = new FileInputStream(string);
        this.checkAudioFormat(fileInputStream);
        fileInputStream.close();
        mP3File = new MP3File(string);
        this.loadInfo(mP3File);
    }

    private void checkAudioFormat(InputStream inputStream) throws JavaLayerException {
        try {
            String[][] stringArrayArray = new String[][]{{"MpegEncoding.MPEG2L1", "MpegEncoding.MPEG2L2", "MpegEncoding.MPEG2L3"}, {"MpegEncoding.MPEG1L1", "MpegEncoding.MPEG1L2", "MpegEncoding.MPEG1L3"}, {"MpegEncoding.MPEG2DOT5L1", "MpegEncoding.MPEG2DOT5L2", "MpegEncoding.MPEG2DOT5L3"}};
            Bitstream bitstream = new Bitstream(inputStream);
            Header header = bitstream.readFrame();
            int n = header.version();
            int n2 = header.layer();
            n2 = header.layer();
            int n3 = header.sample_frequency();
            int n4 = header.mode();
            int n5 = header.calculate_framesize();
            if (n5 < 0) {
                throw new JavaLayerException("not a MPEG stream: invalid framelength");
            }
            int n6 = header.frequency();
            float f = (float)(1.0 / (double)header.ms_per_frame() * 1000.0);
            if (f < 0.0f) {
                throw new JavaLayerException("not a MPEG stream: invalid framerate");
            }
            int n7 = Header.bitrates[n][n2 - 1][header.bitrate_index()];
            if (n7 <= 0) {
                throw new JavaLayerException("not a MPEG stream: invalid bitrate");
            }
            int n8 = header.getSyncHeader();
            String string = stringArrayArray[n][n2 - 1];
            int n9 = n8 >> 19 & 3;
            if (n9 == 1) {
                throw new JavaLayerException("not a MPEG stream: wrong version");
            }
            int n10 = n8 >> 10 & 3;
            if (n10 == 3) {
                throw new JavaLayerException("not a MPEG stream: wrong sampling rate");
            }
        }
        catch (Exception exception) {
            throw new JavaLayerException(exception.getMessage());
        }
    }

    private void loadInfo(MP3File mP3File) throws ID3v2FormatException {
        this.rate = mP3File.getSampleRate();
        this.nominalbitrate = mP3File.getBitRate() * 1000;
        this.version = mP3File.getMPEGVersion();
        this.layer = mP3File.getMPEGLayer();
        this.copyright = mP3File.isMPEGCopyrighted();
        this.crc = mP3File.isMPEGProtected();
        this.original = mP3File.isMPEGOriginal();
        this.emphasis = mP3File.getMPEGEmphasis();
        this.channels = mP3File.getMPEGChannelMode();
        this.total = mP3File.getPlayingTime();
        this.vbr = mP3File.isVBR();
        this.album = mP3File.getAlbum();
        this.artist = mP3File.getArtist();
        this.title = mP3File.getTitle();
        this.genre = mP3File.getGenre();
        this.year = mP3File.getYear();
        this.track = mP3File.getTrack();
        this.comments = new Vector();
        this.comments.add(mP3File.getComment());
    }

    public boolean getVBR() {
        return this.vbr;
    }

    public String getChannels() {
        return this.channels;
    }

    public String getVersion() {
        return this.version;
    }

    public String getEmphasis() {
        return this.emphasis;
    }

    public boolean getCopyright() {
        return this.copyright;
    }

    public boolean getCRC() {
        return this.crc;
    }

    public boolean getOriginal() {
        return this.original;
    }

    public String getLayer() {
        return this.layer;
    }

    public long getSize() {
        return this.size;
    }

    public String getLocation() {
        return this.location;
    }

    public int getSamplingRate() {
        return this.rate;
    }

    public int getBitRate() {
        return this.nominalbitrate;
    }

    public long getPlayTime() {
        return this.total;
    }

    public String getTitle() {
        return this.title;
    }

    public String getArtist() {
        return this.artist;
    }

    public String getAlbum() {
        return this.album;
    }

    public int getTrack() {
        return this.track;
    }

    public String getGenre() {
        return this.genre;
    }

    public Vector getComment() {
        return this.comments;
    }

    public String getYear() {
        return this.year;
    }
}

