/*
 * Decompiled with CFR 0.152.
 */
package javazoom.Util.ini;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import javazoom.Util.ini.CRC32OutputStream;
import javazoom.Util.ini.SortedStrings;

public class Configuration {
    private File config_file = null;
    private URL config_url = null;
    private Hashtable props = new Hashtable(64);

    public Configuration(String string) {
        if (string.toLowerCase().startsWith("http")) {
            try {
                this.config_url = new URL(string);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.load();
        } else {
            this.config_file = new File(string);
            this.load();
        }
    }

    public Configuration(File file) {
        this.config_file = file;
        this.load();
    }

    public Configuration(URL uRL) {
        this.config_url = this.config_url;
        this.load();
    }

    public Configuration() {
        this.config_file = null;
    }

    public File getConfigFile() {
        return this.config_file;
    }

    public void add(String string, String string2) {
        this.props.put(string, string2);
    }

    public void add(String string, boolean bl) {
        this.props.put(string, bl ? "true" : "false");
    }

    public void add(String string, int n) {
        this.props.put(string, Integer.toString(n));
    }

    public void add(String string, double d) {
        this.props.put(string, Double.toString(d));
    }

    public String get(String string) {
        return (String)this.props.get(string);
    }

    public String get(String string, String string2) {
        Object v = this.props.get(string);
        return v != null ? (String)v : string2;
    }

    public boolean getBoolean(String string) {
        Object v = this.props.get(string);
        return v != null ? v.equals("true") : false;
    }

    public boolean getBoolean(String string, boolean bl) {
        Object v = this.props.get(string);
        return v != null ? v.equals("true") : bl;
    }

    public int getInt(String string) {
        try {
            return Integer.parseInt((String)this.props.get(string));
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public int getInt(String string, int n) {
        try {
            return Integer.parseInt((String)this.props.get(string));
        }
        catch (Exception exception) {
            return n;
        }
    }

    public double getDouble(String string) {
        try {
            return new Double((String)this.props.get(string));
        }
        catch (Exception exception) {
            return -1.0;
        }
    }

    public double getDouble(String string, double d) {
        try {
            return new Double((String)this.props.get(string));
        }
        catch (Exception exception) {
            return d;
        }
    }

    public void remove(String string) {
        this.props.remove(string);
    }

    public void removeAll() {
        this.props.clear();
    }

    public boolean load() {
        if (this.config_file == null && this.config_url == null) {
            return false;
        }
        if (this.config_url != null) {
            try {
                return this.load(new BufferedReader(new InputStreamReader(this.config_url.openStream())));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        }
        if (!this.config_file.exists()) {
            return false;
        }
        try {
            return this.load(new BufferedReader(new FileReader(this.config_file)));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public boolean load(BufferedReader bufferedReader) throws IOException {
        Hashtable hashtable = this.props;
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            int n = string.indexOf(61);
            if (n <= 0) continue;
            String string2 = string.substring(0, n).trim();
            String string3 = string.substring(n + 1).trim();
            hashtable.put(string2, string3);
        }
        bufferedReader.close();
        return true;
    }

    public boolean save() {
        if (this.config_url != null) {
            return false;
        }
        try {
            PrintWriter printWriter = new PrintWriter(new FileWriter(this.config_file));
            return this.save(printWriter);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public boolean save(PrintWriter printWriter) throws IOException {
        Hashtable hashtable = this.props;
        Enumeration enumeration = hashtable.keys();
        SortedStrings sortedStrings = new SortedStrings();
        while (enumeration.hasMoreElements()) {
            sortedStrings.add((String)enumeration.nextElement());
        }
        int n = 0;
        while (n < sortedStrings.stringCount()) {
            String string = sortedStrings.stringAt(n);
            String string2 = (String)hashtable.get(string);
            printWriter.print(string);
            printWriter.print("=");
            printWriter.println(string2);
            ++n;
        }
        printWriter.close();
        return true;
    }

    public void storeCRC() {
        this.add("crc", this.generateCRC());
    }

    public boolean isValidCRC() {
        String string = this.generateCRC();
        String string2 = (String)this.props.get("crc");
        if (string2 == null) {
            return false;
        }
        return string2.equals(string);
    }

    private String generateCRC() {
        Hashtable hashtable = this.props;
        CRC32OutputStream cRC32OutputStream = new CRC32OutputStream();
        PrintWriter printWriter = new PrintWriter(cRC32OutputStream);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equals("crc")) continue;
            printWriter.println((String)hashtable.get(string));
        }
        printWriter.flush();
        return "" + cRC32OutputStream.getValue();
    }
}

