//----------------------------------------------------------
HRESULT SetRMRenderState(
  LPDIRECT3DRMDEVICE IRMDevice,
  D3DRENDERSTATETYPE RST, DWORD RS)
{
  if (!IRMDevice) return DDERR_INVALIDPARAMS;
  LPDIRECT3DDEVICE IDev = NULL;
  HRESULT hr = IRMDevice->GetDirect3DDevice(&IDev);
  if (HR_FAILED(hr)) return hr;
  hr = SetRenderState(IDev, RST, RS);
  RELEASE(IDev);
  return hr;
}//---------------------------------------------------------
HRESULT SetRenderState(
  LPDIRECT3DDEVICE IDevice,
  D3DRENDERSTATETYPE RST, DWORD RS)
{
  HRESULT hr;
  size_t size      = 0;//   
  WORD state_count = 3;//    STATE_DATA()
  WORD instr_count = 2;//    OP_STATE_RENDER()
  LPDIRECT3DVIEWPORT IView = NULL;
  LPDIRECT3DEXECUTEBUFFER IExBuf = NULL;

  if (!IDevice) return DDERR_INVALIDPARAMS;
  try { //     :
     hr = IDevice->NextViewport(NULL, &IView, D3DNEXT_HEAD);
  } catch (...) {hr = D3DRMERR_NOTDONEYET;}
  if (HR_FAILED(hr)) goto end;

  //     :
  size += sizeof(D3DINSTRUCTION) * instr_count;
  size += sizeof(D3DSTATE)       * state_count;
  //    :
  D3DEXECUTEBUFFERDESC ExDesc;
  memset(&ExDesc, 0, sizeof(D3DEXECUTEBUFFERDESC));
  ExDesc.dwSize  = sizeof(D3DEXECUTEBUFFERDESC);
  ExDesc.dwFlags = D3DDEB_BUFSIZE;
  ExDesc.dwBufferSize = size;
  //     :
  hr= IDevice->CreateExecuteBuffer(&ExDesc, &IExBuf, NULL);
  if (HR_FAILED(hr)) goto end;

  //    :
  hr = IExBuf->Lock(&ExDesc);
  if (HR_FAILED(hr)) goto end;
  //   :
  memset(ExDesc.lpData, 0, size);

  LPVOID pBuffer, pInsert;
  pInsert = ExDesc.lpData;
  pBuffer = pInsert;

  OP_STATE_RENDER(state_count, pBuffer);
    //   
    STATE_DATA(D3DSTATE_OVERRIDE(RST), FALSE, pBuffer);
    //    
    STATE_DATA(RST, RS, pBuffer);
    //   
    STATE_DATA(D3DSTATE_OVERRIDE(RST), TRUE, pBuffer);
  OP_EXIT(pBuffer);

  //    :
  hr = IExBuf->Unlock();
  if (HR_FAILED(hr)) goto end;

  D3DEXECUTEDATA ExData;
  memset(&ExData, 0, sizeof(D3DEXECUTEDATA));
  ExData.dwSize = sizeof(D3DEXECUTEDATA);
  ExData.dwInstructionOffset = (ULONG) 0;
  ExData.dwInstructionLength =
           (ULONG) ((char*)pBuffer - (char*)pInsert);

  IExBuf->SetExecuteData(&ExData);

  hr = IDevice->BeginScene();
  if (HR_FAILED(hr)) goto end;

  //   -> UNCLIPPED
  hr=IDevice->Execute(IExBuf, IView, D3DEXECUTE_UNCLIPPED);
  if (HR_FAILED(hr)) goto end;

  hr = IDevice->EndScene();
  if (HR_FAILED(hr)) goto end;

  end:
  RELEASE(IExBuf);
  RELEASE(IView);
  return hr;
}//---------------------------------------------------------
HRESULT SetLightState(
  LPDIRECT3DDEVICE  IDevice,
  D3DLIGHTSTATETYPE LST, DWORD LS)
{
  //   SetRenderState()
/*
  OP_STATE_LIGHT(3, pBuffer);
    STATE_DATA(D3DSTATE_OVERRIDE(LST), FALSE, pBuffer);
    STATE_DATA(LST, LS, pBuffer);
    STATE_DATA(D3DSTATE_OVERRIDE(LST), TRUE, pBuffer);
  OP_EXIT(pBuffer);
*/
  return DD_OK;
}//---------------------------------------------------------