void BuilderRotate(LPDIRECT3DRMMESHBUILDER  IBuilder,
                   D3DVALUE x, D3DVALUE y, D3DVALUE z,
                   D3DVALUE theta)
{
  if (!IBuilder) return;
  if (!(x+y+z) && !theta) return;

  D3DVECTOR *vlist;
  DWORD vcount, ncount , flsize;
  IBuilder->GetVertices(&vcount, NULL,
                        &ncount, NULL,
                        &flsize, NULL);
  vlist = new D3DVECTOR[vcount];
  IBuilder->GetVertices(&vcount, vlist,
                        &ncount, NULL,
                        &flsize, NULL);
  D3DVALUE new_x, new_y, new_z;
  D3DVECTOR norm_result, axis;
  axis.x = x;  axis.y = y;  axis.z = z;
  for (DWORD i = 0; i < vcount; i++) {
     LPD3DVECTOR lpr;
     D3DVALUE modulus = D3DRMVectorModulus(&vlist[i]);
     lpr = D3DRMVectorRotate(
                     &norm_result, &vlist[i], &axis, theta);
     assert(lpr);
     new_x = modulus * norm_result.x;
     new_y = modulus * norm_result.y;
     new_z = modulus * norm_result.z;
     IBuilder->SetVertex(i, new_x, new_y, new_z);
  }
  delete[] vlist;
}//---------------------------------------------------------
