HRESULT FrameGetBox(LPDIRECT3DRMFRAME IFrame,
                     D3DRMBOX *pBox)
{
  if (!IFrame || !pBox) return D3DRMERR_BADVALUE;
  LPDIRECT3DRM IRM = NULL;
  HRESULT hr;
  hr = Direct3DRMCreate(&IRM);
  if (HR_FAILED(hr)) return hr;
  LPDIRECT3DRMMESHBUILDER Ibuilder = NULL;
  hr = IRM->CreateMeshBuilder(&Ibuilder);
  if (HR_FAILED(hr)) {IRM->Release(); return hr;}
  hr = Ibuilder->AddFrame(IFrame);
  if (HR_FAILED(hr)) {
     Ibuilder->Release();
     IRM->Release();
     return hr;
  }
  Ibuilder->GetBox(pBox);
  Ibuilder->Release();
  IRM->Release();
  return D3DRM_OK;
}//---------------------------------------------------------
void FrameProjection(LPDIRECT3DRMFRAME IFrame,
                     LPDIRECT3DRMVIEWPORT IRMVport,
                     PROJECTION proj)
{
  if (!IFrame || !IRMVport) return;
  D3DRMBOX scene_box, frame_box;
  FrameGetBox(IFrame, &frame_box);
  IFrame->Transform(&scene_box.min, &frame_box.min);
  IFrame->Transform(&scene_box.max, &frame_box.max);
  BoxProjection(&scene_box, IRMVport, proj);
}//---------------------------------------------------------
void BuilderProjection(LPDIRECT3DRMMESHBUILDER IBuilder,
           LPDIRECT3DRMVIEWPORT IRMVport,
           PROJECTION proj)
{
  if (!IBuilder || !IRMVport) return;
  D3DRMBOX Box;
  IBuilder->GetBox(&Box);
  BoxProjection(&Box, IRMVport, proj);
}//---------------------------------------------------------
// .      
//    

//      ,  
//        
// 
void BoxProjection(D3DRMBOX *pBox,
                   LPDIRECT3DRMVIEWPORT IRMVport,
                   PROJECTION proj)
{
  if (!pBox || !IRMVport) return;

  //      
  //     :
  D3DVECTOR dif;
  D3DRMVectorSubtract(&dif, &pBox->max, &pBox->min);

  //    :
  D3DVALUE diag = D3DRMVectorModulus(&dif);

  //   :
  D3DVECTOR center;
  D3DRMVectorAdd(&center, &pBox->max, &pBox->min);
  D3DRMVectorScale(&center, &center, 0.5);

  //    :
  D3DVALUE vback  = IRMVport->GetBack();
  D3DVALUE vfront = IRMVport->GetFront();
  D3DVALUE vfield = IRMVport->GetField();

  //  ,      :
  if (diag == 0) diag = 1;

  //  ,    
  //      :
  D3DVALUE dist = (diag * vfront) / (2 * vfield);
  //       
  //   :
  if (vback < (dist+diag*2)) IRMVport->SetBack(dist+diag*2);

  //       
  //    :
  D3DRMPROJECTIONTYPE prjt = IRMVport->GetProjection();
  if (prjt == D3DRMPROJECT_ORTHOGRAPHIC)
     IRMVport->SetField(diag / 2);

  //         
  //   :
  LPDIRECT3DRMFRAME ICam = NULL;
  LPDIRECT3DRMFRAME IPar = NULL;
  IRMVport->GetCamera(&ICam);
  ICam->GetParent(&IPar);

  //     
  //      
  // :
  if (ICam && IPar) {
     switch (proj) {
        case PROJECTION_POSX:
           ICam->SetOrientation(IPar, -1,0,0, 0,0,1);
        break;
        case PROJECTION_NEGX:
           ICam->SetOrientation(IPar, 1,0,0, 0,0,1);
        break;
        case PROJECTION_POSY:
           ICam->SetOrientation(IPar, 0,-1,0, 0,0,1);
        break;
        case PROJECTION_NEGY:
           ICam->SetOrientation(IPar, 0,1,0, 0,0,1);
        break;
        case PROJECTION_POSZ:
           ICam->SetOrientation(IPar, 0,0,-1,0,-1,0);
        break;
        case PROJECTION_NEGZ:
           ICam->SetOrientation(IPar, 0,0,1,0,1,0);
        break;
        case PROJECTION_POS:
           ICam->SetOrientation(IPar,
                          - dif.x, - dif.y, - dif.z, 0,0,1);
        break;
        case PROJECTION_NEG:
           ICam->SetOrientation(IPar,
                                dif.x, dif.y, dif.z, 0,0,1);
        break;
     } // switch (proj)

     //      :
     ICam->SetPosition(IPar, center.x, center.y, center.z);

     //     
     //  ,   , 
     // ,      :
     ICam->AddTranslation(D3DRMCOMBINE_BEFORE,0,0,-dist-diag);
  }

  //   :
  RELEASE(ICam);
  RELEASE(IPar);
}//---------------------------------------------------------
void ViewBox(D3DRMBOX &Box,
               LPDIRECT3DRMVIEWPORT IRMVport,
               D3DVALUE x,  D3DVALUE y,  D3DVALUE z,
               D3DVALUE rx, D3DVALUE ry, D3DVALUE rz)
{
  if (!IRMVport) return;
  D3DVECTOR dif;
  D3DRMVectorSubtract(&dif, &Box.max, &Box.min);
  D3DVALUE diag = D3DRMVectorModulus(&dif);
  D3DVECTOR center;
  D3DRMVectorAdd(&center, &Box.max, &Box.min);
  D3DRMVectorScale(&center, &center, 0.5);
  D3DVALUE vback  = IRMVport->GetBack();
  D3DVALUE vfront = IRMVport->GetFront();
  D3DVALUE vfield = IRMVport->GetField();
  if (diag == 0) diag = 1;
  D3DVALUE dist = (diag * vfront) / (2 * vfield);
  if (vback < (dist+diag*2)) IRMVport->SetBack(dist+diag*2);
  D3DRMPROJECTIONTYPE prjt = IRMVport->GetProjection();
  if (prjt == D3DRMPROJECT_ORTHOGRAPHIC)
     IRMVport->SetField(diag / 2);
  LPDIRECT3DRMFRAME ICam   = NULL;
  LPDIRECT3DRMFRAME IPar   = NULL;
  IRMVport->GetCamera(&ICam);
  ICam->GetParent(&IPar);
  if (ICam && IPar) {
     ICam->SetOrientation(IPar,
                    -diag*x, -diag*y, -diag*z, rx,ry,rz);
     ICam->SetPosition(IPar, center.x, center.y, center.z);
     ICam->AddTranslation(D3DRMCOMBINE_BEFORE,0,0,-dist-diag);
  }
  RELEASE(ICam);
  RELEASE(IPar);
}//---------------------------------------------------------
void ViewPoint(LPDIRECT3DRMFRAME IFrame,
               LPDIRECT3DRMVIEWPORT IRMVport,
               D3DVALUE x,  D3DVALUE y,  D3DVALUE z,
               D3DVALUE rx, D3DVALUE ry, D3DVALUE rz)
{
  if (!IFrame) return;
  D3DRMBOX Box;
  FrameGetBox(IFrame, &Box);
  ViewBox(Box, IRMVport,
                x,  y,  z,
               rx, ry, rz);
}//---------------------------------------------------------