//----------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop
#include "D3dUtil.h"
#include "DXEnum.h"
//----------------------------------------------------------
TStrings *DdDescriptions  = NULL;
TStrings *VideoModes      = NULL;
TStrings *D3dDescriptions = NULL;
//----------------------------------------------------------
void ResetDdDescriptions() {
  if (!DdDescriptions) {
     DdDescriptions = new TStringList;
     return;
  }
  for (int i = 0; i < DdDescriptions->Count; i++) {
     if (DdDescriptions->Objects[i])
        delete (TDDDesc*)DdDescriptions->Objects[i];
  }
  DdDescriptions->Clear();
}//---------------------------------------------------------
void ResetD3dDescriptions() {
  if (!D3dDescriptions) {
     D3dDescriptions = new TStringList;
     return;
  }
  for (int i = 0; i < D3dDescriptions->Count; i++) {
     if (D3dDescriptions->Objects[i])
        delete (TD3DDesc*)D3dDescriptions->Objects[i];
  }
  D3dDescriptions->Clear();
}//---------------------------------------------------------
void ResetVideoModes() {
  if (!VideoModes) {
     VideoModes = new TStringList;
     return;
  }
  for (int i = 0; i < VideoModes->Count; i++) {
     if (VideoModes->Objects[i])
        delete (TModeDesc*)VideoModes->Objects[i];
  }
  VideoModes->Clear();
}//---------------------------------------------------------
//      DirectX
BOOL WINAPI DDEnumCallback(LPGUID guid, LPSTR about,
   LPSTR name, LPVOID /*arg*/)
{
  //      guid
  // TRACE("about=" << about << "  name=" << name);
  // WARN(!guid, "No guid");
  LPDIRECTDRAW IDD;
  DDCAPS DriverCaps, HELCaps;
  HRESULT hr = DirectDrawCreate(guid, &IDD, NULL);
  WARN(HR_FAILED(hr), "DirectDrawCreate failed");
  if (HR_FAILED(hr)) return DDENUMRET_OK;
  memset(&DriverCaps, 0, sizeof(DDCAPS));
  DriverCaps.dwSize = sizeof(DDCAPS);
  memset(&HELCaps, 0, sizeof(DDCAPS));
  HELCaps.dwSize = sizeof(DDCAPS);
  hr = IDD->GetCaps(&DriverCaps, &HELCaps);
  if (HR_FAILED(hr)) {
     RELEASE(IDD);
     return DDENUMRET_OK;
  }

  wchar_t *sguid;
  if (guid) StringFromIID(*guid, &sguid);
  else sguid = NULL;
  TDDDesc *DDDesc = new TDDDesc;
  DDDesc->guid  = guid;
  DDDesc->about = AnsiString(about);
  DDDesc->name  = AnsiString(name);
  memcpy(&DDDesc->HELCaps,    &HELCaps,    sizeof(DDCAPS));
  memcpy(&DDDesc->DriverCaps, &DriverCaps, sizeof(DDCAPS));

  DdDescriptions->AddObject(sguid, (TObject*)DDDesc);

  RELEASE(IDD);
  //   
  return DDENUMRET_OK;
}//---------------------------------------------------------
//      Direct3D
HRESULT WINAPI D3DEnumDevicesCallback(
  LPGUID guid, LPSTR about, LPSTR name,
  LPD3DDEVICEDESC hw_d3ddesc,
  LPD3DDEVICEDESC hel_d3ddesc, LPVOID /*arg*/)
{
  wchar_t *sguid;
  StringFromIID(*guid, &sguid);
  TD3DDesc *D3DDesc = new TD3DDesc;
  D3DDesc->guid  = guid;
  D3DDesc->about = AnsiString(about);
  D3DDesc->name  = AnsiString(name);

  LPD3DDEVICEDESC d3ddesc;
  if (hw_d3ddesc->dcmColorModel) {
     d3ddesc = hw_d3ddesc;
     D3DDesc->IsHardware = true;
  } else {
     d3ddesc = hel_d3ddesc;
     D3DDesc->IsHardware = false;
  }
  memcpy(&D3DDesc->d3ddesc, d3ddesc, sizeof(D3DDEVICEDESC));

  D3dDescriptions->AddObject(sguid, (TObject*)D3DDesc);
  //   
  return D3DENUMRET_OK;
}//---------------------------------------------------------
//   
HRESULT WINAPI EnumModesCallback(LPDDSURFACEDESC ddsd,
  LPVOID arg)
{
  TEnumModesArg *marg = (TEnumModesArg*)arg;
  if (!marg) return DDENUMRET_OK;
  
  //     :
  if (marg && marg->D3DDesc->IsHardware) {
     //      DirectDraw:
     DWORD dwVidRamNeeded = ddsd->dwWidth * ddsd->dwHeight *
                3 * ddsd->ddpfPixelFormat.dwRGBBitCount / 8;
     if (dwVidRamNeeded >
                (marg->ddcaps->dwVidMemFree + marg->GDIMem))
     return DDENUMRET_OK; // , 
     //    .
     //    ,   
     //  Direct3D:
     DWORD rbd =
              marg->D3DDesc->d3ddesc.dwDeviceRenderBitDepth;
     switch (ddsd->ddpfPixelFormat.dwRGBBitCount) {
        case 8 :
           if (!(rbd & DDBD_8)) return DDENUMRET_OK;  break;
        case 16 :
           if (!(rbd & DDBD_16)) return DDENUMRET_OK; break;
        case 24 :
           if (!(rbd & DDBD_24)) return DDENUMRET_OK; break;
        case 32 :
           if (!(rbd & DDBD_32)) return DDENUMRET_OK; break;
     } // switch
  } // if marg && IsHardware

  //      :
  TModeDesc *mdesc = new TModeDesc;
  mdesc->width     = ddsd->dwWidth;
  mdesc->height    = ddsd->dwHeight;
  mdesc->RGBbits   = ddsd->ddpfPixelFormat.dwRGBBitCount;

  char buf[512];
  if ((mdesc->width   == 320) && (mdesc->RGBbits == 8) &&
      ((mdesc->height == 200) || (mdesc->height  == 240))
  )
     sprintf(buf, "%dx%dx%d (ModeX)",
               mdesc->width, mdesc->height, mdesc->RGBbits);
  else
     sprintf(buf, "%dx%dx%d",
               mdesc->width, mdesc->height, mdesc->RGBbits);
  VideoModes->AddObject(AnsiString(buf), (TObject*)mdesc);
  //   
  return DDENUMRET_OK;
}//---------------------------------------------------------
static void RMTraceFunc(LPDIRECT3DRMOBJECT obj, LPVOID arg){
#ifdef __TRACE
  TRACE("Found " << RMClassName(obj) << " " << RMName(obj));
#endif
}//---------------------------------------------------------
void RMTraceObjects(LPDIRECT3DRM IRM) {
#ifdef __TRACE
  if (!IRM) return;
  TRACE("Starting enumerating RM objects:");
  IRM->EnumerateObjects(RMTraceFunc,NULL);
  TRACE("Finished enumerating RM objects:");
#endif
}//---------------------------------------------------------
