/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.ui;

import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

class Region
implements Cloneable,
Serializable {
    protected Vector rects = new Vector();

    public Region() {
    }

    public Region(Rectangle r2) {
        this.addRectangle(r2);
    }

    public Region(Rectangle r1, Rectangle r2) {
        this.addRectangle(r1);
        this.addRectangle(r2);
    }

    public boolean isEmpty() {
        return this.rects.isEmpty();
    }

    public int getNumRectangles() {
        return this.rects.size();
    }

    public Enumeration rectangles() {
        return this.rects.elements();
    }

    public Object clone() {
        Region r2 = new Region();
        r2.rects = (Vector)this.rects.clone();
        return r2;
    }

    public Rectangle getBounds() {
        Rectangle r2 = new Rectangle();
        int i2 = 0;
        while (i2 < this.rects.size()) {
            r2 = r2.union((Rectangle)this.rects.elementAt(i2));
            ++i2;
        }
        return r2;
    }

    public void addRectangle(Rectangle r2) {
        int position = 0;
        while (position < this.rects.size()) {
            Rectangle current = (Rectangle)this.rects.elementAt(position);
            if (r2.x > current.x && r2.y > current.y && Region.right(r2) <= Region.right(current) && Region.bottom(r2) <= Region.bottom(current)) {
                return;
            }
            if (r2.intersects(current)) {
                r2 = r2.union(current);
                this.rects.removeElementAt(position);
                continue;
            }
            ++position;
        }
        this.rects.addElement(r2);
    }

    public boolean intersects(Rectangle r2) {
        int position = 0;
        while (position < this.rects.size()) {
            Rectangle rect = (Rectangle)this.rects.elementAt(position);
            if (rect.intersects(r2)) {
                return true;
            }
            ++position;
        }
        return false;
    }

    public void intersect(Rectangle r2) {
        int position = 0;
        while (position < this.rects.size()) {
            Rectangle rect = (Rectangle)this.rects.elementAt(position);
            if ((rect = rect.intersection(r2)).isEmpty()) {
                this.rects.removeElementAt(position);
                continue;
            }
            this.rects.setElementAt(rect, position);
            ++position;
        }
    }

    public void addRegion(Region r2) {
        Enumeration e2 = r2.rectangles();
        while (e2.hasMoreElements()) {
            this.addRectangle((Rectangle)e2.nextElement());
        }
    }

    public void translate(int dx, int dy) {
        int p2 = 0;
        while (p2 < this.rects.size()) {
            Rectangle r2 = (Rectangle)this.rects.elementAt(p2);
            r2.translate(dx, dy);
            ++p2;
        }
    }

    public String toString() {
        String s = String.valueOf(this.getClass().getName()) + " = [\n";
        Enumeration e2 = this.rectangles();
        while (e2.hasMoreElements()) {
            s = String.valueOf(s) + "(" + (Rectangle)e2.nextElement() + ")\n";
        }
        return String.valueOf(s) + "]";
    }

    public static int right(Rectangle r2) {
        return r2.x + r2.width - 1;
    }

    public static int bottom(Rectangle r2) {
        return r2.y + r2.height - 1;
    }
}

