/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.codec.audio.mpa;

import com.sun.media.JMFSecurityManager;
import com.sun.media.codec.audio.AudioCodec;
import com.sun.media.codec.audio.mpa.MpegAudio;
import com.sun.media.util.Arch;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.ResourceUnavailableException;
import javax.media.format.AudioFormat;

public class NativeDecoder
extends AudioCodec {
    private int pendingDataSize;
    private static final int OUTSIZE = 32768;
    private byte[] pendingData = new byte[131072];
    private MpegAudio mpa;
    private int nativeData;
    private boolean expectingSameInputBuffer = false;
    int[] inRead = new int[1];
    int[] inReq = new int[1];
    int[] outWritten = new int[1];

    public NativeDecoder() {
        this.inputFormats = new Format[]{new AudioFormat("mpeglayer3", 16000.0, -1, -1, -1, 1), new AudioFormat("mpeglayer3", 22050.0, -1, -1, -1, 1), new AudioFormat("mpeglayer3", 24000.0, -1, -1, -1, 1), new AudioFormat("mpeglayer3", 32000.0, -1, -1, -1, 1), new AudioFormat("mpeglayer3", 44100.0, -1, -1, -1, 1), new AudioFormat("mpeglayer3", 48000.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 16000.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 22050.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 24000.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 32000.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 44100.0, -1, -1, -1, 1), new AudioFormat("mpegaudio", 48000.0, -1, -1, -1, 1)};
    }

    public String getName() {
        return "MPEG Layer 3 Decoder";
    }

    public Format[] getSupportedOutputFormats(Format input) {
        if (input == null) {
            return new Format[]{new AudioFormat("LINEAR")};
        }
        if (input instanceof AudioFormat) {
            AudioFormat af = (AudioFormat)input;
            AudioFormat output = new AudioFormat("LINEAR", af.getSampleRate(), af.getSampleSizeInBits(), af.getChannels(), Arch.isBigEndian() ? 1 : 0, 1);
            this.outputFormats = new Format[]{output};
        } else {
            this.outputFormats = new Format[0];
        }
        return this.outputFormats;
    }

    public synchronized void open() throws ResourceUnavailableException {
        if (this.nativeData != 0) {
            this.close();
        }
        try {
            JMFSecurityManager.loadLibrary("jmutil");
            JMFSecurityManager.loadLibrary("jmmpa");
            this.mpa = new MpegAudio();
            this.nativeData = MpegAudio.nOpen(new int[1]);
            if (this.nativeData == 0) {
                throw new ResourceUnavailableException("could not open " + this.getName());
            }
            this.pendingDataSize = 0;
            this.expectingSameInputBuffer = false;
            return;
        }
        catch (Throwable throwable) {
            throw new ResourceUnavailableException("could not open " + this.getName());
        }
    }

    public synchronized void close() {
        if (this.nativeData != 0) {
            MpegAudio.nClose(this.nativeData);
            this.nativeData = 0;
        }
    }

    public synchronized void reset() {
        block2: {
            if (this.nativeData == 0) break block2;
            this.close();
            try {
                this.open();
            }
            catch (ResourceUnavailableException rue) {
                System.err.println("MP3 Decoder: " + rue);
            }
        }
    }

    public synchronized int process(Buffer in, Buffer out) {
        if (this.isEOM(in)) {
            this.propagateEOM(out);
            return 0;
        }
        Object inObject = in.getData();
        Object outObject = out.getData();
        if (outObject == null) {
            outObject = new byte[32768];
            out.setData(outObject);
        }
        if (!(inObject instanceof byte[]) || !(outObject instanceof byte[])) {
            return 1;
        }
        byte[] inData = (byte[])inObject;
        byte[] outData = (byte[])outObject;
        int inLength = in.getLength();
        int outdataSize = outData.length;
        int outOffset = 0;
        int pendingDataOffset = 0;
        if (!this.expectingSameInputBuffer) {
            System.arraycopy(inData, 0, this.pendingData, this.pendingDataSize, inLength);
            this.pendingDataSize += inLength;
            this.expectingSameInputBuffer = false;
        }
        this.inReq[0] = 21;
        if (this.nativeData != 0) {
            while (outOffset + 5000 <= outdataSize && this.pendingDataSize >= this.inReq[0]) {
                boolean returnVal = MpegAudio.nConvert(this.nativeData, this.pendingData, pendingDataOffset, this.pendingDataSize, outData, outOffset, outdataSize - outOffset, this.inRead, this.outWritten, pendingDataOffset, this.inReq);
                if (returnVal) {
                    if (this.inRead[0] > this.pendingDataSize) {
                        System.out.println("mpa error: Read more than available !");
                        break;
                    }
                    outOffset += this.outWritten[0];
                    pendingDataOffset += this.inRead[0];
                    this.pendingDataSize -= this.inRead[0];
                    if (this.inReq[0] != 0) continue;
                    this.inReq[0] = 21;
                    continue;
                }
                if (outOffset > 0) break;
                return 1;
            }
        }
        if (pendingDataOffset != 0) {
            System.arraycopy(this.pendingData, pendingDataOffset, this.pendingData, 0, this.pendingDataSize);
        }
        out.setLength(outOffset);
        out.setFormat(this.outputFormat);
        if (this.pendingDataSize > 1024) {
            this.expectingSameInputBuffer = true;
            return 2;
        }
        this.expectingSameInputBuffer = false;
        return 0;
    }
}

