/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.media.bean.multiplayer;

import com.ibm.media.bean.multiplayer.ImageButton;
import com.ibm.media.bean.multiplayer.JMFUtil;
import com.ibm.media.bean.multiplayer.MediaGroup;
import com.ibm.media.bean.multiplayer.RelatedLink;
import java.applet.Applet;
import java.applet.AppletContext;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.beans.Beans;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import javax.media.ClockStartedError;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.EndOfMediaEvent;
import javax.media.Time;
import javax.media.bean.playerbean.MediaPlayer;

public class MultiPlayerBean
extends Panel
implements ActionListener,
Serializable,
ControllerListener,
ComponentListener {
    transient Panel buttonPanel;
    transient Panel gifPanel;
    transient Panel scrollPanel;
    transient Panel utilPanel;
    transient Panel videoPanel;
    transient ImageButton up;
    transient ImageButton down;
    transient ImageButton left;
    transient ImageButton right;
    private MediaPlayer currentPlayer;
    transient Button infoButton;
    transient GridBagLayout gridbag = new GridBagLayout();
    transient GridBagConstraints constraint = new GridBagConstraints();
    private final String infoWindow = JMFUtil.getString("Info");
    private URL currentU;
    private boolean displayURL = false;
    private boolean panelVisible = true;
    private boolean fitVideo = true;
    private boolean looping = true;
    private boolean sequential = true;
    private URL mpCodeBase;
    private AppletContext mpAppletContext;
    private int currentNum;
    private int numOfClips;
    protected int numOfMGroups;
    private int preferredHeight = 400;
    private int preferredWidth = 300;
    private String linksString;
    private String[] mediaNames;
    private String[] links;
    public MediaGroup[] mGroups;
    private int maxMediaGroup = 10;
    private boolean loadOnInit = false;
    private boolean fixAspectRatio = true;
    private int startingButton = 1;
    private String buttonPosition = JMFUtil.getString("SOUTH");
    private int tabsize = 16;
    private boolean msVM = false;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public MultiPlayerBean() {
        this.setup();
    }

    private void getContext(Object parent) {
        if (parent == null) {
            parent = this.getParent();
        }
        if (this.mpCodeBase != null) {
            return;
        }
        if (parent instanceof Applet) {
            this.mpCodeBase = ((Applet)parent).getCodeBase();
            this.mpAppletContext = ((Applet)parent).getAppletContext();
        }
    }

    private void setup() {
        this.getContext(null);
        if (!JMFUtil.msVersion()) {
            this.msVM = false;
            this.doDebug("Not Microsoft VM");
        } else {
            this.msVM = true;
            this.doDebug("Microsoft VM");
        }
        this.setLayout(new BorderLayout(0, 0));
        this.setBackground(this.getBackground());
        this.currentPlayer = null;
        this.buttonPanel = new Panel();
        this.buttonPanel.setLayout(new BorderLayout(0, 0));
        this.buttonPanel.setBackground(this.getBackground());
        this.buttonPanel.setVisible(false);
        this.gifPanel = new Panel();
        this.gifPanel.setBackground(this.getBackground());
        this.gifPanel.setVisible(false);
        this.gifPanel.addComponentListener(this);
        this.scrollPanel = new Panel();
        this.scrollPanel.setLayout(new BorderLayout(0, 0));
        this.scrollPanel.setBackground(this.getBackground());
        this.scrollPanel.add("Center", this.gifPanel);
        this.buttonPanel.add("Center", this.scrollPanel);
        this.infoButton = new Button(JMFUtil.getString("Link"));
        this.infoButton.setActionCommand("info");
        this.infoButton.addActionListener(this);
        this.infoButton.setEnabled(true);
        this.infoButton.setVisible(true);
        this.utilPanel = new Panel();
        this.utilPanel.setBackground(this.getBackground());
        this.utilPanel.setVisible(false);
        this.utilPanel.add("Center", this.infoButton);
        this.videoPanel = new 1();
        this.videoPanel.setBounds(this.getBounds().x, this.getBounds().y, this.getSize().width, this.getSize().height - this.buttonPanel.getSize().height);
        this.videoPanel.setLayout(new BorderLayout(0, 0));
        this.videoPanel.setBackground(this.getBackground());
        this.videoPanel.setVisible(true);
        this.utilPanel.setVisible(true);
        this.buttonPanel.setVisible(true);
        this.videoPanel.validate();
        this.setLayout(new BorderLayout());
        this.position();
    }

    private void position() {
        this.remove(this.videoPanel);
        this.remove(this.buttonPanel);
        if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("WEST"))) {
            this.add("Center", this.videoPanel);
            this.add("West", this.buttonPanel);
        } else if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("EAST"))) {
            this.add("Center", this.videoPanel);
            this.add("East", this.buttonPanel);
        } else if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("SOUTH"))) {
            this.add("Center", this.videoPanel);
            this.add("South", this.buttonPanel);
        } else if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("NORTH"))) {
            this.add("Center", this.videoPanel);
            this.add("North", this.buttonPanel);
        } else {
            this.add("Center", this.videoPanel);
        }
        this.updateGifPanel();
    }

    private void createLeftRight(int height) {
        this.left = new ImageButton("<", true, this.tabsize, height);
        this.right = new ImageButton(">", true, this.tabsize, height);
        this.left.setActionCommand("left");
        this.right.setActionCommand("right");
        this.left.addActionListener(this);
        this.right.addActionListener(this);
        this.left.setBackground(Color.lightGray);
        this.right.setBackground(Color.lightGray);
    }

    private void createUpDown(int width) {
        this.up = new ImageButton("UP", true, width, this.tabsize);
        this.down = new ImageButton("DOWN", true, width, this.tabsize);
        this.up.setActionCommand("up");
        this.down.setActionCommand("down");
        this.up.addActionListener(this);
        this.down.addActionListener(this);
        this.up.setBackground(Color.lightGray);
        this.down.setBackground(Color.lightGray);
    }

    public void start() {
        this.doDebug("in start()");
        if (this.loadOnInit) {
            int i2 = 0;
            while (i2 < this.numOfMGroups) {
                this.mGroups[i2].setPlayer(this.formPlayer(this.mGroups[i2].mediaName));
                ++i2;
            }
        }
        this.videoPanel.setBounds(this.getBounds().x, this.getBounds().y, this.getSize().width, this.getSize().height - this.buttonPanel.getSize().height);
        this.videoPanel.setVisible(true);
        this.pauseCurrent();
        this.setPlayer(1);
        this.validate();
        this.repaint();
    }

    public void stop() {
        this.doDebug("in stop()");
        if (this.currentPlayer != null) {
            this.currentPlayer.stop();
        }
    }

    public void destroy() {
        this.doDebug("in destroy()");
        this.currentPlayer.stop();
        this.currentPlayer.close();
        this.numOfClips = 0;
        System.out.println("out destroy");
    }

    public synchronized void controllerUpdate(ControllerEvent evt) {
        if (evt instanceof EndOfMediaEvent) {
            if (!this.looping && this.currentPlayer != null) {
                this.currentPlayer.setMediaTime(new Time(0L));
            }
            if (this.sequential) {
                this.nextPlayer();
            }
        }
    }

    public void actionPerformed(ActionEvent e2) {
        if (e2.getActionCommand().equalsIgnoreCase("info") && this.mpAppletContext != null) {
            this.doDebug("Info: currentNum = " + this.currentNum);
            if (this.mGroups[this.currentNum - 1].getRelated() != null) {
                Vector links = this.mGroups[this.currentNum - 1].getRelated();
                int numLinks = links.size();
                double currentTime = this.currentPlayer.getMediaTime().getSeconds();
                int i2 = 0;
                while (i2 < numLinks) {
                    RelatedLink l2 = (RelatedLink)links.elementAt(i2);
                    if ((double)l2.startTime <= currentTime && (l2.stopTime == 0L || (double)l2.stopTime >= currentTime)) {
                        this.mpAppletContext.showDocument(l2.uLink, this.infoWindow);
                        i2 = numLinks;
                    }
                    ++i2;
                }
            }
        } else if (e2.getActionCommand().equalsIgnoreCase("left") || e2.getActionCommand().equalsIgnoreCase("up")) {
            this.shiftButtons(-1);
        }
        if (e2.getActionCommand().equalsIgnoreCase("right") || e2.getActionCommand().equalsIgnoreCase("down")) {
            this.shiftButtons(1);
        } else {
            int buttonIndex;
            try {
                buttonIndex = Integer.parseInt(e2.getActionCommand());
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
            this.doDebug("Button " + buttonIndex + " pressed.");
            if (this.currentNum != buttonIndex) {
                this.pauseCurrent();
                this.setPlayer(buttonIndex);
            }
        }
    }

    protected URL getURL(String filename) {
        URL url = null;
        this.doDebug(filename);
        try {
            url = (!filename.startsWith("http") && !filename.startsWith("file")) & this.mpCodeBase != null ? new URL(this.mpCodeBase, filename) : new URL(filename);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println(String.valueOf(JMFUtil.getString("InvalidURL:")) + filename);
            return null;
        }
        return url;
    }

    private void videoResize() {
        this.doDebug("videoResize");
        MediaPlayer pb = this.currentPlayer;
        if (pb == null) {
            return;
        }
        Dimension d2 = this.getSize();
        int height = d2.height;
        int width = d2.width;
        int maxHeight = 10;
        this.buttonPanel.validate();
        Dimension buttonD = this.buttonPanel.getSize();
        if (maxHeight < buttonD.height) {
            maxHeight = buttonD.height;
        }
        pb.setBounds(this.getBounds().x, this.getBounds().y, width, height - maxHeight);
        while (pb.getState() != 500 && pb.getState() != 600) {
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private MediaPlayer formPlayer(String mediaName) {
        try {
            mediaName = mediaName.trim();
            if (mediaName.length() != 0) {
                this.doDebug("Forming player: " + mediaName + "| CodeBase = " + this.mpCodeBase);
                ClassLoader cl = this.getClass().getClassLoader();
                MediaPlayer pb = (MediaPlayer)Beans.instantiate(cl, "javax.media.bean.playerbean.MediaPlayer");
                if ((!mediaName.startsWith("http") && !mediaName.startsWith("file")) & this.mpCodeBase != null) {
                    mediaName = String.valueOf(this.mpCodeBase) + mediaName;
                }
                this.doDebug("loading: 111" + mediaName);
                pb.setMediaLocation(mediaName);
                pb.prefetch();
                pb.waitForState(500);
                System.out.println("Wait for state done");
                pb.addControllerListener(this);
                pb.addComponentListener(this);
                pb.setVisible(false);
                pb.setBackground(this.getBackground());
                pb.setMediaLocationVisible(this.displayURL);
                pb.setPlaybackLoop(this.looping);
                pb.setControlPanelVisible(this.panelVisible);
                ++this.numOfClips;
                System.out.println("num of Clips=" + this.numOfClips);
                Dimension d2 = this.getSize();
                int height = d2.height;
                int width = d2.width;
                int maxHeight = 0;
                int pbHeight = 0;
                int pbWidth = 0;
                Dimension buttonD = this.buttonPanel.getSize();
                if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("NORTH")) || this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("SOUTH"))) {
                    pbHeight = height - buttonD.height;
                    pbWidth = width;
                } else if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("WEST")) || this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("EAST"))) {
                    pbHeight = height;
                    pbWidth = width - buttonD.width;
                }
                if (this.fixAspectRatio) {
                    Component vc = pb.getVisualComponent();
                    float aspect = 1.0f;
                    if (vc != null) {
                        int cHeight = 0;
                        if (pb.getControlPanelComponent() != null && this.panelVisible) {
                            cHeight = pb.getControlPanelComponent().getSize().height;
                        }
                        if (this.displayURL) {
                            cHeight += 23;
                        }
                        Dimension pbD = vc.getPreferredSize();
                        aspect = JMFUtil.aspectRatio(pbD.width, pbD.height, 0);
                        pbHeight = (int)((float)width / aspect) + cHeight;
                        if (pbHeight > height) {
                            pbWidth = (int)(aspect * (float)(height - cHeight));
                            pbHeight = height - maxHeight;
                        } else {
                            pbWidth = width;
                        }
                    }
                }
                pb.setBounds(this.getBounds().x, this.getBounds().y, pbWidth, pbHeight);
                this.doDebug("Number of Clips: " + this.numOfClips);
                return pb;
            }
            return null;
        }
        catch (Exception e2) {
            System.err.println(String.valueOf(JMFUtil.getString("PlayerBeanNotGood")) + e2);
            e2.printStackTrace();
            return null;
        }
    }

    private boolean containsButton(Component but) {
        Component[] comps = this.gifPanel.getComponents();
        int i2 = 0;
        while (i2 < comps.length) {
            if (comps[i2] == but) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    protected ImageButton formButton(URL i2, int index) {
        this.doDebug("Form image button");
        ImageButton newButton = new ImageButton(i2);
        newButton.setActionCommand(Integer.toString(index));
        newButton.addActionListener(this);
        newButton.setEnabled(true);
        newButton.waitForImage(true);
        return newButton;
    }

    protected ImageButton formButton(int index) {
        this.doDebug("Form Index button");
        ImageButton newButton = new ImageButton(Integer.toString(index), true, 80, 60);
        newButton.setActionCommand(Integer.toString(index));
        newButton.addActionListener(this);
        newButton.waitForImage(true);
        return newButton;
    }

    public void pauseCurrent() {
        if (this.currentNum <= this.numOfMGroups && this.currentNum > 0) {
            ImageButton imgB = this.mGroups[this.currentNum - 1].getButton();
            imgB.setBorderColor(new Color(160, 160, 160));
            imgB.drawBorder(true);
        }
        if (this.currentPlayer != null) {
            this.currentPlayer.stop();
            this.currentPlayer.close();
            this.currentPlayer.setVisible(false);
            this.videoPanel.remove(this.currentPlayer);
            this.doDebug("Exiting PauseCurrent.");
        }
    }

    private void changeCurrentPlayer(MediaPlayer newPB, int num) {
        this.currentNum = num;
        this.currentPlayer = newPB;
        this.doDebug("Switching current Player");
        this.currentPlayer.setVisible(true);
        this.videoPanel.add(this.currentPlayer);
        JMFUtil.center(this.videoPanel, this.currentPlayer, true, this.currentPlayer.getMediaLocationHeight() + this.currentPlayer.getControlPanelHeight());
        this.videoPanel.setVisible(true);
        try {
            if (this.currentPlayer.getState() != 600) {
                this.currentPlayer.start();
            } else {
                System.out.println("Player already in started state.");
            }
        }
        catch (ClockStartedError clockStartedError) {
            this.currentPlayer.close();
            this.currentPlayer.deallocate();
            this.currentPlayer.start();
        }
        this.currentPlayer.setVisible(true);
        this.currentPlayer.waitForState(600);
        this.currentPlayer.invalidate();
        this.videoPanel.validate();
        this.videoPanel.setVisible(true);
    }

    public void nextPlayer() {
        if (this.numOfMGroups <= 1) {
            return;
        }
        this.pauseCurrent();
        ++this.currentNum;
        if (this.currentNum > this.numOfMGroups) {
            this.currentNum = 1;
        }
        while (!this.containsButton(this.mGroups[this.currentNum - 1].getButton())) {
            this.shiftButtons(1);
        }
        this.doDebug("Next Player");
        this.setPlayer(this.currentNum);
    }

    public void previousPlayer() {
        if (this.numOfMGroups <= 1) {
            return;
        }
        this.pauseCurrent();
        --this.currentNum;
        if (this.currentNum < 1) {
            this.currentNum = this.numOfMGroups;
        }
        while (!this.containsButton(this.mGroups[this.currentNum - 1].getButton())) {
            this.shiftButtons(-1);
        }
        this.doDebug("Previous Player");
        this.setPlayer(this.currentNum);
    }

    public void setPlayer(int current) {
        MediaGroup mGrp = null;
        ImageButton imgBut = null;
        if (current < 1 || current > this.numOfMGroups) {
            return;
        }
        mGrp = this.mGroups[current - 1];
        mGrp.setPlayer(this.formPlayer(mGrp.mediaName));
        if (!this.containsButton(mGrp.getButton())) {
            this.startingButton = this.currentNum;
            this.updateGifPanel();
        }
        if (mGrp.getRelated() != null && this.mpAppletContext != null) {
            if (mGrp.getRelated().size() > 0) {
                if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("SOUTH")) || this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("NORTH"))) {
                    this.buttonPanel.add("South", this.utilPanel);
                    this.validate();
                } else if (!this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("NONE"))) {
                    this.videoPanel.add("South", this.utilPanel);
                    this.validate();
                }
            } else {
                this.buttonPanel.remove(this.utilPanel);
                this.videoPanel.remove(this.utilPanel);
                this.validate();
            }
        } else {
            this.buttonPanel.remove(this.utilPanel);
            this.videoPanel.remove(this.utilPanel);
        }
        imgBut = mGrp.getButton();
        imgBut.requestFocus();
        imgBut.setBorderColor(Color.darkGray);
        imgBut.drawBorder(false);
        this.currentPlayer = mGrp.getPlayer();
        this.changeCurrentPlayer(this.currentPlayer, current);
    }

    public boolean isFixAspectRatio() {
        return this.fixAspectRatio;
    }

    public void setFixAspectRatio(boolean f2) {
        boolean old = this.fixAspectRatio;
        if (old != f2) {
            int i2 = 0;
            while (i2 < this.numOfClips) {
                ++i2;
            }
        }
        this.fixAspectRatio = f2;
        this.changes.firePropertyChange("fixAspectRatio", new Boolean(old), new Boolean(f2));
    }

    public String getButtonPosition() {
        return this.buttonPosition;
    }

    public void setButtonPosition(String p2) {
        String old = this.buttonPosition;
        if (!old.equalsIgnoreCase(p2)) {
            this.buttonPosition = p2;
            this.position();
            this.changes.firePropertyChange("buttonPosition", new String(old), new String(p2));
        }
    }

    public boolean isSequentialPlay() {
        return this.sequential;
    }

    public void setSequentialPlay(boolean b2) {
        boolean old = this.sequential;
        if (old != b2) {
            this.sequential = b2;
            this.changes.firePropertyChange("sequentialPlay", new Boolean(old), new Boolean(b2));
        }
    }

    public boolean isLooping() {
        return this.looping;
    }

    public void setLooping(boolean l2) {
        boolean old = this.looping;
        if (old != l2) {
            int i2 = 0;
            while (i2 < this.numOfClips) {
                this.mGroups[i2].getPlayer().setPlaybackLoop(l2);
                ++i2;
            }
        }
        this.looping = l2;
        this.changes.firePropertyChange("looping", new Boolean(old), new Boolean(l2));
    }

    public boolean isPanelVisible() {
        return this.panelVisible;
    }

    public void setPanelVisible(boolean val) {
        if (this.panelVisible != val) {
            int i2 = 0;
            while (i2 < this.numOfClips) {
                this.mGroups[i2].getPlayer().setControlPanelVisible(val);
                ++i2;
            }
            this.validate();
            this.panelVisible = val;
            this.changes.firePropertyChange("panelVisible", new Boolean(!val), new Boolean(val));
        }
    }

    public boolean isURLVisible() {
        return this.displayURL;
    }

    public void setURLVisible(boolean val) {
        if (this.displayURL != val) {
            int i2 = 0;
            while (i2 < this.numOfClips) {
                this.mGroups[i2].getPlayer().setMediaLocationVisible(val);
                ++i2;
            }
            this.validate();
            this.displayURL = val;
            this.changes.firePropertyChange("URLVisible", new Boolean(!val), new Boolean(val));
        }
    }

    public boolean isFitVideo() {
        return this.fitVideo;
    }

    public void setFitVideo(boolean f2) {
        boolean old = this.fitVideo;
        if (old != f2) {
            int i2 = 0;
            while (i2 < this.numOfClips) {
                ++i2;
            }
            this.fitVideo = f2;
        }
    }

    public boolean getLoadOnInit() {
        return this.loadOnInit;
    }

    public void setLoadOnInit(boolean b2) {
        boolean old = this.loadOnInit;
        if (old != b2) {
            this.loadOnInit = b2;
            this.changes.firePropertyChange("loadOnInit", new Boolean(old), new Boolean(b2));
        }
    }

    public void moveUp(int index) {
        MediaGroup mg = this.mGroups[index];
        if (index > 0) {
            this.mGroups[index] = this.mGroups[index - 1];
            this.mGroups[index - 1] = mg;
            this.mGroups[index].setIndex(index);
            this.mGroups[index - 1].setIndex(index - 1);
            this.mGroups[index].getButton().setActionCommand(Integer.toString(index + 1));
            this.mGroups[index - 1].getButton().setActionCommand(Integer.toString(index));
            if (this.switchLinkIndex(Integer.toString(index), Integer.toString(index + 1))) {
                this.setLinks(this.links);
            }
            this.doDebug("ActionCommand = " + (index + 1));
            this.doDebug("ActionCommand = " + index);
        }
        int i2 = index - 1;
        while (i2 < this.numOfMGroups) {
            ImageButton b2 = this.mGroups[i2].getButton();
            this.gifPanel.remove(b2);
            this.gifPanel.add(b2);
            ++i2;
        }
        this.validate();
    }

    public void moveDown(int index) {
        MediaGroup mg = this.mGroups[index];
        if (index < this.numOfMGroups - 1) {
            this.mGroups[index] = this.mGroups[index + 1];
            this.mGroups[index + 1] = mg;
            this.mGroups[index].setIndex(index);
            this.mGroups[index + 1].setIndex(index + 1);
            this.mGroups[index].getButton().setActionCommand(Integer.toString(index + 1));
            this.mGroups[index + 1].getButton().setActionCommand(Integer.toString(index + 2));
            if (this.switchLinkIndex(Integer.toString(index + 1), Integer.toString(index + 2))) {
                this.setLinks(this.links);
            }
            this.doDebug("moveDown(i):ActionCommand=" + (index + 1));
            this.doDebug("moveDown(i):ActionCommand=" + (index + 2));
        }
        int i2 = index;
        while (i2 < this.numOfMGroups) {
            ImageButton b2 = this.mGroups[i2].getButton();
            this.doDebug("Moving media " + this.mGroups[i2].mediaName);
            this.gifPanel.remove(b2);
            this.gifPanel.add(b2);
            ++i2;
        }
        this.validate();
    }

    public void addMGroup(String mediaName, String buttonGif) {
        this.doDebug("adding media group - " + this.numOfMGroups);
        if (this.mGroups == null) {
            this.mGroups = new MediaGroup[this.maxMediaGroup];
        }
        if (this.numOfMGroups < this.maxMediaGroup) {
            this.mGroups[this.numOfMGroups] = new MediaGroup(mediaName, buttonGif, "", this);
        } else {
            System.out.println(JMFUtil.getString("MaxMGroup"));
        }
        this.doDebug("Number of next media group = " + this.numOfMGroups);
    }

    public void deleteMGroup(int i2) {
        boolean changed = false;
        String index = Integer.toString(i2 + 1);
        this.doDebug("i = " + i2);
        this.doDebug("index = " + index);
        this.doDebug("MGroups length = " + this.mGroups.length);
        String[] temp = null;
        MediaGroup mg = this.mGroups[i2];
        int linksLength = 0;
        if (this.links != null) {
            linksLength = this.links.length;
        }
        int j2 = 0;
        while (j2 < linksLength) {
            if (index.equals(this.links[j2])) {
                changed = true;
                temp = new String[this.links.length - 4];
                JMFUtil.copyShortenStringArray(this.links, temp, j2, 4);
            }
            j2 += 4;
        }
        int j3 = i2;
        while (j3 < this.numOfMGroups - 1) {
            this.mGroups[j3] = this.mGroups[j3 + 1];
            if (this.links != null) {
                int k2;
                index = Integer.toString(j3 + 1);
                if (changed) {
                    k2 = 0;
                    while (k2 < temp.length) {
                        if (temp[k2].equals(index)) {
                            temp[k2] = Integer.toString(j3);
                        }
                        k2 += 4;
                    }
                } else {
                    temp = new String[linksLength];
                    JMFUtil.copyStringArray(this.links, temp);
                    k2 = 0;
                    while (k2 < temp.length) {
                        if (temp[k2].equals(index)) {
                            changed = true;
                            temp[k2] = Integer.toString(j3);
                        }
                        k2 += 4;
                    }
                }
            }
            ++j3;
        }
        if (changed) {
            this.setLinks(temp);
        }
        this.mGroups[this.numOfMGroups - 1] = null;
        --this.numOfMGroups;
        this.doDebug("Remove button " + mg.gifName);
        this.gifPanel.remove(mg.getButton());
        this.updateGifPanel();
        this.validate();
    }

    private boolean switchLinkIndex(String index1, String index2) {
        boolean changed = false;
        if (this.links != null) {
            int i2 = 0;
            while (i2 < this.links.length) {
                if (index1.equals(this.links[i2])) {
                    this.doDebug("Switched " + this.links[i2] + " with " + index2);
                    changed = true;
                    this.links[i2] = index2;
                } else if (index2.equals(this.links[i2])) {
                    this.doDebug("Switched " + this.links[i2] + " with " + index1);
                    changed = true;
                    this.links[i2] = index1;
                }
                i2 += 4;
            }
        }
        return changed;
    }

    public void replaceMGroup(int i2, String mName, String gName) {
        if (i2 < this.numOfMGroups) {
            MediaGroup mg;
            if (i2 < this.numOfMGroups - 1) {
                MediaGroup m1 = this.mGroups[i2 + 1];
                if (m1.mediaName.equals(mName) & m1.gifName.equals(gName)) {
                    this.moveDown(i2);
                    return;
                }
            }
            if ((mg = this.mGroups[i2]).getPlayer() != null) {
                MediaPlayer pb = mg.getPlayer();
                pb.close();
                pb.deallocate();
                mg.setPlayer(null);
            }
            this.doDebug("Media Name = " + mName);
            this.doDebug("Gif Name = " + gName);
            mg.mediaName = mName;
            mg.gifName = gName;
            if (gName != null || gName.compareTo("") != 0) {
                mg.setButton(this.formButton(this.getURL(gName), i2 + 1));
            } else {
                mg.setButton(this.formButton(i2 + 1));
            }
            this.doDebug("Replacing " + i2);
            this.refreshAllButtons();
        }
    }

    private void refreshAllButtons() {
        this.gifPanel.removeAll();
        int i2 = 0;
        while (i2 < this.numOfMGroups) {
            this.gifPanel.add(this.mGroups[i2].getButton());
            ++i2;
        }
        this.validate();
    }

    public boolean addLink(int index, String l2, long start, long end) {
        this.doDebug("adding link: index = " + index);
        this.doDebug("Link = " + l2 + " start=" + start + " stop=" + end);
        try {
            RelatedLink link = new RelatedLink(l2, start, end, this);
            this.mGroups[index - 1].setRelated(link);
        }
        catch (MalformedURLException malformedURLException) {
            System.out.println(JMFUtil.getString("InvalidURL"));
            return false;
        }
        if (!this.duplicate(Integer.toString(index + 1), l2, Long.toString(start), Long.toString(end))) {
            int len = 0;
            if (this.links != null) {
                len = this.links.length;
            }
            String[] temp = new String[len + 4];
            JMFUtil.copyStringArray(this.links, temp);
            temp[len] = Integer.toString(index + 1);
            temp[len + 1] = l2;
            temp[len + 2] = Long.toString(start);
            temp[len + 3] = Long.toString(end);
        }
        return true;
    }

    private boolean duplicate(String mIndex, String url, String start, String stop) {
        if (this.links != null) {
            int i2 = 0;
            while (i2 < this.links.length) {
                if (this.links[i2].equals(mIndex) & this.links[i2 + 1].equals(url) & this.links[i2 + 2].equals(start) & this.links[i2 + 3].equals(stop)) {
                    return true;
                }
                i2 += 4;
            }
        }
        return false;
    }

    public void setMGroups(MediaGroup[] indexprop) {
        MediaGroup[] oldValue = this.mGroups;
        this.mGroups = indexprop;
        this.changes.firePropertyChange("mGroups", oldValue, indexprop);
    }

    public void setMGroups(int index, MediaGroup indexprop) {
        MediaGroup[] oldValue = this.mGroups;
        this.mGroups[index] = indexprop;
        this.changes.firePropertyChange("mGroups", oldValue, this.mGroups);
    }

    public MediaGroup[] getMGroups() {
        return this.mGroups;
    }

    public MediaGroup getMGroups(int index) {
        return this.mGroups[index];
    }

    public void setMediaNames(String[] indexprop) {
        String[] oldValue = this.mediaNames;
        this.mediaNames = indexprop;
        this.doDebug("setmediaNames " + this.mediaNames);
        this.updateMGroups(this.mediaNames);
        this.updateLinks(this.links);
        this.doDebug("updateMGroups done");
        this.updateGifPanel();
        this.changes.firePropertyChange("mediaNames", oldValue, indexprop);
    }

    public void setMediaNames(String[] indexprop, Object t) {
        String[] oldValue = this.mediaNames;
        this.mediaNames = indexprop;
        this.doDebug("setmediaNames " + this.mediaNames);
        this.getContext(t);
        this.updateMGroups(this.mediaNames);
        this.updateLinks(this.links);
        this.doDebug("updateMGroups done");
        this.updateGifPanel();
        this.changes.firePropertyChange("mediaNames", oldValue, indexprop);
    }

    public void setMediaNames(int index, String indexprop) {
        String gifName;
        String mediaName;
        String[] oldValue = this.mediaNames;
        this.mediaNames[index] = indexprop;
        if (index % 2 == 0) {
            mediaName = this.mediaNames[index];
            gifName = this.mediaNames[index + 1];
        } else {
            mediaName = this.mediaNames[index - 1];
            gifName = this.mediaNames[index];
        }
        this.updateMGroups(index / 2, mediaName, gifName);
        this.updateGifPanel();
        this.changes.firePropertyChange("mediaNames", oldValue, this.mediaNames);
    }

    private boolean updateMGroups(String[] mNames) {
        boolean changed = false;
        int mNamesLength = 0;
        int mindex = 0;
        if (mNames != null) {
            mNamesLength = mNames.length;
        }
        this.doDebug("Updating MGroups " + mNamesLength);
        int i2 = 0;
        while (i2 < mNamesLength) {
            mindex = i2 / 2;
            if (changed) {
                this.updateMGroups(mindex, mNames[i2], mNames[i2 + 1]);
            } else {
                changed = this.updateMGroups(mindex, mNames[i2], mNames[i2 + 1]);
            }
            i2 += 2;
        }
        if (mNamesLength / 2 < this.numOfMGroups) {
            int i3 = this.numOfMGroups - 1;
            while (i3 >= mNamesLength / 2) {
                this.doDebug("Deleting mGroup " + i3);
                this.mGroups[i3].delete();
                --i3;
            }
        }
        return changed;
    }

    private boolean updateMGroups(int i2, String mediaName, String gifName) {
        this.doDebug("Index=" + i2 + " Media=" + mediaName + " Gif=" + gifName);
        if (i2 < this.numOfMGroups) {
            MediaGroup m2 = this.mGroups[i2];
            if (!m2.mediaName.equals(mediaName) | !m2.gifName.equals(gifName)) {
                this.replaceMGroup(i2, mediaName, gifName);
                return true;
            }
        } else {
            this.addMGroup(mediaName, gifName);
            return true;
        }
        return false;
    }

    public String[] getMediaNames() {
        return this.mediaNames;
    }

    public String getMediaNames(int index) {
        return this.mediaNames[index];
    }

    public void setLinks(String[] indexprop) {
        String[] oldValue = this.links;
        boolean changed = false;
        this.links = indexprop;
        this.doDebug("Inside setLinks(String[])");
        changed = this.deleteLinks(this.links);
        this.doDebug("updating links...");
        if (this.updateLinks(this.links) | changed) {
            this.changes.firePropertyChange("links", oldValue, indexprop);
        }
    }

    public void setLinks(int index, String indexprop) {
        String[] oldValue = this.links;
        String mediaNum = "";
        String relatedName = "";
        String startString = "";
        String stopString = "";
        this.links[index] = indexprop;
        if (index % 4 == 0) {
            mediaNum = this.links[index];
            relatedName = this.links[index + 1];
            startString = this.links[index + 2];
            stopString = this.links[index + 3];
        } else if (index % 4 == 1) {
            mediaNum = this.links[index - 1];
            relatedName = this.links[index];
            startString = this.links[index + 1];
            stopString = this.links[index + 2];
        } else if (index % 3 == 2) {
            mediaNum = this.links[index - 2];
            relatedName = this.links[index - 1];
            startString = this.links[index];
            stopString = this.links[index + 1];
        } else if (index % 3 == 4) {
            mediaNum = this.links[index - 3];
            relatedName = this.links[index - 2];
            startString = this.links[index - 1];
            stopString = this.links[index];
        }
        if (this.updateLinks(mediaNum, relatedName, startString, stopString)) {
            this.changes.firePropertyChange("links", oldValue, this.links);
        }
    }

    private boolean deleteLinks(String[] linksList) {
        boolean index = false;
        Vector rl = null;
        RelatedLink l2 = null;
        boolean changed = false;
        boolean match = false;
        int i2 = 0;
        while (i2 < this.numOfMGroups) {
            rl = this.mGroups[i2].getRelated();
            if (rl != null) {
                int j2 = 0;
                while (j2 < rl.size()) {
                    l2 = (RelatedLink)rl.elementAt(j2);
                    match = false;
                    if (linksList != null) {
                        int k2 = 0;
                        while (k2 < linksList.length) {
                            if (Integer.toString(i2).equals(linksList[k2]) & l2.link.equals(linksList[k2 + 1]) & Long.toString(l2.startTime).equals(linksList[k2 + 2]) & Long.toString(l2.stopTime).equals(linksList[k2 + 3])) {
                                match = true;
                                break;
                            }
                            k2 += 4;
                        }
                    }
                    if (!match) {
                        rl.removeElementAt(j2);
                        changed = true;
                    }
                    ++j2;
                }
            }
            ++i2;
        }
        return changed;
    }

    private boolean updateLinks(String[] linksList) {
        boolean changed = false;
        if (linksList != null) {
            this.doDebug("links length: " + linksList.length);
            if (this.msVM) {
                int i2 = 0;
                while (i2 < linksList.length) {
                    String temp = linksList[i2];
                    ++i2;
                }
            }
            int i3 = 0;
            while (i3 < linksList.length) {
                if (changed) {
                    this.updateLinks(linksList[i3], linksList[i3 + 1], linksList[i3 + 2], linksList[i3 + 3]);
                } else {
                    changed = this.updateLinks(linksList[i3], linksList[i3 + 1], linksList[i3 + 2], linksList[i3 + 3]);
                }
                i3 += 4;
            }
        }
        return changed;
    }

    private boolean updateLinks(String mediaNum, String relatedName, String startString, String stopString) {
        this.doDebug("MediaNum=" + mediaNum + " related=" + relatedName);
        this.doDebug("Start=" + startString + " Stop=" + stopString);
        int i2 = Integer.parseInt(mediaNum) - 1;
        long start = 0L;
        long stop = 0L;
        boolean dup = false;
        try {
            start = Long.parseLong(startString);
            stop = Long.parseLong(stopString);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        if (i2 < this.numOfMGroups & i2 >= 0) {
            MediaGroup m2 = this.mGroups[i2];
            Vector r2 = m2.getRelated();
            RelatedLink rl = null;
            if (r2 != null) {
                int j2 = 0;
                while (j2 < r2.size()) {
                    rl = (RelatedLink)r2.elementAt(j2);
                    if (rl.link.equals(relatedName) & rl.startTime == start & rl.stopTime == stop) {
                        dup = true;
                        j2 = r2.size();
                        return false;
                    }
                    ++j2;
                }
            }
            if (!dup) {
                try {
                    m2.setRelated(new RelatedLink(relatedName, start, stop, this));
                }
                catch (MalformedURLException malformedURLException) {
                    System.out.println(String.valueOf(JMFUtil.getBIString("BadURL")) + relatedName);
                    return false;
                }
                return true;
            }
        }
        System.out.println(JMFUtil.getBIString("MEDIA_GROUP_BOUNDS"));
        return false;
    }

    public String[] getLinks() {
        return this.links;
    }

    public String getLinks(int index) {
        return this.links[index];
    }

    public void setAppletContext(AppletContext ac) {
        this.mpAppletContext = ac;
    }

    public void setCodeBase(URL cb) {
        this.mpCodeBase = cb;
    }

    public void addControllerListener(ControllerListener listener) {
        int i2 = 0;
        while (i2 < this.numOfClips) {
            this.mGroups[i2].getPlayer().addControllerListener(listener);
            ++i2;
        }
    }

    public void removeControllerListener(ControllerListener listener) {
        int i2 = 0;
        while (i2 < this.numOfClips) {
            this.mGroups[i2].getPlayer().removeControllerListener(listener);
            ++i2;
        }
    }

    public int getNumberOfMediaGroups() {
        return this.numOfMGroups;
    }

    public void setBounds(int x, int y, int w, int h2) {
        super.setBounds(x, y, w, h2);
        Dimension d2 = this.getSize();
        int height = d2.height;
        int maxHeight = 10;
        Dimension buttonD = this.buttonPanel.getSize();
        if (maxHeight < buttonD.height) {
            maxHeight = buttonD.height;
        }
        this.doDebug("Num of Clips = " + this.numOfClips);
        int i2 = 0;
        while (i2 < this.numOfClips) {
            this.mGroups[i2].getPlayer().setBounds(x, y, w, h2 - maxHeight);
            ++i2;
        }
        this.updateGifPanel();
    }

    public Dimension getPreferredSize() {
        if (Beans.isDesignTime()) {
            return new Dimension(this.preferredWidth, this.preferredHeight);
        }
        Dimension d2 = this.getSize();
        if (d2.width == 0 || d2.height == 0) {
            return new Dimension(this.preferredWidth, this.preferredHeight);
        }
        return d2;
    }

    public void addPropertyChangeListener(PropertyChangeListener c2) {
        this.changes.addPropertyChangeListener(c2);
    }

    public void removePropertyChangeListener(PropertyChangeListener c2) {
        this.changes.removePropertyChangeListener(c2);
    }

    protected void createTabs(int length) {
        if (this.up != null) {
            this.scrollPanel.remove(this.up);
        }
        if (this.down != null) {
            this.scrollPanel.remove(this.down);
        }
        if (this.left != null) {
            this.scrollPanel.remove(this.left);
        }
        if (this.right != null) {
            this.scrollPanel.remove(this.right);
        }
        if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("SOUTH")) || this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("NORTH"))) {
            this.createLeftRight(length);
            this.scrollPanel.add("West", this.left);
            this.scrollPanel.add("East", this.right);
        } else if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("WEST")) || this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("EAST"))) {
            this.createUpDown(length);
            this.scrollPanel.add("North", this.up);
            this.scrollPanel.add("South", this.down);
        }
    }

    private void shiftButtons(int difference) {
        this.startingButton += difference;
        if (this.startingButton > this.numOfMGroups) {
            this.startingButton -= this.numOfMGroups;
        }
        if (this.startingButton < 1) {
            this.startingButton = this.numOfMGroups + this.startingButton;
        }
        this.updateGifPanel();
    }

    protected void updateGifPanel() {
        if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("NONE"))) {
            this.validate();
            return;
        }
        if (this.numOfMGroups <= 0) {
            return;
        }
        int numOfButtons = 0;
        int i2 = this.startingButton - 1;
        int stop = i2 + 1;
        if (stop == this.numOfMGroups) {
            stop = 0;
        }
        int tabLength = 0;
        ImageButton iButton = this.mGroups[i2].getButton();
        int gifLength = this.getSize().width;
        int buttonsLength = 0;
        tabLength = iButton.height;
        if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("WEST")) || this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("EAST"))) {
            gifLength = this.getSize().height;
            buttonsLength = 0;
            tabLength = iButton.width;
        }
        gifLength -= 2 * this.tabsize;
        boolean first = true;
        this.scrollPanel.setVisible(false);
        this.scrollPanel.removeAll();
        this.gifPanel.setVisible(false);
        this.gifPanel.removeAll();
        if (++i2 >= this.numOfMGroups) {
            i2 = 0;
        }
        this.doDebug("ButtonsLength: " + buttonsLength);
        this.doDebug("Gif Length: " + gifLength);
        this.doDebug("i: " + i2);
        this.doDebug("stop: " + stop);
        iButton = this.mGroups[i2].getButton();
        while (first || i2 != stop) {
            first = false;
            if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("NORTH")) || this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("SOUTH"))) {
                if (iButton.width + buttonsLength > gifLength) break;
                ++numOfButtons;
                buttonsLength += iButton.width;
                if (iButton.height > tabLength) {
                    tabLength = iButton.height;
                }
            } else if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("WEST")) || this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("EAST"))) {
                if (iButton.height + buttonsLength > gifLength) break;
                ++numOfButtons;
                buttonsLength += iButton.height;
                if (iButton.width > tabLength) {
                    tabLength = iButton.width;
                }
            }
            if (++i2 < this.numOfMGroups) continue;
            i2 = 0;
        }
        int gap = 0;
        if (numOfButtons > 1) {
            gap = (gifLength - buttonsLength) / (numOfButtons - 1);
        }
        System.out.println("gap=" + gap + " gifLength=" + gifLength + " buttonsLength=" + buttonsLength);
        if (numOfButtons == 1) {
            this.gifPanel.setLayout(new FlowLayout());
        } else if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("NORTH")) || this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("SOUTH"))) {
            this.gifPanel.setLayout(new GridLayout(1, numOfButtons, gap, 0));
        } else if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("WEST")) || this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("EAST"))) {
            this.gifPanel.setLayout(new GridLayout(numOfButtons, 1, 0, gap));
        }
        iButton = this.mGroups[this.startingButton - 1].getButton();
        buttonsLength = iButton.width;
        first = true;
        if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("WEST")) || this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("EAST"))) {
            buttonsLength = iButton.height;
        }
        if ((i2 = this.startingButton) >= this.numOfMGroups) {
            i2 = 0;
        }
        while (buttonsLength <= gifLength && (first || i2 != stop)) {
            first = false;
            this.gifPanel.add(iButton);
            iButton = this.mGroups[i2].getButton();
            if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("NORTH")) || this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("SOUTH"))) {
                buttonsLength += iButton.width;
            } else if (this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("WEST")) || this.buttonPosition.equalsIgnoreCase(JMFUtil.getString("EAST"))) {
                buttonsLength += iButton.height;
            }
            if (++i2 < this.numOfMGroups) continue;
            i2 = 0;
        }
        if (buttonsLength > gifLength && i2 != stop) {
            this.createTabs(tabLength);
        }
        this.scrollPanel.add("Center", this.gifPanel);
        this.gifPanel.setVisible(true);
        this.scrollPanel.setVisible(true);
        this.validate();
    }

    public void componentResized(ComponentEvent ce) {
        this.doDebug("Something is being resized.");
        this.doDebug("videoPanel=" + this.videoPanel);
        if (this.currentPlayer != null) {
            this.doDebug("pb=" + this.currentPlayer);
        }
        if (ce.getSource() == this.gifPanel) {
            this.doDebug("resize gifPanel: " + this.gifPanel);
            this.videoResize();
            if (!this.msVM) {
                this.updateGifPanel();
            }
        } else if (ce.getSource() == this.currentPlayer) {
            this.doDebug("resize currentPlayer: " + this.currentPlayer.getSize());
            JMFUtil.center(this.videoPanel, this.currentPlayer, true, this.currentPlayer.getPreferredSize().height - this.currentPlayer.getVisualComponent().getSize().height);
        }
    }

    public void componentMoved(ComponentEvent ce) {
    }

    public void componentHidden(ComponentEvent ce) {
    }

    public void componentShown(ComponentEvent ce) {
    }

    protected void doDebug(String s) {
        System.out.println(s);
    }

    private final class 1
    extends Panel {
        public Insets insets() {
            return new Insets(10, 10, 10, 10);
        }

        /* synthetic */ 1() {
        }
    }
}

