/*
 * Decompiled with CFR 0.152.
 */
import com.sun.media.rtp.RTPSessionMgr;
import com.sun.media.ui.PlayerWindow;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Vector;
import javax.media.Controller;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.Manager;
import javax.media.Player;
import javax.media.RealizeCompleteEvent;
import javax.media.SizeChangeEvent;
import javax.media.protocol.DataSource;
import javax.media.rtp.ReceiveStream;
import javax.media.rtp.ReceiveStreamListener;
import javax.media.rtp.SessionAddress;
import javax.media.rtp.SessionManager;
import javax.media.rtp.SessionManagerException;
import javax.media.rtp.event.NewReceiveStreamEvent;
import javax.media.rtp.event.ReceiveStreamEvent;
import javax.media.rtp.rtcp.SourceDescription;
import rtp.ParticipantListWindow;

public class RTPPlayerApplet
extends Applet
implements ControllerListener,
ReceiveStreamListener,
ActionListener {
    InetAddress destaddr;
    String address;
    String portstr;
    String media;
    Player videoplayer;
    SessionManager videomgr;
    SessionManager audiomgr;
    Component visualComponent;
    Component controlComponent;
    Panel panel;
    Button audiobutton;
    Button videobutton;
    GridBagLayout gridbag;
    GridBagConstraints c;
    ParticipantListWindow videogui;
    ParticipantListWindow audiogui;
    int width = 320;
    int height;
    Vector playerlist = new Vector();

    public void init() {
        this.setLayout(new BorderLayout());
        Panel buttonPanel = new Panel();
        buttonPanel.setLayout(new FlowLayout());
        this.add("North", buttonPanel);
        this.media = this.getParameter("video");
        if (this.media.equals("On")) {
            this.address = this.getParameter("videosession");
            this.portstr = this.getParameter("videoport");
            this.StartSessionManager(this.address, this.StrToInt(this.portstr), "video");
            if (this.videomgr == null) {
                System.err.println("null video manager ");
                return;
            }
            this.videobutton = new Button("Video RTP Monitor");
            this.videobutton.addActionListener(this);
            buttonPanel.add(this.videobutton);
        }
        this.media = this.getParameter("audio");
        if (this.media.equals("On")) {
            this.address = this.getParameter("audiosession");
            this.portstr = this.getParameter("audioport");
            this.StartSessionManager(this.address, this.StrToInt(this.portstr), "audio");
            if (this.audiomgr == null) {
                System.err.println("null audio manager");
                return;
            }
            this.audiobutton = new Button("Audio RTP Monitor");
            this.audiobutton.addActionListener(this);
            buttonPanel.add(this.audiobutton);
        }
    }

    public void start() {
        if (this.videoplayer != null) {
            this.videoplayer.start();
        }
        if (this.playerlist == null) {
            return;
        }
        int i2 = 0;
        while (i2 < this.playerlist.size()) {
            Player player = (Player)this.playerlist.elementAt(i2);
            if (player != null) {
                new PlayerWindow(player);
            }
            ++i2;
        }
    }

    public void stop() {
        if (this.videoplayer != null) {
            this.videoplayer.close();
        }
        if (this.playerlist == null) {
            return;
        }
        int i2 = 0;
        while (i2 < this.playerlist.size()) {
            Player player = (Player)this.playerlist.elementAt(i2);
            if (player != null) {
                player.close();
            }
            ++i2;
        }
    }

    public void destroy() {
        String reason = "Shutdown RTP Player";
        if (this.videomgr != null) {
            this.videomgr.closeSession(reason);
            this.videoplayer = null;
            this.videomgr = null;
        }
        if (this.audiomgr != null) {
            this.audiomgr.closeSession(reason);
            this.audiomgr = null;
        }
        super.destroy();
    }

    public void actionPerformed(ActionEvent event) {
        Button button = (Button)event.getSource();
        if (button == this.videobutton && this.videomgr != null) {
            this.videogui = new ParticipantListWindow(this.videomgr);
        }
        if (button == this.audiobutton && this.audiomgr != null) {
            this.audiogui = new ParticipantListWindow(this.audiomgr);
        }
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.StrToInt(this.portstr);
    }

    public String getMedia() {
        return this.media;
    }

    private int StrToInt(String str) {
        if (str == null) {
            return -1;
        }
        Integer retint = new Integer(str);
        return retint;
    }

    public synchronized void controllerUpdate(ControllerEvent event) {
        Player player = null;
        Controller controller = (Controller)event.getSource();
        if (controller instanceof Player) {
            player = (Player)event.getSource();
        }
        if (player == null) {
            return;
        }
        if (event instanceof RealizeCompleteEvent) {
            this.visualComponent = player.getVisualComponent();
            if (this.visualComponent != null) {
                this.width = this.visualComponent.getPreferredSize().width;
                this.height += this.visualComponent.getPreferredSize().height;
                if (this.panel == null) {
                    this.panel = new Panel();
                    this.repositionPanel(this.width, this.height);
                    this.panel.setLayout(new BorderLayout());
                }
                this.panel.add("Center", this.visualComponent);
                this.panel.validate();
            }
            if ((this.controlComponent = player.getControlPanelComponent()) != null) {
                this.height += this.controlComponent.getPreferredSize().height;
                if (this.panel == null) {
                    this.panel = new Panel();
                    this.panel.setLayout(new BorderLayout());
                }
                this.repositionPanel(this.width, this.height);
                this.panel.add("South", this.controlComponent);
                this.panel.validate();
            }
            if (this.panel != null) {
                this.add("Center", this.panel);
                this.invalidate();
            }
        }
        if (event instanceof SizeChangeEvent && this.panel != null) {
            SizeChangeEvent sce = (SizeChangeEvent)event;
            int nooWidth = sce.getWidth();
            int nooHeight = sce.getHeight();
            if (this.controlComponent != null) {
                nooHeight += this.controlComponent.getPreferredSize().height;
            }
            this.repositionPanel(nooWidth, nooHeight);
        }
        this.validate();
    }

    void repositionPanel(int width, int height) {
        this.panel.setBounds(0, 0, width, height);
        this.panel.validate();
    }

    public void update(ReceiveStreamEvent event) {
        SessionManager source = (SessionManager)event.getSource();
        Player newplayer = null;
        if (event instanceof NewReceiveStreamEvent) {
            try {
                ReceiveStream stream = ((NewReceiveStreamEvent)event).getReceiveStream();
                DataSource dsource = stream.getDataSource();
                newplayer = Manager.createPlayer(dsource);
            }
            catch (Exception e2) {
                System.err.println("RTPPlayerApplet Exception " + e2.getMessage());
                e2.printStackTrace();
            }
            if (newplayer == null) {
                return;
            }
            if (source == this.videomgr) {
                if (this.videoplayer == null) {
                    this.videoplayer = newplayer;
                    newplayer.addControllerListener(this);
                    newplayer.start();
                } else {
                    if (this.playerlist != null) {
                        this.playerlist.addElement(newplayer);
                    }
                    new PlayerWindow(newplayer);
                }
            }
            if (source == this.audiomgr) {
                if (this.playerlist != null) {
                    this.playerlist.addElement(newplayer);
                }
                new PlayerWindow(newplayer);
            }
        }
    }

    private SessionManager StartSessionManager(String destaddrstr, int port, String media) {
        RTPSessionMgr mymgr = new RTPSessionMgr();
        if (media.equals("video")) {
            this.videomgr = mymgr;
        }
        if (media.equals("audio")) {
            this.audiomgr = mymgr;
        }
        if (mymgr == null) {
            return null;
        }
        mymgr.addReceiveStreamListener(this);
        String cname = mymgr.generateCNAME();
        String username = "jmf-user";
        SessionAddress localaddr = new SessionAddress();
        try {
            this.destaddr = InetAddress.getByName(destaddrstr);
        }
        catch (UnknownHostException e2) {
            System.err.println("inetaddress " + e2.getMessage());
            e2.printStackTrace();
        }
        SessionAddress sessaddr = new SessionAddress(this.destaddr, port, this.destaddr, port + 1);
        SourceDescription[] userdesclist = new SourceDescription[4];
        int i2 = 0;
        while (i2 < userdesclist.length) {
            if (i2 == 0) {
                userdesclist[i2] = new SourceDescription(3, "jmf-user@sun.com", 1, false);
            } else if (i2 == 1) {
                userdesclist[i2] = new SourceDescription(2, username, 1, false);
            } else if (i2 == 2) {
                userdesclist[i2] = new SourceDescription(1, cname, 1, false);
            } else if (i2 == 3) {
                userdesclist[i2] = new SourceDescription(6, "JMF RTP Player v2.0", 1, false);
            }
            ++i2;
        }
        try {
            mymgr.initSession(localaddr, mymgr.generateSSRC(), userdesclist, 0.05, 0.25);
            mymgr.startSession(sessaddr, 1, null);
        }
        catch (SessionManagerException e3) {
            System.err.println("RTPPlayerApplet: RTPSM Exception " + e3.getMessage());
            e3.printStackTrace();
            return null;
        }
        catch (IOException e4) {
            System.err.println("RTPPlayerApplet: IO Exception " + e4.getMessage());
            e4.printStackTrace();
            return null;
        }
        return mymgr;
    }
}

