/*
 * Decompiled with CFR 0.152.
 */
package GenCns.GenJava;

import GenCns.GenJava.GenCategoryManager;
import GenCns.GenJava.GenDbInfo;
import GenCns.GenJava.GenericException;
import GenCns.GenJava.GenericHeader;
import GenCns.GenJava.PalmBaseManager;
import GenCns.GenJava.PalmRecord;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import palm.conduit.Log;
import palm.conduit.SyncProperties;

public class PcManager
extends PalmBaseManager {
    public static boolean m_bDebug = false;
    protected boolean m_bNeedToSave = false;
    protected boolean m_bStartSync = true;
    protected boolean m_bAlreadyLoaded = false;
    protected String m_dbName = null;
    protected FileInputStream m_fileIn = null;
    protected FileOutputStream m_fileOut = null;
    protected GenericHeader m_genHdr;
    public static final int CM_STORAGE_VERSION_2 = 4098;

    public PcManager(SyncProperties syncProperties, String string, long l) throws IOException {
        super(syncProperties, string, l);
        if (m_bDebug) {
            Log.AddEntry("* PC Manager's Constructor", -1, false);
        }
        this.m_dbName = string;
        this.m_genHdr = new GenericHeader(string, syncProperties.creator, syncProperties.dbType);
    }

    public void changeCategory(int n, int n2) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PC Manager's changeCategory", -1, false);
        }
        if (this.m_databaseRecords != null) {
            int n3 = 0;
            while (n3 < this.m_databaseRecords.length) {
                block6: {
                    PalmRecord palmRecord;
                    try {
                        palmRecord = this.m_databaseRecords[n3];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        break block6;
                    }
                    if (palmRecord != null && palmRecord.getCategoryIndex() == n) {
                        palmRecord.setCategoryIndex(n2);
                        palmRecord.setIsModified(true);
                    }
                }
                ++n3;
            }
        }
    }

    public void DeleteCategory(int n, boolean bl) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PC Manager's DeleteCategory", -1, false);
        }
        if (n < 0 || n >= 16) {
            throw new GenericException(4357);
        }
        if (bl) {
            this.changeCategory(n, 0);
        }
        if (this.m_databaseRecords != null) {
            int n2 = this.m_databaseRecords.length - 1;
            while (n2 >= 0) {
                block8: {
                    PalmRecord palmRecord;
                    try {
                        palmRecord = this.m_databaseRecords[n2];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        break block8;
                    }
                    if (palmRecord != null && palmRecord.getCategoryIndex() == n) {
                        this.m_databaseRecords[n2] = null;
                        --this.m_recordCount;
                    }
                }
                --n2;
            }
        }
        this.m_bNeedToSave = true;
    }

    public void addNewRecord(PalmRecord palmRecord) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PC Manager's addNewRecord", -1, false);
        }
        this.m_bNeedToSave = true;
        super.addNewRecord(palmRecord);
    }

    public void addRec(PalmRecord palmRecord) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PC Manager's addRec", -1, false);
        }
        if (this.m_iSyncType == 1) {
            palmRecord.setIsPending(true);
        }
        this.m_bNeedToSave = true;
        super.addRec(palmRecord);
    }

    public void ModifyRec(PalmRecord palmRecord) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PC Manager's ModifyRec", -1, false);
        }
        this.m_bNeedToSave = true;
        palmRecord.setIsPending(false);
        palmRecord.resetAttribs();
        super.ModifyRec(palmRecord);
    }

    public void DeleteRec(PalmRecord palmRecord) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PC Manager's DeleteRec", -1, false);
        }
        this.m_bNeedToSave = true;
        palmRecord.setIsPending(false);
        palmRecord.setIsDeleted(true);
    }

    public void ModifyRecByIndex(int n, PalmRecord palmRecord) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PC Manager's ModifyRecByIndex", -1, false);
        }
        this.m_bNeedToSave = true;
        palmRecord.resetAttribs();
        super.ModifyRecByIndex(n, palmRecord);
    }

    public void PurgeDeletedRecs() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PC Manager's PurgeDeletedRecs", -1, false);
        }
        this.m_bNeedToSave = true;
        super.PurgeDeletedRecs();
    }

    public void Open() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* Pc Manager's Open", -1, false);
        }
        this.OpenDB();
    }

    protected void OpenDB() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* Pc Manager's OpenDB", -1, false);
        }
        switch (this.m_iSyncType) {
            case 0: 
            case 1: {
                if (this.m_bStartSync) {
                    try {
                        this.Open(0);
                        break;
                    }
                    catch (GenericException genericException) {
                        if (genericException.lastError != 4373) break;
                        throw new GenericException(4387);
                    }
                }
                this.Open(3);
                this.m_bNeedToSave = true;
                break;
            }
            case 2: 
            case 5: {
                this.Open(3);
                this.m_bNeedToSave = true;
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                this.Open(0);
                break;
            }
            case 6: {
                break;
            }
            default: {
                throw new GenericException(4370);
            }
        }
    }

    public void Close(boolean bl) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PC Manager's Close", -1, false);
        }
        this.CloseDB(bl);
    }

    public void CloseDB(boolean bl) throws GenericException {
        this.Close();
    }

    protected void Close() {
        if (this.m_fileIn != null) {
            try {
                this.m_fileIn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_fileIn = null;
        }
        if (this.m_fileOut != null) {
            try {
                this.m_fileOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_fileOut = null;
        }
    }

    protected void Open(int n) throws GenericException {
        File file;
        if (m_bDebug) {
            Log.AddEntry("* Pc Manager's Open(iMode)", -1, false);
            Log.AddEntry("     Filename " + this.m_szLocalFile, -1, false);
        }
        this.Close();
        try {
            file = new File(this.m_szLocalFile);
        }
        catch (NullPointerException nullPointerException) {
            throw new GenericException(4373);
        }
        switch (n) {
            case 0: {
                if (m_bDebug) {
                    Log.AddEntry("* Pc Manager's Open(eRead)", -1, false);
                }
                if (!file.exists()) {
                    if (m_bDebug) {
                        Log.AddEntry("Pc DB does not exist", -1, false);
                    }
                    throw new GenericException(4373);
                }
                try {
                    this.m_fileIn = new FileInputStream(this.m_szLocalFile);
                    break;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    if (m_bDebug) {
                        Log.AddEntry("Pc unable to create input stream", -1, false);
                    }
                    throw new GenericException(4373);
                }
            }
            case 1: {
                if (m_bDebug) {
                    Log.AddEntry("* Pc Manager's Open(eWrite)", -1, false);
                }
                try {
                    this.m_fileOut = new FileOutputStream(this.m_szLocalFile);
                    break;
                }
                catch (IOException iOException) {
                    throw new GenericException(4373);
                }
            }
            case 2: {
                if (m_bDebug) {
                    Log.AddEntry("* Pc Manager's Open(eReadWrite)", -1, false);
                }
                try {
                    this.m_fileIn = new FileInputStream(this.m_szLocalFile);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new GenericException(4373);
                }
            }
            case 3: {
                if (m_bDebug) {
                    Log.AddEntry("* Pc Manager's Open(eCreate)", -1, false);
                }
                try {
                    this.m_fileOut = new FileOutputStream(this.m_szLocalFile);
                    break;
                }
                catch (IOException iOException) {
                    throw new GenericException(4373);
                }
            }
        }
    }

    public void PreSync() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PC Manager's PreSync", -1, false);
        }
        if (this.m_bAlreadyLoaded) {
            return;
        }
        this.m_bAlreadyLoaded = true;
        switch (this.m_iSyncType) {
            case 0: 
            case 1: {
                try {
                    this.RetrieveDB();
                    break;
                }
                catch (GenericException genericException) {
                    if (genericException.lastError != 4378) break;
                    throw new GenericException(4387);
                }
            }
            case 2: 
            case 5: {
                break;
            }
            case 3: 
            case 4: 
            case 7: {
                this.RetrieveDB();
                break;
            }
            case 6: {
                break;
            }
        }
    }

    public void PostSync() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PC Manager's PostSync", -1, false);
        }
        this.m_bStartSync = false;
        this.ResetSyncFlags();
        try {
            switch (this.m_iSyncType) {
                case 0: 
                case 1: {
                    this.StoreDB();
                    break;
                }
                case 2: 
                case 5: {
                    this.StoreDB();
                    break;
                }
                case 3: 
                case 4: 
                case 7: {
                    break;
                }
                case 6: {
                    break;
                }
            }
        }
        catch (GenericException genericException) {
            Log.AddEntry(genericException.getMessage(), -1, false);
        }
    }

    public void PreAppInfoSync() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PC Manager's PreAppInfoSync", -1, false);
        }
        if (!this.isAppInfoSupported()) {
            return;
        }
        try {
            this.PreSync();
            this.ExtractCategories();
        }
        catch (GenericException genericException) {
            throw new GenericException(genericException.lastError);
        }
    }

    public void PostAppInfoSync() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PC Manager's PostAppInfoSync", -1, false);
        }
        if (!this.isAppInfoSupported()) {
            return;
        }
        if (!this.areCategoriesSupported()) {
            return;
        }
        if (this.m_catMgr == null || !this.m_catMgr.isChanged()) {
            return;
        }
        this.CompactCategories();
    }

    public void ExtractCategories() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PC Manager's ExtractCategories", -1, false);
        }
        if (!this.areCategoriesSupported()) {
            return;
        }
        if (this.m_catMgr != null) {
            this.m_catMgr = null;
        }
        if (this.m_appInfo == null || this.m_appInfo.getDataSize() == 0) {
            throw new GenericException(4366);
        }
        try {
            this.m_catMgr = new GenCategoryManager(this.m_appInfo.getData());
        }
        catch (IOException iOException) {
            throw new GenericException(4354);
        }
        if (this.m_catMgr == null) {
            throw new GenericException(4354);
        }
    }

    public void CompactCategories() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PC Manager's CompactCategories", -1, false);
        }
        if (!this.areCategoriesSupported()) {
            return;
        }
        if (this.m_catMgr == null || !this.m_catMgr.isChanged()) {
            return;
        }
        if (this.m_appInfo == null) {
            this.m_appInfo = new GenDbInfo();
            this.m_appInfo.setName(this.m_dbName);
            this.m_appInfo.setVersion(4098);
        }
        try {
            this.m_appInfo.setCategoryData(this.m_catMgr.compact(true));
            this.m_bNeedToSave = true;
        }
        catch (IOException iOException) {
            throw new GenericException(4384);
        }
    }

    protected void RetrieveDB() throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PC Manager's RetrieveDB", -1, false);
        }
        this.m_bNeedToSave = false;
        if (this.m_szLocalFile.length() == 0) {
            throw new GenericException(4379);
        }
        boolean bl = false;
        try {
            this.m_genHdr.readGenericData(this.m_fileIn);
        }
        catch (IOException iOException) {
            if (m_bDebug) {
                Log.AddEntry("Error reading Header - " + iOException.getMessage(), -1, false);
            }
            this.Close();
            throw new GenericException(4380);
        }
        if (this.m_genHdr.getAppInfoSize() > 0) {
            try {
                this.m_appInfo = new GenDbInfo();
                this.m_appInfo.readGenericData(this.m_fileIn);
                super.setIsAppInfoSupported(true);
            }
            catch (IOException iOException) {
                this.Close();
                throw new GenericException(4380);
            }
        }
        if (this.m_genHdr.getSortInfoSize() > 0) {
            try {
                this.m_sortInfo = new GenDbInfo();
                this.m_sortInfo.readGenericData(this.m_fileIn);
                super.setIsSortInfoSupported(true);
            }
            catch (IOException iOException) {
                this.Close();
                throw new GenericException(4380);
            }
        }
        for (int i = 0; !bl && this.m_genHdr.getDBRecCount() > i; ++i) {
            PalmRecord palmRecord = this.getNewRecord();
            try {
                palmRecord.readGenericData(this.m_fileIn);
            }
            catch (IOException iOException) {
                this.Close();
                this.m_bNeedToSave = false;
                throw new GenericException(4383);
            }
            try {
                this.addRec(palmRecord);
                if (!m_bDebug) continue;
                Log.AddEntry("      Loaded record id = " + palmRecord.getId(), -1, false);
                continue;
            }
            catch (GenericException genericException) {
                this.Close();
                this.m_bNeedToSave = false;
                throw new GenericException(4383);
            }
        }
        this.Close();
        this.m_bNeedToSave = false;
    }

    /*
     * Unable to fully structure code
     */
    protected void StoreDB() throws GenericException {
        if (PcManager.m_bDebug) {
            Log.AddEntry("* PC Manager's StoreDB", -1, false);
        }
        if (!this.m_bNeedToSave) {
            return;
        }
        if (this.m_szLocalFile.length() == 0) {
            throw new GenericException(4379);
        }
        this.OpenDB();
        var1_1 = false;
        if (this.m_appInfo != null) {
            this.m_genHdr.setAppInfoSize(this.m_appInfo.getStructSize());
        } else {
            this.m_genHdr.setAppInfoSize(0);
        }
        if (this.m_sortInfo != null) {
            this.m_genHdr.setSortInfoSize(this.m_sortInfo.getStructSize());
        } else {
            this.m_genHdr.setSortInfoSize(0);
        }
        this.m_genHdr.setDBRecCount(this.getRecordCount());
        try {
            this.m_genHdr.writeGenericData(this.m_fileOut);
        }
        catch (IOException var2_2) {
            this.Close();
            throw new GenericException(4380);
        }
        if (this.m_genHdr.getAppInfoSize() > 0) {
            try {
                this.m_appInfo.writeGenericData(this.m_fileOut);
            }
            catch (IOException var2_3) {
                this.Close();
                throw new GenericException(4380);
            }
        }
        if (this.m_genHdr.getSortInfoSize() > 0) {
            try {
                this.m_sortInfo.writeGenericData(this.m_fileOut);
            }
            catch (IOException var2_4) {
                this.Close();
                throw new GenericException(4380);
            }
        }
        try {
            var2_5 = this.findFirstRecByIndex();
            if (true) ** GOTO lbl59
        }
        catch (GenericException var3_6) {
            this.Close();
            var1_1 = true;
            return;
        }
        do {
            try {
                var2_5.resetAttribs();
                var2_5.writeGenericData(this.m_fileOut);
            }
            catch (IOException var3_8) {
                this.Close();
                throw new GenericException(4383);
            }
            try {
                var2_5 = this.findNext();
            }
            catch (GenericException var3_7) {
                var1_1 = true;
            }
lbl59:
            // 3 sources

        } while (!var1_1);
        this.Close();
        this.m_bNeedToSave = false;
    }

    public void setAppInfo(byte[] byArray) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PcManager's setAppInfo", -1, false);
        }
        this.m_bNeedToSave = true;
        super.setAppInfo(byArray);
        this.m_appInfo.setName(this.m_dbName);
    }

    public PalmRecord findRecById(int n, boolean bl) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* PcManager's findRecById " + n, -1, false);
        }
        PalmRecord palmRecord = super.findRecById(n, bl);
        palmRecord.setIsPending(false);
        return palmRecord;
    }

    protected boolean isNeedToSave() {
        return this.m_bNeedToSave;
    }

    protected void setIsNeedToSave(boolean bl) {
        this.m_bNeedToSave = bl;
    }

    void ResetSyncFlags() {
        if (m_bDebug) {
            Log.AddEntry("* PC Manager's ResetSyncFlags", -1, false);
        }
        if (this.m_databaseRecords != null) {
            int n = 0;
            while (n < this.m_databaseRecords.length) {
                block6: {
                    PalmRecord palmRecord;
                    try {
                        palmRecord = this.m_databaseRecords[n];
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        break block6;
                    }
                    if (palmRecord != null && palmRecord.isModified()) {
                        palmRecord.resetAttribs();
                        this.setIsNeedToSave(true);
                    }
                }
                ++n;
            }
        }
    }
}

