/*
 * Decompiled with CFR 0.152.
 */
package GenCns.GenJava;

import GenCns.GenJava.GenericException;
import GenCns.GenJava.PcManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import palm.conduit.Log;
import palm.conduit.SyncProperties;

public class BackupManager
extends PcManager {
    String m_szRealDb = this.m_szLocalFile;

    public BackupManager(SyncProperties syncProperties, String string, long l) throws IOException {
        super(syncProperties, string, l);
        int n = this.m_szLocalFile.lastIndexOf(".");
        if (n != -1) {
            this.m_szLocalFile = this.m_szLocalFile.substring(0, n);
        }
        this.m_szLocalFile = this.m_szLocalFile + ".BAK";
        if (PcManager.m_bDebug) {
            Log.AddEntry("* BackupMgr's constructor: Backup Db name = " + this.m_szLocalFile, -1, false);
        }
    }

    public void PostSync() throws GenericException {
        if (PcManager.m_bDebug) {
            Log.AddEntry("* BackupManager's PostSync", -1, false);
        }
        this.CloseDB(true);
        File file = new File(this.m_szRealDb);
        if (!file.exists()) {
            return;
        }
        int n = 10240;
        byte[] byArray = new byte[n];
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.m_szRealDb);
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.m_szLocalFile);
        }
        catch (IOException iOException) {
            throw new GenericException(4390);
        }
        int n2 = 0;
        boolean bl = false;
        try {
            while (!bl) {
                int n3 = fileInputStream.read(byArray);
                if (n3 < n) {
                    bl = true;
                    fileOutputStream.write(byArray, 0, n3);
                    continue;
                }
                fileOutputStream.write(byArray);
                n2 += n3;
            }
            fileOutputStream.close();
            fileInputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void OpenDB() throws GenericException {
        if (PcManager.m_bDebug) {
            Log.AddEntry("* BackupManager's OpenDB", -1, false);
        }
        if (this.m_iSyncType == 1 && this.m_bStartSync) {
            try {
                this.Open(0);
                this.PreSync();
            }
            catch (GenericException genericException) {
                if (genericException.lastError == 4373) {
                    return;
                }
                throw genericException;
            }
        }
    }

    public void PreSync() throws GenericException {
        if (PcManager.m_bDebug) {
            Log.AddEntry("* BackupManager's PreSync", -1, false);
        }
        if (this.m_bAlreadyLoaded) {
            return;
        }
        this.m_bAlreadyLoaded = true;
        if (this.m_iSyncType == 1) {
            try {
                super.RetrieveDB();
            }
            catch (GenericException genericException) {
                if (genericException.lastError == 4378) {
                    return;
                }
                throw genericException;
            }
        }
    }
}

