/*
 * Decompiled with CFR 0.152.
 */
package CardioFILE;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import palm.conduit.AbstractRecord;

public class CardioFileRecord
extends AbstractRecord {
    private boolean vHandheld = false;

    protected static long cvFechaToLong(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        long l = 0L;
        l = (calendar.get(1) - 1900) * 10000 + (calendar.get(2) + 1) * 100 + calendar.get(5);
        return l;
    }

    protected static long cvHoraToLong(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        long l = 0L;
        l = calendar.get(10) * 10000 + calendar.get(12) * 100 + calendar.get(13);
        return l;
    }

    public static String formatearFecha(Date date) {
        String string = new String();
        Calendar.getInstance();
        string = DateFormat.getDateInstance().format(date);
        return string;
    }

    public static String formatearHora(Date date) {
        String string = null;
        string = new String();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        string = "";
        string = string.concat(String.valueOf(calendar.get(11)));
        string = string.concat(":");
        string = string.concat(String.valueOf(calendar.get(12)));
        string = string.concat(":");
        string = string.concat(String.valueOf(calendar.get(13)));
        return string;
    }

    public boolean getRecordToHandheld() {
        return this.vHandheld;
    }

    protected String nullIfEmpty(String string) {
        if ("".equals(string)) {
            return null;
        }
        return string;
    }

    public void readData(DataInputStream dataInputStream) throws IOException {
    }

    protected static Date readFecha(DataInputStream dataInputStream) throws IOException {
        Calendar calendar = Calendar.getInstance();
        double d = dataInputStream.readDouble();
        long l = (long)d;
        long l2 = l / 10000L;
        long l3 = (l - l2 * 10000L) / 100L;
        long l4 = l - l2 * 10000L - l3 * 100L;
        if (d == -1.0) {
            return null;
        }
        calendar.set((int)l2 + 1900, (int)l3 - 1, (int)l4);
        return calendar.getTime();
    }

    protected Date readTiempo(DataInputStream dataInputStream) throws IOException {
        Calendar calendar = Calendar.getInstance();
        double d = dataInputStream.readDouble();
        long l = (long)d;
        long l2 = l / 10000L;
        long l3 = (l - l2 * 10000L) / 100L;
        long l4 = l - l2 * 10000L - l3 * 100L;
        if (d == -1.0) {
            return null;
        }
        calendar.set(1904, 1, 1, (int)l2, (int)l3, (int)l4);
        return calendar.getTime();
    }

    public void setRecordToHandheld(boolean bl) {
        this.vHandheld = bl;
    }

    protected static String stringWithoutCarriageReturns(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = string.length();
        while (n < n2) {
            char c = string.charAt(n);
            if (c != '\r' || n + 1 >= n2 || string.charAt(n + 1) != '\n') {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public void writeData(DataOutputStream dataOutputStream) throws IOException {
    }
}

