/*
 * Decompiled with CFR 0.152.
 */
package GenCns.GenJava;

import GenCns.GenJava.GenericException;
import GenCns.GenJava.PalmStorage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import palm.conduit.AbstractRecord;
import palm.conduit.Log;

public class PalmRecord
extends AbstractRecord {
    public static boolean m_bDebug = false;
    static final int NEW_RECORD_ID = 0;
    static final int ATTR_DELETED = 1;
    static final int ATTR_ARCHIVED = 2;
    static final int ATTR_MODIFIED = 4;
    static final int ATTR_NEW = 8;
    static final int ATTR_NONE = 32;
    static final int ATTR_NO_REC = 64;
    static final int ATTR_PRIVATE = 256;
    static final int PALM_RECORD_PAD = 2;
    static final int CM_MIN_STORAGE_SIZE = 38;
    static final int CM_STORAGE_VERSION_2 = 4098;
    boolean m_isPending = false;
    int m_iStructSize = 38;
    int m_iStructVersion = 4098;
    int m_iRecSize = 0;
    byte[] m_rawData = null;

    public PalmRecord() {
        if (m_bDebug) {
            Log.AddEntry("* PalmRecord's Constructor", -1, false);
        }
    }

    public void resetAttribs() {
        this.setIsModified(false);
        this.setIsDeleted(false);
        this.setIsNew(false);
        this.setIsArchived(false);
    }

    public void setAttribs(int n) {
        if ((n | 2) != 0) {
            this.setIsArchived(true);
        }
        if ((n | 4) != 0) {
            this.setIsModified(true);
        }
        if ((n | 1) != 0) {
            this.setIsDeleted(true);
        }
        if ((n | 8) != 0) {
            this.setIsNew(true);
        }
        if ((n | 0x100) != 0) {
            this.setIsPrivate(true);
        }
    }

    public int getAttribs() {
        int n = 0;
        if (super.isArchived()) {
            n |= 2;
        }
        if (super.isDeleted()) {
            n |= 1;
        }
        if (super.isModified()) {
            n |= 4;
        }
        if (super.isPrivate()) {
            n |= 0x100;
        }
        if (super.isNew()) {
            n |= 8;
        }
        return n;
    }

    public boolean isPending() {
        return this.m_isPending;
    }

    public void setIsPending(boolean bl) {
        this.m_isPending = bl;
    }

    public boolean equals(Object object) {
        PalmRecord palmRecord = (PalmRecord)object;
        if (palmRecord.getId() != this.getId()) {
            return false;
        }
        if (this.m_rawData == null) {
            return palmRecord.m_rawData == null;
        }
        if (palmRecord.m_rawData == null) {
            return false;
        }
        if (this.m_rawData.length != palmRecord.m_rawData.length) {
            if (m_bDebug) {
                Log.AddEntry("  record equals - sizes", -1, false);
            }
            return false;
        }
        int n = 0;
        while (n < this.m_rawData.length) {
            if (this.m_rawData[n] != palmRecord.m_rawData[n]) {
                if (m_bDebug) {
                    Log.AddEntry("  record different data", -1, false);
                }
                return false;
            }
            ++n;
        }
        if (palmRecord.getCategoryIndex() != this.getCategoryIndex()) {
            return false;
        }
        if (this.isPrivate() != palmRecord.isPrivate()) {
            return false;
        }
        if (m_bDebug) {
            Log.AddEntry("  records are equal", -1, false);
        }
        return true;
    }

    public Object clone() throws CloneNotSupportedException {
        if (m_bDebug) {
            Log.AddEntry("* PalmRecord's clone", -1, false);
        }
        PalmRecord palmRecord = new PalmRecord();
        palmRecord.setId(this.getId());
        palmRecord.setIndex(this.getIndex());
        palmRecord.setIsPending(this.isPending());
        palmRecord.setIsModified(this.isModified());
        palmRecord.setIsDeleted(this.isDeleted());
        palmRecord.setIsArchived(this.isArchived());
        palmRecord.setCategoryIndex(super.getCategoryIndex());
        palmRecord.setIsNew(super.isNew());
        palmRecord.setIsPrivate(super.isPrivate());
        palmRecord.m_rawData = new byte[this.m_rawData.length];
        System.arraycopy(this.m_rawData, 0, palmRecord.m_rawData, 0, this.m_rawData.length);
        return palmRecord;
    }

    public void writeData(DataOutputStream dataOutputStream) throws IOException {
        if (m_bDebug) {
            Log.AddEntry("* PalmRecord's writeData, raw data length = " + this.m_rawData.length, -1, false);
        }
        this.LogData();
        if (this.m_rawData != null) {
            dataOutputStream.write(this.m_rawData);
        }
    }

    public void readData(DataInputStream dataInputStream) throws IOException {
        if (m_bDebug) {
            Log.AddEntry("* PalmRecord's readData (size = " + dataInputStream.available() + ")", -1, false);
        }
        this.m_rawData = new byte[dataInputStream.available()];
        dataInputStream.read(this.m_rawData);
    }

    public void writeGenericData(FileOutputStream fileOutputStream) throws IOException {
        if (m_bDebug) {
            Log.AddEntry("* PalmRecord's writeGenericData", -1, false);
        }
        int n = 0;
        if (this.m_rawData != null) {
            n = this.m_rawData.length;
        }
        this.m_iStructSize = 40 + n;
        PalmStorage.writeDword(fileOutputStream, this.m_iStructSize);
        this.m_iStructVersion = 4098;
        PalmStorage.writeDword(fileOutputStream, this.m_iStructVersion);
        int n2 = 40;
        PalmStorage.writeDword(fileOutputStream, n2);
        n2 = 0;
        PalmStorage.writeDword(fileOutputStream, n2);
        PalmStorage.writeDword(fileOutputStream, this.getId());
        PalmStorage.writeDword(fileOutputStream, this.getIndex());
        int n3 = 0;
        if (super.isArchived()) {
            n3 |= 2;
        }
        if (super.isDeleted()) {
            n3 |= 1;
        }
        if (super.isModified()) {
            n3 |= 4;
        }
        if (super.isPrivate()) {
            n3 |= 0x100;
        }
        if (super.isNew()) {
            n3 |= 8;
        }
        PalmStorage.writeWord(fileOutputStream, n3);
        int n4 = 0;
        PalmStorage.writeWord(fileOutputStream, n4);
        PalmStorage.writeDword(fileOutputStream, super.getCategoryIndex());
        n2 = 0;
        PalmStorage.writeDword(fileOutputStream, n2);
        if (this.m_rawData != null) {
            PalmStorage.writeDword(fileOutputStream, this.m_rawData.length);
            fileOutputStream.write(this.m_rawData);
        } else {
            PalmStorage.writeDword(fileOutputStream, 0);
        }
    }

    public void readGenericData(FileInputStream fileInputStream) throws IOException {
        if (m_bDebug) {
            Log.AddEntry("* PalmRecord's readGenericData :", -1, false);
        }
        this.m_iStructSize = PalmStorage.readDword(fileInputStream) - 2;
        if (m_bDebug) {
            Log.AddEntry("      m_iStructSize       = " + this.m_iStructSize, -1, false);
        }
        this.m_iStructVersion = PalmStorage.readDword(fileInputStream);
        if (m_bDebug) {
            Log.AddEntry("      m_iStructVersion    = " + this.m_iStructVersion, -1, false);
        }
        int n = PalmStorage.readDword(fileInputStream) - 2;
        if (m_bDebug) {
            Log.AddEntry("      dwRawDataOffset     = " + n, -1, false);
        }
        n = PalmStorage.readDword(fileInputStream);
        if (m_bDebug) {
            Log.AddEntry("      dwInternalFlags     = " + n, -1, false);
        }
        n = PalmStorage.readDword(fileInputStream);
        if (m_bDebug) {
            Log.AddEntry("      dwRecId             = " + n, -1, false);
        }
        this.setId(n);
        n = PalmStorage.readDword(fileInputStream);
        if (m_bDebug) {
            Log.AddEntry("      dwRecIndex          = " + n, -1, false);
        }
        this.setIndex(n);
        int n2 = PalmStorage.readWord(fileInputStream);
        if (m_bDebug) {
            Log.AddEntry("      wAttribs            = " + n2, -1, false);
        }
        int n3 = 0;
        n3 = PalmStorage.readWord(fileInputStream);
        if ((n2 & 4) > 0) {
            super.setIsModified(true);
        }
        if ((n2 & 1) > 0) {
            super.setIsDeleted(true);
        }
        if ((n2 & 2) > 0) {
            super.setIsArchived(true);
        }
        if ((n2 & 8) > 0) {
            super.setIsNew(true);
        } else {
            super.setIsNew(false);
        }
        if ((n2 & 0x100) > 0) {
            super.setIsPrivate(true);
        }
        n = PalmStorage.readDword(fileInputStream);
        if (m_bDebug) {
            Log.AddEntry("      dwCatIndex          = " + n, -1, false);
        }
        this.setCategoryIndex(n);
        n = PalmStorage.readDword(fileInputStream);
        if (m_bDebug) {
            Log.AddEntry("      dwConduitId         = " + n, -1, false);
        }
        this.m_iRecSize = PalmStorage.readDword(fileInputStream);
        if (m_bDebug) {
            Log.AddEntry("      m_iRecSize          = " + this.m_iRecSize, -1, false);
        }
        try {
            if (m_bDebug) {
                Log.AddEntry("  record size         = " + this.m_iRecSize, -1, false);
            }
            this.m_rawData = new byte[this.m_iRecSize];
            if (this.m_iRecSize > 0) {
                fileInputStream.read(this.m_rawData);
            }
        }
        catch (Throwable throwable) {
            Log.err("PalmRecord error - Out of Memory");
            return;
        }
    }

    public int getStatus() {
        if (m_bDebug) {
            Log.AddEntry("* PalmRecord's getStatus", -1, false);
        }
        int n = 0;
        if (this.isModified()) {
            n |= 4;
        }
        if (this.isDeleted()) {
            n |= 1;
        }
        if (this.isNew()) {
            n |= 8;
        }
        if (this.isArchived()) {
            n |= 2;
        }
        if (n == 0) {
            n = 32;
        }
        return n;
    }

    public void LogData() throws IOException {
        if (m_bDebug) {
            Log.AddEntry("* PalmRecord's LogData : ", -1, false);
            Log.AddEntry("      m_iStructSize       = " + this.m_iStructSize, -1, false);
            Log.AddEntry("      m_iStructVersion    = " + this.m_iStructVersion, -1, false);
            Log.AddEntry("      dwRecId             = " + this.getId(), -1, false);
            Log.AddEntry("      dwRecIndex          = " + this.getIndex(), -1, false);
            Log.AddEntry("      dwCatIndex          = " + this.getCategoryIndex(), -1, false);
            Log.AddEntry("      Attributes: ", -1, false);
            if (this.isArchived()) {
                Log.AddEntry("          Archived", -1, false);
            }
            if (this.isPrivate()) {
                Log.AddEntry("          Private", -1, false);
            }
            if (this.isDeleted()) {
                Log.AddEntry("          Deleted", -1, false);
            }
            if (this.isModified() || this.isNew()) {
                Log.AddEntry("          Modified", -1, false);
            }
            if (this.m_rawData != null) {
                Log.AddEntry("      m_iRecSize          = " + this.m_rawData.length, -1, false);
            } else {
                Log.AddEntry("      m_iRecSize          = 0", -1, false);
            }
        }
    }

    public static int flipWord(int n) {
        int n2 = n >> 8 & 0xFF | (n & 0xFF) << 8;
        return n2;
    }

    public static int swapDWordToIntel(int n) {
        int n2 = 0;
        int n3 = 3;
        int n4 = 0;
        while (n4 <= n3) {
            byte by = (byte)(n >> (n3 - n4) * 8 & 0xFF);
            n2 |= by << n4 * 8;
            ++n4;
        }
        return n2;
    }

    public static int swapDWordToMotor(int n) {
        int n2 = 0;
        int n3 = 3;
        int n4 = 0;
        while (n4 <= n3) {
            byte by = (byte)(n >> n4 * 8 & 0xFF);
            n2 |= by << (n3 - n4) * 8;
            ++n4;
        }
        return n2;
    }

    public void setRawData(byte[] byArray) throws GenericException {
        this.m_rawData = byArray;
    }

    public byte[] getRawData() throws GenericException {
        return this.m_rawData;
    }
}

