/*
 * Decompiled with CFR 0.152.
 */
package GenCns.GenJava;

import GenCns.GenJava.GenericException;
import GenCns.GenJava.PalmStorage;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import palm.conduit.Log;

public class GenDbInfo
extends PalmStorage {
    public static boolean m_bDebug = false;
    static final int GENERIC_DB_PAD_SIZE = 2;
    static final int DB_NAMELEN = 32;
    static final int CM_STORAGE_VERSION_2 = 4098;
    static final int CM_MIN_STORAGE_INFO_SIZE = 54;
    static final int GENERIC_DB_INFO_RAW_DATA_OFFSET = 56;
    byte[] m_rawData = null;
    int m_rawDataSize = 0;
    int m_iVersion = 4098;
    int m_iReserved = 0;
    String m_dbName = null;

    public GenDbInfo() {
        if (m_bDebug) {
            Log.AddEntry("* GenDbInfo's Constructor", -1, false);
        }
    }

    public void setData(byte[] byArray) {
        if (m_bDebug) {
            Log.AddEntry("* GenDbInfo's setData", -1, false);
        }
        this.m_rawData = byArray;
        this.m_rawDataSize = byArray.length;
    }

    public void setCategoryData(byte[] byArray) throws GenericException {
        if (m_bDebug) {
            Log.AddEntry("* GenDbInfo's setCategoryData", -1, false);
        }
        if (byArray.length != 274) {
            throw new GenericException(4359);
        }
        if (this.m_rawData == null) {
            this.m_rawData = new byte[byArray.length];
        }
        System.arraycopy(byArray, 0, this.m_rawData, 0, 274);
    }

    public void setData(byte[] byArray, int n) {
        if (m_bDebug) {
            Log.AddEntry("* GenDbInfo's setData at Offset", -1, false);
        }
        byte[] byArray2 = new byte[n + byArray.length];
        if (this.m_rawData != null) {
            System.arraycopy(this.m_rawData, 0, byArray2, 0, n);
        }
        System.arraycopy(byArray, 0, byArray2, n, byArray.length);
        this.m_rawData = byArray2;
        this.m_rawDataSize = this.m_rawData.length;
    }

    public byte[] getData() {
        return this.m_rawData;
    }

    public byte[] getData(int n) {
        if (this.m_rawData != null || this.m_rawData.length > n) {
            byte[] byArray = new byte[this.m_rawData.length - n];
            System.arraycopy(this.m_rawData, n, byArray, 0, this.m_rawData.length - n);
            return byArray;
        }
        return null;
    }

    public int getDataSize() {
        if (this.m_rawData != null) {
            return this.m_rawData.length;
        }
        return 0;
    }

    public int getStructSize() {
        int n = 0;
        if (this.m_rawData != null) {
            n = this.m_rawData.length + 54 + 2;
        }
        return n;
    }

    public byte[] allocateData(int n) {
        this.m_rawData = new byte[n];
        this.m_rawDataSize = n;
        return this.m_rawData;
    }

    public void setName(String string) {
        this.m_dbName = string;
    }

    public String getName() {
        return this.m_dbName;
    }

    public void setVersion(int n) {
        this.m_iVersion = n;
    }

    public int getVersion() {
        return this.m_iVersion;
    }

    public boolean equals(Object object) {
        return false;
    }

    public void writeGenericData(FileOutputStream fileOutputStream) throws IOException {
        int n;
        if (m_bDebug) {
            Log.AddEntry("* GenDbInfo's writeGenericData :", -1, false);
        }
        int n2 = this.getStructSize();
        PalmStorage.writeDword(fileOutputStream, n2);
        if (m_bDebug) {
            Log.AddEntry("      dwStructSize    = " + n2, -1, false);
        }
        PalmStorage.writeWord(fileOutputStream, this.m_iVersion);
        if (m_bDebug) {
            Log.AddEntry("      wVersion        = " + this.m_iVersion, -1, false);
        }
        int n3 = 0;
        PalmStorage.writeWord(fileOutputStream, n3);
        PalmStorage.writeDword(fileOutputStream, 56);
        if (m_bDebug) {
            Log.AddEntry("      dwRawDataOffset = 54", -1, false);
        }
        if ((n = this.m_dbName.length()) > 32) {
            n = 32;
            this.m_dbName = this.m_dbName.substring(0, n - 1);
        }
        try {
            byte[] byArray = new byte[32];
            try {
                this.m_dbName.getBytes(0, this.m_dbName.length(), byArray, 0);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw new IOException("Unable to get name to write");
            }
            fileOutputStream.write(byArray, 0, 32);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (m_bDebug) {
            Log.AddEntry("      m_dbName        = " + this.m_dbName, -1, false);
        }
        PalmStorage.writeDword(fileOutputStream, this.m_rawData.length);
        if (m_bDebug) {
            Log.AddEntry("      dwTotalBytes    = " + this.m_rawData.length, -1, false);
        }
        PalmStorage.writeDword(fileOutputStream, this.m_rawData.length);
        if (m_bDebug) {
            Log.AddEntry("      dwReadBytes     = " + this.m_rawData.length, -1, false);
        }
        PalmStorage.writeDword(fileOutputStream, this.m_iReserved);
        if (m_bDebug) {
            Log.AddEntry("      dwReserved      = " + this.m_iReserved, -1, false);
        }
        fileOutputStream.write(this.m_rawData, 0, this.m_rawData.length);
    }

    public void readGenericData(FileInputStream fileInputStream) throws IOException {
        if (m_bDebug) {
            Log.AddEntry("* GenDbInfo's readGenericData", -1, false);
        }
        int n = PalmStorage.readDword(fileInputStream) - 56;
        this.m_iVersion = PalmStorage.readWord(fileInputStream);
        int n2 = 0;
        n2 = PalmStorage.readWord(fileInputStream);
        int n3 = PalmStorage.readDword(fileInputStream) - 2;
        boolean bl = false;
        this.m_dbName = "";
        int n4 = 0;
        while (n4 < 32) {
            byte by = (byte)PalmStorage.readByte(fileInputStream);
            if (by == 0) {
                bl = true;
            } else if (!bl) {
                this.m_dbName = this.m_dbName + (char)by;
            }
            ++n4;
        }
        n3 = PalmStorage.readDword(fileInputStream);
        int n5 = PalmStorage.readDword(fileInputStream);
        if (n5 != n && m_bDebug) {
            Log.AddEntry("      Structsize " + n5 + " != " + n, -1, false);
        }
        n3 = PalmStorage.readDword(fileInputStream);
        try {
            this.m_rawData = new byte[n];
            fileInputStream.read(this.m_rawData);
            this.LogData();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void LogData() {
        if (m_bDebug) {
            Log.AddEntry("* GenDbInfo's LogData :", -1, false);
            Log.AddEntry("      wVersion        = " + this.m_iVersion, -1, false);
            Log.AddEntry("      dwRawDataOffset = 54", -1, false);
            Log.AddEntry("      m_dbName        = " + this.m_dbName, -1, false);
            if (this.m_rawData != null) {
                Log.AddEntry("      dwTotalBytes    = " + this.m_rawData.length, -1, false);
                Log.AddEntry("      dwReadBytes     = " + this.m_rawData.length, -1, false);
            }
            Log.AddEntry("      dwReserved      = " + this.m_iReserved, -1, false);
        }
    }
}

