/*
 * Decompiled with CFR 0.152.
 */
package CardioFILEConduit;

import java.io.IOException;
import java.util.Vector;
import palm.conduit.Record;
import palm.conduit.SyncException;
import palm.conduit.SyncManager;
import palm.conduit.SyncProperties;

public class RecordManager {
    SyncProperties props;
    Vector hhRecords;
    Vector pcRecords;
    Vector archivedRecords;
    Vector backupRecords;
    Vector slowPCRecords;
    Class recordClass;
    int db;
    int recordIndex;
    int recordCount;
    boolean slowSync;

    public RecordManager(SyncProperties syncProperties, int n, Class clazz) {
        this.props = syncProperties;
        this.db = n;
        this.recordClass = clazz;
        this.hhRecords = new Vector();
        this.slowSync = false;
    }

    private void addPCRecord(Record record) {
        if (this.slowSync) {
            this.slowPCRecords.addElement(record);
        } else {
            this.pcRecords.addElement(record);
        }
    }

    private void archiveRecord(Record record) throws SyncException {
        this.resetAttributes(record);
        this.archivedRecords.addElement(record);
    }

    private boolean compareRecords(Record record, Record record2) throws IOException {
        if (record.getCategoryIndex() != record2.getCategoryIndex() || record.isPrivate() != record2.isPrivate()) {
            return false;
        }
        return record.equals(record2);
    }

    public Vector copyHHRecords() throws SyncException, IOException {
        this.pcRecords = new Vector();
        int n = SyncManager.getDBRecordCount(this.db);
        this.recordIndex = 0;
        while (this.recordIndex < n) {
            Record record = this.getNewRecord();
            record.setIndex(this.recordIndex);
            SyncManager.readRecordByIndex(this.db, record);
            if (!record.isDeleted()) {
                this.resetAttributes(record);
                this.addPCRecord(record);
            }
            ++this.recordIndex;
        }
        SyncManager.purgeDeletedRecs(this.db);
        SyncManager.resetSyncFlags(this.db);
        return this.pcRecords;
    }

    public Vector copyPCRecords(Vector vector) throws SyncException, IOException {
        this.hhRecords = this.pcRecords = vector;
        this.pcRecords.size();
        SyncManager.purgeAllRecs(this.db);
        this.writeHHRecords();
        this.pcRecords = this.copyHHRecords();
        return this.pcRecords;
    }

    private void deleteHHRecord(Record record) throws SyncException {
        SyncManager.deleteRecord(this.db, record);
        this.hhRecords.removeElement(record);
        --this.recordCount;
        --this.recordIndex;
    }

    private void deletePCRecord(Record record) {
        this.pcRecords.removeElement(record);
    }

    public void fastSyncData(Vector vector, Vector vector2) throws SyncException, IOException {
        boolean bl = false;
        this.pcRecords = vector;
        this.archivedRecords = vector2;
        if (this.pcRecords == null) {
            this.pcRecords = new Vector();
        }
        this.recordIndex = 0;
        while (!bl) {
            try {
                Record record = this.getNewRecord();
                SyncManager.readNextModifiedRec(this.db, record);
                this.hhRecords.addElement(record);
                this.synchronizeHHRecord(record);
            }
            catch (SyncException syncException) {
                bl = true;
            }
        }
        bl = false;
        this.recordIndex = 0;
        while (!bl) {
            Record record = this.getNextModifiedRecord();
            if (record != null) {
                this.synchronizePCRecord(record);
                this.resetAttributes(record);
                continue;
            }
            bl = true;
        }
        this.writeHHRecords();
    }

    private Record getNewRecord() {
        Record record = null;
        try {
            record = (Record)this.recordClass.newInstance();
        }
        catch (Throwable throwable) {
            System.out.println("Uncaught exception: " + throwable);
            throwable.printStackTrace();
        }
        return record;
    }

    private Record getNextModifiedRecord() {
        if (this.pcRecords != null) {
            int n = this.recordIndex;
            while (n < this.pcRecords.size()) {
                Record record = (Record)this.pcRecords.elementAt(n);
                ++this.recordIndex;
                if (this.props.firstDevice == 2 || record.isModified() || record.isNew() || record.isDeleted() || record.isArchived()) {
                    return record;
                }
                ++n;
            }
        }
        return null;
    }

    private Record getRecordById(int n, Vector vector) {
        if (vector != null) {
            int n2 = 0;
            while (n2 < vector.size()) {
                Record record = (Record)vector.elementAt(n2);
                if (record.getId() == n) {
                    return record;
                }
                ++n2;
            }
        }
        return null;
    }

    public void handleArchived(Record record, Record record2) throws IOException {
        Record record3;
        if (!record2.isModified()) {
            this.archiveRecord(record);
            this.deleteHHRecord(record);
            this.deletePCRecord(record2);
            return;
        }
        if (!(record.isModified() || record.isNew() || record.isDeleted() || this.props.syncType != 1 || (record3 = this.getRecordById(record.getId(), this.backupRecords)) != null && this.compareRecords(record, record3))) {
            record.setIsModified(true);
        }
        if (record.isModified()) {
            if (this.compareRecords(record, record2)) {
                this.archiveRecord(record);
                this.deleteHHRecord(record);
                this.deletePCRecord(record2);
            } else {
                record2.setId(0);
                record2.setIsNew(true);
                this.resetAttributes(record);
                this.addPCRecord(record);
            }
        } else if (record2.isArchived() || record2.isDeleted()) {
            this.archiveRecord(record);
            this.deletePCRecord(record2);
            this.deleteHHRecord(record);
        } else {
            this.resetAttributes(record2);
            this.deleteHHRecord(record);
            this.hhRecords.addElement(record2);
        }
    }

    public void handleDeleted(Record record, Record record2) throws IOException {
        if (record2.isArchived()) {
            this.archiveRecord(record2);
            this.deleteHHRecord(record);
            this.deletePCRecord(record2);
        } else if (record2.isModified()) {
            this.resetAttributes(record2);
            this.hhRecords.addElement(record2);
        } else {
            this.deleteHHRecord(record);
            this.deletePCRecord(record2);
        }
    }

    public void handleModified(Record record, Record record2) throws IOException {
        Record record3;
        if (!(record.isModified() || (record3 = this.getRecordById(record.getId(), this.backupRecords)) != null && this.compareRecords(record, record3))) {
            record.setIsModified(true);
        }
        if (record.isModified()) {
            if (record2.isDeleted()) {
                this.deletePCRecord(record2);
                this.addPCRecord(record);
            } else if (!record2.isModified()) {
                this.resetAttributes(record);
                this.deletePCRecord(record2);
                this.addPCRecord(record);
            } else if (this.compareRecords(record, record2)) {
                if (record2.isArchived()) {
                    this.archiveRecord(record2);
                    this.deletePCRecord(record2);
                    this.deleteHHRecord(record);
                } else if (record2.isDeleted()) {
                    this.deletePCRecord(record2);
                    this.deleteHHRecord(record);
                } else {
                    this.resetAttributes(record2);
                    if (this.slowSync) {
                        this.slowPCRecords.addElement(record2);
                    }
                }
            } else {
                this.resetAttributes(record2);
                record2.setIsNew(true);
                record2.setId(0);
                this.resetAttributes(record);
                this.addPCRecord(record);
            }
        } else {
            if (record2.isArchived()) {
                this.archiveRecord(record2);
                this.deleteHHRecord(record2);
            } else if (record2.isDeleted()) {
                this.deleteHHRecord(record);
            } else if (record2.isModified() && !this.compareRecords(record, record2)) {
                this.hhRecords.addElement(record2);
                this.slowPCRecords.addElement(record2);
            } else {
                this.slowPCRecords.addElement(record2);
            }
            this.pcRecords.removeElement(record2);
        }
    }

    private void resetAttributes(Record record) {
        record.setIsModified(false);
        record.setIsArchived(false);
        record.setIsDeleted(false);
        record.setIsNew(false);
    }

    private Record retrieveHHRecord(Record record) throws IOException {
        Record record2 = this.getNewRecord();
        record2.setId(record.getId());
        try {
            SyncManager.readRecordById(this.db, record2);
        }
        catch (SyncException syncException) {
            return null;
        }
        return record2;
    }

    public Vector slowSyncData(Vector vector, Vector vector2, Vector vector3) throws SyncException, IOException {
        this.backupRecords = vector3;
        this.pcRecords = vector;
        this.archivedRecords = vector2;
        if (this.pcRecords == null) {
            this.pcRecords = new Vector();
        }
        this.recordIndex = 0;
        this.slowPCRecords = new Vector();
        this.slowSync = true;
        this.recordCount = SyncManager.getDBRecordCount(this.db);
        this.recordIndex = 0;
        while (this.recordIndex < this.recordCount) {
            Record record = this.getNewRecord();
            record.setIndex(this.recordIndex);
            SyncManager.readRecordByIndex(this.db, record);
            this.synchronizeHHRecord(record);
            ++this.recordIndex;
        }
        int n = 0;
        while (n < vector.size()) {
            Record record = (Record)vector.elementAt(n);
            if (record.isNew()) {
                this.resetAttributes(record);
                this.addPCRecord(record);
                this.hhRecords.addElement(record);
            }
            ++n;
        }
        this.writeHHRecords();
        return this.slowPCRecords;
    }

    public void synchronizeHHRecord(Record record) throws SyncException, IOException {
        Record record2 = this.getRecordById(record.getId(), this.pcRecords);
        if (record2 == null) {
            if (record.isArchived()) {
                this.archiveRecord(record);
                this.deleteHHRecord(record);
            } else if (record.isDeleted()) {
                this.deletePCRecord(record);
                this.deleteHHRecord(record);
            } else {
                this.resetAttributes(record);
                this.addPCRecord(record);
                this.hhRecords.removeElement(record);
            }
        } else if (record.isArchived()) {
            this.handleArchived(record, record2);
        } else if (record.isDeleted()) {
            this.handleDeleted(record, record2);
        } else {
            this.handleModified(record, record2);
        }
    }

    public void synchronizePCRecord(Record record) throws IOException, SyncException {
        if (!record.isNew()) {
            Record record2 = this.retrieveHHRecord(record);
            if (record2 == null) {
                if (this.props.firstDevice == 2) {
                    this.hhRecords.addElement(record);
                }
                SyncManager.writeRec(this.db, record);
            } else if (record.isArchived()) {
                this.archiveRecord(record);
                this.deletePCRecord(record);
                this.deleteHHRecord(record);
            } else if (record.isDeleted()) {
                this.deletePCRecord(record);
                this.deleteHHRecord(record2);
            } else if (!this.compareRecords(record2, record)) {
                this.hhRecords.addElement(record);
            }
        } else if (record.isArchived()) {
            this.archiveRecord(record);
            this.deletePCRecord(record);
        } else if (record.isDeleted()) {
            this.deletePCRecord(record);
        } else {
            this.resetAttributes(record);
            this.hhRecords.addElement(record);
        }
    }

    private void writeHHRecords() throws IOException {
        if (this.hhRecords != null) {
            int n = 0;
            while (n < this.hhRecords.size()) {
                Record record = (Record)this.hhRecords.elementAt(n);
                SyncManager.writeRec(this.db, record);
                ++n;
            }
            SyncManager.purgeDeletedRecs(this.db);
            SyncManager.resetSyncFlags(this.db);
        }
    }
}

