/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.tiff;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.UnsupportedFormatException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.decoder.tiff.IFD;
import com.sun.jimi.core.decoder.tiff.IFDDecode;
import com.sun.jimi.core.util.SeekInputStream;
import com.sun.jimi.util.ExpandableArray;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class TIFDecoder
extends JimiDecoderBase {
    public final short TIF_SIG_BE = (short)19789;
    public final short TIF_SIG_LE = (short)18761;
    public final short TIF_VERSION = (short)42;
    public final short TIF_HEADER_SIZE = (short)8;
    private AdaptiveRasterImage ji;
    private InputStream in;
    private InputStream bufIn;
    private SeekInputStream sis;
    private int state;
    private short tifSignature;
    private short version;
    private int ifdOffset;
    int nextIFDoffset;
    ExpandableArray IFDs;

    public void decode(IFD iFD) throws JimiException, IOException {
        IFDDecode iFDDecode = new IFDDecode(this, this.ji, this.sis);
        iFDDecode.decodeTags(iFD);
        iFDDecode.decodeImage();
    }

    public boolean driveDecoder() throws JimiException {
        try {
            if (this.nextIFDoffset == 0) {
                throw new JimiException("No more images.");
            }
            IFD iFD = new IFD();
            iFD.read(this.nextIFDoffset, this.sis);
            this.nextIFDoffset = iFD.offset;
            this.state = this.nextIFDoffset == 0 ? (this.state &= 0xFFFFFFF7) : (this.state |= 8);
            this.IFDs.addElement(iFD);
            try {
                this.decode(iFD);
            }
            catch (Exception exception) {}
            this.ji.addFullCoverage();
            this.state = 0;
            this.state |= 2;
            this.state |= 4;
            if (this.nextIFDoffset != 0) {
                this.state |= 8;
            }
        }
        catch (IOException iOException) {
            throw new JimiException("TIFF IO Error");
        }
        return false;
    }

    public void freeDecoder() throws JimiException {
        this.in = null;
        this.bufIn = null;
        this.sis = null;
        this.ji = null;
    }

    public int getCapabilities() {
        return 1;
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.ji;
    }

    public int getState() {
        return this.state;
    }

    public void initDecoder(InputStream inputStream, AdaptiveRasterImage adaptiveRasterImage) throws JimiException {
        try {
            this.in = inputStream;
            this.bufIn = inputStream;
            DataInputStream dataInputStream = new DataInputStream(this.bufIn);
            this.tifSignature = dataInputStream.readShort();
            if (this.tifSignature != 18761 && this.tifSignature != 19789) {
                throw new UnsupportedFormatException("not a TIFF file");
            }
            this.sis = new SeekInputStream(this.tifSignature == 19789, this.bufIn, 2);
            this.version = this.sis.readShort();
            this.ifdOffset = this.sis.readInt();
            if (this.version != 42 || this.ifdOffset < 8) {
                throw new UnsupportedFormatException("invalid TIFF Version or TIFF Header size");
            }
            this.ji = adaptiveRasterImage;
            this.nextIFDoffset = this.ifdOffset;
            this.state = 8;
            this.IFDs = new ExpandableArray();
        }
        catch (IOException iOException) {
            throw new JimiException("IO Error reading TIFF header");
        }
    }

    public void skipImage() throws JimiException {
        try {
            IFD iFD = new IFD();
            iFD.read(this.nextIFDoffset, this.sis);
            this.nextIFDoffset = iFD.offset;
            if (this.nextIFDoffset == 0) {
                this.state &= 0xFFFFFFF7;
            }
        }
        catch (IOException iOException) {
            throw new JimiException("Read error");
        }
    }
}

