/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.tga;

import com.sun.jimi.core.decoder.tga.TGAFileHeader;
import com.sun.jimi.core.util.LEDataInputStream;
import java.io.IOException;

public class TGAColorMap {
    byte[] cmap;

    public TGAColorMap(LEDataInputStream lEDataInputStream, TGAFileHeader tGAFileHeader) throws IOException {
        if (tGAFileHeader.colorMapType == 1) {
            switch (tGAFileHeader.colorMapEntrySize) {
                case 8: {
                    this.cmap = new byte[tGAFileHeader.colorMapLength];
                    int n = 0;
                    int n2 = tGAFileHeader.firstEntryIndex;
                    while (n2 < tGAFileHeader.colorMapLength) {
                        byte by;
                        this.cmap[n] = by = lEDataInputStream.readByte();
                        this.cmap[++n] = by;
                        this.cmap[++n] = by;
                        ++n;
                        ++n2;
                    }
                    break;
                }
                case 15: 
                case 16: {
                    this.cmap = new byte[tGAFileHeader.colorMapLength * 3];
                    int n = tGAFileHeader.firstEntryIndex * 3;
                    int n3 = tGAFileHeader.firstEntryIndex;
                    while (n3 < tGAFileHeader.colorMapLength) {
                        short s = lEDataInputStream.readShort();
                        this.cmap[n] = (byte)((s >> 10 & 0x1F) * 255 / 31);
                        this.cmap[++n] = (byte)((s >> 5 & 0x1F) * 255 / 31);
                        this.cmap[++n] = (byte)((s & 0x1F) * 255 / 31);
                        ++n;
                        ++n3;
                    }
                    break;
                }
                case 24: {
                    this.cmap = new byte[tGAFileHeader.colorMapLength * 3];
                    int n = tGAFileHeader.firstEntryIndex * 3;
                    int n4 = tGAFileHeader.firstEntryIndex;
                    while (n4 < tGAFileHeader.colorMapLength) {
                        byte by;
                        byte by2 = lEDataInputStream.readByte();
                        byte by3 = lEDataInputStream.readByte();
                        this.cmap[n] = by = lEDataInputStream.readByte();
                        this.cmap[++n] = by3;
                        this.cmap[++n] = by2;
                        ++n;
                        ++n4;
                    }
                    break;
                }
                case 32: {
                    this.cmap = new byte[tGAFileHeader.colorMapLength * 4];
                    int n = tGAFileHeader.firstEntryIndex * 4;
                    int n5 = tGAFileHeader.firstEntryIndex;
                    while (n5 < tGAFileHeader.colorMapLength) {
                        byte by = lEDataInputStream.readByte();
                        byte by4 = lEDataInputStream.readByte();
                        byte by5 = lEDataInputStream.readByte();
                        byte by6 = lEDataInputStream.readByte();
                        this.cmap[n] = by5;
                        this.cmap[++n] = by4;
                        this.cmap[++n] = by;
                        this.cmap[++n] = by6;
                        ++n;
                        ++n5;
                    }
                    break;
                }
            }
        }
    }
}

