#ifndef PARTITION_H_
#define PARTITION_H_ 1
// Partition.h : just contains data structure for a partition: name, colour, range
//

// Copyright (c) 1999 by Andrew W. Phillips.
//
// No restrictions are placed on the noncommercial use of this code,
// as long as this text (from the above copyright notice to the
// disclaimer below) is preserved.
//
// This code may be redistributed as long as it remains unmodified
// and is not sold for profit without the author's written consent.
//
// This code, or any part of it, may not be used in any software that
// is sold for profit, without the author's written consent.
//
// DISCLAIMER: This file is provided "as is" with no expressed or
// implied warranty. The author accepts no liability for any damage
// or loss of business that this product may cause.
//

#pragma warning(disable : 4786) // We need this so we don't miss important warnings
#include <sstream>
#include <string>
#include "range_set.h"

struct partn
{
    partn(const CString &n = "", COLORREF c = 0, const char *r = NULL) : name(n), col(c)
    {
        if (r != NULL)
        {
            std::istringstream str(r);
            str >> range;
        }
    }
    CString name;
    COLORREF col;
    range_set<int> range;
    friend operator==(const partn &p1, const partn &p2)
    {
        return p1.name == p2.name && p1.col == p2.col && p1.range == p2.range;
    }
};
#endif
