// EBCDIC.cpp : contains EBCDIC <-> ASCII conversion tables and routine to read, test, fix them
//
// Copyright (c) 1999 by Andrew W. Phillips.

#include "stdafx.h"
#include "HexEdit.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

// Table to convert EBCDIC to ASCII - used to display EBCDIC chars
// [Only converts display characters - not control characters.)
unsigned char e2a_tab[] =
{
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

        0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x5b,0x2e,0x3c,0x28,0x2b,0x21,
        0x26,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x5d,0x24,0x2a,0x29,0x3b,0x5E,
        0x2d,0x2f,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x2c,0x25,0x5f,0x3e,0x3f,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x60,0x3a,0x23,0x40,0x27,0x3d,0x22,

        0x00,0x61,0x62,0x63,0x64,0x65,0x66,0x67,
        0x68,0x69,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x6a,0x6b,0x6c,0x6d,0x6e,0x6f,0x70,
        0x71,0x72,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x73,0x74,0x75,0x76,0x77,0x78,
        0x79,0x7a,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,

        0x7B,0x41,0x42,0x43,0x44,0x45,0x46,0x47,
        0x48,0x49,0x00,0x00,0x00,0x00,0x00,0x00,
        0x7D,0x4a,0x4b,0x4c,0x4d,0x4e,0x4f,0x50,
        0x51,0x52,0x00,0x00,0x00,0x00,0x00,0x00,
        0x5C,0x00,0x53,0x54,0x55,0x56,0x57,0x58,
        0x59,0x5a,0x00,0x00,0x00,0x00,0x00,0x00,
        0x30,0x31,0x32,0x33,0x34,0x35,0x36,0x37,
        0x38,0x39,0x00,0x00,0x00,0x00,0x00,0x00
};

// Table to convert ASCII to EBCDIC - used when entering chars in EBCDIC mode
// [Note: only converts display characters - not control characters.)
unsigned char a2e_tab[] =
{
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
        0x40,0x4F,0x7F,0x7B,0x5B,0x6C,0x50,0x7D,
        0x4D,0x5D,0x5C,0x4E,0x6B,0x60,0x4B,0x61,
        0xF0,0xF1,0xF2,0xF3,0xF4,0xF5,0xF6,0xF7,
        0xF8,0xF9,0x7A,0x5E,0x4C,0x7E,0x6E,0x6F,

        0x7C,0xC1,0xC2,0xC3,0xC4,0xC5,0xC6,0xC7,
        0xC8,0xC9,0xD1,0xD2,0xD3,0xD4,0xD5,0xD6,
        0xD7,0xD8,0xD9,0xE2,0xE3,0xE4,0xE5,0xE6,
        0xE7,0xE8,0xE9,0x4A,0xE0,0x5A,0x5F,0x6D,
        0x79,0x81,0x82,0x83,0x84,0x85,0x86,0x87,
        0x88,0x89,0x91,0x92,0x93,0x94,0x95,0x96,
        0x97,0x98,0x99,0xA2,0xA3,0xA4,0xA5,0xA6,
        0xA7,0xA8,0xA9,0xC0,0x00,0xD0,0x00,0x00,
};

void CHexEditApp::InitEbcdic()
{
    int ii;                             // Loop var
    FILE *ftab;                         // File containing the new EBCDIC table
    char table_fullname[_MAX_PATH];     // Full name of EBCDIC table file
    char *end;                          // End of path of help file
    CString err_mess;                   // Any problems with table read from file

    // Try to find the EBCDIC table file in the same dir as the help file
    strncpy(table_fullname, m_pszHelpFilePath, sizeof(table_fullname)-12);
    table_fullname[sizeof(table_fullname)-12] = '\0';
    if ((end = strrchr(table_fullname, '\\')) == NULL && (end = strrchr(table_fullname, ':')) == NULL)
        end = table_fullname;
    else
        ++end;
    *end = '\0';
    strcat(table_fullname, "EBCDIC.TAB");
    if ((ftab = fopen(table_fullname, "rb")) != NULL)
    {
        // File found - read it into e2a_tab
        if (fread(e2a_tab, sizeof(e2a_tab), 1, ftab) == 1)
        {
            ASSERT(fgetc(ftab) == EOF);        // Make sure file is right length
            ASSERT(e2a_tab[0] == 0);

            fclose(ftab);

            // Fix a2e_tab to match e2a_tab
            for (ii = 0; ii < sizeof(a2e_tab); ++ii)        // Init to all zero
                a2e_tab[ii] = 0;

            for (ii = 0; ii < sizeof(e2a_tab); ++ii)
            {
                if (e2a_tab[ii] < 128)
                    a2e_tab[e2a_tab[ii]] = ii;
                else if (e2a_tab[ii] != 0)
                {
                    CString ss;
                    ss.Format("EBCDIC table entry %ld is not a valid ASCII character\n", long(ii));
                    err_mess += ss;
                }
            }
        }
        else
            err_mess = "ECBDIC.TAB is too short";

        if (!err_mess.IsEmpty())
            ::HMessageBox(err_mess);
    }

#ifdef _DEBUG
    // Verify that ASCII -> EBCDIC and EBCDIC -> ASCII conversions are compatible
    for (ii = 0; ii < 256; ++ii)
    {
        ASSERT(e2a_tab[ii] < 128);
        if (e2a_tab[ii] > 0)
            ASSERT(a2e_tab[e2a_tab[ii]] == ii);
    }
    for (ii = 0; ii < 128; ++ii)
        if (a2e_tab[ii] > 0)
            ASSERT(e2a_tab[a2e_tab[ii]] == ii);
#endif
}
