<?xml version="1.0"?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">

<HTML>
<HEAD>
    <TITLE>Supplier Info</TITLE>
    <LINK REL="stylesheet" type="text/css"><xsl:attribute name="href"><xsl:value-of select="MSI/LAYOUT/WEBPATH"/><xsl:value-of select="MSI/LAYOUT/CSS"/></xsl:attribute></LINK>
</HEAD>



<BODY CLASS="PRINT">

<H3 CLASS="PRINT"><CENTER>Supplier Information</CENTER></H3>

<xsl:for-each select="MSI/SUPPLIERLIST/SUPPLIER">
<xsl:sort select="SUPPLIERINFO/SupplierTable/supplier_name" data-type="text" order="ascending"/>

<TABLE>
   
<TR>
<TD><H4 CLASS="PRINT"><xsl:value-of select="SUPPLIERINFO/SupplierTable/supplier_name"/></H4></TD>
</TR>

<TR CLASS="PRINT">
<TD><B>Contact:<xsl:text> </xsl:text><xsl:value-of select="SUPPLIERINFO/SupplierTable/contact_person"/></B></TD>
</TR>



<TR CLASS="PRINT">
<TD><xsl:value-of select="SUPPLIERINFO/SupplierTable/address1"/></TD>
</TR>

<TR CLASS="PRINT">
<TD><xsl:value-of select="SUPPLIERINFO/SupplierTable/address2"/></TD>
</TR>

<TR CLASS="PRINT">
<TD><xsl:value-of select="SUPPLIERINFO/SupplierTable/city"/><xsl:text>, </xsl:text><xsl:value-of select="SUPPLIERINFO/SupplierTable/state"/><xsl:text> </xsl:text><xsl:value-of select="SUPPLIERINFO/SupplierTable/zip"/></TD>
</TR>

<TR CLASS="PRINT">
<TD>Phone:<xsl:text> </xsl:text><xsl:value-of select="SUPPLIERINFO/SupplierTable/phone"/></TD>
</TR>

<TR CLASS="PRINT">
<TD>Cell Phone:<xsl:text> </xsl:text><xsl:value-of select="SUPPLIERINFO/SupplierTable/phone"/></TD>
</TR>

<TR CLASS="PRINT">
<TD>Fax:<xsl:text> </xsl:text><xsl:value-of select="SUPPLIERINFO/SupplierTable/fax"/></TD>
</TR>

<TR CLASS="PRINT">
<TD>Email:<xsl:text> </xsl:text><xsl:value-of select="SUPPLIERINFO/SupplierTable/email"/></TD>
</TR>

<TR CLASS="PRINT">
<TD>Web Site:<xsl:text> </xsl:text><xsl:value-of select="SUPPLIERINFO/SupplierTable/website"/></TD>
</TR>

</TABLE>


<xsl:choose>
<xsl:when test="ITEMRESULT/ProductTable[.!='']">


<TABLE CELLPADDING="2">
<TR CLASS="PRINT">
<TH>Sku</TH>
<TH>Description</TH>
<TH>Price</TH>
<TH>Type</TH>
<TH>Discount</TH>
</TR>


<xsl:for-each select="ITEMRESULT/ProductTable">
<xsl:sort select="sku" data-type="text" order="ascending"/>
<TR CLASS="PRINT">

<TD><xsl:value-of select="sku"/></TD>
<TD><xsl:value-of select="itemdescription"/></TD>
<TD ALIGN="RIGHT">$<xsl:value-of select="price"/></TD>
<TD><xsl:value-of select="itemtype"/></TD>

<xsl:choose>
<xsl:when test="multiitem[.='1']">
<TD ALIGN="CENTER">Yes</TD>
</xsl:when>
</xsl:choose>

</TR>
</xsl:for-each>

</TABLE>

</xsl:when>
</xsl:choose>

<P/>

</xsl:for-each>

</BODY></HTML>


</xsl:template>
</xsl:stylesheet>
