<?xml version="1.0"?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">

<HTML>
<HEAD>
    <TITLE>Customer Info</TITLE>
    <LINK REL="stylesheet" type="text/css"><xsl:attribute name="href"><xsl:value-of select="MSI/LAYOUT/WEBPATH"/><xsl:value-of select="MSI/LAYOUT/CSS"/></xsl:attribute></LINK>
</HEAD>



<BODY CLASS="PRINT">

<H3 CLASS="PRINT"><CENTER>Customer Information</CENTER></H3>

<xsl:for-each select="MSI/CUSTOMERINFOLIST/CUSTOMERINFO">
<xsl:sort select="CompanyTable/company_name" data-type="text" order="ascending"/>

<TABLE>
   
<TR>
<TD><H4 CLASS="PRINT"><xsl:value-of select="CompanyTable/company_name"/></H4></TD>
</TR>

<TR>
<TD><H5 CLASS="PRINT">Buyer:<xsl:text> </xsl:text><xsl:value-of select="CompanyTable/buyer"/></H5>
</TD>
</TR>

<TR CLASS="PRINT">
<TD>Billing Address</TD>
<TD></TD>
<TD>Shipping Address</TD>
</TR>

<TR CLASS="PRINT">
<TD><xsl:value-of select="CompanyTable/bill_address1"/></TD>
<TD></TD>
<TD><xsl:value-of select="CompanyTable/ship_address1"/></TD>
</TR>

<TR CLASS="PRINT">
<TD><xsl:value-of select="CompanyTable/bill_address2"/></TD>
<TD></TD>
<TD><xsl:value-of select="CompanyTable/ship_address2"/></TD>
</TR>

<TR CLASS="PRINT">
<TD><xsl:value-of select="CompanyTable/bill_city"/><xsl:text>, </xsl:text><xsl:value-of select="CompanyTable/bill_state"/><xsl:text> </xsl:text><xsl:text> </xsl:text><xsl:value-of select="CompanyTable/bill_zip"/></TD>
<TD></TD>
<TD><xsl:value-of select="CompanyTable/ship_city"/><xsl:text>, </xsl:text><xsl:value-of select="CompanyTable/ship_state"/><xsl:text> </xsl:text><xsl:text> </xsl:text><xsl:value-of select="CompanyTable/ship_zip"/></TD>
</TR>

<TR CLASS="PRINT">
<TD>Phone:<xsl:text> </xsl:text><xsl:value-of select="CompanyTable/phone"/></TD>
</TR>

<TR CLASS="PRINT">
<TD>Cell Phone:<xsl:text> </xsl:text><xsl:value-of select="CompanyTable/cellPhone"/></TD>
</TR>

<TR CLASS="PRINT">
<TD>Fax:<xsl:text> </xsl:text><xsl:value-of select="CompanyTable/fax"/></TD>
</TR>

<TR CLASS="PRINT">
<TD>Email:<xsl:text> </xsl:text><xsl:value-of select="CompanyTable/email"/></TD>
</TR>

<TR CLASS="PRINT">
<TD>Web Site:<xsl:text> </xsl:text><xsl:value-of select="CompanyTable/website"/></TD>
</TR>




</TABLE>
<P/>

</xsl:for-each>

</BODY></HTML>


</xsl:template>
</xsl:stylesheet>
