<?xml version="1.0"?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">


<HTML>
<HEAD>
     <TITLE>Product Page for <xsl:value-of select="MSI/FULLRESULT/SUPPLIER/SUPPLIER_NAME"/></TITLE>
     <LINK REL="stylesheet" type="text/css"><xsl:attribute name="href"><xsl:value-of select="MSI/LAYOUT/WEBPATH"/><xsl:value-of select="MSI/LAYOUT/CSS"/></xsl:attribute></LINK>
</HEAD>


<SCRIPT LANGUAGE="JavaScript">
<xsl:comment>
<![CDATA[

function setTab(focusItem) {
    focusItem.focus();
}

function validate(form) {
   var field = form.SKU;  
   //var fieldval = parseInt(field.value);   
   if (field.value == '') {
      alert("You must enter a product ID.");
      return false;
   }
   else {
      return true;
   }
}
]]>
</xsl:comment>
</SCRIPT>



<BODY onLoad="setTab(FORM1.SKU)">



<CENTER><H1>Products for <xsl:value-of select="MSI/FULLRESULT/SUPPLIER/SUPPLIER_NAME"/></H1></CENTER><P></P>
<FORM NAME="FORM1" METHOD="POST" onSubmit="return validate(this)">
<xsl:attribute name="ACTION"><xsl:value-of select="MSI/LAYOUT/SERVLET"/></xsl:attribute>



<INPUT TYPE="HIDDEN" NAME="recipient" VALUE=""></INPUT>
<INPUT TYPE="HIDDEN" NAME="subject" VALUE=""></INPUT>
<INPUT TYPE="HIDDEN" NAME="redirect" VALUE=""></INPUT>

<INPUT type="hidden" NAME="COMPANYID"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/FULLRESULT/SUPPLIER/SUPPLIER_ID"/></xsl:attribute></INPUT>
<INPUT type="hidden" NAME="COMPANYNAME"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/FULLRESULT/SUPPLIER/SUPPLIER_NAME"/></xsl:attribute></INPUT>
<INPUT type="hidden" name="disValue" value="263"></INPUT>


<TABLE CELLPADDING="2" WIDTH="100%">

<TR><TD WIDTH="30%" VALIGN="TOP">Product ID</TD><TD WIDTH="70%" VALIGN="TOP"><INPUT NAME="SKU" VALUE="" SIZE="10"></INPUT></TD></TR>
<TR><TD WIDTH="30%" VALIGN="TOP">Product Description</TD><TD WIDTH="70%" VALIGN="TOP"><INPUT NAME="ITEMDESCRIPTION" VALUE="" SIZE="30"></INPUT></TD></TR>
<TR><TD WIDTH="30%" VALIGN="TOP">Price</TD><TD WIDTH="70%" VALIGN="TOP"><INPUT NAME="PRICE" VALUE="" SIZE="10"></INPUT></TD></TR>
<TR><TD WIDTH="30%" VALIGN="TOP">Commission</TD><TD WIDTH="70%" VALIGN="TOP"><INPUT NAME="COMMISSION" VALUE="" SIZE="30"></INPUT></TD></TR>
<TR><TD WIDTH="30%" VALIGN="TOP">Item Catagory</TD><TD WIDTH="70%" VALIGN="TOP"><INPUT NAME="ITEMTYPE" VALUE="" SIZE="30"></INPUT></TD></TR>
<TR><TD>Multi Item Discount</TD><TD><INPUT TYPE="CheckBox" NAME="MULTIDISCOUNT" VALUE="MULTI"></INPUT></TD></TR>
<TR><TD COLSPAN="2"><INPUT TYPE="SUBMIT" VALUE="Add Product"></INPUT></TD></TR>

</TABLE></FORM><P></P>

<P></P>


<xsl:choose>
<xsl:when test="MSI/FULLRESULT/ITEMRESULT/ProductTable[.!='']">

<FORM METHOD="POST">
<xsl:attribute name="ACTION"><xsl:value-of select="MSI/LAYOUT/SERVLET"/></xsl:attribute>


<TABLE>
	
		<TR>
			<TH></TH>
			<TH>Item ID</TH>
			<TH> Item Description </TH>
			<TH> Price </TH>
			<TH> Commission </TH>
			<TH> Category </TH>
			<TH></TH>
		</TR>
		<xsl:for-each select="MSI/FULLRESULT/ITEMRESULT/ProductTable">
		<xsl:sort select="sku" data-type="number" order="ascending"/>
			<TR>
			    <xsl:choose>
			    <xsl:when test="position() mod 2 = 1">
		   	    <xsl:attribute name="CLASS">ODDROW</xsl:attribute>
			    </xsl:when>
			    <xsl:otherwise>
				    <xsl:attribute name="CLASS">EVENROW</xsl:attribute>
			    </xsl:otherwise>
			    </xsl:choose>			
    				
			
				<TD><INPUT TYPE="CheckBox">
					<xsl:attribute name="NAME">item<xsl:value-of select="c1"/></xsl:attribute>
					<xsl:attribute name="VALUE"><xsl:value-of select="sku"/></xsl:attribute>
				     </INPUT></TD>
				<TD><xsl:value-of select="sku"/></TD>
				<TD><xsl:value-of select="itemdescription"/></TD>
				<TD align="RIGHT">$<xsl:value-of select="price"/></TD>
				
				<TD align="CENTER">
				<xsl:choose>
				<xsl:when test="commission[.!='']">
				<xsl:value-of select="commission"/>%
				</xsl:when>
				</xsl:choose>
				</TD>
				
				<TD><!-- xsl:value-of select="itemtype"/ -->
				<xsl:choose>
				<xsl:when test="itemtype[.!='']">
				<xsl:value-of select="itemtype"/>
				</xsl:when>
				</xsl:choose>
				</TD>

		
				
				<TD>				
				<xsl:choose>
				<xsl:when test="multiitem[.='1']">
					<INPUT TYPE="SUBMIT" VALUE="Edit Discounts">
					<xsl:attribute name="NAME">discount<xsl:value-of select="c1"/></xsl:attribute>
					</INPUT>
				</xsl:when>
				<xsl:otherwise>
					<INPUT TYPE="SUBMIT" VALUE="Add Discounts">
					<xsl:attribute name="NAME">discount<xsl:value-of select="c1"/></xsl:attribute>
					</INPUT>
				</xsl:otherwise>
				</xsl:choose>
				</TD>

				<INPUT TYPE="hidden">
					<xsl:attribute name="NAME">sku<xsl:value-of select="c1"/></xsl:attribute>
					<xsl:attribute name="VALUE"><xsl:value-of select="sku"/></xsl:attribute>
				</INPUT>

				<INPUT TYPE="hidden">
					<xsl:attribute name="NAME">desc<xsl:value-of select="c1"/></xsl:attribute>
					<xsl:attribute name="VALUE"><xsl:value-of select="itemdescription"/></xsl:attribute>
				</INPUT>

			
			</TR>
		</xsl:for-each>
</TABLE>

<INPUT type="hidden" name="disValue" value="267"></INPUT>
<INPUT type="hidden" NAME="TOTALITEMS"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/FULLRESULT/ITEMRESULT/FOOTER/TOTALCOUNT"/></xsl:attribute></INPUT>
<INPUT type="hidden" NAME="COMPANYID"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/FULLRESULT/SUPPLIER/SUPPLIER_ID"/></xsl:attribute></INPUT>
<INPUT type="hidden" NAME="COMPANYNAME"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/FULLRESULT/SUPPLIER/SUPPLIER_NAME"/></xsl:attribute></INPUT>
<INPUT TYPE="SUBMIT" NAME="EDIT" VALUE="Edit Products"></INPUT><xsl:text> </xsl:text>
<INPUT TYPE="SUBMIT" NAME="DELETE" VALUE="Delete Products"></INPUT>
</FORM><P></P>

</xsl:when>
</xsl:choose>



</BODY></HTML>

</xsl:template>
</xsl:stylesheet>
