<?xml version="1.0"?>
<xsl:stylesheet
  version="1.0"
  xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:template match="/">


<HTML>
<HEAD>
     <TITLE>Pay Rep</TITLE>
     <LINK REL="stylesheet" type="text/css"><xsl:attribute name="href"><xsl:value-of select="MSI/LAYOUT/WEBPATH"/><xsl:value-of select="MSI/LAYOUT/CSS"/></xsl:attribute></LINK>
</HEAD>

<SCRIPT LANGUAGE="JavaScript">
<xsl:comment>
<![CDATA[
function validate(form) {
   var field = form.CHECKNUM;  
      //var fieldval = parseInt(field.value);   
   
   if (field.value == '') {
      alert("You must enter a Check Number.");
      return false;
   }

   
   field = form.REP;		
   if (field.value == '') {
      alert("You need to select a Rep.");
      return false;
   }
   else {
      return true;
   }
}

function setTab(focusItem) {
    focusItem.focus();
}

]]>
</xsl:comment>
</SCRIPT>


<BODY onLoad="setTab(FORM1.REP)">


<CENTER><H1>Pay Rep Check</H1></CENTER><P></P>
<P></P>
<TD CLASS="REQUIRED">Red Field</TD> - denotes a required field (cannot be blank)<P></P>

<FORM METHOD="POST" NAME="FORM1" onSubmit="return validate(this)">
<xsl:attribute name="ACTION"><xsl:value-of select="MSI/LAYOUT/SERVLET"/></xsl:attribute>

<input type="hidden" name="disValue" value="805"></input>

<TABLE>

<xsl:choose>
<xsl:when test="MSI/REPLIST/REP/REPNAME[.!='']">

<TR><TD CLASS="REQUIRED">Select Rep</TD><TD/><TD><SELECT NAME="REP">
<xsl:for-each select="MSI/REPLIST/REP">
<xsl:sort select="REPNAME" data-type="text" order="ascending"/>

<OPTION> 
	<xsl:attribute name="VALUE"><xsl:value-of select="REPID"/></xsl:attribute><xsl:value-of select="REPNAME"/>
</OPTION>
</xsl:for-each>
</SELECT></TD></TR>
</xsl:when>

<xsl:otherwise>
Using current User for Check
<input type="hidden" name="REP">
<xsl:attribute name="VALUE"><xsl:value-of select="MSI/REPLIST/REP/REPID"/></xsl:attribute>
</input>
</xsl:otherwise>
</xsl:choose>



<TR><TD CLASS="REQUIRED">Check Number</TD><TD></TD><TD><INPUT NAME="CHECKNUM" VALUE="" SIZE="15"></INPUT></TD></TR>
<TR><TD>Date Received</TD><TD></TD><TD><INPUT NAME="DATERECV" SIZE="15"><xsl:attribute name="VALUE"><xsl:value-of select="MSI/TODAY"/></xsl:attribute></INPUT></TD></TR>



<TR><TD COLSPAN="2"><INPUT TYPE="SUBMIT" NAME="SUBMIT" VALUE="Enter"><INPUT TYPE="RESET" Value="Undo Changes"></INPUT></INPUT></TD></TR></TABLE></FORM><P></P>



</BODY></HTML>

</xsl:template>
</xsl:stylesheet>

