/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.BufferedReader;
import java.io.IOException;
import org.apache.tools.ant.Project;

public class JikesOutputParser {
    protected Project project;
    protected boolean errorFlag = false;
    protected int errors;
    protected int warnings;
    protected boolean error = false;
    protected boolean emacsMode;

    protected JikesOutputParser(Project project, boolean emacsMode) {
        this.project = project;
        this.emacsMode = emacsMode;
    }

    protected boolean getErrorFlag() {
        return this.errorFlag;
    }

    private void log(String line) {
        if (!this.emacsMode) {
            this.project.log("", this.error ? 0 : 1);
        }
        this.project.log(line, this.error ? 0 : 1);
    }

    private void parseEmacsOutput(BufferedReader reader) throws IOException {
        this.parseStandardOutput(reader);
    }

    protected void parseOutput(BufferedReader reader) throws IOException {
        if (this.emacsMode) {
            this.parseEmacsOutput(reader);
        } else {
            this.parseStandardOutput(reader);
        }
    }

    private void parseStandardOutput(BufferedReader reader) throws IOException {
        String line;
        while ((line = reader.readLine()) != null) {
            String lower = line.toLowerCase();
            if (line.trim().equals("")) continue;
            if (lower.indexOf("error") != -1) {
                this.setError(true);
            } else if (lower.indexOf("warning") != -1) {
                this.setError(false);
            } else if (this.emacsMode) {
                this.setError(true);
            }
            this.log(line);
        }
    }

    private void setError(boolean err) {
        this.error = err;
        if (this.error) {
            this.errorFlag = true;
        }
    }
}

