/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;

public class Copyfile
extends Task {
    private File srcFile;
    private File destFile;
    private boolean filtering = false;

    public void execute() throws BuildException {
        if (this.srcFile.lastModified() > this.destFile.lastModified()) {
            try {
                this.project.copyFile(this.srcFile, this.destFile, this.filtering);
            }
            catch (IOException ioe) {
                String msg = "Error copying file: " + this.srcFile.getAbsolutePath() + " due to " + ioe.getMessage();
                throw new BuildException(msg);
            }
        }
    }

    public void setDest(String dest) {
        this.destFile = this.project.resolveFile(dest);
    }

    public void setFiltering(String filter) {
        this.filtering = Project.toBoolean(filter);
    }

    public void setSrc(String src) {
        this.srcFile = this.project.resolveFile(src);
    }
}

